package software.amazon.awscdk.services.autoscaling;

/**
 * A CloudFormation `AWS::AutoScaling::ScheduledAction`.
 * <p>
 * The <code>AWS::AutoScaling::ScheduledAction</code> resource specifies an Amazon EC2 Auto Scaling scheduled action so that the Auto Scaling group can change the number of instances available for your application in response to predictable load changes.
 * <p>
 * When you update a stack with an Auto Scaling group and scheduled action, CloudFormation always sets the min size, max size, and desired capacity properties of your group to the values that are defined in the <code>AWS::AutoScaling::AutoScalingGroup</code> section of your template. However, you might not want CloudFormation to do that when you have a scheduled action in effect. You can use an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html">UpdatePolicy attribute</a> to prevent CloudFormation from changing the min size, max size, or desired capacity property values during a stack update unless you modified the individual values in your template. If you have rolling updates enabled, before you can update the Auto Scaling group, you must suspend scheduled actions by specifying an <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html">UpdatePolicy attribute</a> for the Auto Scaling group. You can find a sample update policy for rolling updates in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/quickref-autoscaling.html">Auto scaling template snippets</a> .
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/schedule_time.html">Scheduled scaling</a> and <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html">Suspending and resuming scaling processes</a> in the <em>Amazon EC2 Auto Scaling User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * CfnScheduledAction cfnScheduledAction = CfnScheduledAction.Builder.create(this, "MyCfnScheduledAction")
 *         .autoScalingGroupName("autoScalingGroupName")
 *         // the properties below are optional
 *         .desiredCapacity(123)
 *         .endTime("endTime")
 *         .maxSize(123)
 *         .minSize(123)
 *         .recurrence("recurrence")
 *         .startTime("startTime")
 *         .timeZone("timeZone")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:40.967Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.CfnScheduledAction")
public class CfnScheduledAction extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnScheduledAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnScheduledAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.autoscaling.CfnScheduledAction.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::AutoScaling::ScheduledAction`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnScheduledAction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.CfnScheduledActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAutoScalingGroupName() {
        return software.amazon.jsii.Kernel.get(this, "autoScalingGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Auto Scaling group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoScalingGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "autoScalingGroupName", java.util.Objects.requireNonNull(value, "autoScalingGroupName is required"));
    }

    /**
     * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.
     * <p>
     * It can scale beyond this capacity if you add more scaling conditions.
     * <p>
     * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCapacity() {
        return software.amazon.jsii.Kernel.get(this, "desiredCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.
     * <p>
     * It can scale beyond this capacity if you add more scaling conditions.
     * <p>
     * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDesiredCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "desiredCapacity", value);
    }

    /**
     * The date and time for the recurring schedule to end, in UTC.
     * <p>
     * For example, <code>"2021-06-01T00:00:00Z"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndTime() {
        return software.amazon.jsii.Kernel.get(this, "endTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time for the recurring schedule to end, in UTC.
     * <p>
     * For example, <code>"2021-06-01T00:00:00Z"</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endTime", value);
    }

    /**
     * The maximum size of the Auto Scaling group.
     * <p>
     * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxSize() {
        return software.amazon.jsii.Kernel.get(this, "maxSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum size of the Auto Scaling group.
     * <p>
     * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxSize", value);
    }

    /**
     * The minimum size of the Auto Scaling group.
     * <p>
     * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinSize() {
        return software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum size of the Auto Scaling group.
     * <p>
     * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinSize(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minSize", value);
    }

    /**
     * The recurring schedule for this action.
     * <p>
     * This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. For more information about this format, see <a href="https://docs.aws.amazon.com/http://crontab.org">Crontab</a> .
     * <p>
     * When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code> , they form the boundaries of when the recurring action starts and stops.
     * <p>
     * Cron expressions use Universal Coordinated Time (UTC) by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRecurrence() {
        return software.amazon.jsii.Kernel.get(this, "recurrence", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The recurring schedule for this action.
     * <p>
     * This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. For more information about this format, see <a href="https://docs.aws.amazon.com/http://crontab.org">Crontab</a> .
     * <p>
     * When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code> , they form the boundaries of when the recurring action starts and stops.
     * <p>
     * Cron expressions use Universal Coordinated Time (UTC) by default.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecurrence(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "recurrence", value);
    }

    /**
     * The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only. For example, `"2021-06-01T00:00:00Z"` .
     * <p>
     * If you specify <code>Recurrence</code> and <code>StartTime</code> , Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStartTime() {
        return software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only. For example, `"2021-06-01T00:00:00Z"` .
     * <p>
     * If you specify <code>Recurrence</code> and <code>StartTime</code> , Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartTime(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "startTime", value);
    }

    /**
     * Specifies the time zone for a cron expression.
     * <p>
     * If a time zone is not provided, UTC is used by default.
     * <p>
     * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code> ). For more information, see <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
        return software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the time zone for a cron expression.
     * <p>
     * If a time zone is not provided, UTC is used by default.
     * <p>
     * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code> ). For more information, see <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTimeZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "timeZone", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.autoscaling.CfnScheduledAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.autoscaling.CfnScheduledAction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.autoscaling.CfnScheduledActionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.autoscaling.CfnScheduledActionProps.Builder();
        }

        /**
         * The name of the Auto Scaling group.
         * <p>
         * @return {@code this}
         * @param autoScalingGroupName The name of the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroupName(final java.lang.String autoScalingGroupName) {
            this.props.autoScalingGroupName(autoScalingGroupName);
            return this;
        }

        /**
         * The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain.
         * <p>
         * It can scale beyond this capacity if you add more scaling conditions.
         * <p>
         * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
         * <p>
         * @return {@code this}
         * @param desiredCapacity The desired capacity is the initial capacity of the Auto Scaling group after the scheduled action runs and the capacity it attempts to maintain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCapacity(final java.lang.Number desiredCapacity) {
            this.props.desiredCapacity(desiredCapacity);
            return this;
        }

        /**
         * The date and time for the recurring schedule to end, in UTC.
         * <p>
         * For example, <code>"2021-06-01T00:00:00Z"</code> .
         * <p>
         * @return {@code this}
         * @param endTime The date and time for the recurring schedule to end, in UTC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endTime(final java.lang.String endTime) {
            this.props.endTime(endTime);
            return this;
        }

        /**
         * The maximum size of the Auto Scaling group.
         * <p>
         * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
         * <p>
         * @return {@code this}
         * @param maxSize The maximum size of the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxSize(final java.lang.Number maxSize) {
            this.props.maxSize(maxSize);
            return this;
        }

        /**
         * The minimum size of the Auto Scaling group.
         * <p>
         * You must specify at least one of the following properties: <code>MaxSize</code> , <code>MinSize</code> , or <code>DesiredCapacity</code> .
         * <p>
         * @return {@code this}
         * @param minSize The minimum size of the Auto Scaling group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(final java.lang.Number minSize) {
            this.props.minSize(minSize);
            return this;
        }

        /**
         * The recurring schedule for this action.
         * <p>
         * This format consists of five fields separated by white spaces: [Minute] [Hour] [Day_of_Month] [Month_of_Year] [Day_of_Week]. For more information about this format, see <a href="https://docs.aws.amazon.com/http://crontab.org">Crontab</a> .
         * <p>
         * When <code>StartTime</code> and <code>EndTime</code> are specified with <code>Recurrence</code> , they form the boundaries of when the recurring action starts and stops.
         * <p>
         * Cron expressions use Universal Coordinated Time (UTC) by default.
         * <p>
         * @return {@code this}
         * @param recurrence The recurring schedule for this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recurrence(final java.lang.String recurrence) {
            this.props.recurrence(recurrence);
            return this;
        }

        /**
         * The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only. For example, `"2021-06-01T00:00:00Z"` .
         * <p>
         * If you specify <code>Recurrence</code> and <code>StartTime</code> , Amazon EC2 Auto Scaling performs the action at this time, and then performs the action based on the specified recurrence.
         * <p>
         * @return {@code this}
         * @param startTime The date and time for this action to start, in YYYY-MM-DDThh:mm:ssZ format in UTC/GMT only. For example, `"2021-06-01T00:00:00Z"` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startTime(final java.lang.String startTime) {
            this.props.startTime(startTime);
            return this;
        }

        /**
         * Specifies the time zone for a cron expression.
         * <p>
         * If a time zone is not provided, UTC is used by default.
         * <p>
         * Valid values are the canonical names of the IANA time zones, derived from the IANA Time Zone Database (such as <code>Etc/GMT+9</code> or <code>Pacific/Tahiti</code> ). For more information, see <a href="https://docs.aws.amazon.com/https://en.wikipedia.org/wiki/List_of_tz_database_time_zones">https://en.wikipedia.org/wiki/List_of_tz_database_time_zones</a> .
         * <p>
         * @return {@code this}
         * @param timeZone Specifies the time zone for a cron expression. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeZone(final java.lang.String timeZone) {
            this.props.timeZone(timeZone);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.autoscaling.CfnScheduledAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.autoscaling.CfnScheduledAction build() {
            return new software.amazon.awscdk.services.autoscaling.CfnScheduledAction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
