package software.amazon.awscdk.services.billingconductor;

/**
 * Properties for defining a `CfnBillingGroup`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.billingconductor.*;
 * CfnBillingGroupProps cfnBillingGroupProps = CfnBillingGroupProps.builder()
 *         .accountGrouping(AccountGroupingProperty.builder()
 *                 .linkedAccountIds(List.of("linkedAccountIds"))
 *                 .build())
 *         .computationPreference(ComputationPreferenceProperty.builder()
 *                 .pricingPlanArn("pricingPlanArn")
 *                 .build())
 *         .name("name")
 *         .primaryAccountId("primaryAccountId")
 *         // the properties below are optional
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.061Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_billingconductor.CfnBillingGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnBillingGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBillingGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::BillingConductor::BillingGroup.AccountGrouping`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAccountGrouping();

    /**
     * `AWS::BillingConductor::BillingGroup.ComputationPreference`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getComputationPreference();

    /**
     * `AWS::BillingConductor::BillingGroup.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * `AWS::BillingConductor::BillingGroup.PrimaryAccountId`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPrimaryAccountId();

    /**
     * `AWS::BillingConductor::BillingGroup.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBillingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBillingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBillingGroupProps> {
        java.lang.Object accountGrouping;
        java.lang.Object computationPreference;
        java.lang.String name;
        java.lang.String primaryAccountId;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnBillingGroupProps#getAccountGrouping}
         * @param accountGrouping `AWS::BillingConductor::BillingGroup.AccountGrouping`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountGrouping(software.amazon.awscdk.services.billingconductor.CfnBillingGroup.AccountGroupingProperty accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getAccountGrouping}
         * @param accountGrouping `AWS::BillingConductor::BillingGroup.AccountGrouping`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountGrouping(software.amazon.awscdk.IResolvable accountGrouping) {
            this.accountGrouping = accountGrouping;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getComputationPreference}
         * @param computationPreference `AWS::BillingConductor::BillingGroup.ComputationPreference`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationPreference(software.amazon.awscdk.services.billingconductor.CfnBillingGroup.ComputationPreferenceProperty computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getComputationPreference}
         * @param computationPreference `AWS::BillingConductor::BillingGroup.ComputationPreference`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computationPreference(software.amazon.awscdk.IResolvable computationPreference) {
            this.computationPreference = computationPreference;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getName}
         * @param name `AWS::BillingConductor::BillingGroup.Name`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getPrimaryAccountId}
         * @param primaryAccountId `AWS::BillingConductor::BillingGroup.PrimaryAccountId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryAccountId(java.lang.String primaryAccountId) {
            this.primaryAccountId = primaryAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnBillingGroupProps#getDescription}
         * @param description `AWS::BillingConductor::BillingGroup.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBillingGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBillingGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBillingGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBillingGroupProps {
        private final java.lang.Object accountGrouping;
        private final java.lang.Object computationPreference;
        private final java.lang.String name;
        private final java.lang.String primaryAccountId;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountGrouping = software.amazon.jsii.Kernel.get(this, "accountGrouping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.computationPreference = software.amazon.jsii.Kernel.get(this, "computationPreference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.primaryAccountId = software.amazon.jsii.Kernel.get(this, "primaryAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountGrouping = java.util.Objects.requireNonNull(builder.accountGrouping, "accountGrouping is required");
            this.computationPreference = java.util.Objects.requireNonNull(builder.computationPreference, "computationPreference is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.primaryAccountId = java.util.Objects.requireNonNull(builder.primaryAccountId, "primaryAccountId is required");
            this.description = builder.description;
        }

        @Override
        public final java.lang.Object getAccountGrouping() {
            return this.accountGrouping;
        }

        @Override
        public final java.lang.Object getComputationPreference() {
            return this.computationPreference;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getPrimaryAccountId() {
            return this.primaryAccountId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accountGrouping", om.valueToTree(this.getAccountGrouping()));
            data.set("computationPreference", om.valueToTree(this.getComputationPreference()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("primaryAccountId", om.valueToTree(this.getPrimaryAccountId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_billingconductor.CfnBillingGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBillingGroupProps.Jsii$Proxy that = (CfnBillingGroupProps.Jsii$Proxy) o;

            if (!accountGrouping.equals(that.accountGrouping)) return false;
            if (!computationPreference.equals(that.computationPreference)) return false;
            if (!name.equals(that.name)) return false;
            if (!primaryAccountId.equals(that.primaryAccountId)) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accountGrouping.hashCode();
            result = 31 * result + (this.computationPreference.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.primaryAccountId.hashCode());
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
