package software.amazon.awscdk.services.billingconductor;

/**
 * Properties for defining a `CfnCustomLineItem`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.billingconductor.*;
 * CfnCustomLineItemProps cfnCustomLineItemProps = CfnCustomLineItemProps.builder()
 *         .billingGroupArn("billingGroupArn")
 *         .name("name")
 *         // the properties below are optional
 *         .billingPeriodRange(BillingPeriodRangeProperty.builder()
 *                 .exclusiveEndBillingPeriod("exclusiveEndBillingPeriod")
 *                 .inclusiveStartBillingPeriod("inclusiveStartBillingPeriod")
 *                 .build())
 *         .customLineItemChargeDetails(CustomLineItemChargeDetailsProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .flat(CustomLineItemFlatChargeDetailsProperty.builder()
 *                         .chargeValue(123)
 *                         .build())
 *                 .percentage(CustomLineItemPercentageChargeDetailsProperty.builder()
 *                         .percentageValue(123)
 *                         // the properties below are optional
 *                         .childAssociatedResources(List.of("childAssociatedResources"))
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.063Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_billingconductor.CfnCustomLineItemProps")
@software.amazon.jsii.Jsii.Proxy(CfnCustomLineItemProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCustomLineItemProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::BillingConductor::CustomLineItem.BillingGroupArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBillingGroupArn();

    /**
     * `AWS::BillingConductor::CustomLineItem.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * `AWS::BillingConductor::CustomLineItem.BillingPeriodRange`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBillingPeriodRange() {
        return null;
    }

    /**
     * `AWS::BillingConductor::CustomLineItem.CustomLineItemChargeDetails`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCustomLineItemChargeDetails() {
        return null;
    }

    /**
     * `AWS::BillingConductor::CustomLineItem.Description`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCustomLineItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCustomLineItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCustomLineItemProps> {
        java.lang.String billingGroupArn;
        java.lang.String name;
        java.lang.Object billingPeriodRange;
        java.lang.Object customLineItemChargeDetails;
        java.lang.String description;

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getBillingGroupArn}
         * @param billingGroupArn `AWS::BillingConductor::CustomLineItem.BillingGroupArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingGroupArn(java.lang.String billingGroupArn) {
            this.billingGroupArn = billingGroupArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getName}
         * @param name `AWS::BillingConductor::CustomLineItem.Name`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getBillingPeriodRange}
         * @param billingPeriodRange `AWS::BillingConductor::CustomLineItem.BillingPeriodRange`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingPeriodRange(software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.BillingPeriodRangeProperty billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getBillingPeriodRange}
         * @param billingPeriodRange `AWS::BillingConductor::CustomLineItem.BillingPeriodRange`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingPeriodRange(software.amazon.awscdk.IResolvable billingPeriodRange) {
            this.billingPeriodRange = billingPeriodRange;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getCustomLineItemChargeDetails}
         * @param customLineItemChargeDetails `AWS::BillingConductor::CustomLineItem.CustomLineItemChargeDetails`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customLineItemChargeDetails(software.amazon.awscdk.services.billingconductor.CfnCustomLineItem.CustomLineItemChargeDetailsProperty customLineItemChargeDetails) {
            this.customLineItemChargeDetails = customLineItemChargeDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getCustomLineItemChargeDetails}
         * @param customLineItemChargeDetails `AWS::BillingConductor::CustomLineItem.CustomLineItemChargeDetails`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customLineItemChargeDetails(software.amazon.awscdk.IResolvable customLineItemChargeDetails) {
            this.customLineItemChargeDetails = customLineItemChargeDetails;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomLineItemProps#getDescription}
         * @param description `AWS::BillingConductor::CustomLineItem.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCustomLineItemProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCustomLineItemProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCustomLineItemProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCustomLineItemProps {
        private final java.lang.String billingGroupArn;
        private final java.lang.String name;
        private final java.lang.Object billingPeriodRange;
        private final java.lang.Object customLineItemChargeDetails;
        private final java.lang.String description;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.billingGroupArn = software.amazon.jsii.Kernel.get(this, "billingGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.billingPeriodRange = software.amazon.jsii.Kernel.get(this, "billingPeriodRange", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customLineItemChargeDetails = software.amazon.jsii.Kernel.get(this, "customLineItemChargeDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.billingGroupArn = java.util.Objects.requireNonNull(builder.billingGroupArn, "billingGroupArn is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.billingPeriodRange = builder.billingPeriodRange;
            this.customLineItemChargeDetails = builder.customLineItemChargeDetails;
            this.description = builder.description;
        }

        @Override
        public final java.lang.String getBillingGroupArn() {
            return this.billingGroupArn;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getBillingPeriodRange() {
            return this.billingPeriodRange;
        }

        @Override
        public final java.lang.Object getCustomLineItemChargeDetails() {
            return this.customLineItemChargeDetails;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("billingGroupArn", om.valueToTree(this.getBillingGroupArn()));
            data.set("name", om.valueToTree(this.getName()));
            if (this.getBillingPeriodRange() != null) {
                data.set("billingPeriodRange", om.valueToTree(this.getBillingPeriodRange()));
            }
            if (this.getCustomLineItemChargeDetails() != null) {
                data.set("customLineItemChargeDetails", om.valueToTree(this.getCustomLineItemChargeDetails()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_billingconductor.CfnCustomLineItemProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCustomLineItemProps.Jsii$Proxy that = (CfnCustomLineItemProps.Jsii$Proxy) o;

            if (!billingGroupArn.equals(that.billingGroupArn)) return false;
            if (!name.equals(that.name)) return false;
            if (this.billingPeriodRange != null ? !this.billingPeriodRange.equals(that.billingPeriodRange) : that.billingPeriodRange != null) return false;
            if (this.customLineItemChargeDetails != null ? !this.customLineItemChargeDetails.equals(that.customLineItemChargeDetails) : that.customLineItemChargeDetails != null) return false;
            return this.description != null ? this.description.equals(that.description) : that.description == null;
        }

        @Override
        public final int hashCode() {
            int result = this.billingGroupArn.hashCode();
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.billingPeriodRange != null ? this.billingPeriodRange.hashCode() : 0);
            result = 31 * result + (this.customLineItemChargeDetails != null ? this.customLineItemChargeDetails.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}
