package software.amazon.awscdk.services.cloudtrail;

/**
 * Selecting an S3 bucket and an optional prefix to be logged for data events.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * S3EventSelector s3EventSelector = S3EventSelector.builder()
 *         .bucket(bucket)
 *         // the properties below are optional
 *         .objectPrefix("objectPrefix")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.325Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.S3EventSelector")
@software.amazon.jsii.Jsii.Proxy(S3EventSelector.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface S3EventSelector extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getBucket();

    /**
     * Data events for objects whose key matches this prefix will be logged.
     * <p>
     * Default: - all objects
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getObjectPrefix() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link S3EventSelector}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link S3EventSelector}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<S3EventSelector> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.String objectPrefix;

        /**
         * Sets the value of {@link S3EventSelector#getBucket}
         * @param bucket S3 bucket. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link S3EventSelector#getObjectPrefix}
         * @param objectPrefix Data events for objects whose key matches this prefix will be logged.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder objectPrefix(java.lang.String objectPrefix) {
            this.objectPrefix = objectPrefix;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link S3EventSelector}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public S3EventSelector build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link S3EventSelector}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3EventSelector {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String objectPrefix;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.objectPrefix = software.amazon.jsii.Kernel.get(this, "objectPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.objectPrefix = builder.objectPrefix;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getObjectPrefix() {
            return this.objectPrefix;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            if (this.getObjectPrefix() != null) {
                data.set("objectPrefix", om.valueToTree(this.getObjectPrefix()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.S3EventSelector"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            S3EventSelector.Jsii$Proxy that = (S3EventSelector.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            return this.objectPrefix != null ? this.objectPrefix.equals(that.objectPrefix) : that.objectPrefix == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.objectPrefix != null ? this.objectPrefix.hashCode() : 0);
            return result;
        }
    }
}
