package software.amazon.awscdk.services.codecommit;

/**
 * Provides a CodeCommit Repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated from non-compiling source. May contain errors.
 * PipelineProject project;
 * Repository repository = Repository.Builder.create(this, "MyRepository")
 *         .repositoryName("MyRepository")
 *         .build();
 * PipelineProject project = new PipelineProject(this, "MyProject");
 * Artifact sourceOutput = new Artifact();
 * CodeCommitSourceAction sourceAction = CodeCommitSourceAction.Builder.create()
 *         .actionName("CodeCommit")
 *         .repository(repository)
 *         .output(sourceOutput)
 *         .build();
 * CodeBuildAction buildAction = CodeBuildAction.Builder.create()
 *         .actionName("CodeBuild")
 *         .project(project)
 *         .input(sourceOutput)
 *         .outputs(List.of(new Artifact())) // optional
 *         .executeBatchBuild(true) // optional, defaults to false
 *         .combineBatchBuildArtifacts(true)
 *         .build();
 * Pipeline.Builder.create(this, "MyPipeline")
 *         .stages(List.of(StageProps.builder()
 *                 .stageName("Source")
 *                 .actions(List.of(sourceAction))
 *                 .build(), StageProps.builder()
 *                 .stageName("Build")
 *                 .actions(List.of(buildAction))
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.511Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codecommit.Repository")
public class Repository extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codecommit.IRepository {

    protected Repository(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Repository(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Repository(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.RepositoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports a codecommit repository.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param repositoryArn (e.g. `arn:aws:codecommit:us-east-1:123456789012:MyDemoRepo`). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository fromRepositoryArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String repositoryArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Repository.class, "fromRepositoryArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.IRepository.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(repositoryArn, "repositoryArn is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param repositoryName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository fromRepositoryName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String repositoryName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Repository.class, "fromRepositoryName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.IRepository.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(repositoryName, "repositoryName is required") });
    }

    /**
     * Returns a source configuration for notification rule.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig bindAsNotificationRuleSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bindAsNotificationRuleSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * Grant the given principal identity permissions to perform the actions on this repository.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * Grant the given identity permissions to pull this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPull(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantPull", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant the given identity permissions to pull and push this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPullPush(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantPullPush", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grant the given identity permissions to read this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a pull request is merged.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifiyOnPullRequestMerged(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifiyOnPullRequestMerged", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a pull request is merged.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifiyOnPullRequestMerged(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifiyOnPullRequestMerged", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Create a trigger to notify another service to run actions on repository events.
     * <p>
     * @param arn Arn of the resource that repository events will notify. This parameter is required.
     * @param options Trigger options to run actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Repository notify(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codecommit.RepositoryTriggerOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notify", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Repository.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), options });
    }

    /**
     * Create a trigger to notify another service to run actions on repository events.
     * <p>
     * @param arn Arn of the resource that repository events will notify. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Repository notify(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.Kernel.call(this, "notify", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Repository.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * Defines a CodeStar Notification rule triggered when the project events specified by you are emitted. Similar to `onEvent` API.
     * <p>
     * You can also use the methods to define rules for the specific event emitted.
     * eg: <code>notifyOnPullRequstCreated</code>.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOn(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.RepositoryNotifyOnOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when an approval rule is overridden.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnApprovalRuleOverridden(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnApprovalRuleOverridden", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when an approval rule is overridden.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnApprovalRuleOverridden(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnApprovalRuleOverridden", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when an approval status is changed.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnApprovalStatusChanged(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnApprovalStatusChanged", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when an approval status is changed.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnApprovalStatusChanged(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnApprovalStatusChanged", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a new branch or tag is created.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnBranchOrTagCreated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnBranchOrTagCreated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a new branch or tag is created.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnBranchOrTagCreated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnBranchOrTagCreated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a branch or tag is deleted.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnBranchOrTagDeleted(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnBranchOrTagDeleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a branch or tag is deleted.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnBranchOrTagDeleted(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnBranchOrTagDeleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a comment is made on a pull request.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnPullRequestComment(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnPullRequestComment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a comment is made on a pull request.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnPullRequestComment(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnPullRequestComment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a pull request is created.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnPullRequestCreated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnPullRequestCreated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a pull request is created.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnPullRequestCreated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnPullRequestCreated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a pull request is merged.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnPullRequestMerged(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnPullRequestMerged", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * Defines a CodeStar Notification rule which triggers when a pull request is merged.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnPullRequestMerged(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnPullRequestMerged", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a comment is made on a commit.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnCommit(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onCommentOnCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a comment is made on a commit.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnCommit(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onCommentOnCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a comment is made on a pull request.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnPullRequest(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onCommentOnPullRequest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a comment is made on a pull request.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnPullRequest(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onCommentOnPullRequest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a commit is pushed to a branch.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommit(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codecommit.OnCommitOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a commit is pushed to a branch.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommit(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers for repository events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers for repository events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a pull request state is changed.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onPullRequestStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onPullRequestStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a pull request state is changed.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onPullRequestStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onPullRequestStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is created (i.e. a new branch/tag is created) to the repository.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceCreated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceCreated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is created (i.e. a new branch/tag is created) to the repository.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceCreated(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceCreated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is delete (i.e. a branch/tag is deleted) from the repository.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceDeleted(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceDeleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is delete (i.e. a branch/tag is deleted) from the repository.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceDeleted(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceDeleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is updated (i.e. a commit is pushed to an existing or new branch) from the repository.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceUpdated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceUpdated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a reference is updated (i.e. a commit is pushed to an existing or new branch) from the repository.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceUpdated(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceUpdated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a "CodeCommit Repository State Change" event occurs.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * Defines a CloudWatch event rule which triggers when a "CodeCommit Repository State Change" event occurs.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The ARN of this Repository.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryArn() {
        return software.amazon.jsii.Kernel.get(this, "repositoryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The HTTPS (GRC) clone URL.
     * <p>
     * HTTPS (GRC) is the protocol to use with git-remote-codecommit (GRC).
     * <p>
     * It is the recommended method for supporting connections made with federated
     * access, identity providers, and temporary credentials.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryCloneUrlGrc() {
        return software.amazon.jsii.Kernel.get(this, "repositoryCloneUrlGrc", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The HTTP clone URL.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryCloneUrlHttp() {
        return software.amazon.jsii.Kernel.get(this, "repositoryCloneUrlHttp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The SSH clone URL.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryCloneUrlSsh() {
        return software.amazon.jsii.Kernel.get(this, "repositoryCloneUrlSsh", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The human-visible name of this Repository.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName() {
        return software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codecommit.Repository}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codecommit.Repository> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codecommit.RepositoryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codecommit.RepositoryProps.Builder();
        }

        /**
         * Name of the repository.
         * <p>
         * This property is required for all CodeCommit repositories.
         * <p>
         * @return {@code this}
         * @param repositoryName Name of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        /**
         * The contents with which to initialize the repository after it has been created.
         * <p>
         * Default: - No initialization (create empty repo)
         * <p>
         * @return {@code this}
         * @param code The contents with which to initialize the repository after it has been created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder code(final software.amazon.awscdk.services.codecommit.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * A description of the repository.
         * <p>
         * Use the description to identify the
         * purpose of the repository.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codecommit.Repository}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codecommit.Repository build() {
            return new software.amazon.awscdk.services.codecommit.Repository(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
