package software.amazon.awscdk.services.codepipeline;

/**
 * A CloudFormation `AWS::CodePipeline::Pipeline`.
 * <p>
 * The <code>AWS::CodePipeline::Pipeline</code> resource creates a CodePipeline pipeline that describes how software changes go through a release process. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/welcome.html">What Is CodePipeline?</a> in the <em>AWS CodePipeline User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codepipeline.*;
 * Object configuration;
 * CfnPipeline cfnPipeline = CfnPipeline.Builder.create(this, "MyCfnPipeline")
 *         .roleArn("roleArn")
 *         .stages(List.of(StageDeclarationProperty.builder()
 *                 .actions(List.of(ActionDeclarationProperty.builder()
 *                         .actionTypeId(ActionTypeIdProperty.builder()
 *                                 .category("category")
 *                                 .owner("owner")
 *                                 .provider("provider")
 *                                 .version("version")
 *                                 .build())
 *                         .name("name")
 *                         // the properties below are optional
 *                         .configuration(configuration)
 *                         .inputArtifacts(List.of(InputArtifactProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .namespace("namespace")
 *                         .outputArtifacts(List.of(OutputArtifactProperty.builder()
 *                                 .name("name")
 *                                 .build()))
 *                         .region("region")
 *                         .roleArn("roleArn")
 *                         .runOrder(123)
 *                         .build()))
 *                 .name("name")
 *                 // the properties below are optional
 *                 .blockers(List.of(BlockerDeclarationProperty.builder()
 *                         .name("name")
 *                         .type("type")
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .artifactStore(ArtifactStoreProperty.builder()
 *                 .location("location")
 *                 .type("type")
 *                 // the properties below are optional
 *                 .encryptionKey(EncryptionKeyProperty.builder()
 *                         .id("id")
 *                         .type("type")
 *                         .build())
 *                 .build())
 *         .artifactStores(List.of(ArtifactStoreMapProperty.builder()
 *                 .artifactStore(ArtifactStoreProperty.builder()
 *                         .location("location")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .encryptionKey(EncryptionKeyProperty.builder()
 *                                 .id("id")
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .region("region")
 *                 .build()))
 *         .disableInboundStageTransitions(List.of(StageTransitionProperty.builder()
 *                 .reason("reason")
 *                 .stageName("stageName")
 *                 .build()))
 *         .name("name")
 *         .restartExecutionOnUpdate(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.592Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline")
public class CfnPipeline extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnPipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codepipeline.CfnPipeline.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CodePipeline::Pipeline`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.CfnPipelineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The version of the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * A new pipeline is always assigned a version number of 1. This number increments when a pipeline is updated.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies the tags applied to the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no `actionRoleArn` , or to use to assume roles for actions with an `actionRoleArn` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no `actionRoleArn` , or to use to assume roles for actions with an `actionRoleArn` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * Represents information about a stage and its definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getStages() {
        return software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents information about a stage and its definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStages(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "stages", java.util.Objects.requireNonNull(value, "stages is required"));
    }

    /**
     * Represents information about a stage and its definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStages(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "stages", java.util.Objects.requireNonNull(value, "stages is required"));
    }

    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getArtifactStore() {
        return software.amazon.jsii.Kernel.get(this, "artifactStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactStore(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreProperty value) {
        software.amazon.jsii.Kernel.set(this, "artifactStore", value);
    }

    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactStore(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "artifactStore", value);
    }

    /**
     * A mapping of `artifactStore` objects and their corresponding AWS Regions.
     * <p>
     * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getArtifactStores() {
        return software.amazon.jsii.Kernel.get(this, "artifactStores", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A mapping of `artifactStore` objects and their corresponding AWS Regions.
     * <p>
     * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactStores(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "artifactStores", value);
    }

    /**
     * A mapping of `artifactStore` objects and their corresponding AWS Regions.
     * <p>
     * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setArtifactStores(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "artifactStores", value);
    }

    /**
     * Represents the input of a `DisableStageTransition` action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDisableInboundStageTransitions() {
        return software.amazon.jsii.Kernel.get(this, "disableInboundStageTransitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Represents the input of a `DisableStageTransition` action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableInboundStageTransitions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "disableInboundStageTransitions", value);
    }

    /**
     * Represents the input of a `DisableStageTransition` action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisableInboundStageTransitions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "disableInboundStageTransitions", value);
    }

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * Indicates whether to rerun the CodePipeline pipeline after you update it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getRestartExecutionOnUpdate() {
        return software.amazon.jsii.Kernel.get(this, "restartExecutionOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether to rerun the CodePipeline pipeline after you update it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestartExecutionOnUpdate(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "restartExecutionOnUpdate", value);
    }

    /**
     * Indicates whether to rerun the CodePipeline pipeline after you update it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestartExecutionOnUpdate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "restartExecutionOnUpdate", value);
    }
    /**
     * Represents information about an action declaration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * Object configuration;
     * ActionDeclarationProperty actionDeclarationProperty = ActionDeclarationProperty.builder()
     *         .actionTypeId(ActionTypeIdProperty.builder()
     *                 .category("category")
     *                 .owner("owner")
     *                 .provider("provider")
     *                 .version("version")
     *                 .build())
     *         .name("name")
     *         // the properties below are optional
     *         .configuration(configuration)
     *         .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .namespace("namespace")
     *         .outputArtifacts(List.of(OutputArtifactProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .region("region")
     *         .roleArn("roleArn")
     *         .runOrder(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionDeclarationProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionDeclarationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionDeclarationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the action type and the provider of the action.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActionTypeId();

        /**
         * The action declaration's name.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The action's configuration.
         * <p>
         * These are key-value pairs that specify input values for an action. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Action Structure Requirements in CodePipeline</a> . For the list of configuration properties for the AWS CloudFormation action type in CodePipeline, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html">Configuration Properties Reference</a> in the <em>AWS CloudFormation User Guide</em> . For template snippets with examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html">Using Parameter Override Functions with CodePipeline Pipelines</a> in the <em>AWS CloudFormation User Guide</em> .
         * <p>
         * The values can be represented in either JSON or YAML format. For example, the JSON configuration item format is as follows:
         * <p>
         * <em>JSON:</em>
         * <p>
         * <code>"Configuration" : { Key : Value },</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * The name or ID of the artifact consumed by the action, such as a test or build artifact.
         * <p>
         * <blockquote>
         * <p>
         * For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html">CodeBuild action reference page</a> in the <em>AWS CodePipeline User Guide</em> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputArtifacts() {
            return null;
        }

        /**
         * The variable namespace associated with the action.
         * <p>
         * All variables produced as output by this action fall under this namespace.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The name or ID of the result of the action declaration, such as a test or build artifact.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputArtifacts() {
            return null;
        }

        /**
         * The action declaration's AWS Region, such as us-east-1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
            return null;
        }

        /**
         * The ARN of the IAM service role that performs the declared action.
         * <p>
         * This is assumed through the roleArn for the pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * The order in which actions are run.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRunOrder() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ActionDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionDeclarationProperty> {
            java.lang.Object actionTypeId;
            java.lang.String name;
            java.lang.Object configuration;
            java.lang.Object inputArtifacts;
            java.lang.String namespace;
            java.lang.Object outputArtifacts;
            java.lang.String region;
            java.lang.String roleArn;
            java.lang.Number runOrder;

            /**
             * Sets the value of {@link ActionDeclarationProperty#getActionTypeId}
             * @param actionTypeId Specifies the action type and the provider of the action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionTypeId(software.amazon.awscdk.services.codepipeline.CfnPipeline.ActionTypeIdProperty actionTypeId) {
                this.actionTypeId = actionTypeId;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getActionTypeId}
             * @param actionTypeId Specifies the action type and the provider of the action. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actionTypeId(software.amazon.awscdk.IResolvable actionTypeId) {
                this.actionTypeId = actionTypeId;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getName}
             * @param name The action declaration's name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getConfiguration}
             * @param configuration The action's configuration.
             *                      These are key-value pairs that specify input values for an action. For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#action-requirements">Action Structure Requirements in CodePipeline</a> . For the list of configuration properties for the AWS CloudFormation action type in CodePipeline, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-action-reference.html">Configuration Properties Reference</a> in the <em>AWS CloudFormation User Guide</em> . For template snippets with examples, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/continuous-delivery-codepipeline-parameter-override-functions.html">Using Parameter Override Functions with CodePipeline Pipelines</a> in the <em>AWS CloudFormation User Guide</em> .
             *                      <p>
             *                      The values can be represented in either JSON or YAML format. For example, the JSON configuration item format is as follows:
             *                      <p>
             *                      <em>JSON:</em>
             *                      <p>
             *                      <code>"Configuration" : { Key : Value },</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(java.lang.Object configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getInputArtifacts}
             * @param inputArtifacts The name or ID of the artifact consumed by the action, such as a test or build artifact.
             *                       <blockquote>
             *                       <p>
             *                       For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html">CodeBuild action reference page</a> in the <em>AWS CodePipeline User Guide</em> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputArtifacts(software.amazon.awscdk.IResolvable inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getInputArtifacts}
             * @param inputArtifacts The name or ID of the artifact consumed by the action, such as a test or build artifact.
             *                       <blockquote>
             *                       <p>
             *                       For a CodeBuild action with multiple input artifacts, one of your input sources must be designated the PrimarySource. For more information, see the <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/action-reference-CodeBuild.html">CodeBuild action reference page</a> in the <em>AWS CodePipeline User Guide</em> .
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputArtifacts(java.util.List<? extends java.lang.Object> inputArtifacts) {
                this.inputArtifacts = inputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getNamespace}
             * @param namespace The variable namespace associated with the action.
             *                  All variables produced as output by this action fall under this namespace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getOutputArtifacts}
             * @param outputArtifacts The name or ID of the result of the action declaration, such as a test or build artifact.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputArtifacts(software.amazon.awscdk.IResolvable outputArtifacts) {
                this.outputArtifacts = outputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getOutputArtifacts}
             * @param outputArtifacts The name or ID of the result of the action declaration, such as a test or build artifact.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputArtifacts(java.util.List<? extends java.lang.Object> outputArtifacts) {
                this.outputArtifacts = outputArtifacts;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getRegion}
             * @param region The action declaration's AWS Region, such as us-east-1.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getRoleArn}
             * @param roleArn The ARN of the IAM service role that performs the declared action.
             *                This is assumed through the roleArn for the pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link ActionDeclarationProperty#getRunOrder}
             * @param runOrder The order in which actions are run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runOrder(java.lang.Number runOrder) {
                this.runOrder = runOrder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionDeclarationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionDeclarationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionDeclarationProperty {
            private final java.lang.Object actionTypeId;
            private final java.lang.String name;
            private final java.lang.Object configuration;
            private final java.lang.Object inputArtifacts;
            private final java.lang.String namespace;
            private final java.lang.Object outputArtifacts;
            private final java.lang.String region;
            private final java.lang.String roleArn;
            private final java.lang.Number runOrder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actionTypeId = software.amazon.jsii.Kernel.get(this, "actionTypeId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputArtifacts = software.amazon.jsii.Kernel.get(this, "inputArtifacts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.outputArtifacts = software.amazon.jsii.Kernel.get(this, "outputArtifacts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actionTypeId = java.util.Objects.requireNonNull(builder.actionTypeId, "actionTypeId is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.configuration = builder.configuration;
                this.inputArtifacts = builder.inputArtifacts;
                this.namespace = builder.namespace;
                this.outputArtifacts = builder.outputArtifacts;
                this.region = builder.region;
                this.roleArn = builder.roleArn;
                this.runOrder = builder.runOrder;
            }

            @Override
            public final java.lang.Object getActionTypeId() {
                return this.actionTypeId;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.Object getInputArtifacts() {
                return this.inputArtifacts;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.Object getOutputArtifacts() {
                return this.outputArtifacts;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Number getRunOrder() {
                return this.runOrder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actionTypeId", om.valueToTree(this.getActionTypeId()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }
                if (this.getInputArtifacts() != null) {
                    data.set("inputArtifacts", om.valueToTree(this.getInputArtifacts()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getOutputArtifacts() != null) {
                    data.set("outputArtifacts", om.valueToTree(this.getOutputArtifacts()));
                }
                if (this.getRegion() != null) {
                    data.set("region", om.valueToTree(this.getRegion()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getRunOrder() != null) {
                    data.set("runOrder", om.valueToTree(this.getRunOrder()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionDeclarationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionDeclarationProperty.Jsii$Proxy that = (ActionDeclarationProperty.Jsii$Proxy) o;

                if (!actionTypeId.equals(that.actionTypeId)) return false;
                if (!name.equals(that.name)) return false;
                if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
                if (this.inputArtifacts != null ? !this.inputArtifacts.equals(that.inputArtifacts) : that.inputArtifacts != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                if (this.outputArtifacts != null ? !this.outputArtifacts.equals(that.outputArtifacts) : that.outputArtifacts != null) return false;
                if (this.region != null ? !this.region.equals(that.region) : that.region != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.runOrder != null ? this.runOrder.equals(that.runOrder) : that.runOrder == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actionTypeId.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
                result = 31 * result + (this.inputArtifacts != null ? this.inputArtifacts.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.outputArtifacts != null ? this.outputArtifacts.hashCode() : 0);
                result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Represents information about an action type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * ActionTypeIdProperty actionTypeIdProperty = ActionTypeIdProperty.builder()
     *         .category("category")
     *         .owner("owner")
     *         .provider("provider")
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionTypeIdProperty")
    @software.amazon.jsii.Jsii.Proxy(ActionTypeIdProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ActionTypeIdProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A category defines what kind of action can be taken in the stage, and constrains the provider type for the action.
         * <p>
         * Valid categories are limited to one of the values below.
         * <p>
         * <ul>
         * <li><code>Source</code></li>
         * <li><code>Build</code></li>
         * <li><code>Test</code></li>
         * <li><code>Deploy</code></li>
         * <li><code>Invoke</code></li>
         * <li><code>Approval</code></li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCategory();

        /**
         * The creator of the action being called.
         * <p>
         * There are three valid values for the <code>Owner</code> field in the action category section within your pipeline structure: <code>AWS</code> , <code>ThirdParty</code> , and <code>Custom</code> . For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOwner();

        /**
         * The provider of the service being called by the action.
         * <p>
         * Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified as <code>CodeDeploy</code> . For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getProvider();

        /**
         * A string that describes the action version.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getVersion();

        /**
         * @return a {@link Builder} of {@link ActionTypeIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ActionTypeIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ActionTypeIdProperty> {
            java.lang.String category;
            java.lang.String owner;
            java.lang.String provider;
            java.lang.String version;

            /**
             * Sets the value of {@link ActionTypeIdProperty#getCategory}
             * @param category A category defines what kind of action can be taken in the stage, and constrains the provider type for the action. This parameter is required.
             *                 Valid categories are limited to one of the values below.
             *                 <p>
             *                 <ul>
             *                 <li><code>Source</code></li>
             *                 <li><code>Build</code></li>
             *                 <li><code>Test</code></li>
             *                 <li><code>Deploy</code></li>
             *                 <li><code>Invoke</code></li>
             *                 <li><code>Approval</code></li>
             *                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder category(java.lang.String category) {
                this.category = category;
                return this;
            }

            /**
             * Sets the value of {@link ActionTypeIdProperty#getOwner}
             * @param owner The creator of the action being called. This parameter is required.
             *              There are three valid values for the <code>Owner</code> field in the action category section within your pipeline structure: <code>AWS</code> , <code>ThirdParty</code> , and <code>Custom</code> . For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder owner(java.lang.String owner) {
                this.owner = owner;
                return this;
            }

            /**
             * Sets the value of {@link ActionTypeIdProperty#getProvider}
             * @param provider The provider of the service being called by the action. This parameter is required.
             *                 Valid providers are determined by the action category. For example, an action in the Deploy category type might have a provider of CodeDeploy, which would be specified as <code>CodeDeploy</code> . For more information, see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html#actions-valid-providers">Valid Action Types and Providers in CodePipeline</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provider(java.lang.String provider) {
                this.provider = provider;
                return this;
            }

            /**
             * Sets the value of {@link ActionTypeIdProperty#getVersion}
             * @param version A string that describes the action version. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ActionTypeIdProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ActionTypeIdProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ActionTypeIdProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ActionTypeIdProperty {
            private final java.lang.String category;
            private final java.lang.String owner;
            private final java.lang.String provider;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.owner = software.amazon.jsii.Kernel.get(this, "owner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
                this.owner = java.util.Objects.requireNonNull(builder.owner, "owner is required");
                this.provider = java.util.Objects.requireNonNull(builder.provider, "provider is required");
                this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            }

            @Override
            public final java.lang.String getCategory() {
                return this.category;
            }

            @Override
            public final java.lang.String getOwner() {
                return this.owner;
            }

            @Override
            public final java.lang.String getProvider() {
                return this.provider;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("category", om.valueToTree(this.getCategory()));
                data.set("owner", om.valueToTree(this.getOwner()));
                data.set("provider", om.valueToTree(this.getProvider()));
                data.set("version", om.valueToTree(this.getVersion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.ActionTypeIdProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ActionTypeIdProperty.Jsii$Proxy that = (ActionTypeIdProperty.Jsii$Proxy) o;

                if (!category.equals(that.category)) return false;
                if (!owner.equals(that.owner)) return false;
                if (!provider.equals(that.provider)) return false;
                return this.version.equals(that.version);
            }

            @Override
            public final int hashCode() {
                int result = this.category.hashCode();
                result = 31 * result + (this.owner.hashCode());
                result = 31 * result + (this.provider.hashCode());
                result = 31 * result + (this.version.hashCode());
                return result;
            }
        }
    }
    /**
     * A mapping of `artifactStore` objects and their corresponding AWS Regions.
     * <p>
     * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * ArtifactStoreMapProperty artifactStoreMapProperty = ArtifactStoreMapProperty.builder()
     *         .artifactStore(ArtifactStoreProperty.builder()
     *                 .location("location")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .encryptionKey(EncryptionKeyProperty.builder()
     *                         .id("id")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .region("region")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreMapProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactStoreMapProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactStoreMapProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Represents information about the S3 bucket where artifacts are stored for the pipeline.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getArtifactStore();

        /**
         * The action declaration's AWS Region, such as us-east-1.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRegion();

        /**
         * @return a {@link Builder} of {@link ArtifactStoreMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactStoreMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactStoreMapProperty> {
            java.lang.Object artifactStore;
            java.lang.String region;

            /**
             * Sets the value of {@link ArtifactStoreMapProperty#getArtifactStore}
             * @param artifactStore Represents information about the S3 bucket where artifacts are stored for the pipeline. This parameter is required.
             *                      <blockquote>
             *                      <p>
             *                      You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder artifactStore(software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreProperty artifactStore) {
                this.artifactStore = artifactStore;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreMapProperty#getArtifactStore}
             * @param artifactStore Represents information about the S3 bucket where artifacts are stored for the pipeline. This parameter is required.
             *                      <blockquote>
             *                      <p>
             *                      You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder artifactStore(software.amazon.awscdk.IResolvable artifactStore) {
                this.artifactStore = artifactStore;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreMapProperty#getRegion}
             * @param region The action declaration's AWS Region, such as us-east-1. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder region(java.lang.String region) {
                this.region = region;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactStoreMapProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactStoreMapProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArtifactStoreMapProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactStoreMapProperty {
            private final java.lang.Object artifactStore;
            private final java.lang.String region;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.artifactStore = software.amazon.jsii.Kernel.get(this, "artifactStore", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.region = software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.artifactStore = java.util.Objects.requireNonNull(builder.artifactStore, "artifactStore is required");
                this.region = java.util.Objects.requireNonNull(builder.region, "region is required");
            }

            @Override
            public final java.lang.Object getArtifactStore() {
                return this.artifactStore;
            }

            @Override
            public final java.lang.String getRegion() {
                return this.region;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("artifactStore", om.valueToTree(this.getArtifactStore()));
                data.set("region", om.valueToTree(this.getRegion()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreMapProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactStoreMapProperty.Jsii$Proxy that = (ArtifactStoreMapProperty.Jsii$Proxy) o;

                if (!artifactStore.equals(that.artifactStore)) return false;
                return this.region.equals(that.region);
            }

            @Override
            public final int hashCode() {
                int result = this.artifactStore.hashCode();
                result = 31 * result + (this.region.hashCode());
                return result;
            }
        }
    }
    /**
     * The S3 bucket where artifacts for the pipeline are stored.
     * <p>
     * <blockquote>
     * <p>
     * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * ArtifactStoreProperty artifactStoreProperty = ArtifactStoreProperty.builder()
     *         .location("location")
     *         .type("type")
     *         // the properties below are optional
     *         .encryptionKey(EncryptionKeyProperty.builder()
     *                 .id("id")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreProperty")
    @software.amazon.jsii.Jsii.Proxy(ArtifactStoreProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ArtifactStoreProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket used for storing the artifacts for a pipeline.
         * <p>
         * You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocation();

        /**
         * The type of the artifact store, such as S3.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key.
         * <p>
         * If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html">AWS::CodePipeline::Pipeline</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ArtifactStoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ArtifactStoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ArtifactStoreProperty> {
            java.lang.String location;
            java.lang.String type;
            java.lang.Object encryptionKey;

            /**
             * Sets the value of {@link ArtifactStoreProperty#getLocation}
             * @param location The S3 bucket used for storing the artifacts for a pipeline. This parameter is required.
             *                 You can specify the name of an S3 bucket but not a folder in the bucket. A folder to contain the pipeline artifacts is created for you based on the name of the pipeline. You can use any S3 bucket in the same AWS Region as the pipeline to store your pipeline artifacts.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder location(java.lang.String location) {
                this.location = location;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreProperty#getType}
             * @param type The type of the artifact store, such as S3. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreProperty#getEncryptionKey}
             * @param encryptionKey The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key.
             *                      If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html">AWS::CodePipeline::Pipeline</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(software.amazon.awscdk.services.codepipeline.CfnPipeline.EncryptionKeyProperty encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Sets the value of {@link ArtifactStoreProperty#getEncryptionKey}
             * @param encryptionKey The encryption key used to encrypt the data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key.
             *                      If this is undefined, the default key for Amazon S3 is used. To see an example artifact store encryption key field, see the example structure here: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codepipeline-pipeline.html">AWS::CodePipeline::Pipeline</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(software.amazon.awscdk.IResolvable encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ArtifactStoreProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ArtifactStoreProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ArtifactStoreProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ArtifactStoreProperty {
            private final java.lang.String location;
            private final java.lang.String type;
            private final java.lang.Object encryptionKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.location = software.amazon.jsii.Kernel.get(this, "location", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.location = java.util.Objects.requireNonNull(builder.location, "location is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.encryptionKey = builder.encryptionKey;
            }

            @Override
            public final java.lang.String getLocation() {
                return this.location;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getEncryptionKey() {
                return this.encryptionKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("location", om.valueToTree(this.getLocation()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getEncryptionKey() != null) {
                    data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.ArtifactStoreProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ArtifactStoreProperty.Jsii$Proxy that = (ArtifactStoreProperty.Jsii$Proxy) o;

                if (!location.equals(that.location)) return false;
                if (!type.equals(that.type)) return false;
                return this.encryptionKey != null ? this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.location.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Reserved for future use.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * BlockerDeclarationProperty blockerDeclarationProperty = BlockerDeclarationProperty.builder()
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.BlockerDeclarationProperty")
    @software.amazon.jsii.Jsii.Proxy(BlockerDeclarationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BlockerDeclarationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Reserved for future use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Reserved for future use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link BlockerDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BlockerDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BlockerDeclarationProperty> {
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link BlockerDeclarationProperty#getName}
             * @param name Reserved for future use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link BlockerDeclarationProperty#getType}
             * @param type Reserved for future use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BlockerDeclarationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BlockerDeclarationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BlockerDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BlockerDeclarationProperty {
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.BlockerDeclarationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BlockerDeclarationProperty.Jsii$Proxy that = (BlockerDeclarationProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Represents information about the key used to encrypt data in the artifact store, such as an AWS Key Management Service ( AWS KMS) key.
     * <p>
     * <code>EncryptionKey</code> is a property of the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codepipeline-pipeline-artifactstore.html">ArtifactStore</a> property type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * EncryptionKeyProperty encryptionKeyProperty = EncryptionKeyProperty.builder()
     *         .id("id")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.EncryptionKeyProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionKeyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionKeyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID used to identify the key.
         * <p>
         * For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
         * <p>
         * <blockquote>
         * <p>
         * Aliases are recognized only in the account that created the AWS KMS key. For cross-account actions, you can only use the key ID or key ARN to identify the key.
         * <p>
         * </blockquote>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * The type of encryption key, such as an AWS KMS key.
         * <p>
         * When creating or updating a pipeline, the value must be set to 'KMS'.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link EncryptionKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionKeyProperty> {
            java.lang.String id;
            java.lang.String type;

            /**
             * Sets the value of {@link EncryptionKeyProperty#getId}
             * @param id The ID used to identify the key. This parameter is required.
             *           For an AWS KMS key, you can use the key ID, the key ARN, or the alias ARN.
             *           <p>
             *           <blockquote>
             *           <p>
             *           Aliases are recognized only in the account that created the AWS KMS key. For cross-account actions, you can only use the key ID or key ARN to identify the key.
             *           <p>
             *           </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionKeyProperty#getType}
             * @param type The type of encryption key, such as an AWS KMS key. This parameter is required.
             *             When creating or updating a pipeline, the value must be set to 'KMS'.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionKeyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionKeyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionKeyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionKeyProperty {
            private final java.lang.String id;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.id = java.util.Objects.requireNonNull(builder.id, "id is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("id", om.valueToTree(this.getId()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.EncryptionKeyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionKeyProperty.Jsii$Proxy that = (EncryptionKeyProperty.Jsii$Proxy) o;

                if (!id.equals(that.id)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.id.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Represents information about an artifact to be worked on, such as a test or build artifact.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * InputArtifactProperty inputArtifactProperty = InputArtifactProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.InputArtifactProperty")
    @software.amazon.jsii.Jsii.Proxy(InputArtifactProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InputArtifactProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the artifact to be worked on (for example, "My App").
         * <p>
         * The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link InputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InputArtifactProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link InputArtifactProperty#getName}
             * @param name The name of the artifact to be worked on (for example, "My App"). This parameter is required.
             *             The input artifact of an action must exactly match the output artifact declared in a preceding action, but the input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InputArtifactProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InputArtifactProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InputArtifactProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.InputArtifactProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InputArtifactProperty.Jsii$Proxy that = (InputArtifactProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * Represents information about the output of an action.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * OutputArtifactProperty outputArtifactProperty = OutputArtifactProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.OutputArtifactProperty")
    @software.amazon.jsii.Jsii.Proxy(OutputArtifactProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OutputArtifactProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the output of an artifact, such as "My App".
         * <p>
         * The output artifact name must exactly match the input artifact declared for a downstream action. However, the downstream action's input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
         * <p>
         * Output artifact names must be unique within a pipeline.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * @return a {@link Builder} of {@link OutputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OutputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OutputArtifactProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link OutputArtifactProperty#getName}
             * @param name The name of the output of an artifact, such as "My App". This parameter is required.
             *             The output artifact name must exactly match the input artifact declared for a downstream action. However, the downstream action's input artifact does not have to be the next action in strict sequence from the action that provided the output artifact. Actions in parallel can declare different output artifacts, which are in turn consumed by different following actions.
             *             <p>
             *             Output artifact names must be unique within a pipeline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OutputArtifactProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OutputArtifactProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OutputArtifactProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OutputArtifactProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.OutputArtifactProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OutputArtifactProperty.Jsii$Proxy that = (OutputArtifactProperty.Jsii$Proxy) o;

                return this.name.equals(that.name);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                return result;
            }
        }
    }
    /**
     * Represents information about a stage and its definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * Object configuration;
     * StageDeclarationProperty stageDeclarationProperty = StageDeclarationProperty.builder()
     *         .actions(List.of(ActionDeclarationProperty.builder()
     *                 .actionTypeId(ActionTypeIdProperty.builder()
     *                         .category("category")
     *                         .owner("owner")
     *                         .provider("provider")
     *                         .version("version")
     *                         .build())
     *                 .name("name")
     *                 // the properties below are optional
     *                 .configuration(configuration)
     *                 .inputArtifacts(List.of(InputArtifactProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .namespace("namespace")
     *                 .outputArtifacts(List.of(OutputArtifactProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .region("region")
     *                 .roleArn("roleArn")
     *                 .runOrder(123)
     *                 .build()))
     *         .name("name")
     *         // the properties below are optional
     *         .blockers(List.of(BlockerDeclarationProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.StageDeclarationProperty")
    @software.amazon.jsii.Jsii.Proxy(StageDeclarationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StageDeclarationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The actions included in a stage.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getActions();

        /**
         * The name of the stage.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Reserved for future use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBlockers() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StageDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StageDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StageDeclarationProperty> {
            java.lang.Object actions;
            java.lang.String name;
            java.lang.Object blockers;

            /**
             * Sets the value of {@link StageDeclarationProperty#getActions}
             * @param actions The actions included in a stage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(software.amazon.awscdk.IResolvable actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getActions}
             * @param actions The actions included in a stage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder actions(java.util.List<? extends java.lang.Object> actions) {
                this.actions = actions;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getName}
             * @param name The name of the stage. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getBlockers}
             * @param blockers Reserved for future use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockers(software.amazon.awscdk.IResolvable blockers) {
                this.blockers = blockers;
                return this;
            }

            /**
             * Sets the value of {@link StageDeclarationProperty#getBlockers}
             * @param blockers Reserved for future use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder blockers(java.util.List<? extends java.lang.Object> blockers) {
                this.blockers = blockers;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageDeclarationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StageDeclarationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StageDeclarationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageDeclarationProperty {
            private final java.lang.Object actions;
            private final java.lang.String name;
            private final java.lang.Object blockers;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.blockers = software.amazon.jsii.Kernel.get(this, "blockers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.actions = java.util.Objects.requireNonNull(builder.actions, "actions is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.blockers = builder.blockers;
            }

            @Override
            public final java.lang.Object getActions() {
                return this.actions;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getBlockers() {
                return this.blockers;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("actions", om.valueToTree(this.getActions()));
                data.set("name", om.valueToTree(this.getName()));
                if (this.getBlockers() != null) {
                    data.set("blockers", om.valueToTree(this.getBlockers()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.StageDeclarationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StageDeclarationProperty.Jsii$Proxy that = (StageDeclarationProperty.Jsii$Proxy) o;

                if (!actions.equals(that.actions)) return false;
                if (!name.equals(that.name)) return false;
                return this.blockers != null ? this.blockers.equals(that.blockers) : that.blockers == null;
            }

            @Override
            public final int hashCode() {
                int result = this.actions.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.blockers != null ? this.blockers.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The name of the pipeline in which you want to disable the flow of artifacts from one stage to another.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.codepipeline.*;
     * StageTransitionProperty stageTransitionProperty = StageTransitionProperty.builder()
     *         .reason("reason")
     *         .stageName("stageName")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CfnPipeline.StageTransitionProperty")
    @software.amazon.jsii.Jsii.Proxy(StageTransitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StageTransitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests.
         * <p>
         * This message is displayed in the pipeline console UI.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getReason();

        /**
         * The name of the stage where you want to disable the inbound or outbound transition of artifacts.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getStageName();

        /**
         * @return a {@link Builder} of {@link StageTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StageTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StageTransitionProperty> {
            java.lang.String reason;
            java.lang.String stageName;

            /**
             * Sets the value of {@link StageTransitionProperty#getReason}
             * @param reason The reason given to the user that a stage is disabled, such as waiting for manual approval or manual tests. This parameter is required.
             *               This message is displayed in the pipeline console UI.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reason(java.lang.String reason) {
                this.reason = reason;
                return this;
            }

            /**
             * Sets the value of {@link StageTransitionProperty#getStageName}
             * @param stageName The name of the stage where you want to disable the inbound or outbound transition of artifacts. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stageName(java.lang.String stageName) {
                this.stageName = stageName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StageTransitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StageTransitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StageTransitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StageTransitionProperty {
            private final java.lang.String reason;
            private final java.lang.String stageName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.reason = software.amazon.jsii.Kernel.get(this, "reason", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.stageName = software.amazon.jsii.Kernel.get(this, "stageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.reason = java.util.Objects.requireNonNull(builder.reason, "reason is required");
                this.stageName = java.util.Objects.requireNonNull(builder.stageName, "stageName is required");
            }

            @Override
            public final java.lang.String getReason() {
                return this.reason;
            }

            @Override
            public final java.lang.String getStageName() {
                return this.stageName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("reason", om.valueToTree(this.getReason()));
                data.set("stageName", om.valueToTree(this.getStageName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CfnPipeline.StageTransitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StageTransitionProperty.Jsii$Proxy that = (StageTransitionProperty.Jsii$Proxy) o;

                if (!reason.equals(that.reason)) return false;
                return this.stageName.equals(that.stageName);
            }

            @Override
            public final int hashCode() {
                int result = this.reason.hashCode();
                result = 31 * result + (this.stageName.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.CfnPipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.CfnPipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codepipeline.CfnPipelineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codepipeline.CfnPipelineProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no `actionRoleArn` , or to use to assume roles for actions with an `actionRoleArn` .
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) for CodePipeline to use to either perform actions with no `actionRoleArn` , or to use to assume roles for actions with an `actionRoleArn` . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * Represents information about a stage and its definition.
         * <p>
         * @return {@code this}
         * @param stages Represents information about a stage and its definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(final software.amazon.awscdk.IResolvable stages) {
            this.props.stages(stages);
            return this;
        }
        /**
         * Represents information about a stage and its definition.
         * <p>
         * @return {@code this}
         * @param stages Represents information about a stage and its definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stages(final java.util.List<? extends java.lang.Object> stages) {
            this.props.stages(stages);
            return this;
        }

        /**
         * The S3 bucket where artifacts for the pipeline are stored.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param artifactStore The S3 bucket where artifacts for the pipeline are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStore(final software.amazon.awscdk.services.codepipeline.CfnPipeline.ArtifactStoreProperty artifactStore) {
            this.props.artifactStore(artifactStore);
            return this;
        }
        /**
         * The S3 bucket where artifacts for the pipeline are stored.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param artifactStore The S3 bucket where artifacts for the pipeline are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStore(final software.amazon.awscdk.IResolvable artifactStore) {
            this.props.artifactStore(artifactStore);
            return this;
        }

        /**
         * A mapping of `artifactStore` objects and their corresponding AWS Regions.
         * <p>
         * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param artifactStores A mapping of `artifactStore` objects and their corresponding AWS Regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStores(final software.amazon.awscdk.IResolvable artifactStores) {
            this.props.artifactStores(artifactStores);
            return this;
        }
        /**
         * A mapping of `artifactStore` objects and their corresponding AWS Regions.
         * <p>
         * There must be an artifact store for the pipeline Region and for each cross-region action in the pipeline.
         * <p>
         * <blockquote>
         * <p>
         * You must include either <code>artifactStore</code> or <code>artifactStores</code> in your pipeline, but you cannot use both. If you create a cross-region action in your pipeline, you must use <code>artifactStores</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param artifactStores A mapping of `artifactStore` objects and their corresponding AWS Regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactStores(final java.util.List<? extends java.lang.Object> artifactStores) {
            this.props.artifactStores(artifactStores);
            return this;
        }

        /**
         * Represents the input of a `DisableStageTransition` action.
         * <p>
         * @return {@code this}
         * @param disableInboundStageTransitions Represents the input of a `DisableStageTransition` action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableInboundStageTransitions(final software.amazon.awscdk.IResolvable disableInboundStageTransitions) {
            this.props.disableInboundStageTransitions(disableInboundStageTransitions);
            return this;
        }
        /**
         * Represents the input of a `DisableStageTransition` action.
         * <p>
         * @return {@code this}
         * @param disableInboundStageTransitions Represents the input of a `DisableStageTransition` action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableInboundStageTransitions(final java.util.List<? extends java.lang.Object> disableInboundStageTransitions) {
            this.props.disableInboundStageTransitions(disableInboundStageTransitions);
            return this;
        }

        /**
         * The name of the pipeline.
         * <p>
         * @return {@code this}
         * @param name The name of the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * Indicates whether to rerun the CodePipeline pipeline after you update it.
         * <p>
         * @return {@code this}
         * @param restartExecutionOnUpdate Indicates whether to rerun the CodePipeline pipeline after you update it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(final java.lang.Boolean restartExecutionOnUpdate) {
            this.props.restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }
        /**
         * Indicates whether to rerun the CodePipeline pipeline after you update it.
         * <p>
         * @return {@code this}
         * @param restartExecutionOnUpdate Indicates whether to rerun the CodePipeline pipeline after you update it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restartExecutionOnUpdate(final software.amazon.awscdk.IResolvable restartExecutionOnUpdate) {
            this.props.restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        /**
         * Specifies the tags applied to the pipeline.
         * <p>
         * @return {@code this}
         * @param tags Specifies the tags applied to the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codepipeline.CfnPipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.CfnPipeline build() {
            return new software.amazon.awscdk.services.codepipeline.CfnPipeline(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
