package software.amazon.awscdk.services.cognito;

/**
 * A CloudFormation `AWS::Cognito::UserPoolIdentityProvider`.
 * <p>
 * The <code>AWS::Cognito::UserPoolIdentityProvider</code> resource creates an identity provider for a user pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * Object attributeMapping;
 * Object providerDetails;
 * CfnUserPoolIdentityProvider cfnUserPoolIdentityProvider = CfnUserPoolIdentityProvider.Builder.create(this, "MyCfnUserPoolIdentityProvider")
 *         .providerName("providerName")
 *         .providerType("providerType")
 *         .userPoolId("userPoolId")
 *         // the properties below are optional
 *         .attributeMapping(attributeMapping)
 *         .idpIdentifiers(List.of("idpIdentifiers"))
 *         .providerDetails(providerDetails)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.765Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.CfnUserPoolIdentityProvider")
public class CfnUserPoolIdentityProvider extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnUserPoolIdentityProvider(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUserPoolIdentityProvider(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.CfnUserPoolIdentityProvider.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Cognito::UserPoolIdentityProvider`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUserPoolIdentityProvider(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.CfnUserPoolIdentityProviderProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A mapping of identity provider attributes to standard and custom user pool attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAttributeMapping() {
        return software.amazon.jsii.Kernel.get(this, "attributeMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A mapping of identity provider attributes to standard and custom user pool attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAttributeMapping(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "attributeMapping", java.util.Objects.requireNonNull(value, "attributeMapping is required"));
    }

    /**
     * The identity provider details. The following list describes the provider detail keys for each identity provider type.
     * <p>
     * <ul>
     * <li>For Google and Login with Amazon:</li>
     * <li>client_id</li>
     * <li>client_secret</li>
     * <li>authorize_scopes</li>
     * <li>For Facebook:</li>
     * <li>client_id</li>
     * <li>client_secret</li>
     * <li>authorize_scopes</li>
     * <li>api_version</li>
     * <li>For Sign in with Apple:</li>
     * <li>client_id</li>
     * <li>team_id</li>
     * <li>key_id</li>
     * <li>private_key</li>
     * <li>authorize_scopes</li>
     * <li>For OpenID Connect (OIDC) providers:</li>
     * <li>client_id</li>
     * <li>client_secret</li>
     * <li>attributes_request_method</li>
     * <li>oidc_issuer</li>
     * <li>authorize_scopes</li>
     * <li>authorize_url <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li>token_url <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li>attributes_url <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li>jwks_uri <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li>attributes_url_add_attributes <em>a read-only property that is set automatically</em></li>
     * <li>For SAML providers:</li>
     * <li>MetadataFile OR MetadataURL</li>
     * <li>IDPSignout (optional)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getProviderDetails() {
        return software.amazon.jsii.Kernel.get(this, "providerDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The identity provider details. The following list describes the provider detail keys for each identity provider type.
     * <p>
     * <ul>
     * <li>For Google and Login with Amazon:</li>
     * <li>client_id</li>
     * <li>client_secret</li>
     * <li>authorize_scopes</li>
     * <li>For Facebook:</li>
     * <li>client_id</li>
     * <li>client_secret</li>
     * <li>authorize_scopes</li>
     * <li>api_version</li>
     * <li>For Sign in with Apple:</li>
     * <li>client_id</li>
     * <li>team_id</li>
     * <li>key_id</li>
     * <li>private_key</li>
     * <li>authorize_scopes</li>
     * <li>For OpenID Connect (OIDC) providers:</li>
     * <li>client_id</li>
     * <li>client_secret</li>
     * <li>attributes_request_method</li>
     * <li>oidc_issuer</li>
     * <li>authorize_scopes</li>
     * <li>authorize_url <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li>token_url <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li>attributes_url <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li>jwks_uri <em>if not available from discovery URL specified by oidc_issuer key</em></li>
     * <li>attributes_url_add_attributes <em>a read-only property that is set automatically</em></li>
     * <li>For SAML providers:</li>
     * <li>MetadataFile OR MetadataURL</li>
     * <li>IDPSignout (optional)</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProviderDetails(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "providerDetails", java.util.Objects.requireNonNull(value, "providerDetails is required"));
    }

    /**
     * The identity provider name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProviderName() {
        return software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identity provider name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProviderName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "providerName", java.util.Objects.requireNonNull(value, "providerName is required"));
    }

    /**
     * The identity provider type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProviderType() {
        return software.amazon.jsii.Kernel.get(this, "providerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identity provider type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProviderType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "providerType", java.util.Objects.requireNonNull(value, "providerType is required"));
    }

    /**
     * The user pool ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getUserPoolId() {
        return software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user pool ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setUserPoolId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "userPoolId", java.util.Objects.requireNonNull(value, "userPoolId is required"));
    }

    /**
     * A list of identity provider identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdpIdentifiers() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "idpIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of identity provider identifiers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdpIdentifiers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "idpIdentifiers", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.CfnUserPoolIdentityProvider}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.CfnUserPoolIdentityProvider> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.CfnUserPoolIdentityProviderProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.CfnUserPoolIdentityProviderProps.Builder();
        }

        /**
         * The identity provider name.
         * <p>
         * @return {@code this}
         * @param providerName The identity provider name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerName(final java.lang.String providerName) {
            this.props.providerName(providerName);
            return this;
        }

        /**
         * The identity provider type.
         * <p>
         * @return {@code this}
         * @param providerType The identity provider type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerType(final java.lang.String providerType) {
            this.props.providerType(providerType);
            return this;
        }

        /**
         * The user pool ID.
         * <p>
         * @return {@code this}
         * @param userPoolId The user pool ID. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolId(final java.lang.String userPoolId) {
            this.props.userPoolId(userPoolId);
            return this;
        }

        /**
         * A mapping of identity provider attributes to standard and custom user pool attributes.
         * <p>
         * @return {@code this}
         * @param attributeMapping A mapping of identity provider attributes to standard and custom user pool attributes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(final java.lang.Object attributeMapping) {
            this.props.attributeMapping(attributeMapping);
            return this;
        }

        /**
         * A list of identity provider identifiers.
         * <p>
         * @return {@code this}
         * @param idpIdentifiers A list of identity provider identifiers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idpIdentifiers(final java.util.List<java.lang.String> idpIdentifiers) {
            this.props.idpIdentifiers(idpIdentifiers);
            return this;
        }

        /**
         * The identity provider details. The following list describes the provider detail keys for each identity provider type.
         * <p>
         * <ul>
         * <li>For Google and Login with Amazon:</li>
         * <li>client_id</li>
         * <li>client_secret</li>
         * <li>authorize_scopes</li>
         * <li>For Facebook:</li>
         * <li>client_id</li>
         * <li>client_secret</li>
         * <li>authorize_scopes</li>
         * <li>api_version</li>
         * <li>For Sign in with Apple:</li>
         * <li>client_id</li>
         * <li>team_id</li>
         * <li>key_id</li>
         * <li>private_key</li>
         * <li>authorize_scopes</li>
         * <li>For OpenID Connect (OIDC) providers:</li>
         * <li>client_id</li>
         * <li>client_secret</li>
         * <li>attributes_request_method</li>
         * <li>oidc_issuer</li>
         * <li>authorize_scopes</li>
         * <li>authorize_url <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li>token_url <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li>attributes_url <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li>jwks_uri <em>if not available from discovery URL specified by oidc_issuer key</em></li>
         * <li>attributes_url_add_attributes <em>a read-only property that is set automatically</em></li>
         * <li>For SAML providers:</li>
         * <li>MetadataFile OR MetadataURL</li>
         * <li>IDPSignout (optional)</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param providerDetails The identity provider details. The following list describes the provider detail keys for each identity provider type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder providerDetails(final java.lang.Object providerDetails) {
            this.props.providerDetails(providerDetails);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cognito.CfnUserPoolIdentityProvider}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.CfnUserPoolIdentityProvider build() {
            return new software.amazon.awscdk.services.cognito.CfnUserPoolIdentityProvider(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
