package software.amazon.awscdk.services.cognito;

/**
 * Options to create a UserPoolDomain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool pool = new UserPool(this, "Pool");
 * pool.addDomain("CognitoDomain", UserPoolDomainOptions.builder()
 *         .cognitoDomain(CognitoDomainOptions.builder()
 *                 .domainPrefix("my-awesome-app")
 *                 .build())
 *         .build());
 * String certificateArn = "arn:aws:acm:us-east-1:123456789012:certificate/11-3336f1-44483d-adc7-9cd375c5169d";
 * ICertificate domainCert = Certificate.fromCertificateArn(this, "domainCert", certificateArn);
 * pool.addDomain("CustomDomain", UserPoolDomainOptions.builder()
 *         .customDomain(CustomDomainOptions.builder()
 *                 .domainName("user.myapp.com")
 *                 .certificate(domainCert)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.819Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolDomainOptions")
@software.amazon.jsii.Jsii.Proxy(UserPoolDomainOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolDomainOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Associate a cognito prefix domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
     * <p>
     * Default: - not set if `customDomain` is specified, otherwise, throws an error.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain-prefix.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CognitoDomainOptions getCognitoDomain() {
        return null;
    }

    /**
     * Associate a custom domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
     * <p>
     * Default: - not set if `cognitoDomain` is specified, otherwise, throws an error.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-add-custom-domain.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.CustomDomainOptions getCustomDomain() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolDomainOptions> {
        software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain;
        software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain;

        /**
         * Sets the value of {@link UserPoolDomainOptions#getCognitoDomain}
         * @param cognitoDomain Associate a cognito prefix domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoDomain(software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain) {
            this.cognitoDomain = cognitoDomain;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolDomainOptions#getCustomDomain}
         * @param customDomain Associate a custom domain with your user pool Either `customDomain` or `cognitoDomain` must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customDomain(software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain) {
            this.customDomain = customDomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolDomainOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolDomainOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolDomainOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolDomainOptions {
        private final software.amazon.awscdk.services.cognito.CognitoDomainOptions cognitoDomain;
        private final software.amazon.awscdk.services.cognito.CustomDomainOptions customDomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cognitoDomain = software.amazon.jsii.Kernel.get(this, "cognitoDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.CognitoDomainOptions.class));
            this.customDomain = software.amazon.jsii.Kernel.get(this, "customDomain", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.CustomDomainOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cognitoDomain = builder.cognitoDomain;
            this.customDomain = builder.customDomain;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.CognitoDomainOptions getCognitoDomain() {
            return this.cognitoDomain;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.CustomDomainOptions getCustomDomain() {
            return this.customDomain;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCognitoDomain() != null) {
                data.set("cognitoDomain", om.valueToTree(this.getCognitoDomain()));
            }
            if (this.getCustomDomain() != null) {
                data.set("customDomain", om.valueToTree(this.getCustomDomain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolDomainOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolDomainOptions.Jsii$Proxy that = (UserPoolDomainOptions.Jsii$Proxy) o;

            if (this.cognitoDomain != null ? !this.cognitoDomain.equals(that.cognitoDomain) : that.cognitoDomain != null) return false;
            return this.customDomain != null ? this.customDomain.equals(that.customDomain) : that.customDomain == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cognitoDomain != null ? this.cognitoDomain.hashCode() : 0;
            result = 31 * result + (this.customDomain != null ? this.customDomain.hashCode() : 0);
            return result;
        }
    }
}
