package software.amazon.awscdk.services.cognito;

/**
 * User pool operations to which lambda triggers can be attached.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function authChallengeFn = Function.Builder.create(this, "authChallengeFn")
 *         .runtime(Runtime.NODEJS_12_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "path/to/asset")))
 *         .build();
 * UserPool userpool = UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .lambdaTriggers(UserPoolTriggers.builder()
 *                 .createAuthChallenge(authChallengeFn)
 *                 .build())
 *         .build();
 * userpool.addTrigger(UserPoolOperation.USER_MIGRATION, Function.Builder.create(this, "userMigrationFn")
 *         .runtime(Runtime.NODEJS_12_X)
 *         .handler("index.handler")
 *         .code(Code.fromAsset(join(__dirname, "path/to/asset")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.824Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolOperation")
public class UserPoolOperation extends software.amazon.jsii.JsiiObject {

    protected UserPoolOperation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolOperation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CREATE_AUTH_CHALLENGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "CREATE_AUTH_CHALLENGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        CUSTOM_EMAIL_SENDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "CUSTOM_EMAIL_SENDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        CUSTOM_MESSAGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "CUSTOM_MESSAGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        CUSTOM_SMS_SENDER = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "CUSTOM_SMS_SENDER", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        DEFINE_AUTH_CHALLENGE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "DEFINE_AUTH_CHALLENGE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        POST_AUTHENTICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "POST_AUTHENTICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        POST_CONFIRMATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "POST_CONFIRMATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        PRE_AUTHENTICATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "PRE_AUTHENTICATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        PRE_SIGN_UP = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "PRE_SIGN_UP", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        PRE_TOKEN_GENERATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "PRE_TOKEN_GENERATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        USER_MIGRATION = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "USER_MIGRATION", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
        VERIFY_AUTH_CHALLENGE_RESPONSE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "VERIFY_AUTH_CHALLENGE_RESPONSE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class));
    }

    /**
     * A custom user pool operation.
     * <p>
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolOperation of(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cognito.UserPoolOperation.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolOperation.class), new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * Creates a challenge in a custom auth flow.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-create-auth-challenge.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation CREATE_AUTH_CHALLENGE;

    /**
     * Amazon Cognito invokes this trigger to send email notifications to users.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-email-sender.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation CUSTOM_EMAIL_SENDER;

    /**
     * Advanced customization and localization of messages.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-message.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation CUSTOM_MESSAGE;

    /**
     * Amazon Cognito invokes this trigger to send email notifications to users.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-custom-sms-sender.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation CUSTOM_SMS_SENDER;

    /**
     * Determines the next challenge in a custom auth flow.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-define-auth-challenge.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation DEFINE_AUTH_CHALLENGE;

    /**
     * Event logging for custom analytics.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-authentication.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation POST_AUTHENTICATION;

    /**
     * Custom welcome messages or event logging for custom analytics.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-post-confirmation.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation POST_CONFIRMATION;

    /**
     * Custom validation to accept or deny the sign-in request.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-authentication.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation PRE_AUTHENTICATION;

    /**
     * Custom validation to accept or deny the sign-up request.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-sign-up.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation PRE_SIGN_UP;

    /**
     * Add or remove attributes in Id tokens.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-pre-token-generation.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation PRE_TOKEN_GENERATION;

    /**
     * Migrate a user from an existing user directory to user pools.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-migrate-user.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation USER_MIGRATION;

    /**
     * Determines if a response is correct in a custom auth flow.
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-lambda-verify-auth-challenge-response.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.cognito.UserPoolOperation VERIFY_AUTH_CHALLENGE_RESPONSE;

    /**
     * The key to use in `CfnUserPool.LambdaConfigProperty`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getOperationName() {
        return software.amazon.jsii.Kernel.get(this, "operationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
