package software.amazon.awscdk.services.cognito;

/**
 * Properties for the UserPoolResourceServer construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * ResourceServerScope resourceServerScope;
 * UserPool userPool;
 * UserPoolResourceServerProps userPoolResourceServerProps = UserPoolResourceServerProps.builder()
 *         .identifier("identifier")
 *         .userPool(userPool)
 *         // the properties below are optional
 *         .scopes(List.of(resourceServerScope))
 *         .userPoolResourceServerName("userPoolResourceServerName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.826Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolResourceServerProps")
@software.amazon.jsii.Jsii.Proxy(UserPoolResourceServerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UserPoolResourceServerProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.cognito.UserPoolResourceServerOptions {

    /**
     * The user pool to add this resource server to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.IUserPool getUserPool();

    /**
     * @return a {@link Builder} of {@link UserPoolResourceServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolResourceServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolResourceServerProps> {
        software.amazon.awscdk.services.cognito.IUserPool userPool;
        java.lang.String identifier;
        java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope> scopes;
        java.lang.String userPoolResourceServerName;

        /**
         * Sets the value of {@link UserPoolResourceServerProps#getUserPool}
         * @param userPool The user pool to add this resource server to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.userPool = userPool;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolResourceServerProps#getIdentifier}
         * @param identifier A unique resource server identifier for the resource server. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolResourceServerProps#getScopes}
         * @param scopes Oauth scopes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder scopes(java.util.List<? extends software.amazon.awscdk.services.cognito.ResourceServerScope> scopes) {
            this.scopes = (java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope>)scopes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolResourceServerProps#getUserPoolResourceServerName}
         * @param userPoolResourceServerName A friendly name for the resource server.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPoolResourceServerName(java.lang.String userPoolResourceServerName) {
            this.userPoolResourceServerName = userPoolResourceServerName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolResourceServerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UserPoolResourceServerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UserPoolResourceServerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolResourceServerProps {
        private final software.amazon.awscdk.services.cognito.IUserPool userPool;
        private final java.lang.String identifier;
        private final java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope> scopes;
        private final java.lang.String userPoolResourceServerName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.userPool = software.amazon.jsii.Kernel.get(this, "userPool", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class));
            this.identifier = software.amazon.jsii.Kernel.get(this, "identifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.scopes = software.amazon.jsii.Kernel.get(this, "scopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ResourceServerScope.class)));
            this.userPoolResourceServerName = software.amazon.jsii.Kernel.get(this, "userPoolResourceServerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.userPool = java.util.Objects.requireNonNull(builder.userPool, "userPool is required");
            this.identifier = java.util.Objects.requireNonNull(builder.identifier, "identifier is required");
            this.scopes = (java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope>)builder.scopes;
            this.userPoolResourceServerName = builder.userPoolResourceServerName;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.IUserPool getUserPool() {
            return this.userPool;
        }

        @Override
        public final java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cognito.ResourceServerScope> getScopes() {
            return this.scopes;
        }

        @Override
        public final java.lang.String getUserPoolResourceServerName() {
            return this.userPoolResourceServerName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("userPool", om.valueToTree(this.getUserPool()));
            data.set("identifier", om.valueToTree(this.getIdentifier()));
            if (this.getScopes() != null) {
                data.set("scopes", om.valueToTree(this.getScopes()));
            }
            if (this.getUserPoolResourceServerName() != null) {
                data.set("userPoolResourceServerName", om.valueToTree(this.getUserPoolResourceServerName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolResourceServerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolResourceServerProps.Jsii$Proxy that = (UserPoolResourceServerProps.Jsii$Proxy) o;

            if (!userPool.equals(that.userPool)) return false;
            if (!identifier.equals(that.identifier)) return false;
            if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) return false;
            return this.userPoolResourceServerName != null ? this.userPoolResourceServerName.equals(that.userPoolResourceServerName) : that.userPoolResourceServerName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.userPool.hashCode();
            result = 31 * result + (this.identifier.hashCode());
            result = 31 * result + (this.scopes != null ? this.scopes.hashCode() : 0);
            result = 31 * result + (this.userPoolResourceServerName != null ? this.userPoolResourceServerName.hashCode() : 0);
            return result;
        }
    }
}
