package software.amazon.awscdk.services.config;

/**
 * A CloudFormation `AWS::Config::ConfigurationAggregator`.
 * <p>
 * The details about the configuration aggregator, including information about source accounts, regions, and metadata of the aggregator.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.config.*;
 * CfnConfigurationAggregator cfnConfigurationAggregator = CfnConfigurationAggregator.Builder.create(this, "MyCfnConfigurationAggregator")
 *         .accountAggregationSources(List.of(AccountAggregationSourceProperty.builder()
 *                 .accountIds(List.of("accountIds"))
 *                 // the properties below are optional
 *                 .allAwsRegions(false)
 *                 .awsRegions(List.of("awsRegions"))
 *                 .build()))
 *         .configurationAggregatorName("configurationAggregatorName")
 *         .organizationAggregationSource(OrganizationAggregationSourceProperty.builder()
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .allAwsRegions(false)
 *                 .awsRegions(List.of("awsRegions"))
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.836Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationAggregator")
public class CfnConfigurationAggregator extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConfigurationAggregator(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConfigurationAggregator(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.config.CfnConfigurationAggregator.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Config::ConfigurationAggregator`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationAggregator(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnConfigurationAggregatorProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Create a new `AWS::Config::ConfigurationAggregator`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConfigurationAggregator(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the aggregator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationAggregatorArn() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationAggregatorArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An array of tag object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Provides a list of source accounts and regions to be aggregated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccountAggregationSources() {
        return software.amazon.jsii.Kernel.get(this, "accountAggregationSources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides a list of source accounts and regions to be aggregated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountAggregationSources(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "accountAggregationSources", value);
    }

    /**
     * Provides a list of source accounts and regions to be aggregated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountAggregationSources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "accountAggregationSources", value);
    }

    /**
     * The name of the aggregator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getConfigurationAggregatorName() {
        return software.amazon.jsii.Kernel.get(this, "configurationAggregatorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the aggregator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationAggregatorName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "configurationAggregatorName", value);
    }

    /**
     * Provides an organization and list of regions to be aggregated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOrganizationAggregationSource() {
        return software.amazon.jsii.Kernel.get(this, "organizationAggregationSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Provides an organization and list of regions to be aggregated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationAggregationSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.config.CfnConfigurationAggregator.OrganizationAggregationSourceProperty value) {
        software.amazon.jsii.Kernel.set(this, "organizationAggregationSource", value);
    }

    /**
     * Provides an organization and list of regions to be aggregated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationAggregationSource(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "organizationAggregationSource", value);
    }
    /**
     * A collection of accounts and regions.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * AccountAggregationSourceProperty accountAggregationSourceProperty = AccountAggregationSourceProperty.builder()
     *         .accountIds(List.of("accountIds"))
     *         // the properties below are optional
     *         .allAwsRegions(false)
     *         .awsRegions(List.of("awsRegions"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationAggregator.AccountAggregationSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(AccountAggregationSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AccountAggregationSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The 12-digit account ID of the account being aggregated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAccountIds();

        /**
         * If true, aggregate existing AWS Config regions and future regions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllAwsRegions() {
            return null;
        }

        /**
         * The source regions being aggregated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAwsRegions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AccountAggregationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AccountAggregationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AccountAggregationSourceProperty> {
            java.util.List<java.lang.String> accountIds;
            java.lang.Object allAwsRegions;
            java.util.List<java.lang.String> awsRegions;

            /**
             * Sets the value of {@link AccountAggregationSourceProperty#getAccountIds}
             * @param accountIds The 12-digit account ID of the account being aggregated. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountIds(java.util.List<java.lang.String> accountIds) {
                this.accountIds = accountIds;
                return this;
            }

            /**
             * Sets the value of {@link AccountAggregationSourceProperty#getAllAwsRegions}
             * @param allAwsRegions If true, aggregate existing AWS Config regions and future regions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allAwsRegions(java.lang.Boolean allAwsRegions) {
                this.allAwsRegions = allAwsRegions;
                return this;
            }

            /**
             * Sets the value of {@link AccountAggregationSourceProperty#getAllAwsRegions}
             * @param allAwsRegions If true, aggregate existing AWS Config regions and future regions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allAwsRegions(software.amazon.awscdk.IResolvable allAwsRegions) {
                this.allAwsRegions = allAwsRegions;
                return this;
            }

            /**
             * Sets the value of {@link AccountAggregationSourceProperty#getAwsRegions}
             * @param awsRegions The source regions being aggregated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegions(java.util.List<java.lang.String> awsRegions) {
                this.awsRegions = awsRegions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AccountAggregationSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AccountAggregationSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AccountAggregationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AccountAggregationSourceProperty {
            private final java.util.List<java.lang.String> accountIds;
            private final java.lang.Object allAwsRegions;
            private final java.util.List<java.lang.String> awsRegions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountIds = software.amazon.jsii.Kernel.get(this, "accountIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allAwsRegions = software.amazon.jsii.Kernel.get(this, "allAwsRegions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsRegions = software.amazon.jsii.Kernel.get(this, "awsRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountIds = java.util.Objects.requireNonNull(builder.accountIds, "accountIds is required");
                this.allAwsRegions = builder.allAwsRegions;
                this.awsRegions = builder.awsRegions;
            }

            @Override
            public final java.util.List<java.lang.String> getAccountIds() {
                return this.accountIds;
            }

            @Override
            public final java.lang.Object getAllAwsRegions() {
                return this.allAwsRegions;
            }

            @Override
            public final java.util.List<java.lang.String> getAwsRegions() {
                return this.awsRegions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accountIds", om.valueToTree(this.getAccountIds()));
                if (this.getAllAwsRegions() != null) {
                    data.set("allAwsRegions", om.valueToTree(this.getAllAwsRegions()));
                }
                if (this.getAwsRegions() != null) {
                    data.set("awsRegions", om.valueToTree(this.getAwsRegions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationAggregator.AccountAggregationSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AccountAggregationSourceProperty.Jsii$Proxy that = (AccountAggregationSourceProperty.Jsii$Proxy) o;

                if (!accountIds.equals(that.accountIds)) return false;
                if (this.allAwsRegions != null ? !this.allAwsRegions.equals(that.allAwsRegions) : that.allAwsRegions != null) return false;
                return this.awsRegions != null ? this.awsRegions.equals(that.awsRegions) : that.awsRegions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountIds.hashCode();
                result = 31 * result + (this.allAwsRegions != null ? this.allAwsRegions.hashCode() : 0);
                result = 31 * result + (this.awsRegions != null ? this.awsRegions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This object contains regions to set up the aggregator and an IAM role to retrieve organization details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.config.*;
     * OrganizationAggregationSourceProperty organizationAggregationSourceProperty = OrganizationAggregationSourceProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .allAwsRegions(false)
     *         .awsRegions(List.of("awsRegions"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_config.CfnConfigurationAggregator.OrganizationAggregationSourceProperty")
    @software.amazon.jsii.Jsii.Proxy(OrganizationAggregationSourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OrganizationAggregationSourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * ARN of the IAM role used to retrieve AWS Organizations details associated with the aggregator account.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * If true, aggregate existing AWS Config regions and future regions.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllAwsRegions() {
            return null;
        }

        /**
         * The source regions being aggregated.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAwsRegions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OrganizationAggregationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OrganizationAggregationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OrganizationAggregationSourceProperty> {
            java.lang.String roleArn;
            java.lang.Object allAwsRegions;
            java.util.List<java.lang.String> awsRegions;

            /**
             * Sets the value of {@link OrganizationAggregationSourceProperty#getRoleArn}
             * @param roleArn ARN of the IAM role used to retrieve AWS Organizations details associated with the aggregator account. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationAggregationSourceProperty#getAllAwsRegions}
             * @param allAwsRegions If true, aggregate existing AWS Config regions and future regions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allAwsRegions(java.lang.Boolean allAwsRegions) {
                this.allAwsRegions = allAwsRegions;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationAggregationSourceProperty#getAllAwsRegions}
             * @param allAwsRegions If true, aggregate existing AWS Config regions and future regions.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allAwsRegions(software.amazon.awscdk.IResolvable allAwsRegions) {
                this.allAwsRegions = allAwsRegions;
                return this;
            }

            /**
             * Sets the value of {@link OrganizationAggregationSourceProperty#getAwsRegions}
             * @param awsRegions The source regions being aggregated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsRegions(java.util.List<java.lang.String> awsRegions) {
                this.awsRegions = awsRegions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OrganizationAggregationSourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OrganizationAggregationSourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OrganizationAggregationSourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OrganizationAggregationSourceProperty {
            private final java.lang.String roleArn;
            private final java.lang.Object allAwsRegions;
            private final java.util.List<java.lang.String> awsRegions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allAwsRegions = software.amazon.jsii.Kernel.get(this, "allAwsRegions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.awsRegions = software.amazon.jsii.Kernel.get(this, "awsRegions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.allAwsRegions = builder.allAwsRegions;
                this.awsRegions = builder.awsRegions;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getAllAwsRegions() {
                return this.allAwsRegions;
            }

            @Override
            public final java.util.List<java.lang.String> getAwsRegions() {
                return this.awsRegions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getAllAwsRegions() != null) {
                    data.set("allAwsRegions", om.valueToTree(this.getAllAwsRegions()));
                }
                if (this.getAwsRegions() != null) {
                    data.set("awsRegions", om.valueToTree(this.getAwsRegions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_config.CfnConfigurationAggregator.OrganizationAggregationSourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OrganizationAggregationSourceProperty.Jsii$Proxy that = (OrganizationAggregationSourceProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (this.allAwsRegions != null ? !this.allAwsRegions.equals(that.allAwsRegions) : that.allAwsRegions != null) return false;
                return this.awsRegions != null ? this.awsRegions.equals(that.awsRegions) : that.awsRegions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.allAwsRegions != null ? this.allAwsRegions.hashCode() : 0);
                result = 31 * result + (this.awsRegions != null ? this.awsRegions.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.config.CfnConfigurationAggregator}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.config.CfnConfigurationAggregator> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.config.CfnConfigurationAggregatorProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * Provides a list of source accounts and regions to be aggregated.
         * <p>
         * @return {@code this}
         * @param accountAggregationSources Provides a list of source accounts and regions to be aggregated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountAggregationSources(final software.amazon.awscdk.IResolvable accountAggregationSources) {
            this.props().accountAggregationSources(accountAggregationSources);
            return this;
        }
        /**
         * Provides a list of source accounts and regions to be aggregated.
         * <p>
         * @return {@code this}
         * @param accountAggregationSources Provides a list of source accounts and regions to be aggregated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountAggregationSources(final java.util.List<? extends java.lang.Object> accountAggregationSources) {
            this.props().accountAggregationSources(accountAggregationSources);
            return this;
        }

        /**
         * The name of the aggregator.
         * <p>
         * @return {@code this}
         * @param configurationAggregatorName The name of the aggregator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationAggregatorName(final java.lang.String configurationAggregatorName) {
            this.props().configurationAggregatorName(configurationAggregatorName);
            return this;
        }

        /**
         * Provides an organization and list of regions to be aggregated.
         * <p>
         * @return {@code this}
         * @param organizationAggregationSource Provides an organization and list of regions to be aggregated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationAggregationSource(final software.amazon.awscdk.services.config.CfnConfigurationAggregator.OrganizationAggregationSourceProperty organizationAggregationSource) {
            this.props().organizationAggregationSource(organizationAggregationSource);
            return this;
        }
        /**
         * Provides an organization and list of regions to be aggregated.
         * <p>
         * @return {@code this}
         * @param organizationAggregationSource Provides an organization and list of regions to be aggregated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationAggregationSource(final software.amazon.awscdk.IResolvable organizationAggregationSource) {
            this.props().organizationAggregationSource(organizationAggregationSource);
            return this;
        }

        /**
         * An array of tag object.
         * <p>
         * @return {@code this}
         * @param tags An array of tag object. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.config.CfnConfigurationAggregator}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.config.CfnConfigurationAggregator build() {
            return new software.amazon.awscdk.services.config.CfnConfigurationAggregator(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.config.CfnConfigurationAggregatorProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.config.CfnConfigurationAggregatorProps.Builder();
            }
            return this.props;
        }
    }
}
