package software.amazon.awscdk.services.databrew;

/**
 * Properties for defining a `CfnJob`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.databrew.*;
 * Object parameters;
 * CfnJobProps cfnJobProps = CfnJobProps.builder()
 *         .name("name")
 *         .roleArn("roleArn")
 *         .type("type")
 *         // the properties below are optional
 *         .databaseOutputs(List.of(DatabaseOutputProperty.builder()
 *                 .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .tempDirectory(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .glueConnectionName("glueConnectionName")
 *                 // the properties below are optional
 *                 .databaseOutputMode("databaseOutputMode")
 *                 .build()))
 *         .dataCatalogOutputs(List.of(DataCatalogOutputProperty.builder()
 *                 .databaseName("databaseName")
 *                 .tableName("tableName")
 *                 // the properties below are optional
 *                 .catalogId("catalogId")
 *                 .databaseOptions(DatabaseTableOutputOptionsProperty.builder()
 *                         .tableName("tableName")
 *                         // the properties below are optional
 *                         .tempDirectory(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .overwrite(false)
 *                 .s3Options(S3TableOutputOptionsProperty.builder()
 *                         .location(S3LocationProperty.builder()
 *                                 .bucket("bucket")
 *                                 // the properties below are optional
 *                                 .bucketOwner("bucketOwner")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .datasetName("datasetName")
 *         .encryptionKeyArn("encryptionKeyArn")
 *         .encryptionMode("encryptionMode")
 *         .jobSample(JobSampleProperty.builder()
 *                 .mode("mode")
 *                 .size(123)
 *                 .build())
 *         .logSubscription("logSubscription")
 *         .maxCapacity(123)
 *         .maxRetries(123)
 *         .outputLocation(OutputLocationProperty.builder()
 *                 .bucket("bucket")
 *                 // the properties below are optional
 *                 .bucketOwner("bucketOwner")
 *                 .key("key")
 *                 .build())
 *         .outputs(List.of(OutputProperty.builder()
 *                 .location(S3LocationProperty.builder()
 *                         .bucket("bucket")
 *                         // the properties below are optional
 *                         .bucketOwner("bucketOwner")
 *                         .key("key")
 *                         .build())
 *                 // the properties below are optional
 *                 .compressionFormat("compressionFormat")
 *                 .format("format")
 *                 .formatOptions(OutputFormatOptionsProperty.builder()
 *                         .csv(CsvOutputOptionsProperty.builder()
 *                                 .delimiter("delimiter")
 *                                 .build())
 *                         .build())
 *                 .maxOutputFiles(123)
 *                 .overwrite(false)
 *                 .partitionColumns(List.of("partitionColumns"))
 *                 .build()))
 *         .profileConfiguration(ProfileConfigurationProperty.builder()
 *                 .columnStatisticsConfigurations(List.of(ColumnStatisticsConfigurationProperty.builder()
 *                         .statistics(StatisticsConfigurationProperty.builder()
 *                                 .includedStatistics(List.of("includedStatistics"))
 *                                 .overrides(List.of(StatisticOverrideProperty.builder()
 *                                         .parameters(parameters)
 *                                         .statistic("statistic")
 *                                         .build()))
 *                                 .build())
 *                         // the properties below are optional
 *                         .selectors(List.of(ColumnSelectorProperty.builder()
 *                                 .name("name")
 *                                 .regex("regex")
 *                                 .build()))
 *                         .build()))
 *                 .datasetStatisticsConfiguration(StatisticsConfigurationProperty.builder()
 *                         .includedStatistics(List.of("includedStatistics"))
 *                         .overrides(List.of(StatisticOverrideProperty.builder()
 *                                 .parameters(parameters)
 *                                 .statistic("statistic")
 *                                 .build()))
 *                         .build())
 *                 .entityDetectorConfiguration(EntityDetectorConfigurationProperty.builder()
 *                         .entityTypes(List.of("entityTypes"))
 *                         // the properties below are optional
 *                         .allowedStatistics(AllowedStatisticsProperty.builder()
 *                                 .statistics(List.of("statistics"))
 *                                 .build())
 *                         .build())
 *                 .profileColumns(List.of(ColumnSelectorProperty.builder()
 *                         .name("name")
 *                         .regex("regex")
 *                         .build()))
 *                 .build())
 *         .projectName("projectName")
 *         .recipe(RecipeProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .timeout(123)
 *         .validationConfigurations(List.of(ValidationConfigurationProperty.builder()
 *                 .rulesetArn("rulesetArn")
 *                 // the properties below are optional
 *                 .validationMode("validationMode")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:41.922Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_databrew.CfnJobProps")
@software.amazon.jsii.Jsii.Proxy(CfnJobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnJobProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::DataBrew::Job.Name`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * `AWS::DataBrew::Job.RoleArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * `AWS::DataBrew::Job.Type`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * `AWS::DataBrew::Job.DatabaseOutputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDatabaseOutputs() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.DataCatalogOutputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDataCatalogOutputs() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.DatasetName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatasetName() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.EncryptionKeyArn`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.EncryptionMode`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionMode() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.JobSample`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getJobSample() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.LogSubscription`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLogSubscription() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.MaxCapacity`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.MaxRetries`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetries() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.OutputLocation`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutputLocation() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.Outputs`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOutputs() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.ProfileConfiguration`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProfileConfiguration() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.ProjectName`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProjectName() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.Recipe`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRecipe() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.Timeout`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTimeout() {
        return null;
    }

    /**
     * `AWS::DataBrew::Job.ValidationConfigurations`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getValidationConfigurations() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnJobProps> {
        java.lang.String name;
        java.lang.String roleArn;
        java.lang.String type;
        java.lang.Object databaseOutputs;
        java.lang.Object dataCatalogOutputs;
        java.lang.String datasetName;
        java.lang.String encryptionKeyArn;
        java.lang.String encryptionMode;
        java.lang.Object jobSample;
        java.lang.String logSubscription;
        java.lang.Number maxCapacity;
        java.lang.Number maxRetries;
        java.lang.Object outputLocation;
        java.lang.Object outputs;
        java.lang.Object profileConfiguration;
        java.lang.String projectName;
        java.lang.Object recipe;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Number timeout;
        java.lang.Object validationConfigurations;

        /**
         * Sets the value of {@link CfnJobProps#getName}
         * @param name `AWS::DataBrew::Job.Name`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getRoleArn}
         * @param roleArn `AWS::DataBrew::Job.RoleArn`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getType}
         * @param type `AWS::DataBrew::Job.Type`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getDatabaseOutputs}
         * @param databaseOutputs `AWS::DataBrew::Job.DatabaseOutputs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseOutputs(software.amazon.awscdk.IResolvable databaseOutputs) {
            this.databaseOutputs = databaseOutputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getDatabaseOutputs}
         * @param databaseOutputs `AWS::DataBrew::Job.DatabaseOutputs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseOutputs(java.util.List<? extends java.lang.Object> databaseOutputs) {
            this.databaseOutputs = databaseOutputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getDataCatalogOutputs}
         * @param dataCatalogOutputs `AWS::DataBrew::Job.DataCatalogOutputs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogOutputs(software.amazon.awscdk.IResolvable dataCatalogOutputs) {
            this.dataCatalogOutputs = dataCatalogOutputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getDataCatalogOutputs}
         * @param dataCatalogOutputs `AWS::DataBrew::Job.DataCatalogOutputs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataCatalogOutputs(java.util.List<? extends java.lang.Object> dataCatalogOutputs) {
            this.dataCatalogOutputs = dataCatalogOutputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getDatasetName}
         * @param datasetName `AWS::DataBrew::Job.DatasetName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder datasetName(java.lang.String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getEncryptionKeyArn}
         * @param encryptionKeyArn `AWS::DataBrew::Job.EncryptionKeyArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKeyArn(java.lang.String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getEncryptionMode}
         * @param encryptionMode `AWS::DataBrew::Job.EncryptionMode`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionMode(java.lang.String encryptionMode) {
            this.encryptionMode = encryptionMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getJobSample}
         * @param jobSample `AWS::DataBrew::Job.JobSample`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobSample(software.amazon.awscdk.services.databrew.CfnJob.JobSampleProperty jobSample) {
            this.jobSample = jobSample;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getJobSample}
         * @param jobSample `AWS::DataBrew::Job.JobSample`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobSample(software.amazon.awscdk.IResolvable jobSample) {
            this.jobSample = jobSample;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getLogSubscription}
         * @param logSubscription `AWS::DataBrew::Job.LogSubscription`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logSubscription(java.lang.String logSubscription) {
            this.logSubscription = logSubscription;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getMaxCapacity}
         * @param maxCapacity `AWS::DataBrew::Job.MaxCapacity`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(java.lang.Number maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getMaxRetries}
         * @param maxRetries `AWS::DataBrew::Job.MaxRetries`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxRetries(java.lang.Number maxRetries) {
            this.maxRetries = maxRetries;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getOutputLocation}
         * @param outputLocation `AWS::DataBrew::Job.OutputLocation`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(software.amazon.awscdk.services.databrew.CfnJob.OutputLocationProperty outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getOutputLocation}
         * @param outputLocation `AWS::DataBrew::Job.OutputLocation`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputLocation(software.amazon.awscdk.IResolvable outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getOutputs}
         * @param outputs `AWS::DataBrew::Job.Outputs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(software.amazon.awscdk.IResolvable outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getOutputs}
         * @param outputs `AWS::DataBrew::Job.Outputs`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.util.List<? extends java.lang.Object> outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getProfileConfiguration}
         * @param profileConfiguration `AWS::DataBrew::Job.ProfileConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileConfiguration(software.amazon.awscdk.services.databrew.CfnJob.ProfileConfigurationProperty profileConfiguration) {
            this.profileConfiguration = profileConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getProfileConfiguration}
         * @param profileConfiguration `AWS::DataBrew::Job.ProfileConfiguration`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profileConfiguration(software.amazon.awscdk.IResolvable profileConfiguration) {
            this.profileConfiguration = profileConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getProjectName}
         * @param projectName `AWS::DataBrew::Job.ProjectName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectName(java.lang.String projectName) {
            this.projectName = projectName;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getRecipe}
         * @param recipe `AWS::DataBrew::Job.Recipe`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipe(software.amazon.awscdk.services.databrew.CfnJob.RecipeProperty recipe) {
            this.recipe = recipe;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getRecipe}
         * @param recipe `AWS::DataBrew::Job.Recipe`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recipe(software.amazon.awscdk.IResolvable recipe) {
            this.recipe = recipe;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getTags}
         * @param tags `AWS::DataBrew::Job.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getTimeout}
         * @param timeout `AWS::DataBrew::Job.Timeout`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(java.lang.Number timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getValidationConfigurations}
         * @param validationConfigurations `AWS::DataBrew::Job.ValidationConfigurations`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationConfigurations(software.amazon.awscdk.IResolvable validationConfigurations) {
            this.validationConfigurations = validationConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnJobProps#getValidationConfigurations}
         * @param validationConfigurations `AWS::DataBrew::Job.ValidationConfigurations`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder validationConfigurations(java.util.List<? extends java.lang.Object> validationConfigurations) {
            this.validationConfigurations = validationConfigurations;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnJobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnJobProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnJobProps {
        private final java.lang.String name;
        private final java.lang.String roleArn;
        private final java.lang.String type;
        private final java.lang.Object databaseOutputs;
        private final java.lang.Object dataCatalogOutputs;
        private final java.lang.String datasetName;
        private final java.lang.String encryptionKeyArn;
        private final java.lang.String encryptionMode;
        private final java.lang.Object jobSample;
        private final java.lang.String logSubscription;
        private final java.lang.Number maxCapacity;
        private final java.lang.Number maxRetries;
        private final java.lang.Object outputLocation;
        private final java.lang.Object outputs;
        private final java.lang.Object profileConfiguration;
        private final java.lang.String projectName;
        private final java.lang.Object recipe;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Number timeout;
        private final java.lang.Object validationConfigurations;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseOutputs = software.amazon.jsii.Kernel.get(this, "databaseOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataCatalogOutputs = software.amazon.jsii.Kernel.get(this, "dataCatalogOutputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.datasetName = software.amazon.jsii.Kernel.get(this, "datasetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKeyArn = software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionMode = software.amazon.jsii.Kernel.get(this, "encryptionMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobSample = software.amazon.jsii.Kernel.get(this, "jobSample", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logSubscription = software.amazon.jsii.Kernel.get(this, "logSubscription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxRetries = software.amazon.jsii.Kernel.get(this, "maxRetries", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.outputLocation = software.amazon.jsii.Kernel.get(this, "outputLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.profileConfiguration = software.amazon.jsii.Kernel.get(this, "profileConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.projectName = software.amazon.jsii.Kernel.get(this, "projectName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recipe = software.amazon.jsii.Kernel.get(this, "recipe", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.validationConfigurations = software.amazon.jsii.Kernel.get(this, "validationConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.databaseOutputs = builder.databaseOutputs;
            this.dataCatalogOutputs = builder.dataCatalogOutputs;
            this.datasetName = builder.datasetName;
            this.encryptionKeyArn = builder.encryptionKeyArn;
            this.encryptionMode = builder.encryptionMode;
            this.jobSample = builder.jobSample;
            this.logSubscription = builder.logSubscription;
            this.maxCapacity = builder.maxCapacity;
            this.maxRetries = builder.maxRetries;
            this.outputLocation = builder.outputLocation;
            this.outputs = builder.outputs;
            this.profileConfiguration = builder.profileConfiguration;
            this.projectName = builder.projectName;
            this.recipe = builder.recipe;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.timeout = builder.timeout;
            this.validationConfigurations = builder.validationConfigurations;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getDatabaseOutputs() {
            return this.databaseOutputs;
        }

        @Override
        public final java.lang.Object getDataCatalogOutputs() {
            return this.dataCatalogOutputs;
        }

        @Override
        public final java.lang.String getDatasetName() {
            return this.datasetName;
        }

        @Override
        public final java.lang.String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        @Override
        public final java.lang.String getEncryptionMode() {
            return this.encryptionMode;
        }

        @Override
        public final java.lang.Object getJobSample() {
            return this.jobSample;
        }

        @Override
        public final java.lang.String getLogSubscription() {
            return this.logSubscription;
        }

        @Override
        public final java.lang.Number getMaxCapacity() {
            return this.maxCapacity;
        }

        @Override
        public final java.lang.Number getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public final java.lang.Object getOutputLocation() {
            return this.outputLocation;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        public final java.lang.Object getProfileConfiguration() {
            return this.profileConfiguration;
        }

        @Override
        public final java.lang.String getProjectName() {
            return this.projectName;
        }

        @Override
        public final java.lang.Object getRecipe() {
            return this.recipe;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.lang.Object getValidationConfigurations() {
            return this.validationConfigurations;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getDatabaseOutputs() != null) {
                data.set("databaseOutputs", om.valueToTree(this.getDatabaseOutputs()));
            }
            if (this.getDataCatalogOutputs() != null) {
                data.set("dataCatalogOutputs", om.valueToTree(this.getDataCatalogOutputs()));
            }
            if (this.getDatasetName() != null) {
                data.set("datasetName", om.valueToTree(this.getDatasetName()));
            }
            if (this.getEncryptionKeyArn() != null) {
                data.set("encryptionKeyArn", om.valueToTree(this.getEncryptionKeyArn()));
            }
            if (this.getEncryptionMode() != null) {
                data.set("encryptionMode", om.valueToTree(this.getEncryptionMode()));
            }
            if (this.getJobSample() != null) {
                data.set("jobSample", om.valueToTree(this.getJobSample()));
            }
            if (this.getLogSubscription() != null) {
                data.set("logSubscription", om.valueToTree(this.getLogSubscription()));
            }
            if (this.getMaxCapacity() != null) {
                data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
            }
            if (this.getMaxRetries() != null) {
                data.set("maxRetries", om.valueToTree(this.getMaxRetries()));
            }
            if (this.getOutputLocation() != null) {
                data.set("outputLocation", om.valueToTree(this.getOutputLocation()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }
            if (this.getProfileConfiguration() != null) {
                data.set("profileConfiguration", om.valueToTree(this.getProfileConfiguration()));
            }
            if (this.getProjectName() != null) {
                data.set("projectName", om.valueToTree(this.getProjectName()));
            }
            if (this.getRecipe() != null) {
                data.set("recipe", om.valueToTree(this.getRecipe()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getValidationConfigurations() != null) {
                data.set("validationConfigurations", om.valueToTree(this.getValidationConfigurations()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_databrew.CfnJobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnJobProps.Jsii$Proxy that = (CfnJobProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!type.equals(that.type)) return false;
            if (this.databaseOutputs != null ? !this.databaseOutputs.equals(that.databaseOutputs) : that.databaseOutputs != null) return false;
            if (this.dataCatalogOutputs != null ? !this.dataCatalogOutputs.equals(that.dataCatalogOutputs) : that.dataCatalogOutputs != null) return false;
            if (this.datasetName != null ? !this.datasetName.equals(that.datasetName) : that.datasetName != null) return false;
            if (this.encryptionKeyArn != null ? !this.encryptionKeyArn.equals(that.encryptionKeyArn) : that.encryptionKeyArn != null) return false;
            if (this.encryptionMode != null ? !this.encryptionMode.equals(that.encryptionMode) : that.encryptionMode != null) return false;
            if (this.jobSample != null ? !this.jobSample.equals(that.jobSample) : that.jobSample != null) return false;
            if (this.logSubscription != null ? !this.logSubscription.equals(that.logSubscription) : that.logSubscription != null) return false;
            if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
            if (this.maxRetries != null ? !this.maxRetries.equals(that.maxRetries) : that.maxRetries != null) return false;
            if (this.outputLocation != null ? !this.outputLocation.equals(that.outputLocation) : that.outputLocation != null) return false;
            if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) return false;
            if (this.profileConfiguration != null ? !this.profileConfiguration.equals(that.profileConfiguration) : that.profileConfiguration != null) return false;
            if (this.projectName != null ? !this.projectName.equals(that.projectName) : that.projectName != null) return false;
            if (this.recipe != null ? !this.recipe.equals(that.recipe) : that.recipe != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            return this.validationConfigurations != null ? this.validationConfigurations.equals(that.validationConfigurations) : that.validationConfigurations == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.databaseOutputs != null ? this.databaseOutputs.hashCode() : 0);
            result = 31 * result + (this.dataCatalogOutputs != null ? this.dataCatalogOutputs.hashCode() : 0);
            result = 31 * result + (this.datasetName != null ? this.datasetName.hashCode() : 0);
            result = 31 * result + (this.encryptionKeyArn != null ? this.encryptionKeyArn.hashCode() : 0);
            result = 31 * result + (this.encryptionMode != null ? this.encryptionMode.hashCode() : 0);
            result = 31 * result + (this.jobSample != null ? this.jobSample.hashCode() : 0);
            result = 31 * result + (this.logSubscription != null ? this.logSubscription.hashCode() : 0);
            result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
            result = 31 * result + (this.maxRetries != null ? this.maxRetries.hashCode() : 0);
            result = 31 * result + (this.outputLocation != null ? this.outputLocation.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            result = 31 * result + (this.profileConfiguration != null ? this.profileConfiguration.hashCode() : 0);
            result = 31 * result + (this.projectName != null ? this.projectName.hashCode() : 0);
            result = 31 * result + (this.recipe != null ? this.recipe.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.validationConfigurations != null ? this.validationConfigurations.hashCode() : 0);
            return result;
        }
    }
}
