package software.amazon.awscdk.services.docdb;

/**
 * Backup configuration for DocumentDB databases.
 * <p>
 * Default: - The retention period for automated backups is 1 day.
 * The preferred backup window will be a 30-minute window selected at random
 * from an 8-hour block of time for each AWS Region.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.docdb.*;
 * BackupProps backupProps = BackupProps.builder()
 *         .retention(Duration.minutes(30))
 *         // the properties below are optional
 *         .preferredWindow("preferredWindow")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/documentdb/latest/developerguide/backup-restore.db-cluster-snapshots.html#backup-restore.backup-window
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.082Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.BackupProps")
@software.amazon.jsii.Jsii.Proxy(BackupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BackupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * How many days to retain the backup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getRetention();

    /**
     * A daily time range in 24-hours UTC format in which backups preferably execute.
     * <p>
     * Must be at least 30 minutes long.
     * <p>
     * Example: '01:00-02:00'
     * <p>
     * Default: - a 30-minute window selected at random from an 8-hour block of
     * time for each AWS Region. To see the time blocks available, see
     * https://docs.aws.amazon.com/documentdb/latest/developerguide/backup-restore.db-cluster-snapshots.html#backup-restore.backup-window
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPreferredWindow() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BackupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BackupProps> {
        software.amazon.awscdk.Duration retention;
        java.lang.String preferredWindow;

        /**
         * Sets the value of {@link BackupProps#getRetention}
         * @param retention How many days to retain the backup. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retention(software.amazon.awscdk.Duration retention) {
            this.retention = retention;
            return this;
        }

        /**
         * Sets the value of {@link BackupProps#getPreferredWindow}
         * @param preferredWindow A daily time range in 24-hours UTC format in which backups preferably execute.
         *                        Must be at least 30 minutes long.
         *                        <p>
         *                        Example: '01:00-02:00'
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredWindow(java.lang.String preferredWindow) {
            this.preferredWindow = preferredWindow;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BackupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BackupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupProps {
        private final software.amazon.awscdk.Duration retention;
        private final java.lang.String preferredWindow;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.retention = software.amazon.jsii.Kernel.get(this, "retention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.preferredWindow = software.amazon.jsii.Kernel.get(this, "preferredWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.retention = java.util.Objects.requireNonNull(builder.retention, "retention is required");
            this.preferredWindow = builder.preferredWindow;
        }

        @Override
        public final software.amazon.awscdk.Duration getRetention() {
            return this.retention;
        }

        @Override
        public final java.lang.String getPreferredWindow() {
            return this.preferredWindow;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("retention", om.valueToTree(this.getRetention()));
            if (this.getPreferredWindow() != null) {
                data.set("preferredWindow", om.valueToTree(this.getPreferredWindow()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_docdb.BackupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupProps.Jsii$Proxy that = (BackupProps.Jsii$Proxy) o;

            if (!retention.equals(that.retention)) return false;
            return this.preferredWindow != null ? this.preferredWindow.equals(that.preferredWindow) : that.preferredWindow == null;
        }

        @Override
        public final int hashCode() {
            int result = this.retention.hashCode();
            result = 31 * result + (this.preferredWindow != null ? this.preferredWindow.hashCode() : 0);
            return result;
        }
    }
}
