package software.amazon.awscdk.services.docdb;

/**
 * Create a clustered database with a given number of instances.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .masterUser(Login.builder()
 *                 .username("myuser") // NOTE: 'admin' is reserved by DocumentDB
 *                 .excludeCharacters("\"&#64;/:") // optional, defaults to the set "\"&#64;/" and is also used for eventually created rotations
 *                 .secretName("/myapp/mydocdb/masteruser")
 *                 .build())
 *         .instanceType(InstanceType.of(InstanceClass.R5, InstanceSize.LARGE))
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.092Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_docdb.DatabaseCluster")
public class DatabaseCluster extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.docdb.IDatabaseCluster {

    protected DatabaseCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        DEFAULT_NUM_INSTANCES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.docdb.DatabaseCluster.class, "DEFAULT_NUM_INSTANCES", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        DEFAULT_PORT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.docdb.DatabaseCluster.class, "DEFAULT_PORT", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.DatabaseClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing DatabaseCluster from properties.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.IDatabaseCluster fromDatabaseClusterAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.DatabaseClusterAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.docdb.DatabaseCluster.class, "fromDatabaseClusterAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.IDatabaseCluster.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Adds the multi user rotation to this cluster.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationMultiUser(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.RotationMultiUserOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationMultiUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Adds the single user rotation of the master password to this cluster.
     * <p>
     * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationSingleUser(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration automaticallyAfter) {
        return software.amazon.jsii.Kernel.call(this, "addRotationSingleUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class), new Object[] { automaticallyAfter });
    }

    /**
     * Adds the single user rotation of the master password to this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretRotation addRotationSingleUser() {
        return software.amazon.jsii.Kernel.call(this, "addRotationSingleUser", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretRotation.class));
    }

    /**
     * Adds security groups to this cluster.
     * <p>
     * @param securityGroups The security groups to add. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.ISecurityGroup... securityGroups) {
        software.amazon.jsii.Kernel.call(this, "addSecurityGroups", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(securityGroups).toArray(Object[]::new));
    }

    /**
     * Renders the secret attachment target specifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps asSecretAttachmentTarget() {
        return software.amazon.jsii.Kernel.call(this, "asSecretAttachmentTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.SecretAttachmentTargetProps.class));
    }

    /**
     * The default number of instances in the DocDB cluster if none are specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.Number DEFAULT_NUM_INSTANCES;

    /**
     * The default port Document DB listens on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.Number DEFAULT_PORT;

    /**
     * The endpoint to use for read/write operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.Endpoint getClusterEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.Endpoint.class));
    }

    /**
     * Identifier of the cluster.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "clusterIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Endpoint to use for load-balanced read-only operations.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.docdb.Endpoint getClusterReadEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "clusterReadEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.Endpoint.class));
    }

    /**
     * The resource id for the cluster;
     * <p>
     * for example: cluster-ABCD1234EFGH5678IJKL90MNOP. The cluster ID uniquely
     * identifies the cluster and is used in things like IAM authentication policies.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterResourceIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "clusterResourceIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The connections object to implement IConnectable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Endpoints which address each individual replica.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.docdb.Endpoint> getInstanceEndpoints() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.docdb.Endpoint.class))));
    }

    /**
     * Identifiers of the replicas.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getInstanceIdentifiers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "instanceIdentifiers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Security group identifier of this database.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecurityGroupId() {
        return software.amazon.jsii.Kernel.get(this, "securityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The secret attached to this cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecret() {
        return software.amazon.jsii.Kernel.get(this, "secret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.docdb.DatabaseCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.docdb.DatabaseCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.docdb.DatabaseClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.docdb.DatabaseClusterProps.Builder();
        }

        /**
         * What type of instance to start for the replicas.
         * <p>
         * @return {@code this}
         * @param instanceType What type of instance to start for the replicas. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(final software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.props.instanceType(instanceType);
            return this;
        }

        /**
         * Username and password for the administrative user.
         * <p>
         * @return {@code this}
         * @param masterUser Username and password for the administrative user. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder masterUser(final software.amazon.awscdk.services.docdb.Login masterUser) {
            this.props.masterUser(masterUser);
            return this;
        }

        /**
         * What subnets to run the DocumentDB instances in.
         * <p>
         * Must be at least 2 subnets in two different AZs.
         * <p>
         * @return {@code this}
         * @param vpc What subnets to run the DocumentDB instances in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * Backup settings.
         * <p>
         * Default: - Backup retention period for automated backups is 1 day.
         * Backup preferred window is set to a 30-minute window selected at random from an
         * 8-hour block of time for each AWS Region, occurring on a random day of the week.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/documentdb/latest/developerguide/backup-restore.db-cluster-snapshots.html#backup-restore.backup-window
         * @param backup Backup settings. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backup(final software.amazon.awscdk.services.docdb.BackupProps backup) {
            this.props.backup(backup);
            return this;
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         * <p>
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to <code>Infinity</code>.
         * <p>
         * Default: - logs never expire
         * <p>
         * @return {@code this}
         * @param cloudWatchLogsRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsRetention(final software.amazon.awscdk.services.logs.RetentionDays cloudWatchLogsRetention) {
            this.props.cloudWatchLogsRetention(cloudWatchLogsRetention);
            return this;
        }

        /**
         * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * <p>
         * Default: - a new role is created.
         * <p>
         * @return {@code this}
         * @param cloudWatchLogsRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsRetentionRole(final software.amazon.awscdk.services.iam.IRole cloudWatchLogsRetentionRole) {
            this.props.cloudWatchLogsRetentionRole(cloudWatchLogsRetentionRole);
            return this;
        }

        /**
         * An optional identifier for the cluster.
         * <p>
         * Default: - A name is automatically generated.
         * <p>
         * @return {@code this}
         * @param dbClusterName An optional identifier for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbClusterName(final java.lang.String dbClusterName) {
            this.props.dbClusterName(dbClusterName);
            return this;
        }

        /**
         * Specifies whether this cluster can be deleted.
         * <p>
         * If deletionProtection is
         * enabled, the cluster cannot be deleted unless it is modified and
         * deletionProtection is disabled. deletionProtection protects clusters from
         * being accidentally deleted.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param deletionProtection Specifies whether this cluster can be deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * What version of the database to start.
         * <p>
         * Default: - The default engine version.
         * <p>
         * @return {@code this}
         * @param engineVersion What version of the database to start. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        /**
         * Whether the audit logs should be exported to CloudWatch.
         * <p>
         * Note that you also have to configure the audit log export in the Cluster's Parameter Group.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/documentdb/latest/developerguide/event-auditing.html#event-auditing-enabling-auditing
         * @param exportAuditLogsToCloudWatch Whether the audit logs should be exported to CloudWatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportAuditLogsToCloudWatch(final java.lang.Boolean exportAuditLogsToCloudWatch) {
            this.props.exportAuditLogsToCloudWatch(exportAuditLogsToCloudWatch);
            return this;
        }

        /**
         * Whether the profiler logs should be exported to CloudWatch.
         * <p>
         * Note that you also have to configure the profiler log export in the Cluster's Parameter Group.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/documentdb/latest/developerguide/profiling.html#profiling.enable-profiling
         * @param exportProfilerLogsToCloudWatch Whether the profiler logs should be exported to CloudWatch. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportProfilerLogsToCloudWatch(final java.lang.Boolean exportProfilerLogsToCloudWatch) {
            this.props.exportProfilerLogsToCloudWatch(exportProfilerLogsToCloudWatch);
            return this;
        }

        /**
         * Base identifier for instances.
         * <p>
         * Every replica is named by appending the replica number to this string, 1-based.
         * <p>
         * Default: - `dbClusterName` is used with the word "Instance" appended. If `dbClusterName` is not provided, the
         * identifier is automatically generated.
         * <p>
         * @return {@code this}
         * @param instanceIdentifierBase Base identifier for instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceIdentifierBase(final java.lang.String instanceIdentifierBase) {
            this.props.instanceIdentifierBase(instanceIdentifierBase);
            return this;
        }

        /**
         * Number of DocDB compute instances.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param instances Number of DocDB compute instances. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instances(final java.lang.Number instances) {
            this.props.instances(instances);
            return this;
        }

        /**
         * The KMS key for storage encryption.
         * <p>
         * Default: - default master key.
         * <p>
         * @return {@code this}
         * @param kmsKey The KMS key for storage encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * The DB parameter group to associate with the instance.
         * <p>
         * Default: no parameter group
         * <p>
         * @return {@code this}
         * @param parameterGroup The DB parameter group to associate with the instance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterGroup(final software.amazon.awscdk.services.docdb.IClusterParameterGroup parameterGroup) {
            this.props.parameterGroup(parameterGroup);
            return this;
        }

        /**
         * The port the DocumentDB cluster will listen on.
         * <p>
         * Default: DatabaseCluster.DEFAULT_PORT
         * <p>
         * @return {@code this}
         * @param port The port the DocumentDB cluster will listen on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * A weekly time range in which maintenance should preferably execute.
         * <p>
         * Must be at least 30 minutes long.
         * <p>
         * Example: 'tue:04:17-tue:04:47'
         * <p>
         * Default: - 30-minute window selected at random from an 8-hour block of time for
         * each AWS Region, occurring on a random day of the week.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/documentdb/latest/developerguide/db-instance-maintain.html#maintenance-window
         * @param preferredMaintenanceWindow A weekly time range in which maintenance should preferably execute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * The removal policy to apply when the cluster and its instances are removed or replaced during a stack update, or when the stack is deleted.
         * <p>
         * This
         * removal policy also applies to the implicit security group created for the
         * cluster if one is not supplied as a parameter.
         * <p>
         * Default: - Retain cluster.
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply when the cluster and its instances are removed or replaced during a stack update, or when the stack is deleted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Security group.
         * <p>
         * Default: a new security group is created.
         * <p>
         * @return {@code this}
         * @param securityGroup Security group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.props.securityGroup(securityGroup);
            return this;
        }

        /**
         * Whether to enable storage encryption.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param storageEncrypted Whether to enable storage encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageEncrypted(final java.lang.Boolean storageEncrypted) {
            this.props.storageEncrypted(storageEncrypted);
            return this;
        }

        /**
         * Where to place the instances within the VPC.
         * <p>
         * Default: private subnets
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the instances within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.docdb.DatabaseCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.docdb.DatabaseCluster build() {
            return new software.amazon.awscdk.services.docdb.DatabaseCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
