package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for a global secondary index.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * GlobalSecondaryIndexProps globalSecondaryIndexProps = GlobalSecondaryIndexProps.builder()
 *         .indexName("indexName")
 *         .partitionKey(Attribute.builder()
 *                 .name("name")
 *                 .type(AttributeType.BINARY)
 *                 .build())
 *         // the properties below are optional
 *         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *         .projectionType(ProjectionType.KEYS_ONLY)
 *         .readCapacity(123)
 *         .sortKey(Attribute.builder()
 *                 .name("name")
 *                 .type(AttributeType.BINARY)
 *                 .build())
 *         .writeCapacity(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.143Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.GlobalSecondaryIndexProps")
@software.amazon.jsii.Jsii.Proxy(GlobalSecondaryIndexProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GlobalSecondaryIndexProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.dynamodb.SecondaryIndexProps, software.amazon.awscdk.services.dynamodb.SchemaOptions {

    /**
     * The read capacity for the global secondary index.
     * <p>
     * Can only be provided if table billingMode is Provisioned or undefined.
     * <p>
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getReadCapacity() {
        return null;
    }

    /**
     * The write capacity for the global secondary index.
     * <p>
     * Can only be provided if table billingMode is Provisioned or undefined.
     * <p>
     * Default: 5
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWriteCapacity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GlobalSecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GlobalSecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GlobalSecondaryIndexProps> {
        java.lang.Number readCapacity;
        java.lang.Number writeCapacity;
        java.lang.String indexName;
        java.util.List<java.lang.String> nonKeyAttributes;
        software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;
        software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        software.amazon.awscdk.services.dynamodb.Attribute sortKey;

        /**
         * Sets the value of {@link GlobalSecondaryIndexProps#getReadCapacity}
         * @param readCapacity The read capacity for the global secondary index.
         *                     Can only be provided if table billingMode is Provisioned or undefined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(java.lang.Number readCapacity) {
            this.readCapacity = readCapacity;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexProps#getWriteCapacity}
         * @param writeCapacity The write capacity for the global secondary index.
         *                      Can only be provided if table billingMode is Provisioned or undefined.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(java.lang.Number writeCapacity) {
            this.writeCapacity = writeCapacity;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexProps#getIndexName}
         * @param indexName The name of the secondary index. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder indexName(java.lang.String indexName) {
            this.indexName = indexName;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexProps#getNonKeyAttributes}
         * @param nonKeyAttributes The non-key attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nonKeyAttributes(java.util.List<java.lang.String> nonKeyAttributes) {
            this.nonKeyAttributes = nonKeyAttributes;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexProps#getProjectionType}
         * @param projectionType The set of attributes that are projected into the secondary index.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder projectionType(software.amazon.awscdk.services.dynamodb.ProjectionType projectionType) {
            this.projectionType = projectionType;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexProps#getPartitionKey}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        /**
         * Sets the value of {@link GlobalSecondaryIndexProps#getSortKey}
         * @param sortKey Sort key attribute definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.sortKey = sortKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GlobalSecondaryIndexProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GlobalSecondaryIndexProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GlobalSecondaryIndexProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlobalSecondaryIndexProps {
        private final java.lang.Number readCapacity;
        private final java.lang.Number writeCapacity;
        private final java.lang.String indexName;
        private final java.util.List<java.lang.String> nonKeyAttributes;
        private final software.amazon.awscdk.services.dynamodb.ProjectionType projectionType;
        private final software.amazon.awscdk.services.dynamodb.Attribute partitionKey;
        private final software.amazon.awscdk.services.dynamodb.Attribute sortKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.readCapacity = software.amazon.jsii.Kernel.get(this, "readCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.writeCapacity = software.amazon.jsii.Kernel.get(this, "writeCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.indexName = software.amazon.jsii.Kernel.get(this, "indexName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.nonKeyAttributes = software.amazon.jsii.Kernel.get(this, "nonKeyAttributes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.projectionType = software.amazon.jsii.Kernel.get(this, "projectionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ProjectionType.class));
            this.partitionKey = software.amazon.jsii.Kernel.get(this, "partitionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
            this.sortKey = software.amazon.jsii.Kernel.get(this, "sortKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.Attribute.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.readCapacity = builder.readCapacity;
            this.writeCapacity = builder.writeCapacity;
            this.indexName = java.util.Objects.requireNonNull(builder.indexName, "indexName is required");
            this.nonKeyAttributes = builder.nonKeyAttributes;
            this.projectionType = builder.projectionType;
            this.partitionKey = java.util.Objects.requireNonNull(builder.partitionKey, "partitionKey is required");
            this.sortKey = builder.sortKey;
        }

        @Override
        public final java.lang.Number getReadCapacity() {
            return this.readCapacity;
        }

        @Override
        public final java.lang.Number getWriteCapacity() {
            return this.writeCapacity;
        }

        @Override
        public final java.lang.String getIndexName() {
            return this.indexName;
        }

        @Override
        public final java.util.List<java.lang.String> getNonKeyAttributes() {
            return this.nonKeyAttributes;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.ProjectionType getProjectionType() {
            return this.projectionType;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final software.amazon.awscdk.services.dynamodb.Attribute getSortKey() {
            return this.sortKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getReadCapacity() != null) {
                data.set("readCapacity", om.valueToTree(this.getReadCapacity()));
            }
            if (this.getWriteCapacity() != null) {
                data.set("writeCapacity", om.valueToTree(this.getWriteCapacity()));
            }
            data.set("indexName", om.valueToTree(this.getIndexName()));
            if (this.getNonKeyAttributes() != null) {
                data.set("nonKeyAttributes", om.valueToTree(this.getNonKeyAttributes()));
            }
            if (this.getProjectionType() != null) {
                data.set("projectionType", om.valueToTree(this.getProjectionType()));
            }
            data.set("partitionKey", om.valueToTree(this.getPartitionKey()));
            if (this.getSortKey() != null) {
                data.set("sortKey", om.valueToTree(this.getSortKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.GlobalSecondaryIndexProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GlobalSecondaryIndexProps.Jsii$Proxy that = (GlobalSecondaryIndexProps.Jsii$Proxy) o;

            if (this.readCapacity != null ? !this.readCapacity.equals(that.readCapacity) : that.readCapacity != null) return false;
            if (this.writeCapacity != null ? !this.writeCapacity.equals(that.writeCapacity) : that.writeCapacity != null) return false;
            if (!indexName.equals(that.indexName)) return false;
            if (this.nonKeyAttributes != null ? !this.nonKeyAttributes.equals(that.nonKeyAttributes) : that.nonKeyAttributes != null) return false;
            if (this.projectionType != null ? !this.projectionType.equals(that.projectionType) : that.projectionType != null) return false;
            if (!partitionKey.equals(that.partitionKey)) return false;
            return this.sortKey != null ? this.sortKey.equals(that.sortKey) : that.sortKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.readCapacity != null ? this.readCapacity.hashCode() : 0;
            result = 31 * result + (this.writeCapacity != null ? this.writeCapacity.hashCode() : 0);
            result = 31 * result + (this.indexName.hashCode());
            result = 31 * result + (this.nonKeyAttributes != null ? this.nonKeyAttributes.hashCode() : 0);
            result = 31 * result + (this.projectionType != null ? this.projectionType.hashCode() : 0);
            result = 31 * result + (this.partitionKey.hashCode());
            result = 31 * result + (this.sortKey != null ? this.sortKey.hashCode() : 0);
            return result;
        }
    }
}
