package software.amazon.awscdk.services.ec2;

/**
 * Options for attaching a CloudFormationInit to a resource.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.iam.*;
 * CfnResource cfnResource;
 * Role role;
 * UserData userData;
 * AttachInitOptions attachInitOptions = AttachInitOptions.builder()
 *         .instanceRole(role)
 *         .platform(OperatingSystemType.LINUX)
 *         .userData(userData)
 *         // the properties below are optional
 *         .configSets(List.of("configSets"))
 *         .embedFingerprint(false)
 *         .ignoreFailures(false)
 *         .includeRole(false)
 *         .includeUrl(false)
 *         .printLog(false)
 *         .signalResource(cfnResource)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.184Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AttachInitOptions")
@software.amazon.jsii.Jsii.Proxy(AttachInitOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AttachInitOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Instance role of the consuming instance or fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getInstanceRole();

    /**
     * OS Platform the init config will be used for.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.OperatingSystemType getPlatform();

    /**
     * UserData to add commands to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.UserData getUserData();

    /**
     * ConfigSet to activate.
     * <p>
     * Default: ['default']
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getConfigSets() {
        return null;
    }

    /**
     * Whether to embed a hash into the userData.
     * <p>
     * If <code>true</code> (the default), a hash of the config will be embedded into the
     * UserData, so that if the config changes, the UserData changes and
     * the instance will be replaced.
     * <p>
     * If <code>false</code>, no such hash will be embedded, and if the CloudFormation Init
     * config changes nothing will happen to the running instance.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEmbedFingerprint() {
        return null;
    }

    /**
     * Don't fail the instance creation when cfn-init fails.
     * <p>
     * You can use this to prevent CloudFormation from rolling back when
     * instances fail to start up, to help in debugging.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIgnoreFailures() {
        return null;
    }

    /**
     * Include --role argument when running cfn-init and cfn-signal commands.
     * <p>
     * This will be the IAM instance profile attached to the EC2 instance
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeRole() {
        return null;
    }

    /**
     * Include --url argument when running cfn-init and cfn-signal commands.
     * <p>
     * This will be the cloudformation endpoint in the deployed region
     * e.g. https://cloudformation.us-east-1.amazonaws.com
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeUrl() {
        return null;
    }

    /**
     * Print the results of running cfn-init to the Instance System Log.
     * <p>
     * By default, the output of running cfn-init is written to a log file
     * on the instance. Set this to <code>true</code> to print it to the System Log
     * (visible from the EC2 Console), <code>false</code> to not print it.
     * <p>
     * (Be aware that the system log is refreshed at certain points in
     * time of the instance life cycle, and successful execution may
     * not always show up).
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPrintLog() {
        return null;
    }

    /**
     * When provided, signals this resource instead of the attached resource.
     * <p>
     * You can use this to support signaling LaunchTemplate while attaching AutoScalingGroup
     * <p>
     * Default: - if this property is undefined cfn-signal signals the attached resource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.CfnResource getSignalResource() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AttachInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AttachInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AttachInitOptions> {
        software.amazon.awscdk.services.iam.IRole instanceRole;
        software.amazon.awscdk.services.ec2.OperatingSystemType platform;
        software.amazon.awscdk.services.ec2.UserData userData;
        java.util.List<java.lang.String> configSets;
        java.lang.Boolean embedFingerprint;
        java.lang.Boolean ignoreFailures;
        java.lang.Boolean includeRole;
        java.lang.Boolean includeUrl;
        java.lang.Boolean printLog;
        software.amazon.awscdk.CfnResource signalResource;

        /**
         * Sets the value of {@link AttachInitOptions#getInstanceRole}
         * @param instanceRole Instance role of the consuming instance or fleet. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRole(software.amazon.awscdk.services.iam.IRole instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getPlatform}
         * @param platform OS Platform the init config will be used for. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platform(software.amazon.awscdk.services.ec2.OperatingSystemType platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getUserData}
         * @param userData UserData to add commands to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getConfigSets}
         * @param configSets ConfigSet to activate.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configSets(java.util.List<java.lang.String> configSets) {
            this.configSets = configSets;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getEmbedFingerprint}
         * @param embedFingerprint Whether to embed a hash into the userData.
         *                         If <code>true</code> (the default), a hash of the config will be embedded into the
         *                         UserData, so that if the config changes, the UserData changes and
         *                         the instance will be replaced.
         *                         <p>
         *                         If <code>false</code>, no such hash will be embedded, and if the CloudFormation Init
         *                         config changes nothing will happen to the running instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder embedFingerprint(java.lang.Boolean embedFingerprint) {
            this.embedFingerprint = embedFingerprint;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getIgnoreFailures}
         * @param ignoreFailures Don't fail the instance creation when cfn-init fails.
         *                       You can use this to prevent CloudFormation from rolling back when
         *                       instances fail to start up, to help in debugging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreFailures(java.lang.Boolean ignoreFailures) {
            this.ignoreFailures = ignoreFailures;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getIncludeRole}
         * @param includeRole Include --role argument when running cfn-init and cfn-signal commands.
         *                    This will be the IAM instance profile attached to the EC2 instance
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeRole(java.lang.Boolean includeRole) {
            this.includeRole = includeRole;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getIncludeUrl}
         * @param includeUrl Include --url argument when running cfn-init and cfn-signal commands.
         *                   This will be the cloudformation endpoint in the deployed region
         *                   e.g. https://cloudformation.us-east-1.amazonaws.com
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeUrl(java.lang.Boolean includeUrl) {
            this.includeUrl = includeUrl;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getPrintLog}
         * @param printLog Print the results of running cfn-init to the Instance System Log.
         *                 By default, the output of running cfn-init is written to a log file
         *                 on the instance. Set this to <code>true</code> to print it to the System Log
         *                 (visible from the EC2 Console), <code>false</code> to not print it.
         *                 <p>
         *                 (Be aware that the system log is refreshed at certain points in
         *                 time of the instance life cycle, and successful execution may
         *                 not always show up).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder printLog(java.lang.Boolean printLog) {
            this.printLog = printLog;
            return this;
        }

        /**
         * Sets the value of {@link AttachInitOptions#getSignalResource}
         * @param signalResource When provided, signals this resource instead of the attached resource.
         *                       You can use this to support signaling LaunchTemplate while attaching AutoScalingGroup
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder signalResource(software.amazon.awscdk.CfnResource signalResource) {
            this.signalResource = signalResource;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AttachInitOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AttachInitOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AttachInitOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AttachInitOptions {
        private final software.amazon.awscdk.services.iam.IRole instanceRole;
        private final software.amazon.awscdk.services.ec2.OperatingSystemType platform;
        private final software.amazon.awscdk.services.ec2.UserData userData;
        private final java.util.List<java.lang.String> configSets;
        private final java.lang.Boolean embedFingerprint;
        private final java.lang.Boolean ignoreFailures;
        private final java.lang.Boolean includeRole;
        private final java.lang.Boolean includeUrl;
        private final java.lang.Boolean printLog;
        private final software.amazon.awscdk.CfnResource signalResource;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceRole = software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.platform = software.amazon.jsii.Kernel.get(this, "platform", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.OperatingSystemType.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
            this.configSets = software.amazon.jsii.Kernel.get(this, "configSets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.embedFingerprint = software.amazon.jsii.Kernel.get(this, "embedFingerprint", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ignoreFailures = software.amazon.jsii.Kernel.get(this, "ignoreFailures", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.includeRole = software.amazon.jsii.Kernel.get(this, "includeRole", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.includeUrl = software.amazon.jsii.Kernel.get(this, "includeUrl", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.printLog = software.amazon.jsii.Kernel.get(this, "printLog", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.signalResource = software.amazon.jsii.Kernel.get(this, "signalResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnResource.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceRole = java.util.Objects.requireNonNull(builder.instanceRole, "instanceRole is required");
            this.platform = java.util.Objects.requireNonNull(builder.platform, "platform is required");
            this.userData = java.util.Objects.requireNonNull(builder.userData, "userData is required");
            this.configSets = builder.configSets;
            this.embedFingerprint = builder.embedFingerprint;
            this.ignoreFailures = builder.ignoreFailures;
            this.includeRole = builder.includeRole;
            this.includeUrl = builder.includeUrl;
            this.printLog = builder.printLog;
            this.signalResource = builder.signalResource;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.OperatingSystemType getPlatform() {
            return this.platform;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public final java.util.List<java.lang.String> getConfigSets() {
            return this.configSets;
        }

        @Override
        public final java.lang.Boolean getEmbedFingerprint() {
            return this.embedFingerprint;
        }

        @Override
        public final java.lang.Boolean getIgnoreFailures() {
            return this.ignoreFailures;
        }

        @Override
        public final java.lang.Boolean getIncludeRole() {
            return this.includeRole;
        }

        @Override
        public final java.lang.Boolean getIncludeUrl() {
            return this.includeUrl;
        }

        @Override
        public final java.lang.Boolean getPrintLog() {
            return this.printLog;
        }

        @Override
        public final software.amazon.awscdk.CfnResource getSignalResource() {
            return this.signalResource;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
            data.set("platform", om.valueToTree(this.getPlatform()));
            data.set("userData", om.valueToTree(this.getUserData()));
            if (this.getConfigSets() != null) {
                data.set("configSets", om.valueToTree(this.getConfigSets()));
            }
            if (this.getEmbedFingerprint() != null) {
                data.set("embedFingerprint", om.valueToTree(this.getEmbedFingerprint()));
            }
            if (this.getIgnoreFailures() != null) {
                data.set("ignoreFailures", om.valueToTree(this.getIgnoreFailures()));
            }
            if (this.getIncludeRole() != null) {
                data.set("includeRole", om.valueToTree(this.getIncludeRole()));
            }
            if (this.getIncludeUrl() != null) {
                data.set("includeUrl", om.valueToTree(this.getIncludeUrl()));
            }
            if (this.getPrintLog() != null) {
                data.set("printLog", om.valueToTree(this.getPrintLog()));
            }
            if (this.getSignalResource() != null) {
                data.set("signalResource", om.valueToTree(this.getSignalResource()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.AttachInitOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AttachInitOptions.Jsii$Proxy that = (AttachInitOptions.Jsii$Proxy) o;

            if (!instanceRole.equals(that.instanceRole)) return false;
            if (!platform.equals(that.platform)) return false;
            if (!userData.equals(that.userData)) return false;
            if (this.configSets != null ? !this.configSets.equals(that.configSets) : that.configSets != null) return false;
            if (this.embedFingerprint != null ? !this.embedFingerprint.equals(that.embedFingerprint) : that.embedFingerprint != null) return false;
            if (this.ignoreFailures != null ? !this.ignoreFailures.equals(that.ignoreFailures) : that.ignoreFailures != null) return false;
            if (this.includeRole != null ? !this.includeRole.equals(that.includeRole) : that.includeRole != null) return false;
            if (this.includeUrl != null ? !this.includeUrl.equals(that.includeUrl) : that.includeUrl != null) return false;
            if (this.printLog != null ? !this.printLog.equals(that.printLog) : that.printLog != null) return false;
            return this.signalResource != null ? this.signalResource.equals(that.signalResource) : that.signalResource == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceRole.hashCode();
            result = 31 * result + (this.platform.hashCode());
            result = 31 * result + (this.userData.hashCode());
            result = 31 * result + (this.configSets != null ? this.configSets.hashCode() : 0);
            result = 31 * result + (this.embedFingerprint != null ? this.embedFingerprint.hashCode() : 0);
            result = 31 * result + (this.ignoreFailures != null ? this.ignoreFailures.hashCode() : 0);
            result = 31 * result + (this.includeRole != null ? this.includeRole.hashCode() : 0);
            result = 31 * result + (this.includeUrl != null ? this.includeUrl.hashCode() : 0);
            result = 31 * result + (this.printLog != null ? this.printLog.hashCode() : 0);
            result = 31 * result + (this.signalResource != null ? this.signalResource.hashCode() : 0);
            return result;
        }
    }
}
