package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnEIP`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Instance instance;
 * HostedZone myZone;
 * CfnEIP elasticIp = CfnEIP.Builder.create(this, "EIP")
 *         .domain("vpc")
 *         .instanceId(instance.getInstanceId())
 *         .build();
 * ARecord.Builder.create(this, "ARecord")
 *         .zone(myZone)
 *         .target(RecordTarget.fromIpAddresses(elasticIp.getRef()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.235Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnEIPProps")
@software.amazon.jsii.Jsii.Proxy(CfnEIPProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEIPProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether the Elastic IP address is for use with instances in a VPC or instance in EC2-Classic.
     * <p>
     * Default: If the Region supports EC2-Classic, the default is <code>standard</code> . Otherwise, the default is <code>vpc</code> .
     * <p>
     * Use when allocating an address for use with a VPC if the Region supports EC2-Classic.
     * <p>
     * If you define an Elastic IP address and associate it with a VPC that is defined in the same template, you must declare a dependency on the VPC-gateway attachment by using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> on this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDomain() {
        return null;
    }

    /**
     * The ID of the instance.
     * <p>
     * <blockquote>
     * <p>
     * Updates to the <code>InstanceId</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceId() {
        return null;
    }

    /**
     * The ID of an address pool that you own.
     * <p>
     * Use this parameter to let Amazon EC2 select an address from the address pool.
     * <p>
     * <blockquote>
     * <p>
     * Updates to the <code>PublicIpv4Pool</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPublicIpv4Pool() {
        return null;
    }

    /**
     * Any tags assigned to the Elastic IP address.
     * <p>
     * <blockquote>
     * <p>
     * Updates to the <code>Tags</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEIPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEIPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEIPProps> {
        java.lang.String domain;
        java.lang.String instanceId;
        java.lang.String publicIpv4Pool;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnEIPProps#getDomain}
         * @param domain Indicates whether the Elastic IP address is for use with instances in a VPC or instance in EC2-Classic.
         *               Default: If the Region supports EC2-Classic, the default is <code>standard</code> . Otherwise, the default is <code>vpc</code> .
         *               <p>
         *               Use when allocating an address for use with a VPC if the Region supports EC2-Classic.
         *               <p>
         *               If you define an Elastic IP address and associate it with a VPC that is defined in the same template, you must declare a dependency on the VPC-gateway attachment by using the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-dependson.html">DependsOn Attribute</a> on this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domain(java.lang.String domain) {
            this.domain = domain;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getInstanceId}
         * @param instanceId The ID of the instance.
         *                   <blockquote>
         *                   <p>
         *                   Updates to the <code>InstanceId</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
         *                   <p>
         *                   </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceId(java.lang.String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getPublicIpv4Pool}
         * @param publicIpv4Pool The ID of an address pool that you own.
         *                       Use this parameter to let Amazon EC2 select an address from the address pool.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       Updates to the <code>PublicIpv4Pool</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicIpv4Pool(java.lang.String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        /**
         * Sets the value of {@link CfnEIPProps#getTags}
         * @param tags Any tags assigned to the Elastic IP address.
         *             <blockquote>
         *             <p>
         *             Updates to the <code>Tags</code> property may require <em>some interruptions</em> . Updates on an EIP reassociates the address on its associated resource.
         *             <p>
         *             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEIPProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEIPProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEIPProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEIPProps {
        private final java.lang.String domain;
        private final java.lang.String instanceId;
        private final java.lang.String publicIpv4Pool;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.domain = software.amazon.jsii.Kernel.get(this, "domain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceId = software.amazon.jsii.Kernel.get(this, "instanceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.publicIpv4Pool = software.amazon.jsii.Kernel.get(this, "publicIpv4Pool", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domain = builder.domain;
            this.instanceId = builder.instanceId;
            this.publicIpv4Pool = builder.publicIpv4Pool;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDomain() {
            return this.domain;
        }

        @Override
        public final java.lang.String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final java.lang.String getPublicIpv4Pool() {
            return this.publicIpv4Pool;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDomain() != null) {
                data.set("domain", om.valueToTree(this.getDomain()));
            }
            if (this.getInstanceId() != null) {
                data.set("instanceId", om.valueToTree(this.getInstanceId()));
            }
            if (this.getPublicIpv4Pool() != null) {
                data.set("publicIpv4Pool", om.valueToTree(this.getPublicIpv4Pool()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnEIPProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEIPProps.Jsii$Proxy that = (CfnEIPProps.Jsii$Proxy) o;

            if (this.domain != null ? !this.domain.equals(that.domain) : that.domain != null) return false;
            if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) return false;
            if (this.publicIpv4Pool != null ? !this.publicIpv4Pool.equals(that.publicIpv4Pool) : that.publicIpv4Pool != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.domain != null ? this.domain.hashCode() : 0;
            result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
            result = 31 * result + (this.publicIpv4Pool != null ? this.publicIpv4Pool.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
