package software.amazon.awscdk.services.ec2;

/**
 * Properties for defining a `CfnNetworkInterface`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnNetworkInterfaceProps cfnNetworkInterfaceProps = CfnNetworkInterfaceProps.builder()
 *         .subnetId("subnetId")
 *         // the properties below are optional
 *         .description("description")
 *         .groupSet(List.of("groupSet"))
 *         .interfaceType("interfaceType")
 *         .ipv6AddressCount(123)
 *         .ipv6Addresses(List.of(InstanceIpv6AddressProperty.builder()
 *                 .ipv6Address("ipv6Address")
 *                 .build()))
 *         .privateIpAddress("privateIpAddress")
 *         .privateIpAddresses(List.of(PrivateIpAddressSpecificationProperty.builder()
 *                 .primary(false)
 *                 .privateIpAddress("privateIpAddress")
 *                 .build()))
 *         .secondaryPrivateIpAddressCount(123)
 *         .sourceDestCheck(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.347Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnNetworkInterfaceProps")
@software.amazon.jsii.Jsii.Proxy(CfnNetworkInterfaceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnNetworkInterfaceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the subnet to associate with the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSubnetId();

    /**
     * A description for the network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The security group IDs associated with this network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGroupSet() {
        return null;
    }

    /**
     * The type of network interface.
     * <p>
     * The default is <code>interface</code> . The supported values are <code>efa</code> and <code>trunk</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInterfaceType() {
        return null;
    }

    /**
     * The number of IPv6 addresses to assign to a network interface.
     * <p>
     * Amazon EC2 automatically selects the IPv6 addresses from the subnet range. To specify specific IPv6 addresses, use the <code>Ipv6Addresses</code> property and don't specify this property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
        return null;
    }

    /**
     * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet to associate with the network interface.
     * <p>
     * If you're specifying a number of IPv6 addresses, use the <code>Ipv6AddressCount</code> property and don't specify this property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Addresses() {
        return null;
    }

    /**
     * Assigns a single private IP address to the network interface, which is used as the primary private IP address.
     * <p>
     * If you want to specify multiple private IP address, use the <code>PrivateIpAddresses</code> property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
        return null;
    }

    /**
     * Assigns private IP addresses to the network interface.
     * <p>
     * You can specify a primary private IP address by setting the value of the <code>Primary</code> property to <code>true</code> in the <code>PrivateIpAddressSpecification</code> property. If you want EC2 to automatically assign private IP addresses, use the <code>SecondaryPrivateIpAddressCount</code> property and do not specify this property.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPrivateIpAddresses() {
        return null;
    }

    /**
     * The number of secondary private IPv4 addresses to assign to a network interface.
     * <p>
     * When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using <code>privateIpAddresses</code> .
     * <p>
     * The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per Instance Type</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSecondaryPrivateIpAddressCount() {
        return null;
    }

    /**
     * Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
     * <p>
     * If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceDestCheck() {
        return null;
    }

    /**
     * An arbitrary set of tags (key-value pairs) for this network interface.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnNetworkInterfaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnNetworkInterfaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnNetworkInterfaceProps> {
        java.lang.String subnetId;
        java.lang.String description;
        java.util.List<java.lang.String> groupSet;
        java.lang.String interfaceType;
        java.lang.Number ipv6AddressCount;
        java.lang.Object ipv6Addresses;
        java.lang.String privateIpAddress;
        java.lang.Object privateIpAddresses;
        java.lang.Number secondaryPrivateIpAddressCount;
        java.lang.Object sourceDestCheck;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getSubnetId}
         * @param subnetId The ID of the subnet to associate with the network interface. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetId(java.lang.String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getDescription}
         * @param description A description for the network interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getGroupSet}
         * @param groupSet The security group IDs associated with this network interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupSet(java.util.List<java.lang.String> groupSet) {
            this.groupSet = groupSet;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getInterfaceType}
         * @param interfaceType The type of network interface.
         *                      The default is <code>interface</code> . The supported values are <code>efa</code> and <code>trunk</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder interfaceType(java.lang.String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getIpv6AddressCount}
         * @param ipv6AddressCount The number of IPv6 addresses to assign to a network interface.
         *                         Amazon EC2 automatically selects the IPv6 addresses from the subnet range. To specify specific IPv6 addresses, use the <code>Ipv6Addresses</code> property and don't specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getIpv6Addresses}
         * @param ipv6Addresses One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet to associate with the network interface.
         *                      If you're specifying a number of IPv6 addresses, use the <code>Ipv6AddressCount</code> property and don't specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Addresses(software.amazon.awscdk.IResolvable ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getIpv6Addresses}
         * @param ipv6Addresses One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet to associate with the network interface.
         *                      If you're specifying a number of IPv6 addresses, use the <code>Ipv6AddressCount</code> property and don't specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Addresses(java.util.List<? extends java.lang.Object> ipv6Addresses) {
            this.ipv6Addresses = ipv6Addresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getPrivateIpAddress}
         * @param privateIpAddress Assigns a single private IP address to the network interface, which is used as the primary private IP address.
         *                         If you want to specify multiple private IP address, use the <code>PrivateIpAddresses</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddress(java.lang.String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getPrivateIpAddresses}
         * @param privateIpAddresses Assigns private IP addresses to the network interface.
         *                           You can specify a primary private IP address by setting the value of the <code>Primary</code> property to <code>true</code> in the <code>PrivateIpAddressSpecification</code> property. If you want EC2 to automatically assign private IP addresses, use the <code>SecondaryPrivateIpAddressCount</code> property and do not specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddresses(software.amazon.awscdk.IResolvable privateIpAddresses) {
            this.privateIpAddresses = privateIpAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getPrivateIpAddresses}
         * @param privateIpAddresses Assigns private IP addresses to the network interface.
         *                           You can specify a primary private IP address by setting the value of the <code>Primary</code> property to <code>true</code> in the <code>PrivateIpAddressSpecification</code> property. If you want EC2 to automatically assign private IP addresses, use the <code>SecondaryPrivateIpAddressCount</code> property and do not specify this property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddresses(java.util.List<? extends java.lang.Object> privateIpAddresses) {
            this.privateIpAddresses = privateIpAddresses;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getSecondaryPrivateIpAddressCount}
         * @param secondaryPrivateIpAddressCount The number of secondary private IPv4 addresses to assign to a network interface.
         *                                       When you specify a number of secondary IPv4 addresses, Amazon EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You can't specify this option and specify more than one private IP address using <code>privateIpAddresses</code> .
         *                                       <p>
         *                                       The number of IP addresses you can assign to a network interface varies by instance type. For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI">IP Addresses Per ENI Per Instance Type</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secondaryPrivateIpAddressCount(java.lang.Number secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getSourceDestCheck}
         * @param sourceDestCheck Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
         *                        If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(java.lang.Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getSourceDestCheck}
         * @param sourceDestCheck Enable or disable source/destination checks, which ensure that the instance is either the source or the destination of any traffic that it receives.
         *                        If the value is <code>true</code> , source/destination checks are enabled; otherwise, they are disabled. The default value is <code>true</code> . You must disable source/destination checks if the instance runs services such as network address translation, routing, or firewalls.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(software.amazon.awscdk.IResolvable sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of {@link CfnNetworkInterfaceProps#getTags}
         * @param tags An arbitrary set of tags (key-value pairs) for this network interface.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnNetworkInterfaceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnNetworkInterfaceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnNetworkInterfaceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnNetworkInterfaceProps {
        private final java.lang.String subnetId;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> groupSet;
        private final java.lang.String interfaceType;
        private final java.lang.Number ipv6AddressCount;
        private final java.lang.Object ipv6Addresses;
        private final java.lang.String privateIpAddress;
        private final java.lang.Object privateIpAddresses;
        private final java.lang.Number secondaryPrivateIpAddressCount;
        private final java.lang.Object sourceDestCheck;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.groupSet = software.amazon.jsii.Kernel.get(this, "groupSet", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.interfaceType = software.amazon.jsii.Kernel.get(this, "interfaceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv6AddressCount = software.amazon.jsii.Kernel.get(this, "ipv6AddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.ipv6Addresses = software.amazon.jsii.Kernel.get(this, "ipv6Addresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.privateIpAddresses = software.amazon.jsii.Kernel.get(this, "privateIpAddresses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.secondaryPrivateIpAddressCount = software.amazon.jsii.Kernel.get(this, "secondaryPrivateIpAddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.sourceDestCheck = software.amazon.jsii.Kernel.get(this, "sourceDestCheck", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.subnetId = java.util.Objects.requireNonNull(builder.subnetId, "subnetId is required");
            this.description = builder.description;
            this.groupSet = builder.groupSet;
            this.interfaceType = builder.interfaceType;
            this.ipv6AddressCount = builder.ipv6AddressCount;
            this.ipv6Addresses = builder.ipv6Addresses;
            this.privateIpAddress = builder.privateIpAddress;
            this.privateIpAddresses = builder.privateIpAddresses;
            this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
            this.sourceDestCheck = builder.sourceDestCheck;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getGroupSet() {
            return this.groupSet;
        }

        @Override
        public final java.lang.String getInterfaceType() {
            return this.interfaceType;
        }

        @Override
        public final java.lang.Number getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final java.lang.Object getIpv6Addresses() {
            return this.ipv6Addresses;
        }

        @Override
        public final java.lang.String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final java.lang.Object getPrivateIpAddresses() {
            return this.privateIpAddresses;
        }

        @Override
        public final java.lang.Number getSecondaryPrivateIpAddressCount() {
            return this.secondaryPrivateIpAddressCount;
        }

        @Override
        public final java.lang.Object getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("subnetId", om.valueToTree(this.getSubnetId()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getGroupSet() != null) {
                data.set("groupSet", om.valueToTree(this.getGroupSet()));
            }
            if (this.getInterfaceType() != null) {
                data.set("interfaceType", om.valueToTree(this.getInterfaceType()));
            }
            if (this.getIpv6AddressCount() != null) {
                data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
            }
            if (this.getIpv6Addresses() != null) {
                data.set("ipv6Addresses", om.valueToTree(this.getIpv6Addresses()));
            }
            if (this.getPrivateIpAddress() != null) {
                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
            }
            if (this.getPrivateIpAddresses() != null) {
                data.set("privateIpAddresses", om.valueToTree(this.getPrivateIpAddresses()));
            }
            if (this.getSecondaryPrivateIpAddressCount() != null) {
                data.set("secondaryPrivateIpAddressCount", om.valueToTree(this.getSecondaryPrivateIpAddressCount()));
            }
            if (this.getSourceDestCheck() != null) {
                data.set("sourceDestCheck", om.valueToTree(this.getSourceDestCheck()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnNetworkInterfaceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnNetworkInterfaceProps.Jsii$Proxy that = (CfnNetworkInterfaceProps.Jsii$Proxy) o;

            if (!subnetId.equals(that.subnetId)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.groupSet != null ? !this.groupSet.equals(that.groupSet) : that.groupSet != null) return false;
            if (this.interfaceType != null ? !this.interfaceType.equals(that.interfaceType) : that.interfaceType != null) return false;
            if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
            if (this.ipv6Addresses != null ? !this.ipv6Addresses.equals(that.ipv6Addresses) : that.ipv6Addresses != null) return false;
            if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
            if (this.privateIpAddresses != null ? !this.privateIpAddresses.equals(that.privateIpAddresses) : that.privateIpAddresses != null) return false;
            if (this.secondaryPrivateIpAddressCount != null ? !this.secondaryPrivateIpAddressCount.equals(that.secondaryPrivateIpAddressCount) : that.secondaryPrivateIpAddressCount != null) return false;
            if (this.sourceDestCheck != null ? !this.sourceDestCheck.equals(that.sourceDestCheck) : that.sourceDestCheck != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.subnetId.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.groupSet != null ? this.groupSet.hashCode() : 0);
            result = 31 * result + (this.interfaceType != null ? this.interfaceType.hashCode() : 0);
            result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
            result = 31 * result + (this.ipv6Addresses != null ? this.ipv6Addresses.hashCode() : 0);
            result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
            result = 31 * result + (this.privateIpAddresses != null ? this.privateIpAddresses.hashCode() : 0);
            result = 31 * result + (this.secondaryPrivateIpAddressCount != null ? this.secondaryPrivateIpAddressCount.hashCode() : 0);
            result = 31 * result + (this.sourceDestCheck != null ? this.sourceDestCheck.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
