package software.amazon.awscdk.services.ecr.assets;

/**
 * An asset that represents a Docker image.
 * <p>
 * The image will be created in build time and uploaded to an ECR repository.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.DockerImageAsset;
 * import software.amazon.awscdk.services.ecr.assets.NetworkMode;
 * DockerImageAsset asset = DockerImageAsset.Builder.create(this, "MyBuildImage")
 *         .directory(join(__dirname, "my-image"))
 *         .networkMode(NetworkMode.HOST)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.607Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr_assets.DockerImageAsset")
public class DockerImageAsset extends software.constructs.Construct {

    protected DockerImageAsset(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DockerImageAsset(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DockerImageAsset(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Adds CloudFormation template metadata to the specified resource with information that indicates which resource property is mapped to this local asset.
     * <p>
     * This can be used by tools such as SAM CLI to provide local
     * experience such as local invocation and debugging of Lambda functions.
     * <p>
     * Asset metadata will only be included if the stack is synthesized with the
     * "aws:cdk:enable-asset-metadata" context key defined, which is the default
     * behavior when synthesizing via the CDK Toolkit.
     * <p>
     * @see https://github.com/aws/aws-cdk/issues/1432
     * @param resource The CloudFormation resource which is using this asset [disable-awslint:ref-via-interface]. This parameter is required.
     * @param resourceProperty The property name where this asset is referenced. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addResourceMetadata(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.CfnResource resource, final @org.jetbrains.annotations.NotNull java.lang.String resourceProperty) {
        software.amazon.jsii.Kernel.call(this, "addResourceMetadata", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(resource, "resource is required"), java.util.Objects.requireNonNull(resourceProperty, "resourceProperty is required") });
    }

    /**
     * A hash of this asset, which is available at construction time.
     * <p>
     * As this is a plain string, it
     * can be used in construct IDs in order to enforce creation of a new resource when the content
     * hash has changed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAssetHash() {
        return software.amazon.jsii.Kernel.get(this, "assetHash", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full URI of the image (including a tag).
     * <p>
     * Use this reference to pull
     * the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageUri() {
        return software.amazon.jsii.Kernel.get(this, "imageUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The full URI of the image (including a tag).
     * <p>
     * Use this reference to pull
     * the asset.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setImageUri(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "imageUri", java.util.Objects.requireNonNull(value, "imageUri is required"));
    }

    /**
     * Repository where the image is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return software.amazon.jsii.Kernel.get(this, "repository", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecr.IRepository.class));
    }

    /**
     * Repository where the image is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository value) {
        software.amazon.jsii.Kernel.set(this, "repository", java.util.Objects.requireNonNull(value, "repository is required"));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecr.assets.DockerImageAsset}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecr.assets.DockerImageAsset> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps.Builder();
        }

        /**
         * Glob patterns to exclude from the copy.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude Glob patterns to exclude from the copy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.props.exclude(exclude);
            return this;
        }

        /**
         * A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param followSymlinks A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(final software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.props.followSymlinks(followSymlinks);
            return this;
        }

        /**
         * The ignore behavior to use for exclude patterns.
         * <p>
         * Default: IgnoreMode.GLOB
         * <p>
         * @return {@code this}
         * @param ignoreMode The ignore behavior to use for exclude patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(final software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.props.ignoreMode(ignoreMode);
            return this;
        }

        /**
         * Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * <p>
         * Default: - hash is only based on source content
         * <p>
         * @return {@code this}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(final java.lang.String extraHash) {
            this.props.extraHash(extraHash);
            return this;
        }

        /**
         * Build args to pass to the `docker build` command.
         * <p>
         * Since Docker build arguments are resolved before deployment, keys and
         * values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         * <code>queue.queueUrl</code>).
         * <p>
         * Default: - no build args are passed
         * <p>
         * @return {@code this}
         * @param buildArgs Build args to pass to the `docker build` command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(final java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.props.buildArgs(buildArgs);
            return this;
        }

        /**
         * Path to the Dockerfile (relative to the directory).
         * <p>
         * Default: 'Dockerfile'
         * <p>
         * @return {@code this}
         * @param file Path to the Dockerfile (relative to the directory). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder file(final java.lang.String file) {
            this.props.file(file);
            return this;
        }

        /**
         * Options to control which parameters are used to invalidate the asset hash.
         * <p>
         * Default: - hash all parameters
         * <p>
         * @return {@code this}
         * @param invalidation Options to control which parameters are used to invalidate the asset hash. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invalidation(final software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation) {
            this.props.invalidation(invalidation);
            return this;
        }

        /**
         * Networking mode for the RUN commands during build.
         * <p>
         * Support docker API 1.25+.
         * <p>
         * Default: - no networking mode specified (the default networking mode `NetworkMode.DEFAULT` will be used)
         * <p>
         * @return {@code this}
         * @param networkMode Networking mode for the RUN commands during build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(final software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode) {
            this.props.networkMode(networkMode);
            return this;
        }

        /**
         * Docker target to build to.
         * <p>
         * Default: - no target
         * <p>
         * @return {@code this}
         * @param target Docker target to build to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final java.lang.String target) {
            this.props.target(target);
            return this;
        }

        /**
         * The directory where the Dockerfile is stored.
         * <p>
         * Any directory inside with a name that matches the CDK output folder (cdk.out by default) will be excluded from the asset
         * <p>
         * @return {@code this}
         * @param directory The directory where the Dockerfile is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder directory(final java.lang.String directory) {
            this.props.directory(directory);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecr.assets.DockerImageAsset}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecr.assets.DockerImageAsset build() {
            return new software.amazon.awscdk.services.ecr.assets.DockerImageAsset(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
