package software.amazon.awscdk.services.ecs;

/**
 * An image that will be built from a local directory with a Dockerfile.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.App;
 * import software.amazon.awscdk.Stack;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * import software.amazon.awscdk.cxapi.*;
 * import path.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-ecs-patterns-queue");
 * stack.node.setContext(ECS_REMOVE_DEFAULT_DESIRED_COUNT, true);
 * Vpc vpc = Vpc.Builder.create(stack, "VPC")
 *         .maxAzs(2)
 *         .build();
 * QueueProcessingFargateService.Builder.create(stack, "QueueProcessingService")
 *         .vpc(vpc)
 *         .memoryLimitMiB(512)
 *         .image(new AssetImage(join(__dirname, "..", "sqs-reader")))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.626Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.AssetImage")
public class AssetImage extends software.amazon.awscdk.services.ecs.ContainerImage {

    protected AssetImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AssetImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the AssetImage class.
     * <p>
     * @param directory The directory containing the Dockerfile. This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetImage(final @org.jetbrains.annotations.NotNull java.lang.String directory, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AssetImageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(directory, "directory is required"), props });
    }

    /**
     * Constructs a new instance of the AssetImage class.
     * <p>
     * @param directory The directory containing the Dockerfile. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AssetImage(final @org.jetbrains.annotations.NotNull java.lang.String directory) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(directory, "directory is required") });
    }

    /**
     * Called when the image is used by a ContainerDefinition.
     * <p>
     * @param scope This parameter is required.
     * @param containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerImageConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(containerDefinition, "containerDefinition is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.AssetImage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.AssetImage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param directory The directory containing the Dockerfile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String directory) {
            return new Builder(directory);
        }

        private final java.lang.String directory;
        private software.amazon.awscdk.services.ecs.AssetImageProps.Builder props;

        private Builder(final java.lang.String directory) {
            this.directory = directory;
        }

        /**
         * Glob patterns to exclude from the copy.
         * <p>
         * Default: - nothing is excluded
         * <p>
         * @return {@code this}
         * @param exclude Glob patterns to exclude from the copy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclude(final java.util.List<java.lang.String> exclude) {
            this.props().exclude(exclude);
            return this;
        }

        /**
         * A strategy for how to handle symlinks.
         * <p>
         * Default: SymlinkFollowMode.NEVER
         * <p>
         * @return {@code this}
         * @param followSymlinks A strategy for how to handle symlinks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder followSymlinks(final software.amazon.awscdk.SymlinkFollowMode followSymlinks) {
            this.props().followSymlinks(followSymlinks);
            return this;
        }

        /**
         * The ignore behavior to use for exclude patterns.
         * <p>
         * Default: IgnoreMode.GLOB
         * <p>
         * @return {@code this}
         * @param ignoreMode The ignore behavior to use for exclude patterns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreMode(final software.amazon.awscdk.IgnoreMode ignoreMode) {
            this.props().ignoreMode(ignoreMode);
            return this;
        }

        /**
         * Extra information to encode into the fingerprint (e.g. build instructions and other inputs).
         * <p>
         * Default: - hash is only based on source content
         * <p>
         * @return {@code this}
         * @param extraHash Extra information to encode into the fingerprint (e.g. build instructions and other inputs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraHash(final java.lang.String extraHash) {
            this.props().extraHash(extraHash);
            return this;
        }

        /**
         * Build args to pass to the `docker build` command.
         * <p>
         * Since Docker build arguments are resolved before deployment, keys and
         * values cannot refer to unresolved tokens (such as <code>lambda.functionArn</code> or
         * <code>queue.queueUrl</code>).
         * <p>
         * Default: - no build args are passed
         * <p>
         * @return {@code this}
         * @param buildArgs Build args to pass to the `docker build` command. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder buildArgs(final java.util.Map<java.lang.String, java.lang.String> buildArgs) {
            this.props().buildArgs(buildArgs);
            return this;
        }

        /**
         * Path to the Dockerfile (relative to the directory).
         * <p>
         * Default: 'Dockerfile'
         * <p>
         * @return {@code this}
         * @param file Path to the Dockerfile (relative to the directory). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder file(final java.lang.String file) {
            this.props().file(file);
            return this;
        }

        /**
         * Options to control which parameters are used to invalidate the asset hash.
         * <p>
         * Default: - hash all parameters
         * <p>
         * @return {@code this}
         * @param invalidation Options to control which parameters are used to invalidate the asset hash. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invalidation(final software.amazon.awscdk.services.ecr.assets.DockerImageAssetInvalidationOptions invalidation) {
            this.props().invalidation(invalidation);
            return this;
        }

        /**
         * Networking mode for the RUN commands during build.
         * <p>
         * Support docker API 1.25+.
         * <p>
         * Default: - no networking mode specified (the default networking mode `NetworkMode.DEFAULT` will be used)
         * <p>
         * @return {@code this}
         * @param networkMode Networking mode for the RUN commands during build. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(final software.amazon.awscdk.services.ecr.assets.NetworkMode networkMode) {
            this.props().networkMode(networkMode);
            return this;
        }

        /**
         * Docker target to build to.
         * <p>
         * Default: - no target
         * <p>
         * @return {@code this}
         * @param target Docker target to build to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final java.lang.String target) {
            this.props().target(target);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.AssetImage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.AssetImage build() {
            return new software.amazon.awscdk.services.ecs.AssetImage(
                this.directory,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.AssetImageProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.AssetImageProps.Builder();
            }
            return this.props;
        }
    }
}
