package software.amazon.awscdk.services.ecs;

/**
 * Properties for BottleRocketImage.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.ecs.*;
 * BottleRocketImageProps bottleRocketImageProps = BottleRocketImageProps.builder()
 *         .architecture(InstanceArchitecture.ARM_64)
 *         .cachedInContext(false)
 *         .variant(BottlerocketEcsVariant.AWS_ECS_1)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.633Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.BottleRocketImageProps")
@software.amazon.jsii.Jsii.Proxy(BottleRocketImageProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BottleRocketImageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The CPU architecture.
     * <p>
     * Default: - x86_64
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceArchitecture getArchitecture() {
        return null;
    }

    /**
     * Whether the AMI ID is cached to be stable between deployments.
     * <p>
     * By default, the newest image is used on each deployment. This will cause
     * instances to be replaced whenever a new version is released, and may cause
     * downtime if there aren't enough running instances in the AutoScalingGroup
     * to reschedule the tasks on.
     * <p>
     * If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
     * same value will be used on future runs. Your instances will not be replaced
     * but your AMI version will grow old over time. To refresh the AMI lookup,
     * you will have to evict the value from the cache using the <code>cdk context</code>
     * command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
     * more information.
     * <p>
     * Can not be set to <code>true</code> in environment-agnostic stacks.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCachedInContext() {
        return null;
    }

    /**
     * The Amazon ECS variant to use.
     * <p>
     * Only <code>aws-ecs-1</code> is currently available
     * <p>
     * Default: - BottlerocketEcsVariant.AWS_ECS_1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.BottlerocketEcsVariant getVariant() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BottleRocketImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BottleRocketImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BottleRocketImageProps> {
        software.amazon.awscdk.services.ec2.InstanceArchitecture architecture;
        java.lang.Boolean cachedInContext;
        software.amazon.awscdk.services.ecs.BottlerocketEcsVariant variant;

        /**
         * Sets the value of {@link BottleRocketImageProps#getArchitecture}
         * @param architecture The CPU architecture.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder architecture(software.amazon.awscdk.services.ec2.InstanceArchitecture architecture) {
            this.architecture = architecture;
            return this;
        }

        /**
         * Sets the value of {@link BottleRocketImageProps#getCachedInContext}
         * @param cachedInContext Whether the AMI ID is cached to be stable between deployments.
         *                        By default, the newest image is used on each deployment. This will cause
         *                        instances to be replaced whenever a new version is released, and may cause
         *                        downtime if there aren't enough running instances in the AutoScalingGroup
         *                        to reschedule the tasks on.
         *                        <p>
         *                        If set to true, the AMI ID will be cached in <code>cdk.context.json</code> and the
         *                        same value will be used on future runs. Your instances will not be replaced
         *                        but your AMI version will grow old over time. To refresh the AMI lookup,
         *                        you will have to evict the value from the cache using the <code>cdk context</code>
         *                        command. See https://docs.aws.amazon.com/cdk/latest/guide/context.html for
         *                        more information.
         *                        <p>
         *                        Can not be set to <code>true</code> in environment-agnostic stacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedInContext(java.lang.Boolean cachedInContext) {
            this.cachedInContext = cachedInContext;
            return this;
        }

        /**
         * Sets the value of {@link BottleRocketImageProps#getVariant}
         * @param variant The Amazon ECS variant to use.
         *                Only <code>aws-ecs-1</code> is currently available
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variant(software.amazon.awscdk.services.ecs.BottlerocketEcsVariant variant) {
            this.variant = variant;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BottleRocketImageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BottleRocketImageProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BottleRocketImageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BottleRocketImageProps {
        private final software.amazon.awscdk.services.ec2.InstanceArchitecture architecture;
        private final java.lang.Boolean cachedInContext;
        private final software.amazon.awscdk.services.ecs.BottlerocketEcsVariant variant;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.architecture = software.amazon.jsii.Kernel.get(this, "architecture", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceArchitecture.class));
            this.cachedInContext = software.amazon.jsii.Kernel.get(this, "cachedInContext", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.variant = software.amazon.jsii.Kernel.get(this, "variant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.BottlerocketEcsVariant.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.architecture = builder.architecture;
            this.cachedInContext = builder.cachedInContext;
            this.variant = builder.variant;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceArchitecture getArchitecture() {
            return this.architecture;
        }

        @Override
        public final java.lang.Boolean getCachedInContext() {
            return this.cachedInContext;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.BottlerocketEcsVariant getVariant() {
            return this.variant;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getArchitecture() != null) {
                data.set("architecture", om.valueToTree(this.getArchitecture()));
            }
            if (this.getCachedInContext() != null) {
                data.set("cachedInContext", om.valueToTree(this.getCachedInContext()));
            }
            if (this.getVariant() != null) {
                data.set("variant", om.valueToTree(this.getVariant()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.BottleRocketImageProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BottleRocketImageProps.Jsii$Proxy that = (BottleRocketImageProps.Jsii$Proxy) o;

            if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) return false;
            if (this.cachedInContext != null ? !this.cachedInContext.equals(that.cachedInContext) : that.cachedInContext != null) return false;
            return this.variant != null ? this.variant.equals(that.variant) : that.variant == null;
        }

        @Override
        public final int hashCode() {
            int result = this.architecture != null ? this.architecture.hashCode() : 0;
            result = 31 * result + (this.cachedInContext != null ? this.cachedInContext.hashCode() : 0);
            result = 31 * result + (this.variant != null ? this.variant.hashCode() : 0);
            return result;
        }
    }
}
