package software.amazon.awscdk.services.ecs;

/**
 * A secret environment variable.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Secret secret;
 * Secret dbSecret;
 * StringParameter parameter;
 * TaskDefinition taskDefinition;
 * Bucket s3Bucket;
 * ContainerDefinition newContainer = taskDefinition.addContainer("container", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .memoryLimitMiB(1024)
 *         .environment(Map.of( // clear text, not for sensitive data
 *                 "STAGE", "prod"))
 *         .environmentFiles(List.of(EnvironmentFile.fromAsset("./demo-env-file.env"), EnvironmentFile.fromBucket(s3Bucket, "assets/demo-env-file.env")))
 *         .secrets(Map.of( // Retrieved from AWS Secrets Manager or AWS Systems Manager Parameter Store at container start-up.
 *                 "SECRET", Secret.fromSecretsManager(secret),
 *                 "DB_PASSWORD", Secret.fromSecretsManager(dbSecret, "password"),  // Reference a specific JSON field, (requires platform version 1.4.0 or later for Fargate tasks)
 *                 "API_KEY", Secret.fromSecretsManagerVersion(secret, SecretVersionInfo.builder().versionId("12345").build(), "apiKey"),  // Reference a specific version of the secret by its version id or version stage (requires platform version 1.4.0 or later for Fargate tasks)
 *                 "PARAMETER", Secret.fromSsmParameter(parameter)))
 *         .build());
 * newContainer.addEnvironment("QUEUE_NAME", "MyQueue");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.801Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.Secret")
public abstract class Secret extends software.amazon.jsii.JsiiObject {

    protected Secret(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Secret(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected Secret() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a environment variable value from a secret stored in AWS Secrets Manager.
     * <p>
     * @param secret the secret stored in AWS Secrets Manager. This parameter is required.
     * @param field the name of the field with the value that you want to set as the environment variable value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Secret fromSecretsManager(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret, final @org.jetbrains.annotations.Nullable java.lang.String field) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Secret.class, "fromSecretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required"), field });
    }

    /**
     * Creates a environment variable value from a secret stored in AWS Secrets Manager.
     * <p>
     * @param secret the secret stored in AWS Secrets Manager. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Secret fromSecretsManager(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Secret.class, "fromSecretsManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * Creates a environment variable value from a secret stored in AWS Secrets Manager.
     * <p>
     * @param secret the secret stored in AWS Secrets Manager. This parameter is required.
     * @param versionInfo the version information to reference the secret. This parameter is required.
     * @param field the name of the field with the value that you want to set as the environment variable value.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Secret fromSecretsManagerVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.SecretVersionInfo versionInfo, final @org.jetbrains.annotations.Nullable java.lang.String field) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Secret.class, "fromSecretsManagerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required"), java.util.Objects.requireNonNull(versionInfo, "versionInfo is required"), field });
    }

    /**
     * Creates a environment variable value from a secret stored in AWS Secrets Manager.
     * <p>
     * @param secret the secret stored in AWS Secrets Manager. This parameter is required.
     * @param versionInfo the version information to reference the secret. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Secret fromSecretsManagerVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.SecretVersionInfo versionInfo) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Secret.class, "fromSecretsManagerVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required"), java.util.Objects.requireNonNull(versionInfo, "versionInfo is required") });
    }

    /**
     * Creates an environment variable value from a parameter stored in AWS Systems Manager Parameter Store.
     * <p>
     * @param parameter This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Secret fromSsmParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IParameter parameter) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.Secret.class, "fromSsmParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class), new Object[] { java.util.Objects.requireNonNull(parameter, "parameter is required") });
    }

    /**
     * Grants reading the secret to a principal.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * The ARN of the secret.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getArn();

    /**
     * Whether this secret uses a specific JSON field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable java.lang.Boolean getHasField();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.Secret {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The ARN of the secret.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getArn() {
            return software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Whether this secret uses a specific JSON field.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.Boolean getHasField() {
            return software.amazon.jsii.Kernel.get(this, "hasField", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Grants reading the secret to a principal.
         * <p>
         * @param grantee This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }
    }
}
