package software.amazon.awscdk.services.ecs.patterns;

/**
 * The properties for the ScheduledFargateTask using a task definition.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * import software.amazon.awscdk.services.ecs.patterns.*;
 * FargateTaskDefinition fargateTaskDefinition;
 * ScheduledFargateTaskDefinitionOptions scheduledFargateTaskDefinitionOptions = ScheduledFargateTaskDefinitionOptions.builder()
 *         .taskDefinition(fargateTaskDefinition)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:42.881Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.ScheduledFargateTaskDefinitionOptions")
@software.amazon.jsii.Jsii.Proxy(ScheduledFargateTaskDefinitionOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ScheduledFargateTaskDefinitionOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The task definition to use for tasks in the service. Image or taskDefinition must be specified, but not both.
     * <p>
     * [disable-awslint:ref-via-interface]
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition();

    /**
     * @return a {@link Builder} of {@link ScheduledFargateTaskDefinitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ScheduledFargateTaskDefinitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ScheduledFargateTaskDefinitionOptions> {
        software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition;

        /**
         * Sets the value of {@link ScheduledFargateTaskDefinitionOptions#getTaskDefinition}
         * @param taskDefinition The task definition to use for tasks in the service. Image or taskDefinition must be specified, but not both. This parameter is required.
         *                       [disable-awslint:ref-via-interface]
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ScheduledFargateTaskDefinitionOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ScheduledFargateTaskDefinitionOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ScheduledFargateTaskDefinitionOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledFargateTaskDefinitionOptions {
        private final software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.taskDefinition = software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateTaskDefinition.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.taskDefinition = java.util.Objects.requireNonNull(builder.taskDefinition, "taskDefinition is required");
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
            return this.taskDefinition;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("taskDefinition", om.valueToTree(this.getTaskDefinition()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.ScheduledFargateTaskDefinitionOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ScheduledFargateTaskDefinitionOptions.Jsii$Proxy that = (ScheduledFargateTaskDefinitionOptions.Jsii$Proxy) o;

            return this.taskDefinition.equals(that.taskDefinition);
        }

        @Override
        public final int hashCode() {
            int result = this.taskDefinition.hashCode();
            return result;
        }
    }
}
