package software.amazon.awscdk.services.elasticache;

/**
 * A CloudFormation `AWS::ElastiCache::CacheCluster`.
 * <p>
 * The AWS::ElastiCache::CacheCluster type creates an Amazon ElastiCache cache cluster.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticache.*;
 * CfnCacheCluster cfnCacheCluster = CfnCacheCluster.Builder.create(this, "MyCfnCacheCluster")
 *         .cacheNodeType("cacheNodeType")
 *         .engine("engine")
 *         .numCacheNodes(123)
 *         // the properties below are optional
 *         .autoMinorVersionUpgrade(false)
 *         .azMode("azMode")
 *         .cacheParameterGroupName("cacheParameterGroupName")
 *         .cacheSecurityGroupNames(List.of("cacheSecurityGroupNames"))
 *         .cacheSubnetGroupName("cacheSubnetGroupName")
 *         .clusterName("clusterName")
 *         .engineVersion("engineVersion")
 *         .logDeliveryConfigurations(List.of(LogDeliveryConfigurationRequestProperty.builder()
 *                 .destinationDetails(DestinationDetailsProperty.builder()
 *                         .cloudWatchLogsDetails(CloudWatchLogsDestinationDetailsProperty.builder()
 *                                 .logGroup("logGroup")
 *                                 .build())
 *                         .kinesisFirehoseDetails(KinesisFirehoseDestinationDetailsProperty.builder()
 *                                 .deliveryStream("deliveryStream")
 *                                 .build())
 *                         .build())
 *                 .destinationType("destinationType")
 *                 .logFormat("logFormat")
 *                 .logType("logType")
 *                 .build()))
 *         .notificationTopicArn("notificationTopicArn")
 *         .port(123)
 *         .preferredAvailabilityZone("preferredAvailabilityZone")
 *         .preferredAvailabilityZones(List.of("preferredAvailabilityZones"))
 *         .preferredMaintenanceWindow("preferredMaintenanceWindow")
 *         .snapshotArns(List.of("snapshotArns"))
 *         .snapshotName("snapshotName")
 *         .snapshotRetentionLimit(123)
 *         .snapshotWindow("snapshotWindow")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcSecurityGroupIds(List.of("vpcSecurityGroupIds"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.013Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnCacheCluster")
public class CfnCacheCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCacheCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCacheCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticache.CfnCacheCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ElastiCache::CacheCluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCacheCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticache.CfnCacheClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The DNS hostname of the cache node.
     * <p>
     * <blockquote>
     * <p>
     * Redis (cluster mode disabled) replication groups don't have this attribute. Therefore, <code>Fn::GetAtt</code> returns a value for this attribute only if the replication group is clustered. Otherwise, <code>Fn::GetAtt</code> fails.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number of the configuration endpoint for the Memcached cache cluster.
     * <p>
     * <blockquote>
     * <p>
     * Redis (cluster mode disabled) replication groups don't have this attribute. Therefore, <code>Fn::GetAtt</code> returns a value for this attribute only if the replication group is clustered. Otherwise, <code>Fn::GetAtt</code> fails.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrConfigurationEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrConfigurationEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The DNS address of the configuration endpoint for the Redis cache cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRedisEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrRedisEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The port number of the configuration endpoint for the Redis cache cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrRedisEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrRedisEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of tags to be added to this resource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The compute and memory capacity of the nodes in the node group (shard).
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts. Changing the CacheNodeType of a Memcached instance is currently not supported. If you need to scale using Memcached, we recommend forcing a replacement update by changing the <code>LogicalResourceId</code> of the resource.
     * <p>
     * <ul>
     * <li>General purpose:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.8xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.16xlarge</code> , <code>cache.m6g.24xlarge</code>
     * <p>
     * <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
     * <p>
     * <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
     * <p>
     * <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
     * <p>
     * <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
     * <p>
     * <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>T1 node types:</em> <code>cache.t1.micro</code>
     * <p>
     * <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
     * <p>
     * <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
     * <p>
     * <ul>
     * <li>Compute optimized:</li>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>C1 node types:</em> <code>cache.c1.xlarge</code>
     * <p>
     * <ul>
     * <li>Memory optimized:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
     * <p>
     * </blockquote>
     * <p>
     * <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.8xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.16xlarge</code> , <code>cache.r6g.24xlarge</code>
     * <p>
     * <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
     * <p>
     * <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
     * <p>
     * <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
     * <p>
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Amazon Region</a>
     * <p>
     * <em>Additional node type info</em>
     * <p>
     * <ul>
     * <li>All current generation instance types are created in Amazon VPC by default.</li>
     * <li>Redis append-only files (AOF) are not supported for T1 or T2 instances.</li>
     * <li>Redis Multi-AZ with automatic failover is not supported on T1 instances.</li>
     * <li>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCacheNodeType() {
        return software.amazon.jsii.Kernel.get(this, "cacheNodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The compute and memory capacity of the nodes in the node group (shard).
     * <p>
     * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts. Changing the CacheNodeType of a Memcached instance is currently not supported. If you need to scale using Memcached, we recommend forcing a replacement update by changing the <code>LogicalResourceId</code> of the resource.
     * <p>
     * <ul>
     * <li>General purpose:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.8xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.16xlarge</code> , <code>cache.m6g.24xlarge</code>
     * <p>
     * <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
     * <p>
     * <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
     * <p>
     * <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
     * <p>
     * <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
     * <p>
     * <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>T1 node types:</em> <code>cache.t1.micro</code>
     * <p>
     * <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
     * <p>
     * <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
     * <p>
     * <ul>
     * <li>Compute optimized:</li>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>C1 node types:</em> <code>cache.c1.xlarge</code>
     * <p>
     * <ul>
     * <li>Memory optimized:</li>
     * <li>Current generation:</li>
     * </ul>
     * <p>
     * <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
     * <p>
     * <blockquote>
     * <p>
     * The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
     * <p>
     * </blockquote>
     * <p>
     * <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.8xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.16xlarge</code> , <code>cache.r6g.24xlarge</code>
     * <p>
     * <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
     * <p>
     * <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
     * <p>
     * <ul>
     * <li>Previous generation: (not recommended)</li>
     * </ul>
     * <p>
     * <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
     * <p>
     * <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
     * <p>
     * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Amazon Region</a>
     * <p>
     * <em>Additional node type info</em>
     * <p>
     * <ul>
     * <li>All current generation instance types are created in Amazon VPC by default.</li>
     * <li>Redis append-only files (AOF) are not supported for T1 or T2 instances.</li>
     * <li>Redis Multi-AZ with automatic failover is not supported on T1 instances.</li>
     * <li>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheNodeType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheNodeType", java.util.Objects.requireNonNull(value, "cacheNodeType is required"));
    }

    /**
     * The name of the cache engine to be used for this cluster.
     * <p>
     * Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEngine() {
        return software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the cache engine to be used for this cluster.
     * <p>
     * Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngine(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engine", java.util.Objects.requireNonNull(value, "engine is required"));
    }

    /**
     * The number of cache nodes that the cache cluster should have.
     * <p>
     * <blockquote>
     * <p>
     * However, if the <code>PreferredAvailabilityZone</code> and <code>PreferredAvailabilityZones</code> properties were not previously specified and you don't specify any new values, an update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getNumCacheNodes() {
        return software.amazon.jsii.Kernel.get(this, "numCacheNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of cache nodes that the cache cluster should have.
     * <p>
     * <blockquote>
     * <p>
     * However, if the <code>PreferredAvailabilityZone</code> and <code>PreferredAvailabilityZones</code> properties were not previously specified and you don't specify any new values, an update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNumCacheNodes(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "numCacheNodes", java.util.Objects.requireNonNull(value, "numCacheNodes is required"));
    }

    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAutoMinorVersionUpgrade() {
        return software.amazon.jsii.Kernel.get(this, "autoMinorVersionUpgrade", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAutoMinorVersionUpgrade(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "autoMinorVersionUpgrade", value);
    }

    /**
     * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.
     * <p>
     * This parameter is only supported for Memcached clusters.
     * <p>
     * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAzMode() {
        return software.amazon.jsii.Kernel.get(this, "azMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.
     * <p>
     * This parameter is only supported for Memcached clusters.
     * <p>
     * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAzMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "azMode", value);
    }

    /**
     * The name of the parameter group to associate with this cluster.
     * <p>
     * If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCacheParameterGroupName() {
        return software.amazon.jsii.Kernel.get(this, "cacheParameterGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the parameter group to associate with this cluster.
     * <p>
     * If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheParameterGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheParameterGroupName", value);
    }

    /**
     * A list of security group names to associate with this cluster.
     * <p>
     * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCacheSecurityGroupNames() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "cacheSecurityGroupNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of security group names to associate with this cluster.
     * <p>
     * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheSecurityGroupNames(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "cacheSecurityGroupNames", value);
    }

    /**
     * The name of the subnet group to be used for the cluster.
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * <p>
     * <blockquote>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html">AWS::ElastiCache::SubnetGroup</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCacheSubnetGroupName() {
        return software.amazon.jsii.Kernel.get(this, "cacheSubnetGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the subnet group to be used for the cluster.
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     * <p>
     * <blockquote>
     * <p>
     * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html">AWS::ElastiCache::SubnetGroup</a> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCacheSubnetGroupName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cacheSubnetGroupName", value);
    }

    /**
     * A name for the cache cluster.
     * <p>
     * If you don't specify a name, AWSCloudFormation generates a unique physical ID and uses that ID for the cache cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * The name must contain 1 to 50 alphanumeric characters or hyphens. The name must start with a letter and cannot end with a hyphen or contain two consecutive hyphens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the cache cluster.
     * <p>
     * If you don't specify a name, AWSCloudFormation generates a unique physical ID and uses that ID for the cache cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
     * <p>
     * The name must contain 1 to 50 alphanumeric characters or hyphens. The name must start with a letter and cannot end with a hyphen or contain two consecutive hyphens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", value);
    }

    /**
     * The version number of the cache engine to be used for this cluster.
     * <p>
     * To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.
     * <p>
     * <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version number of the cache engine to be used for this cluster.
     * <p>
     * To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.
     * <p>
     * <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * Specifies the destination, format and type of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogDeliveryConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "logDeliveryConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the destination, format and type of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDeliveryConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logDeliveryConfigurations", value);
    }

    /**
     * Specifies the destination, format and type of the logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogDeliveryConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "logDeliveryConfigurations", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
     * <p>
     * <blockquote>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNotificationTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "notificationTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
     * <p>
     * <blockquote>
     * <p>
     * The Amazon SNS topic owner must be the same as the cluster owner.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationTopicArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "notificationTopicArn", value);
    }

    /**
     * The port number on which each of the cache nodes accepts connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The port number on which each of the cache nodes accepts connections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * The EC2 Availability Zone in which the cluster is created.
     * <p>
     * All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code> .
     * <p>
     * Default: System chosen Availability Zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredAvailabilityZone() {
        return software.amazon.jsii.Kernel.get(this, "preferredAvailabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The EC2 Availability Zone in which the cluster is created.
     * <p>
     * All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code> .
     * <p>
     * Default: System chosen Availability Zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredAvailabilityZone(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredAvailabilityZone", value);
    }

    /**
     * A list of the Availability Zones in which cache nodes are created.
     * <p>
     * The order of the zones in the list is not important.
     * <p>
     * This option is only supported on Memcached.
     * <p>
     * <blockquote>
     * <p>
     * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code> .
     * <p>
     * </blockquote>
     * <p>
     * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.
     * <p>
     * Default: System chosen Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPreferredAvailabilityZones() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "preferredAvailabilityZones", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of the Availability Zones in which cache nodes are created.
     * <p>
     * The order of the zones in the list is not important.
     * <p>
     * This option is only supported on Memcached.
     * <p>
     * <blockquote>
     * <p>
     * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.
     * <p>
     * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code> .
     * <p>
     * </blockquote>
     * <p>
     * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.
     * <p>
     * Default: System chosen Availability Zones.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredAvailabilityZones(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "preferredAvailabilityZones", value);
    }

    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed.
     * <p>
     * It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * <p>
     * Valid values for <code>ddd</code> are:
     * <p>
     * <ul>
     * <li><code>sun</code></li>
     * <li><code>mon</code></li>
     * <li><code>tue</code></li>
     * <li><code>wed</code></li>
     * <li><code>thu</code></li>
     * <li><code>fri</code></li>
     * <li><code>sat</code></li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPreferredMaintenanceWindow() {
        return software.amazon.jsii.Kernel.get(this, "preferredMaintenanceWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the weekly time range during which maintenance on the cluster is performed.
     * <p>
     * It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:
     * <p>
     * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
     * <p>
     * Valid values for <code>ddd</code> are:
     * <p>
     * <ul>
     * <li><code>sun</code></li>
     * <li><code>mon</code></li>
     * <li><code>tue</code></li>
     * <li><code>wed</code></li>
     * <li><code>thu</code></li>
     * <li><code>fri</code></li>
     * <li><code>sat</code></li>
     * </ul>
     * <p>
     * Example: <code>sun:23:00-mon:01:30</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreferredMaintenanceWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "preferredMaintenanceWindow", value);
    }

    /**
     * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3.
     * <p>
     * The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSnapshotArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "snapshotArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3.
     * <p>
     * The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "snapshotArns", value);
    }

    /**
     * The name of a Redis snapshot from which to restore data into the new node group (shard).
     * <p>
     * The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotName() {
        return software.amazon.jsii.Kernel.get(this, "snapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a Redis snapshot from which to restore data into the new node group (shard).
     * <p>
     * The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotName", value);
    }

    /**
     * The number of days for which ElastiCache retains automatic snapshots before deleting them.
     * <p>
     * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSnapshotRetentionLimit() {
        return software.amazon.jsii.Kernel.get(this, "snapshotRetentionLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of days for which ElastiCache retains automatic snapshots before deleting them.
     * <p>
     * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     * <p>
     * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotRetentionLimit(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "snapshotRetentionLimit", value);
    }

    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * <p>
     * Example: <code>05:00-09:00</code>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotWindow() {
        return software.amazon.jsii.Kernel.get(this, "snapshotWindow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
     * <p>
     * Example: <code>05:00-09:00</code>
     * <p>
     * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotWindow(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotWindow", value);
    }

    /**
     * One or more VPC security groups associated with the cluster.
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpcSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "vpcSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * One or more VPC security groups associated with the cluster.
     * <p>
     * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "vpcSecurityGroupIds", value);
    }
    /**
     * Configuration details of a CloudWatch Logs destination.
     * <p>
     * Note that this field is marked as required but only if CloudWatch Logs was chosen as the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * CloudWatchLogsDestinationDetailsProperty cloudWatchLogsDestinationDetailsProperty = CloudWatchLogsDestinationDetailsProperty.builder()
     *         .logGroup("logGroup")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnCacheCluster.CloudWatchLogsDestinationDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsDestinationDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsDestinationDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the CloudWatch Logs log group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogGroup();

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsDestinationDetailsProperty> {
            java.lang.String logGroup;

            /**
             * Sets the value of {@link CloudWatchLogsDestinationDetailsProperty#getLogGroup}
             * @param logGroup The name of the CloudWatch Logs log group. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroup(java.lang.String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsDestinationDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsDestinationDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsDestinationDetailsProperty {
            private final java.lang.String logGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroup = java.util.Objects.requireNonNull(builder.logGroup, "logGroup is required");
            }

            @Override
            public final java.lang.String getLogGroup() {
                return this.logGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("logGroup", om.valueToTree(this.getLogGroup()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnCacheCluster.CloudWatchLogsDestinationDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsDestinationDetailsProperty.Jsii$Proxy that = (CloudWatchLogsDestinationDetailsProperty.Jsii$Proxy) o;

                return this.logGroup.equals(that.logGroup);
            }

            @Override
            public final int hashCode() {
                int result = this.logGroup.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * DestinationDetailsProperty destinationDetailsProperty = DestinationDetailsProperty.builder()
     *         .cloudWatchLogsDetails(CloudWatchLogsDestinationDetailsProperty.builder()
     *                 .logGroup("logGroup")
     *                 .build())
     *         .kinesisFirehoseDetails(KinesisFirehoseDestinationDetailsProperty.builder()
     *                 .deliveryStream("deliveryStream")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnCacheCluster.DestinationDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration details of the CloudWatch Logs destination.
         * <p>
         * Note that this field is marked as required but only if CloudWatch Logs was chosen as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogsDetails() {
            return null;
        }

        /**
         * The configuration details of the Kinesis Data Firehose destination.
         * <p>
         * Note that this field is marked as required but only if Kinesis Data Firehose was chosen as the destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisFirehoseDetails() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationDetailsProperty> {
            java.lang.Object cloudWatchLogsDetails;
            java.lang.Object kinesisFirehoseDetails;

            /**
             * Sets the value of {@link DestinationDetailsProperty#getCloudWatchLogsDetails}
             * @param cloudWatchLogsDetails The configuration details of the CloudWatch Logs destination.
             *                              Note that this field is marked as required but only if CloudWatch Logs was chosen as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsDetails(software.amazon.awscdk.services.elasticache.CfnCacheCluster.CloudWatchLogsDestinationDetailsProperty cloudWatchLogsDetails) {
                this.cloudWatchLogsDetails = cloudWatchLogsDetails;
                return this;
            }

            /**
             * Sets the value of {@link DestinationDetailsProperty#getCloudWatchLogsDetails}
             * @param cloudWatchLogsDetails The configuration details of the CloudWatch Logs destination.
             *                              Note that this field is marked as required but only if CloudWatch Logs was chosen as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsDetails(software.amazon.awscdk.IResolvable cloudWatchLogsDetails) {
                this.cloudWatchLogsDetails = cloudWatchLogsDetails;
                return this;
            }

            /**
             * Sets the value of {@link DestinationDetailsProperty#getKinesisFirehoseDetails}
             * @param kinesisFirehoseDetails The configuration details of the Kinesis Data Firehose destination.
             *                               Note that this field is marked as required but only if Kinesis Data Firehose was chosen as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDetails(software.amazon.awscdk.services.elasticache.CfnCacheCluster.KinesisFirehoseDestinationDetailsProperty kinesisFirehoseDetails) {
                this.kinesisFirehoseDetails = kinesisFirehoseDetails;
                return this;
            }

            /**
             * Sets the value of {@link DestinationDetailsProperty#getKinesisFirehoseDetails}
             * @param kinesisFirehoseDetails The configuration details of the Kinesis Data Firehose destination.
             *                               Note that this field is marked as required but only if Kinesis Data Firehose was chosen as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kinesisFirehoseDetails(software.amazon.awscdk.IResolvable kinesisFirehoseDetails) {
                this.kinesisFirehoseDetails = kinesisFirehoseDetails;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationDetailsProperty {
            private final java.lang.Object cloudWatchLogsDetails;
            private final java.lang.Object kinesisFirehoseDetails;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsDetails = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kinesisFirehoseDetails = software.amazon.jsii.Kernel.get(this, "kinesisFirehoseDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsDetails = builder.cloudWatchLogsDetails;
                this.kinesisFirehoseDetails = builder.kinesisFirehoseDetails;
            }

            @Override
            public final java.lang.Object getCloudWatchLogsDetails() {
                return this.cloudWatchLogsDetails;
            }

            @Override
            public final java.lang.Object getKinesisFirehoseDetails() {
                return this.kinesisFirehoseDetails;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogsDetails() != null) {
                    data.set("cloudWatchLogsDetails", om.valueToTree(this.getCloudWatchLogsDetails()));
                }
                if (this.getKinesisFirehoseDetails() != null) {
                    data.set("kinesisFirehoseDetails", om.valueToTree(this.getKinesisFirehoseDetails()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnCacheCluster.DestinationDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationDetailsProperty.Jsii$Proxy that = (DestinationDetailsProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogsDetails != null ? !this.cloudWatchLogsDetails.equals(that.cloudWatchLogsDetails) : that.cloudWatchLogsDetails != null) return false;
                return this.kinesisFirehoseDetails != null ? this.kinesisFirehoseDetails.equals(that.kinesisFirehoseDetails) : that.kinesisFirehoseDetails == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsDetails != null ? this.cloudWatchLogsDetails.hashCode() : 0;
                result = 31 * result + (this.kinesisFirehoseDetails != null ? this.kinesisFirehoseDetails.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration details of the Kinesis Data Firehose destination.
     * <p>
     * Note that this field is marked as required but only if Kinesis Data Firehose was chosen as the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * KinesisFirehoseDestinationDetailsProperty kinesisFirehoseDestinationDetailsProperty = KinesisFirehoseDestinationDetailsProperty.builder()
     *         .deliveryStream("deliveryStream")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnCacheCluster.KinesisFirehoseDestinationDetailsProperty")
    @software.amazon.jsii.Jsii.Proxy(KinesisFirehoseDestinationDetailsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KinesisFirehoseDestinationDetailsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Kinesis Data Firehose delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDeliveryStream();

        /**
         * @return a {@link Builder} of {@link KinesisFirehoseDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KinesisFirehoseDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KinesisFirehoseDestinationDetailsProperty> {
            java.lang.String deliveryStream;

            /**
             * Sets the value of {@link KinesisFirehoseDestinationDetailsProperty#getDeliveryStream}
             * @param deliveryStream The name of the Kinesis Data Firehose delivery stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStream(java.lang.String deliveryStream) {
                this.deliveryStream = deliveryStream;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KinesisFirehoseDestinationDetailsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KinesisFirehoseDestinationDetailsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KinesisFirehoseDestinationDetailsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KinesisFirehoseDestinationDetailsProperty {
            private final java.lang.String deliveryStream;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.deliveryStream = software.amazon.jsii.Kernel.get(this, "deliveryStream", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.deliveryStream = java.util.Objects.requireNonNull(builder.deliveryStream, "deliveryStream is required");
            }

            @Override
            public final java.lang.String getDeliveryStream() {
                return this.deliveryStream;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("deliveryStream", om.valueToTree(this.getDeliveryStream()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnCacheCluster.KinesisFirehoseDestinationDetailsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KinesisFirehoseDestinationDetailsProperty.Jsii$Proxy that = (KinesisFirehoseDestinationDetailsProperty.Jsii$Proxy) o;

                return this.deliveryStream.equals(that.deliveryStream);
            }

            @Override
            public final int hashCode() {
                int result = this.deliveryStream.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the destination, format and type of the logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.elasticache.*;
     * LogDeliveryConfigurationRequestProperty logDeliveryConfigurationRequestProperty = LogDeliveryConfigurationRequestProperty.builder()
     *         .destinationDetails(DestinationDetailsProperty.builder()
     *                 .cloudWatchLogsDetails(CloudWatchLogsDestinationDetailsProperty.builder()
     *                         .logGroup("logGroup")
     *                         .build())
     *                 .kinesisFirehoseDetails(KinesisFirehoseDestinationDetailsProperty.builder()
     *                         .deliveryStream("deliveryStream")
     *                         .build())
     *                 .build())
     *         .destinationType("destinationType")
     *         .logFormat("logFormat")
     *         .logType("logType")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticache.CfnCacheCluster.LogDeliveryConfigurationRequestProperty")
    @software.amazon.jsii.Jsii.Proxy(LogDeliveryConfigurationRequestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogDeliveryConfigurationRequestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationDetails();

        /**
         * Specify either CloudWatch Logs or Kinesis Data Firehose as the destination type.
         * <p>
         * Valid values are either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDestinationType();

        /**
         * Valid values are either `json` or `text` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogFormat();

        /**
         * Valid value is either `slow-log` , which refers to [slow-log](https://docs.aws.amazon.com/https://redis.io/commands/slowlog) or `engine-log` .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLogType();

        /**
         * @return a {@link Builder} of {@link LogDeliveryConfigurationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogDeliveryConfigurationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogDeliveryConfigurationRequestProperty> {
            java.lang.Object destinationDetails;
            java.lang.String destinationType;
            java.lang.String logFormat;
            java.lang.String logType;

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getDestinationDetails}
             * @param destinationDetails Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationDetails(software.amazon.awscdk.services.elasticache.CfnCacheCluster.DestinationDetailsProperty destinationDetails) {
                this.destinationDetails = destinationDetails;
                return this;
            }

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getDestinationDetails}
             * @param destinationDetails Configuration details of either a CloudWatch Logs destination or Kinesis Data Firehose destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationDetails(software.amazon.awscdk.IResolvable destinationDetails) {
                this.destinationDetails = destinationDetails;
                return this;
            }

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getDestinationType}
             * @param destinationType Specify either CloudWatch Logs or Kinesis Data Firehose as the destination type. This parameter is required.
             *                        Valid values are either <code>cloudwatch-logs</code> or <code>kinesis-firehose</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationType(java.lang.String destinationType) {
                this.destinationType = destinationType;
                return this;
            }

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getLogFormat}
             * @param logFormat Valid values are either `json` or `text` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logFormat(java.lang.String logFormat) {
                this.logFormat = logFormat;
                return this;
            }

            /**
             * Sets the value of {@link LogDeliveryConfigurationRequestProperty#getLogType}
             * @param logType Valid value is either `slow-log` , which refers to [slow-log](https://docs.aws.amazon.com/https://redis.io/commands/slowlog) or `engine-log` . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logType(java.lang.String logType) {
                this.logType = logType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogDeliveryConfigurationRequestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogDeliveryConfigurationRequestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogDeliveryConfigurationRequestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogDeliveryConfigurationRequestProperty {
            private final java.lang.Object destinationDetails;
            private final java.lang.String destinationType;
            private final java.lang.String logFormat;
            private final java.lang.String logType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinationDetails = software.amazon.jsii.Kernel.get(this, "destinationDetails", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationType = software.amazon.jsii.Kernel.get(this, "destinationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logFormat = software.amazon.jsii.Kernel.get(this, "logFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logType = software.amazon.jsii.Kernel.get(this, "logType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinationDetails = java.util.Objects.requireNonNull(builder.destinationDetails, "destinationDetails is required");
                this.destinationType = java.util.Objects.requireNonNull(builder.destinationType, "destinationType is required");
                this.logFormat = java.util.Objects.requireNonNull(builder.logFormat, "logFormat is required");
                this.logType = java.util.Objects.requireNonNull(builder.logType, "logType is required");
            }

            @Override
            public final java.lang.Object getDestinationDetails() {
                return this.destinationDetails;
            }

            @Override
            public final java.lang.String getDestinationType() {
                return this.destinationType;
            }

            @Override
            public final java.lang.String getLogFormat() {
                return this.logFormat;
            }

            @Override
            public final java.lang.String getLogType() {
                return this.logType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("destinationDetails", om.valueToTree(this.getDestinationDetails()));
                data.set("destinationType", om.valueToTree(this.getDestinationType()));
                data.set("logFormat", om.valueToTree(this.getLogFormat()));
                data.set("logType", om.valueToTree(this.getLogType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticache.CfnCacheCluster.LogDeliveryConfigurationRequestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogDeliveryConfigurationRequestProperty.Jsii$Proxy that = (LogDeliveryConfigurationRequestProperty.Jsii$Proxy) o;

                if (!destinationDetails.equals(that.destinationDetails)) return false;
                if (!destinationType.equals(that.destinationType)) return false;
                if (!logFormat.equals(that.logFormat)) return false;
                return this.logType.equals(that.logType);
            }

            @Override
            public final int hashCode() {
                int result = this.destinationDetails.hashCode();
                result = 31 * result + (this.destinationType.hashCode());
                result = 31 * result + (this.logFormat.hashCode());
                result = 31 * result + (this.logType.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticache.CfnCacheCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticache.CfnCacheCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticache.CfnCacheClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticache.CfnCacheClusterProps.Builder();
        }

        /**
         * The compute and memory capacity of the nodes in the node group (shard).
         * <p>
         * The following node types are supported by ElastiCache. Generally speaking, the current generation types provide more memory and computational power at lower cost when compared to their equivalent previous generation counterparts. Changing the CacheNodeType of a Memcached instance is currently not supported. If you need to scale using Memcached, we recommend forcing a replacement update by changing the <code>LogicalResourceId</code> of the resource.
         * <p>
         * <ul>
         * <li>General purpose:</li>
         * <li>Current generation:</li>
         * </ul>
         * <p>
         * <em>M6g node types:</em> <code>cache.m6g.large</code> , <code>cache.m6g.xlarge</code> , <code>cache.m6g.2xlarge</code> , <code>cache.m6g.4xlarge</code> , <code>cache.m6g.8xlarge</code> , <code>cache.m6g.12xlarge</code> , <code>cache.m6g.16xlarge</code> , <code>cache.m6g.24xlarge</code>
         * <p>
         * <em>M5 node types:</em> <code>cache.m5.large</code> , <code>cache.m5.xlarge</code> , <code>cache.m5.2xlarge</code> , <code>cache.m5.4xlarge</code> , <code>cache.m5.12xlarge</code> , <code>cache.m5.24xlarge</code>
         * <p>
         * <em>M4 node types:</em> <code>cache.m4.large</code> , <code>cache.m4.xlarge</code> , <code>cache.m4.2xlarge</code> , <code>cache.m4.4xlarge</code> , <code>cache.m4.10xlarge</code>
         * <p>
         * <em>T4g node types:</em> <code>cache.t4g.micro</code> , <code>cache.t4g.small</code> , <code>cache.t4g.medium</code>
         * <p>
         * <em>T3 node types:</em> <code>cache.t3.micro</code> , <code>cache.t3.small</code> , <code>cache.t3.medium</code>
         * <p>
         * <em>T2 node types:</em> <code>cache.t2.micro</code> , <code>cache.t2.small</code> , <code>cache.t2.medium</code>
         * <p>
         * <ul>
         * <li>Previous generation: (not recommended)</li>
         * </ul>
         * <p>
         * <em>T1 node types:</em> <code>cache.t1.micro</code>
         * <p>
         * <em>M1 node types:</em> <code>cache.m1.small</code> , <code>cache.m1.medium</code> , <code>cache.m1.large</code> , <code>cache.m1.xlarge</code>
         * <p>
         * <em>M3 node types:</em> <code>cache.m3.medium</code> , <code>cache.m3.large</code> , <code>cache.m3.xlarge</code> , <code>cache.m3.2xlarge</code>
         * <p>
         * <ul>
         * <li>Compute optimized:</li>
         * <li>Previous generation: (not recommended)</li>
         * </ul>
         * <p>
         * <em>C1 node types:</em> <code>cache.c1.xlarge</code>
         * <p>
         * <ul>
         * <li>Memory optimized:</li>
         * <li>Current generation:</li>
         * </ul>
         * <p>
         * <em>R6gd node types:</em> <code>cache.r6gd.xlarge</code> , <code>cache.r6gd.2xlarge</code> , <code>cache.r6gd.4xlarge</code> , <code>cache.r6gd.8xlarge</code> , <code>cache.r6gd.12xlarge</code> , <code>cache.r6gd.16xlarge</code>
         * <p>
         * <blockquote>
         * <p>
         * The <code>r6gd</code> family is available in the following regions: <code>us-east-2</code> , <code>us-east-1</code> , <code>us-west-2</code> , <code>us-west-1</code> , <code>eu-west-1</code> , <code>eu-central-1</code> , <code>ap-northeast-1</code> , <code>ap-southeast-1</code> , <code>ap-southeast-2</code> .
         * <p>
         * </blockquote>
         * <p>
         * <em>R6g node types:</em> <code>cache.r6g.large</code> , <code>cache.r6g.xlarge</code> , <code>cache.r6g.2xlarge</code> , <code>cache.r6g.4xlarge</code> , <code>cache.r6g.8xlarge</code> , <code>cache.r6g.12xlarge</code> , <code>cache.r6g.16xlarge</code> , <code>cache.r6g.24xlarge</code>
         * <p>
         * <em>R5 node types:</em> <code>cache.r5.large</code> , <code>cache.r5.xlarge</code> , <code>cache.r5.2xlarge</code> , <code>cache.r5.4xlarge</code> , <code>cache.r5.12xlarge</code> , <code>cache.r5.24xlarge</code>
         * <p>
         * <em>R4 node types:</em> <code>cache.r4.large</code> , <code>cache.r4.xlarge</code> , <code>cache.r4.2xlarge</code> , <code>cache.r4.4xlarge</code> , <code>cache.r4.8xlarge</code> , <code>cache.r4.16xlarge</code>
         * <p>
         * <ul>
         * <li>Previous generation: (not recommended)</li>
         * </ul>
         * <p>
         * <em>M2 node types:</em> <code>cache.m2.xlarge</code> , <code>cache.m2.2xlarge</code> , <code>cache.m2.4xlarge</code>
         * <p>
         * <em>R3 node types:</em> <code>cache.r3.large</code> , <code>cache.r3.xlarge</code> , <code>cache.r3.2xlarge</code> , <code>cache.r3.4xlarge</code> , <code>cache.r3.8xlarge</code>
         * <p>
         * For region availability, see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/CacheNodes.SupportedTypes.html#CacheNodes.SupportedTypesByRegion">Supported Node Types by Amazon Region</a>
         * <p>
         * <em>Additional node type info</em>
         * <p>
         * <ul>
         * <li>All current generation instance types are created in Amazon VPC by default.</li>
         * <li>Redis append-only files (AOF) are not supported for T1 or T2 instances.</li>
         * <li>Redis Multi-AZ with automatic failover is not supported on T1 instances.</li>
         * <li>Redis configuration variables <code>appendonly</code> and <code>appendfsync</code> are not supported on Redis version 2.8.22 and later.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param cacheNodeType The compute and memory capacity of the nodes in the node group (shard). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNodeType(final java.lang.String cacheNodeType) {
            this.props.cacheNodeType(cacheNodeType);
            return this;
        }

        /**
         * The name of the cache engine to be used for this cluster.
         * <p>
         * Valid values for this parameter are: <code>memcached</code> | <code>redis</code>
         * <p>
         * @return {@code this}
         * @param engine The name of the cache engine to be used for this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(final java.lang.String engine) {
            this.props.engine(engine);
            return this;
        }

        /**
         * The number of cache nodes that the cache cluster should have.
         * <p>
         * <blockquote>
         * <p>
         * However, if the <code>PreferredAvailabilityZone</code> and <code>PreferredAvailabilityZones</code> properties were not previously specified and you don't specify any new values, an update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param numCacheNodes The number of cache nodes that the cache cluster should have. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numCacheNodes(final java.lang.Number numCacheNodes) {
            this.props.numCacheNodes(numCacheNodes);
            return this;
        }

        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final java.lang.Boolean autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }
        /**
         * If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions.
         * <p>
         * @return {@code this}
         * @param autoMinorVersionUpgrade If you are running Redis engine version 6.0 or later, set this parameter to yes if you want to opt-in to the next minor version upgrade campaign. This parameter is disabled for previous versions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoMinorVersionUpgrade(final software.amazon.awscdk.IResolvable autoMinorVersionUpgrade) {
            this.props.autoMinorVersionUpgrade(autoMinorVersionUpgrade);
            return this;
        }

        /**
         * Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region.
         * <p>
         * This parameter is only supported for Memcached clusters.
         * <p>
         * If the <code>AZMode</code> and <code>PreferredAvailabilityZones</code> are not specified, ElastiCache assumes <code>single-az</code> mode.
         * <p>
         * @return {@code this}
         * @param azMode Specifies whether the nodes in this Memcached cluster are created in a single Availability Zone or created across multiple Availability Zones in the cluster's region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder azMode(final java.lang.String azMode) {
            this.props.azMode(azMode);
            return this;
        }

        /**
         * The name of the parameter group to associate with this cluster.
         * <p>
         * If this argument is omitted, the default parameter group for the specified engine is used. You cannot use any parameter group which has <code>cluster-enabled='yes'</code> when creating a cluster.
         * <p>
         * @return {@code this}
         * @param cacheParameterGroupName The name of the parameter group to associate with this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheParameterGroupName(final java.lang.String cacheParameterGroupName) {
            this.props.cacheParameterGroupName(cacheParameterGroupName);
            return this;
        }

        /**
         * A list of security group names to associate with this cluster.
         * <p>
         * Use this parameter only when you are creating a cluster outside of an Amazon Virtual Private Cloud (Amazon VPC).
         * <p>
         * @return {@code this}
         * @param cacheSecurityGroupNames A list of security group names to associate with this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSecurityGroupNames(final java.util.List<java.lang.String> cacheSecurityGroupNames) {
            this.props.cacheSecurityGroupNames(cacheSecurityGroupNames);
            return this;
        }

        /**
         * The name of the subnet group to be used for the cluster.
         * <p>
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         * <p>
         * <blockquote>
         * <p>
         * If you're going to launch your cluster in an Amazon VPC, you need to create a subnet group before you start creating a cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-elasticache-subnetgroup.html">AWS::ElastiCache::SubnetGroup</a> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param cacheSubnetGroupName The name of the subnet group to be used for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheSubnetGroupName(final java.lang.String cacheSubnetGroupName) {
            this.props.cacheSubnetGroupName(cacheSubnetGroupName);
            return this;
        }

        /**
         * A name for the cache cluster.
         * <p>
         * If you don't specify a name, AWSCloudFormation generates a unique physical ID and uses that ID for the cache cluster. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * The name must contain 1 to 50 alphanumeric characters or hyphens. The name must start with a letter and cannot end with a hyphen or contain two consecutive hyphens.
         * <p>
         * @return {@code this}
         * @param clusterName A name for the cache cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        /**
         * The version number of the cache engine to be used for this cluster.
         * <p>
         * To view the supported cache engine versions, use the DescribeCacheEngineVersions operation.
         * <p>
         * <em>Important:</em> You can upgrade to a newer engine version (see <a href="https://docs.aws.amazon.com/AmazonElastiCache/latest/red-ug/SelectEngine.html#VersionManagement">Selecting a Cache Engine and Version</a> ), but you cannot downgrade to an earlier engine version. If you want to use an earlier engine version, you must delete the existing cluster or replication group and create it anew with the earlier engine version.
         * <p>
         * @return {@code this}
         * @param engineVersion The version number of the cache engine to be used for this cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props.engineVersion(engineVersion);
            return this;
        }

        /**
         * Specifies the destination, format and type of the logs.
         * <p>
         * @return {@code this}
         * @param logDeliveryConfigurations Specifies the destination, format and type of the logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryConfigurations(final software.amazon.awscdk.IResolvable logDeliveryConfigurations) {
            this.props.logDeliveryConfigurations(logDeliveryConfigurations);
            return this;
        }
        /**
         * Specifies the destination, format and type of the logs.
         * <p>
         * @return {@code this}
         * @param logDeliveryConfigurations Specifies the destination, format and type of the logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDeliveryConfigurations(final java.util.List<? extends java.lang.Object> logDeliveryConfigurations) {
            this.props.logDeliveryConfigurations(logDeliveryConfigurations);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent.
         * <p>
         * <blockquote>
         * <p>
         * The Amazon SNS topic owner must be the same as the cluster owner.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param notificationTopicArn The Amazon Resource Name (ARN) of the Amazon Simple Notification Service (SNS) topic to which notifications are sent. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopicArn(final java.lang.String notificationTopicArn) {
            this.props.notificationTopicArn(notificationTopicArn);
            return this;
        }

        /**
         * The port number on which each of the cache nodes accepts connections.
         * <p>
         * @return {@code this}
         * @param port The port number on which each of the cache nodes accepts connections. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * The EC2 Availability Zone in which the cluster is created.
         * <p>
         * All nodes belonging to this cluster are placed in the preferred Availability Zone. If you want to create your nodes across multiple Availability Zones, use <code>PreferredAvailabilityZones</code> .
         * <p>
         * Default: System chosen Availability Zone.
         * <p>
         * @return {@code this}
         * @param preferredAvailabilityZone The EC2 Availability Zone in which the cluster is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredAvailabilityZone(final java.lang.String preferredAvailabilityZone) {
            this.props.preferredAvailabilityZone(preferredAvailabilityZone);
            return this;
        }

        /**
         * A list of the Availability Zones in which cache nodes are created.
         * <p>
         * The order of the zones in the list is not important.
         * <p>
         * This option is only supported on Memcached.
         * <p>
         * <blockquote>
         * <p>
         * If you are creating your cluster in an Amazon VPC (recommended) you can only locate nodes in Availability Zones that are associated with the subnets in the selected subnet group.
         * <p>
         * The number of Availability Zones listed must equal the value of <code>NumCacheNodes</code> .
         * <p>
         * </blockquote>
         * <p>
         * If you want all the nodes in the same Availability Zone, use <code>PreferredAvailabilityZone</code> instead, or repeat the Availability Zone multiple times in the list.
         * <p>
         * Default: System chosen Availability Zones.
         * <p>
         * @return {@code this}
         * @param preferredAvailabilityZones A list of the Availability Zones in which cache nodes are created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredAvailabilityZones(final java.util.List<java.lang.String> preferredAvailabilityZones) {
            this.props.preferredAvailabilityZones(preferredAvailabilityZones);
            return this;
        }

        /**
         * Specifies the weekly time range during which maintenance on the cluster is performed.
         * <p>
         * It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid values for <code>ddd</code> are:
         * <p>
         * Specifies the weekly time range during which maintenance on the cluster is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi (24H Clock UTC). The minimum maintenance window is a 60 minute period.
         * <p>
         * Valid values for <code>ddd</code> are:
         * <p>
         * <ul>
         * <li><code>sun</code></li>
         * <li><code>mon</code></li>
         * <li><code>tue</code></li>
         * <li><code>wed</code></li>
         * <li><code>thu</code></li>
         * <li><code>fri</code></li>
         * <li><code>sat</code></li>
         * </ul>
         * <p>
         * Example: <code>sun:23:00-mon:01:30</code>
         * <p>
         * @return {@code this}
         * @param preferredMaintenanceWindow Specifies the weekly time range during which maintenance on the cluster is performed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preferredMaintenanceWindow(final java.lang.String preferredMaintenanceWindow) {
            this.props.preferredMaintenanceWindow(preferredMaintenanceWindow);
            return this;
        }

        /**
         * A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3.
         * <p>
         * The snapshot file is used to populate the node group (shard). The Amazon S3 object name in the ARN cannot contain any commas.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
         * <p>
         * </blockquote>
         * <p>
         * Example of an Amazon S3 ARN: <code>arn:aws:s3:::my_bucket/snapshot1.rdb</code>
         * <p>
         * @return {@code this}
         * @param snapshotArns A single-element string list containing an Amazon Resource Name (ARN) that uniquely identifies a Redis RDB snapshot file stored in Amazon S3. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotArns(final java.util.List<java.lang.String> snapshotArns) {
            this.props.snapshotArns(snapshotArns);
            return this;
        }

        /**
         * The name of a Redis snapshot from which to restore data into the new node group (shard).
         * <p>
         * The snapshot status changes to <code>restoring</code> while the new node group (shard) is being created.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param snapshotName The name of a Redis snapshot from which to restore data into the new node group (shard). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotName(final java.lang.String snapshotName) {
            this.props.snapshotName(snapshotName);
            return this;
        }

        /**
         * The number of days for which ElastiCache retains automatic snapshots before deleting them.
         * <p>
         * For example, if you set <code>SnapshotRetentionLimit</code> to 5, a snapshot taken today is retained for 5 days before being deleted.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
         * <p>
         * </blockquote>
         * <p>
         * Default: 0 (i.e., automatic backups are disabled for this cache cluster).
         * <p>
         * @return {@code this}
         * @param snapshotRetentionLimit The number of days for which ElastiCache retains automatic snapshots before deleting them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotRetentionLimit(final java.lang.Number snapshotRetentionLimit) {
            this.props.snapshotRetentionLimit(snapshotRetentionLimit);
            return this;
        }

        /**
         * The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard).
         * <p>
         * Example: <code>05:00-09:00</code>
         * <p>
         * If you do not specify this parameter, ElastiCache automatically chooses an appropriate time range.
         * <p>
         * <blockquote>
         * <p>
         * This parameter is only valid if the <code>Engine</code> parameter is <code>redis</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param snapshotWindow The daily time range (in UTC) during which ElastiCache begins taking a daily snapshot of your node group (shard). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotWindow(final java.lang.String snapshotWindow) {
            this.props.snapshotWindow(snapshotWindow);
            return this;
        }

        /**
         * A list of tags to be added to this resource.
         * <p>
         * @return {@code this}
         * @param tags A list of tags to be added to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * One or more VPC security groups associated with the cluster.
         * <p>
         * Use this parameter only when you are creating a cluster in an Amazon Virtual Private Cloud (Amazon VPC).
         * <p>
         * @return {@code this}
         * @param vpcSecurityGroupIds One or more VPC security groups associated with the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSecurityGroupIds(final java.util.List<java.lang.String> vpcSecurityGroupIds) {
            this.props.vpcSecurityGroupIds(vpcSecurityGroupIds);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.elasticache.CfnCacheCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticache.CfnCacheCluster build() {
            return new software.amazon.awscdk.services.elasticache.CfnCacheCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
