package software.amazon.awscdk.services.emr;

/**
 * Properties for defining a `CfnInstanceFleetConfig`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.emr.*;
 * ConfigurationProperty configurationProperty_;
 * CfnInstanceFleetConfigProps cfnInstanceFleetConfigProps = CfnInstanceFleetConfigProps.builder()
 *         .clusterId("clusterId")
 *         .instanceFleetType("instanceFleetType")
 *         // the properties below are optional
 *         .instanceTypeConfigs(List.of(InstanceTypeConfigProperty.builder()
 *                 .instanceType("instanceType")
 *                 // the properties below are optional
 *                 .bidPrice("bidPrice")
 *                 .bidPriceAsPercentageOfOnDemandPrice(123)
 *                 .configurations(List.of(ConfigurationProperty.builder()
 *                         .classification("classification")
 *                         .configurationProperties(Map.of(
 *                                 "configurationPropertiesKey", "configurationProperties"))
 *                         .configurations(List.of(configurationProperty_))
 *                         .build()))
 *                 .customAmiId("customAmiId")
 *                 .ebsConfiguration(EbsConfigurationProperty.builder()
 *                         .ebsBlockDeviceConfigs(List.of(EbsBlockDeviceConfigProperty.builder()
 *                                 .volumeSpecification(VolumeSpecificationProperty.builder()
 *                                         .sizeInGb(123)
 *                                         .volumeType("volumeType")
 *                                         // the properties below are optional
 *                                         .iops(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .volumesPerInstance(123)
 *                                 .build()))
 *                         .ebsOptimized(false)
 *                         .build())
 *                 .weightedCapacity(123)
 *                 .build()))
 *         .launchSpecifications(InstanceFleetProvisioningSpecificationsProperty.builder()
 *                 .onDemandSpecification(OnDemandProvisioningSpecificationProperty.builder()
 *                         .allocationStrategy("allocationStrategy")
 *                         .build())
 *                 .spotSpecification(SpotProvisioningSpecificationProperty.builder()
 *                         .timeoutAction("timeoutAction")
 *                         .timeoutDurationMinutes(123)
 *                         // the properties below are optional
 *                         .allocationStrategy("allocationStrategy")
 *                         .blockDurationMinutes(123)
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .targetOnDemandCapacity(123)
 *         .targetSpotCapacity(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.257Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_emr.CfnInstanceFleetConfigProps")
@software.amazon.jsii.Jsii.Proxy(CfnInstanceFleetConfigProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInstanceFleetConfigProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier of the EMR cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getClusterId();

    /**
     * The node type that the instance fleet hosts.
     * <p>
     * <em>Allowed Values</em> : TASK
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getInstanceFleetType();

    /**
     * `InstanceTypeConfigs` determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
     * <p>
     * <blockquote>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInstanceTypeConfigs() {
        return null;
    }

    /**
     * The launch specification for the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLaunchSpecifications() {
        return null;
    }

    /**
     * The friendly name of the instance fleet.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
     * <p>
     * When the instance fleet launches, Amazon EMR tries to provision On-Demand instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When an On-Demand instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
     * <p>
     * <blockquote>
     * <p>
     * If not specified or set to 0, only Spot instances are provisioned for the instance fleet using <code>TargetSpotCapacity</code> . At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTargetOnDemandCapacity() {
        return null;
    }

    /**
     * The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
     * <p>
     * When the instance fleet launches, Amazon EMR tries to provision Spot instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When a Spot instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
     * <p>
     * <blockquote>
     * <p>
     * If not specified or set to 0, only On-Demand instances are provisioned for the instance fleet. At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTargetSpotCapacity() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInstanceFleetConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInstanceFleetConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInstanceFleetConfigProps> {
        java.lang.String clusterId;
        java.lang.String instanceFleetType;
        java.lang.Object instanceTypeConfigs;
        java.lang.Object launchSpecifications;
        java.lang.String name;
        java.lang.Number targetOnDemandCapacity;
        java.lang.Number targetSpotCapacity;

        /**
         * Sets the value of {@link CfnInstanceFleetConfigProps#getClusterId}
         * @param clusterId The unique identifier of the EMR cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterId(java.lang.String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceFleetConfigProps#getInstanceFleetType}
         * @param instanceFleetType The node type that the instance fleet hosts. This parameter is required.
         *                          <em>Allowed Values</em> : TASK
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceFleetType(java.lang.String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceFleetConfigProps#getInstanceTypeConfigs}
         * @param instanceTypeConfigs `InstanceTypeConfigs` determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
         *                            <blockquote>
         *                            <p>
         *                            The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeConfigs(software.amazon.awscdk.IResolvable instanceTypeConfigs) {
            this.instanceTypeConfigs = instanceTypeConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceFleetConfigProps#getInstanceTypeConfigs}
         * @param instanceTypeConfigs `InstanceTypeConfigs` determine the EC2 instances that Amazon EMR attempts to provision to fulfill On-Demand and Spot target capacities.
         *                            <blockquote>
         *                            <p>
         *                            The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
         *                            <p>
         *                            </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceTypeConfigs(java.util.List<? extends java.lang.Object> instanceTypeConfigs) {
            this.instanceTypeConfigs = instanceTypeConfigs;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceFleetConfigProps#getLaunchSpecifications}
         * @param launchSpecifications The launch specification for the instance fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchSpecifications(software.amazon.awscdk.services.emr.CfnInstanceFleetConfig.InstanceFleetProvisioningSpecificationsProperty launchSpecifications) {
            this.launchSpecifications = launchSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceFleetConfigProps#getLaunchSpecifications}
         * @param launchSpecifications The launch specification for the instance fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchSpecifications(software.amazon.awscdk.IResolvable launchSpecifications) {
            this.launchSpecifications = launchSpecifications;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceFleetConfigProps#getName}
         * @param name The friendly name of the instance fleet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceFleetConfigProps#getTargetOnDemandCapacity}
         * @param targetOnDemandCapacity The target capacity of On-Demand units for the instance fleet, which determines how many On-Demand instances to provision.
         *                               When the instance fleet launches, Amazon EMR tries to provision On-Demand instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When an On-Demand instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
         *                               <p>
         *                               <blockquote>
         *                               <p>
         *                               If not specified or set to 0, only Spot instances are provisioned for the instance fleet using <code>TargetSpotCapacity</code> . At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
         *                               <p>
         *                               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetOnDemandCapacity(java.lang.Number targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnInstanceFleetConfigProps#getTargetSpotCapacity}
         * @param targetSpotCapacity The target capacity of Spot units for the instance fleet, which determines how many Spot instances to provision.
         *                           When the instance fleet launches, Amazon EMR tries to provision Spot instances as specified by <code>InstanceTypeConfig</code> . Each instance configuration has a specified <code>WeightedCapacity</code> . When a Spot instance is provisioned, the <code>WeightedCapacity</code> units count toward the target capacity. Amazon EMR provisions instances until the target capacity is totally fulfilled, even if this results in an overage. For example, if there are 2 units remaining to fulfill capacity, and Amazon EMR can only provision an instance with a <code>WeightedCapacity</code> of 5 units, the instance is provisioned, and the target capacity is exceeded by 3 units.
         *                           <p>
         *                           <blockquote>
         *                           <p>
         *                           If not specified or set to 0, only On-Demand instances are provisioned for the instance fleet. At least one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> should be greater than 0. For a master instance fleet, only one of <code>TargetSpotCapacity</code> and <code>TargetOnDemandCapacity</code> can be specified, and its value must be 1.
         *                           <p>
         *                           </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetSpotCapacity(java.lang.Number targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInstanceFleetConfigProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInstanceFleetConfigProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInstanceFleetConfigProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInstanceFleetConfigProps {
        private final java.lang.String clusterId;
        private final java.lang.String instanceFleetType;
        private final java.lang.Object instanceTypeConfigs;
        private final java.lang.Object launchSpecifications;
        private final java.lang.String name;
        private final java.lang.Number targetOnDemandCapacity;
        private final java.lang.Number targetSpotCapacity;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.clusterId = software.amazon.jsii.Kernel.get(this, "clusterId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceFleetType = software.amazon.jsii.Kernel.get(this, "instanceFleetType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceTypeConfigs = software.amazon.jsii.Kernel.get(this, "instanceTypeConfigs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.launchSpecifications = software.amazon.jsii.Kernel.get(this, "launchSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetOnDemandCapacity = software.amazon.jsii.Kernel.get(this, "targetOnDemandCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.targetSpotCapacity = software.amazon.jsii.Kernel.get(this, "targetSpotCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.clusterId = java.util.Objects.requireNonNull(builder.clusterId, "clusterId is required");
            this.instanceFleetType = java.util.Objects.requireNonNull(builder.instanceFleetType, "instanceFleetType is required");
            this.instanceTypeConfigs = builder.instanceTypeConfigs;
            this.launchSpecifications = builder.launchSpecifications;
            this.name = builder.name;
            this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
            this.targetSpotCapacity = builder.targetSpotCapacity;
        }

        @Override
        public final java.lang.String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final java.lang.String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        @Override
        public final java.lang.Object getInstanceTypeConfigs() {
            return this.instanceTypeConfigs;
        }

        @Override
        public final java.lang.Object getLaunchSpecifications() {
            return this.launchSpecifications;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getTargetOnDemandCapacity() {
            return this.targetOnDemandCapacity;
        }

        @Override
        public final java.lang.Number getTargetSpotCapacity() {
            return this.targetSpotCapacity;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("clusterId", om.valueToTree(this.getClusterId()));
            data.set("instanceFleetType", om.valueToTree(this.getInstanceFleetType()));
            if (this.getInstanceTypeConfigs() != null) {
                data.set("instanceTypeConfigs", om.valueToTree(this.getInstanceTypeConfigs()));
            }
            if (this.getLaunchSpecifications() != null) {
                data.set("launchSpecifications", om.valueToTree(this.getLaunchSpecifications()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTargetOnDemandCapacity() != null) {
                data.set("targetOnDemandCapacity", om.valueToTree(this.getTargetOnDemandCapacity()));
            }
            if (this.getTargetSpotCapacity() != null) {
                data.set("targetSpotCapacity", om.valueToTree(this.getTargetSpotCapacity()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_emr.CfnInstanceFleetConfigProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInstanceFleetConfigProps.Jsii$Proxy that = (CfnInstanceFleetConfigProps.Jsii$Proxy) o;

            if (!clusterId.equals(that.clusterId)) return false;
            if (!instanceFleetType.equals(that.instanceFleetType)) return false;
            if (this.instanceTypeConfigs != null ? !this.instanceTypeConfigs.equals(that.instanceTypeConfigs) : that.instanceTypeConfigs != null) return false;
            if (this.launchSpecifications != null ? !this.launchSpecifications.equals(that.launchSpecifications) : that.launchSpecifications != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.targetOnDemandCapacity != null ? !this.targetOnDemandCapacity.equals(that.targetOnDemandCapacity) : that.targetOnDemandCapacity != null) return false;
            return this.targetSpotCapacity != null ? this.targetSpotCapacity.equals(that.targetSpotCapacity) : that.targetSpotCapacity == null;
        }

        @Override
        public final int hashCode() {
            int result = this.clusterId.hashCode();
            result = 31 * result + (this.instanceFleetType.hashCode());
            result = 31 * result + (this.instanceTypeConfigs != null ? this.instanceTypeConfigs.hashCode() : 0);
            result = 31 * result + (this.launchSpecifications != null ? this.launchSpecifications.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.targetOnDemandCapacity != null ? this.targetOnDemandCapacity.hashCode() : 0);
            result = 31 * result + (this.targetSpotCapacity != null ? this.targetSpotCapacity.hashCode() : 0);
            return result;
        }
    }
}
