package software.amazon.awscdk.services.fis;

/**
 * Properties for defining a `CfnExperimentTemplate`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.fis.*;
 * Object cloudWatchLogsConfiguration;
 * Object s3Configuration;
 * CfnExperimentTemplateProps cfnExperimentTemplateProps = CfnExperimentTemplateProps.builder()
 *         .description("description")
 *         .roleArn("roleArn")
 *         .stopConditions(List.of(ExperimentTemplateStopConditionProperty.builder()
 *                 .source("source")
 *                 // the properties below are optional
 *                 .value("value")
 *                 .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .targets(Map.of(
 *                 "targetsKey", ExperimentTemplateTargetProperty.builder()
 *                         .resourceType("resourceType")
 *                         .selectionMode("selectionMode")
 *                         // the properties below are optional
 *                         .filters(List.of(ExperimentTemplateTargetFilterProperty.builder()
 *                                 .path("path")
 *                                 .values(List.of("values"))
 *                                 .build()))
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .resourceArns(List.of("resourceArns"))
 *                         .resourceTags(Map.of(
 *                                 "resourceTagsKey", "resourceTags"))
 *                         .build()))
 *         // the properties below are optional
 *         .actions(Map.of(
 *                 "actionsKey", ExperimentTemplateActionProperty.builder()
 *                         .actionId("actionId")
 *                         // the properties below are optional
 *                         .description("description")
 *                         .parameters(Map.of(
 *                                 "parametersKey", "parameters"))
 *                         .startAfter(List.of("startAfter"))
 *                         .targets(Map.of(
 *                                 "targetsKey", "targets"))
 *                         .build()))
 *         .logConfiguration(ExperimentTemplateLogConfigurationProperty.builder()
 *                 .logSchemaVersion(123)
 *                 // the properties below are optional
 *                 .cloudWatchLogsConfiguration(cloudWatchLogsConfiguration)
 *                 .s3Configuration(s3Configuration)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.398Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fis.CfnExperimentTemplateProps")
@software.amazon.jsii.Jsii.Proxy(CfnExperimentTemplateProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnExperimentTemplateProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description for the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDescription();

    /**
     * The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * The stop conditions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getStopConditions();

    /**
     * The tags to apply to the experiment template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.String> getTags();

    /**
     * The targets for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTargets();

    /**
     * The actions for the experiment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getActions() {
        return null;
    }

    /**
     * The configuration for experiment logging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnExperimentTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnExperimentTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnExperimentTemplateProps> {
        java.lang.String description;
        java.lang.String roleArn;
        java.lang.Object stopConditions;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object targets;
        java.lang.Object actions;
        java.lang.Object logConfiguration;

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getDescription}
         * @param description A description for the experiment template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of an IAM role that grants the AWS FIS service permission to perform service actions on your behalf. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getStopConditions}
         * @param stopConditions The stop conditions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stopConditions(software.amazon.awscdk.IResolvable stopConditions) {
            this.stopConditions = stopConditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getStopConditions}
         * @param stopConditions The stop conditions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stopConditions(java.util.List<? extends java.lang.Object> stopConditions) {
            this.stopConditions = stopConditions;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getTags}
         * @param tags The tags to apply to the experiment template. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getTargets}
         * @param targets The targets for the experiment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.IResolvable targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getTargets}
         * @param targets The targets for the experiment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(java.util.Map<java.lang.String, ? extends java.lang.Object> targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getActions}
         * @param actions The actions for the experiment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(software.amazon.awscdk.IResolvable actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getActions}
         * @param actions The actions for the experiment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actions(java.util.Map<java.lang.String, ? extends java.lang.Object> actions) {
            this.actions = actions;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getLogConfiguration}
         * @param logConfiguration The configuration for experiment logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(software.amazon.awscdk.services.fis.CfnExperimentTemplate.ExperimentTemplateLogConfigurationProperty logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnExperimentTemplateProps#getLogConfiguration}
         * @param logConfiguration The configuration for experiment logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logConfiguration(software.amazon.awscdk.IResolvable logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnExperimentTemplateProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnExperimentTemplateProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnExperimentTemplateProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnExperimentTemplateProps {
        private final java.lang.String description;
        private final java.lang.String roleArn;
        private final java.lang.Object stopConditions;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object targets;
        private final java.lang.Object actions;
        private final java.lang.Object logConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stopConditions = software.amazon.jsii.Kernel.get(this, "stopConditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.actions = software.amazon.jsii.Kernel.get(this, "actions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.stopConditions = java.util.Objects.requireNonNull(builder.stopConditions, "stopConditions is required");
            this.tags = java.util.Objects.requireNonNull(builder.tags, "tags is required");
            this.targets = java.util.Objects.requireNonNull(builder.targets, "targets is required");
            this.actions = builder.actions;
            this.logConfiguration = builder.logConfiguration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Object getStopConditions() {
            return this.stopConditions;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTargets() {
            return this.targets;
        }

        @Override
        public final java.lang.Object getActions() {
            return this.actions;
        }

        @Override
        public final java.lang.Object getLogConfiguration() {
            return this.logConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("description", om.valueToTree(this.getDescription()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            data.set("stopConditions", om.valueToTree(this.getStopConditions()));
            data.set("tags", om.valueToTree(this.getTags()));
            data.set("targets", om.valueToTree(this.getTargets()));
            if (this.getActions() != null) {
                data.set("actions", om.valueToTree(this.getActions()));
            }
            if (this.getLogConfiguration() != null) {
                data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_fis.CfnExperimentTemplateProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnExperimentTemplateProps.Jsii$Proxy that = (CfnExperimentTemplateProps.Jsii$Proxy) o;

            if (!description.equals(that.description)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (!stopConditions.equals(that.stopConditions)) return false;
            if (!tags.equals(that.tags)) return false;
            if (!targets.equals(that.targets)) return false;
            if (this.actions != null ? !this.actions.equals(that.actions) : that.actions != null) return false;
            return this.logConfiguration != null ? this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description.hashCode();
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.stopConditions.hashCode());
            result = 31 * result + (this.tags.hashCode());
            result = 31 * result + (this.targets.hashCode());
            result = 31 * result + (this.actions != null ? this.actions.hashCode() : 0);
            result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
            return result;
        }
    }
}
