package software.amazon.awscdk.services.fsx;

/**
 * The different kinds of file system deployments used by Lustre.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * LustreFileSystem fileSystem = LustreFileSystem.Builder.create(this, "FsxLustreFileSystem")
 *         .lustreConfiguration(LustreConfiguration.builder().deploymentType(LustreDeploymentType.SCRATCH_2).build())
 *         .storageCapacityGiB(1200)
 *         .vpc(vpc)
 *         .vpcSubnet(vpc.getPrivateSubnets()[0])
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.472Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_fsx.LustreDeploymentType")
public enum LustreDeploymentType {
    /**
     * Original type for shorter term data processing.
     * <p>
     * Data is not replicated and does not persist on server fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SCRATCH_1,
    /**
     * Newer type for shorter term data processing.
     * <p>
     * Data is not replicated and does not persist on server fail.
     * Provides better support for spiky workloads.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SCRATCH_2,
    /**
     * Long term storage.
     * <p>
     * Data is replicated and file servers are replaced if they fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PERSISTENT_1,
    /**
     * Newer type of long term storage with higher throughput tiers.
     * <p>
     * Data is replicated and file servers are replaced if they fail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PERSISTENT_2,
}
