package software.amazon.awscdk.services.gamelift;

/**
 * A CloudFormation `AWS::GameLift::MatchmakingConfiguration`.
 * <p>
 * The <code>AWS::GameLift::MatchmakingConfiguration</code> resource defines a new matchmaking configuration for use with FlexMatch. Whether you're using FlexMatch with GameLift hosting or as a standalone matchmaking service, the matchmaking configuration sets out rules for matching players and forming teams. If you're using GameLift hosting, it also defines how to start game sessions for each match. Your matchmaking system can use multiple configurations to handle different game scenarios. All matchmaking requests identify the matchmaking configuration to use and provide player attributes that are consistent with that configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.gamelift.*;
 * CfnMatchmakingConfiguration cfnMatchmakingConfiguration = CfnMatchmakingConfiguration.Builder.create(this, "MyCfnMatchmakingConfiguration")
 *         .acceptanceRequired(false)
 *         .name("name")
 *         .requestTimeoutSeconds(123)
 *         .ruleSetName("ruleSetName")
 *         // the properties below are optional
 *         .acceptanceTimeoutSeconds(123)
 *         .additionalPlayerCount(123)
 *         .backfillMode("backfillMode")
 *         .customEventData("customEventData")
 *         .description("description")
 *         .flexMatchMode("flexMatchMode")
 *         .gameProperties(List.of(GamePropertyProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .gameSessionData("gameSessionData")
 *         .gameSessionQueueArns(List.of("gameSessionQueueArns"))
 *         .notificationTarget("notificationTarget")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.504Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnMatchmakingConfiguration")
public class CfnMatchmakingConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnMatchmakingConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMatchmakingConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.gamelift.CfnMatchmakingConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::GameLift::MatchmakingConfiguration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMatchmakingConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.gamelift.CfnMatchmakingConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The unique Amazon Resource Name (ARN) for the `MatchmakingConfiguration` .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The `MatchmakingConfiguration` name, which is unique.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A list of labels to assign to the new matchmaking configuration resource.
     * <p>
     * Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in the <em>AWS General Reference</em> . Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A flag that determines whether a match that was created with this configuration must be accepted by the matched players.
     * <p>
     * To require acceptance, set to <code>TRUE</code> . With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAcceptanceRequired() {
        return software.amazon.jsii.Kernel.get(this, "acceptanceRequired", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A flag that determines whether a match that was created with this configuration must be accepted by the matched players.
     * <p>
     * To require acceptance, set to <code>TRUE</code> . With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAcceptanceRequired(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "acceptanceRequired", java.util.Objects.requireNonNull(value, "acceptanceRequired is required"));
    }

    /**
     * A flag that determines whether a match that was created with this configuration must be accepted by the matched players.
     * <p>
     * To require acceptance, set to <code>TRUE</code> . With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAcceptanceRequired(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "acceptanceRequired", java.util.Objects.requireNonNull(value, "acceptanceRequired is required"));
    }

    /**
     * A unique identifier for the matchmaking configuration.
     * <p>
     * This name is used to identify the configuration associated with a matchmaking request or ticket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the matchmaking configuration.
     * <p>
     * This name is used to identify the configuration associated with a matchmaking request or ticket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
     * <p>
     * Requests that fail due to timing out can be resubmitted as needed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getRequestTimeoutSeconds() {
        return software.amazon.jsii.Kernel.get(this, "requestTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
     * <p>
     * Requests that fail due to timing out can be resubmitted as needed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequestTimeoutSeconds(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "requestTimeoutSeconds", java.util.Objects.requireNonNull(value, "requestTimeoutSeconds is required"));
    }

    /**
     * A unique identifier for the matchmaking rule set to use with this configuration.
     * <p>
     * You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRuleSetName() {
        return software.amazon.jsii.Kernel.get(this, "ruleSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique identifier for the matchmaking rule set to use with this configuration.
     * <p>
     * You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRuleSetName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ruleSetName", java.util.Objects.requireNonNull(value, "ruleSetName is required"));
    }

    /**
     * The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAcceptanceTimeoutSeconds() {
        return software.amazon.jsii.Kernel.get(this, "acceptanceTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAcceptanceTimeoutSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "acceptanceTimeoutSeconds", value);
    }

    /**
     * The number of player slots in a match to keep open for future players.
     * <p>
     * For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getAdditionalPlayerCount() {
        return software.amazon.jsii.Kernel.get(this, "additionalPlayerCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of player slots in a match to keep open for future players.
     * <p>
     * For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdditionalPlayerCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "additionalPlayerCount", value);
    }

    /**
     * The method used to backfill game sessions that are created with this matchmaking configuration.
     * <p>
     * Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature. Specify <code>AUTOMATIC</code> to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a> . Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getBackfillMode() {
        return software.amazon.jsii.Kernel.get(this, "backfillMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The method used to backfill game sessions that are created with this matchmaking configuration.
     * <p>
     * Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature. Specify <code>AUTOMATIC</code> to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a> . Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackfillMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backfillMode", value);
    }

    /**
     * Information to add to all events related to the matchmaking configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomEventData() {
        return software.amazon.jsii.Kernel.get(this, "customEventData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Information to add to all events related to the matchmaking configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomEventData(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customEventData", value);
    }

    /**
     * A descriptive label that is associated with matchmaking configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A descriptive label that is associated with matchmaking configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
     * <p>
     * <ul>
     * <li><em>STANDALONE</em> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">MatchmakingSucceeded</a> event.</li>
     * <li><em>WITH_QUEUE</em> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFlexMatchMode() {
        return software.amazon.jsii.Kernel.get(this, "flexMatchMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
     * <p>
     * <ul>
     * <li><em>STANDALONE</em> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">MatchmakingSucceeded</a> event.</li>
     * <li><em>WITH_QUEUE</em> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlexMatchMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "flexMatchMode", value);
    }

    /**
     * A set of custom properties for a game session, formatted as key-value pairs.
     * <p>
     * These properties are passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getGameProperties() {
        return software.amazon.jsii.Kernel.get(this, "gameProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A set of custom properties for a game session, formatted as key-value pairs.
     * <p>
     * These properties are passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameProperties(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "gameProperties", value);
    }

    /**
     * A set of custom properties for a game session, formatted as key-value pairs.
     * <p>
     * These properties are passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameProperties(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "gameProperties", value);
    }

    /**
     * A set of custom game session properties, formatted as a single string value.
     * <p>
     * This data is passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGameSessionData() {
        return software.amazon.jsii.Kernel.get(this, "gameSessionData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A set of custom game session properties, formatted as a single string value.
     * <p>
     * This data is passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameSessionData(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "gameSessionData", value);
    }

    /**
     * The Amazon Resource Name ( [ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html) ) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::gamesessionqueue/<queue name>` . Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If `FlexMatchMode` is set to `STANDALONE` , do not set this parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getGameSessionQueueArns() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "gameSessionQueueArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The Amazon Resource Name ( [ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html) ) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::gamesessionqueue/<queue name>` . Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If `FlexMatchMode` is set to `STANDALONE` , do not set this parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGameSessionQueueArns(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "gameSessionQueueArns", value);
    }

    /**
     * An SNS topic ARN that is set up to receive matchmaking notifications.
     * <p>
     * See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html">Setting up notifications for matchmaking</a> for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNotificationTarget() {
        return software.amazon.jsii.Kernel.get(this, "notificationTarget", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An SNS topic ARN that is set up to receive matchmaking notifications.
     * <p>
     * See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html">Setting up notifications for matchmaking</a> for more information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationTarget(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "notificationTarget", value);
    }
    /**
     * Set of key-value pairs that contain information about a game session.
     * <p>
     * When included in a game session request, these properties communicate details to be used when setting up the new game session. For example, a game property might specify a game mode, level, or map. Game properties are passed to the game server process when initiating a new game session. For more information, see the <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-create">GameLift Developer Guide</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.gamelift.*;
     * GamePropertyProperty gamePropertyProperty = GamePropertyProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_gamelift.CfnMatchmakingConfiguration.GamePropertyProperty")
    @software.amazon.jsii.Jsii.Proxy(GamePropertyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GamePropertyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The game property identifier.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The game property value.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link GamePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GamePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GamePropertyProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link GamePropertyProperty#getKey}
             * @param key The game property identifier. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link GamePropertyProperty#getValue}
             * @param value The game property value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GamePropertyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GamePropertyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GamePropertyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GamePropertyProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_gamelift.CfnMatchmakingConfiguration.GamePropertyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GamePropertyProperty.Jsii$Proxy that = (GamePropertyProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.gamelift.CfnMatchmakingConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.gamelift.CfnMatchmakingConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.gamelift.CfnMatchmakingConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.gamelift.CfnMatchmakingConfigurationProps.Builder();
        }

        /**
         * A flag that determines whether a match that was created with this configuration must be accepted by the matched players.
         * <p>
         * To require acceptance, set to <code>TRUE</code> . With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.
         * <p>
         * @return {@code this}
         * @param acceptanceRequired A flag that determines whether a match that was created with this configuration must be accepted by the matched players. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceRequired(final java.lang.Boolean acceptanceRequired) {
            this.props.acceptanceRequired(acceptanceRequired);
            return this;
        }
        /**
         * A flag that determines whether a match that was created with this configuration must be accepted by the matched players.
         * <p>
         * To require acceptance, set to <code>TRUE</code> . With this option enabled, matchmaking tickets use the status <code>REQUIRES_ACCEPTANCE</code> to indicate when a completed potential match is waiting for player acceptance.
         * <p>
         * @return {@code this}
         * @param acceptanceRequired A flag that determines whether a match that was created with this configuration must be accepted by the matched players. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceRequired(final software.amazon.awscdk.IResolvable acceptanceRequired) {
            this.props.acceptanceRequired(acceptanceRequired);
            return this;
        }

        /**
         * A unique identifier for the matchmaking configuration.
         * <p>
         * This name is used to identify the configuration associated with a matchmaking request or ticket.
         * <p>
         * @return {@code this}
         * @param name A unique identifier for the matchmaking configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out.
         * <p>
         * Requests that fail due to timing out can be resubmitted as needed.
         * <p>
         * @return {@code this}
         * @param requestTimeoutSeconds The maximum duration, in seconds, that a matchmaking ticket can remain in process before timing out. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTimeoutSeconds(final java.lang.Number requestTimeoutSeconds) {
            this.props.requestTimeoutSeconds(requestTimeoutSeconds);
            return this;
        }

        /**
         * A unique identifier for the matchmaking rule set to use with this configuration.
         * <p>
         * You can use either the rule set name or ARN value. A matchmaking configuration can only use rule sets that are defined in the same Region.
         * <p>
         * @return {@code this}
         * @param ruleSetName A unique identifier for the matchmaking rule set to use with this configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ruleSetName(final java.lang.String ruleSetName) {
            this.props.ruleSetName(ruleSetName);
            return this;
        }

        /**
         * The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required.
         * <p>
         * @return {@code this}
         * @param acceptanceTimeoutSeconds The length of time (in seconds) to wait for players to accept a proposed match, if acceptance is required. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder acceptanceTimeoutSeconds(final java.lang.Number acceptanceTimeoutSeconds) {
            this.props.acceptanceTimeoutSeconds(acceptanceTimeoutSeconds);
            return this;
        }

        /**
         * The number of player slots in a match to keep open for future players.
         * <p>
         * For example, if the configuration's rule set specifies a match for a single 12-person team, and the additional player count is set to 2, only 10 players are selected for the match. This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * <p>
         * @return {@code this}
         * @param additionalPlayerCount The number of player slots in a match to keep open for future players. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalPlayerCount(final java.lang.Number additionalPlayerCount) {
            this.props.additionalPlayerCount(additionalPlayerCount);
            return this;
        }

        /**
         * The method used to backfill game sessions that are created with this matchmaking configuration.
         * <p>
         * Specify <code>MANUAL</code> when your game manages backfill requests manually or does not use the match backfill feature. Specify <code>AUTOMATIC</code> to have GameLift create a <code>StartMatchBackfill</code> request whenever a game session has one or more open slots. Learn more about manual and automatic backfill in <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-backfill.html">Backfill Existing Games with FlexMatch</a> . Automatic backfill is not available when <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * <p>
         * @return {@code this}
         * @param backfillMode The method used to backfill game sessions that are created with this matchmaking configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backfillMode(final java.lang.String backfillMode) {
            this.props.backfillMode(backfillMode);
            return this;
        }

        /**
         * Information to add to all events related to the matchmaking configuration.
         * <p>
         * @return {@code this}
         * @param customEventData Information to add to all events related to the matchmaking configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customEventData(final java.lang.String customEventData) {
            this.props.customEventData(customEventData);
            return this;
        }

        /**
         * A descriptive label that is associated with matchmaking configuration.
         * <p>
         * @return {@code this}
         * @param description A descriptive label that is associated with matchmaking configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution.
         * <p>
         * <ul>
         * <li><em>STANDALONE</em> - FlexMatch forms matches and returns match information, including players and team assignments, in a <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-events.html#match-events-matchmakingsucceeded">MatchmakingSucceeded</a> event.</li>
         * <li><em>WITH_QUEUE</em> - FlexMatch forms matches and uses the specified GameLift queue to start a game session for the match.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @param flexMatchMode Indicates whether this matchmaking configuration is being used with GameLift hosting or as a standalone matchmaking solution. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexMatchMode(final java.lang.String flexMatchMode) {
            this.props.flexMatchMode(flexMatchMode);
            return this;
        }

        /**
         * A set of custom properties for a game session, formatted as key-value pairs.
         * <p>
         * These properties are passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * <p>
         * @return {@code this}
         * @param gameProperties A set of custom properties for a game session, formatted as key-value pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameProperties(final software.amazon.awscdk.IResolvable gameProperties) {
            this.props.gameProperties(gameProperties);
            return this;
        }
        /**
         * A set of custom properties for a game session, formatted as key-value pairs.
         * <p>
         * These properties are passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * <p>
         * @return {@code this}
         * @param gameProperties A set of custom properties for a game session, formatted as key-value pairs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameProperties(final java.util.List<? extends java.lang.Object> gameProperties) {
            this.props.gameProperties(gameProperties);
            return this;
        }

        /**
         * A set of custom game session properties, formatted as a single string value.
         * <p>
         * This data is passed to a game server process with a request to start a new game session. See <a href="https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession">Start a Game Session</a> . This parameter is not used if <code>FlexMatchMode</code> is set to <code>STANDALONE</code> .
         * <p>
         * @return {@code this}
         * @param gameSessionData A set of custom game session properties, formatted as a single string value. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionData(final java.lang.String gameSessionData) {
            this.props.gameSessionData(gameSessionData);
            return this;
        }

        /**
         * The Amazon Resource Name ( [ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html) ) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::gamesessionqueue/<queue name>` . Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If `FlexMatchMode` is set to `STANDALONE` , do not set this parameter.
         * <p>
         * @return {@code this}
         * @param gameSessionQueueArns The Amazon Resource Name ( [ARN](https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html) ) that is assigned to a GameLift game session queue resource and uniquely identifies it. ARNs are unique across all Regions. Format is `arn:aws:gamelift:<region>::gamesessionqueue/<queue name>` . Queues can be located in any Region. Queues are used to start new GameLift-hosted game sessions for matches that are created with this matchmaking configuration. If `FlexMatchMode` is set to `STANDALONE` , do not set this parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gameSessionQueueArns(final java.util.List<java.lang.String> gameSessionQueueArns) {
            this.props.gameSessionQueueArns(gameSessionQueueArns);
            return this;
        }

        /**
         * An SNS topic ARN that is set up to receive matchmaking notifications.
         * <p>
         * See <a href="https://docs.aws.amazon.com/gamelift/latest/flexmatchguide/match-notification.html">Setting up notifications for matchmaking</a> for more information.
         * <p>
         * @return {@code this}
         * @param notificationTarget An SNS topic ARN that is set up to receive matchmaking notifications. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTarget(final java.lang.String notificationTarget) {
            this.props.notificationTarget(notificationTarget);
            return this;
        }

        /**
         * A list of labels to assign to the new matchmaking configuration resource.
         * <p>
         * Tags are developer-defined key-value pairs. Tagging AWS resources are useful for resource management, access management and cost allocation. For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging AWS Resources</a> in the <em>AWS General Reference</em> . Once the resource is created, you can use TagResource, UntagResource, and ListTagsForResource to add, remove, and view tags. The maximum tag limit may be lower than stated. See the AWS General Reference for actual tagging limits.
         * <p>
         * @return {@code this}
         * @param tags A list of labels to assign to the new matchmaking configuration resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.gamelift.CfnMatchmakingConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.gamelift.CfnMatchmakingConfiguration build() {
            return new software.amazon.awscdk.services.gamelift.CfnMatchmakingConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
