package software.amazon.awscdk.services.glue;

/**
 * A CloudFormation `AWS::Glue::Connection`.
 * <p>
 * The <code>AWS::Glue::Connection</code> resource specifies an AWS Glue connection to a data source. For more information, see <a href="https://docs.aws.amazon.com/glue/latest/dg/populate-add-connection.html">Adding a Connection to Your Data Store</a> and <a href="https://docs.aws.amazon.com/glue/latest/dg/aws-glue-api-catalog-connections.html#aws-glue-api-catalog-connections-Connection">Connection Structure</a> in the <em>AWS Glue Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.glue.*;
 * Object connectionProperties;
 * CfnConnection cfnConnection = CfnConnection.Builder.create(this, "MyCfnConnection")
 *         .catalogId("catalogId")
 *         .connectionInput(ConnectionInputProperty.builder()
 *                 .connectionType("connectionType")
 *                 // the properties below are optional
 *                 .connectionProperties(connectionProperties)
 *                 .description("description")
 *                 .matchCriteria(List.of("matchCriteria"))
 *                 .name("name")
 *                 .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
 *                         .availabilityZone("availabilityZone")
 *                         .securityGroupIdList(List.of("securityGroupIdList"))
 *                         .subnetId("subnetId")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.540Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection")
public class CfnConnection extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnConnection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnConnection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.glue.CfnConnection.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Glue::Connection`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnConnection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnConnectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The ID of the data catalog to create the catalog object in.
     * <p>
     * Currently, this should be the AWS account ID.
     * <p>
     * <blockquote>
     * <p>
     * To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCatalogId() {
        return software.amazon.jsii.Kernel.get(this, "catalogId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the data catalog to create the catalog object in.
     * <p>
     * Currently, this should be the AWS account ID.
     * <p>
     * <blockquote>
     * <p>
     * To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code> .
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCatalogId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "catalogId", java.util.Objects.requireNonNull(value, "catalogId is required"));
    }

    /**
     * The connection that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getConnectionInput() {
        return software.amazon.jsii.Kernel.get(this, "connectionInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The connection that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.glue.CfnConnection.ConnectionInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "connectionInput", java.util.Objects.requireNonNull(value, "connectionInput is required"));
    }

    /**
     * The connection that you want to create.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConnectionInput(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "connectionInput", java.util.Objects.requireNonNull(value, "connectionInput is required"));
    }
    /**
     * A structure that is used to specify a connection to create or update.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * Object connectionProperties;
     * ConnectionInputProperty connectionInputProperty = ConnectionInputProperty.builder()
     *         .connectionType("connectionType")
     *         // the properties below are optional
     *         .connectionProperties(connectionProperties)
     *         .description("description")
     *         .matchCriteria(List.of("matchCriteria"))
     *         .name("name")
     *         .physicalConnectionRequirements(PhysicalConnectionRequirementsProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .securityGroupIdList(List.of("securityGroupIdList"))
     *                 .subnetId("subnetId")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.ConnectionInputProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectionInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectionInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the connection. Currently, these types are supported:.
         * <p>
         * <ul>
         * <li><code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).</li>
         * <li><code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.</li>
         * <li><code>MONGODB</code> - Designates a connection to a MongoDB document database.</li>
         * <li><code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).</li>
         * </ul>
         * <p>
         * SFTP is not supported.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectionType();

        /**
         * These key-value pairs define parameters for the connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectionProperties() {
            return null;
        }

        /**
         * The description of the connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * A list of criteria that can be used in selecting this connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMatchCriteria() {
            return null;
        }

        /**
         * The name of the connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * A map of physical connection requirements, such as virtual private cloud (VPC) and `SecurityGroup` , that are needed to successfully make this connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhysicalConnectionRequirements() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectionInputProperty> {
            java.lang.String connectionType;
            java.lang.Object connectionProperties;
            java.lang.String description;
            java.util.List<java.lang.String> matchCriteria;
            java.lang.String name;
            java.lang.Object physicalConnectionRequirements;

            /**
             * Sets the value of {@link ConnectionInputProperty#getConnectionType}
             * @param connectionType The type of the connection. Currently, these types are supported:. This parameter is required.
             *                       <ul>
             *                       <li><code>JDBC</code> - Designates a connection to a database through Java Database Connectivity (JDBC).</li>
             *                       <li><code>KAFKA</code> - Designates a connection to an Apache Kafka streaming platform.</li>
             *                       <li><code>MONGODB</code> - Designates a connection to a MongoDB document database.</li>
             *                       <li><code>NETWORK</code> - Designates a network connection to a data source within an Amazon Virtual Private Cloud environment (Amazon VPC).</li>
             *                       </ul>
             *                       <p>
             *                       SFTP is not supported.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionType(java.lang.String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getConnectionProperties}
             * @param connectionProperties These key-value pairs define parameters for the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionProperties(java.lang.Object connectionProperties) {
                this.connectionProperties = connectionProperties;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getDescription}
             * @param description The description of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getMatchCriteria}
             * @param matchCriteria A list of criteria that can be used in selecting this connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder matchCriteria(java.util.List<java.lang.String> matchCriteria) {
                this.matchCriteria = matchCriteria;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getName}
             * @param name The name of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getPhysicalConnectionRequirements}
             * @param physicalConnectionRequirements A map of physical connection requirements, such as virtual private cloud (VPC) and `SecurityGroup` , that are needed to successfully make this connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalConnectionRequirements(software.amazon.awscdk.services.glue.CfnConnection.PhysicalConnectionRequirementsProperty physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            /**
             * Sets the value of {@link ConnectionInputProperty#getPhysicalConnectionRequirements}
             * @param physicalConnectionRequirements A map of physical connection requirements, such as virtual private cloud (VPC) and `SecurityGroup` , that are needed to successfully make this connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder physicalConnectionRequirements(software.amazon.awscdk.IResolvable physicalConnectionRequirements) {
                this.physicalConnectionRequirements = physicalConnectionRequirements;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectionInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectionInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectionInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectionInputProperty {
            private final java.lang.String connectionType;
            private final java.lang.Object connectionProperties;
            private final java.lang.String description;
            private final java.util.List<java.lang.String> matchCriteria;
            private final java.lang.String name;
            private final java.lang.Object physicalConnectionRequirements;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectionType = software.amazon.jsii.Kernel.get(this, "connectionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionProperties = software.amazon.jsii.Kernel.get(this, "connectionProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.matchCriteria = software.amazon.jsii.Kernel.get(this, "matchCriteria", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.physicalConnectionRequirements = software.amazon.jsii.Kernel.get(this, "physicalConnectionRequirements", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectionType = java.util.Objects.requireNonNull(builder.connectionType, "connectionType is required");
                this.connectionProperties = builder.connectionProperties;
                this.description = builder.description;
                this.matchCriteria = builder.matchCriteria;
                this.name = builder.name;
                this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
            }

            @Override
            public final java.lang.String getConnectionType() {
                return this.connectionType;
            }

            @Override
            public final java.lang.Object getConnectionProperties() {
                return this.connectionProperties;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.util.List<java.lang.String> getMatchCriteria() {
                return this.matchCriteria;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getPhysicalConnectionRequirements() {
                return this.physicalConnectionRequirements;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectionType", om.valueToTree(this.getConnectionType()));
                if (this.getConnectionProperties() != null) {
                    data.set("connectionProperties", om.valueToTree(this.getConnectionProperties()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getMatchCriteria() != null) {
                    data.set("matchCriteria", om.valueToTree(this.getMatchCriteria()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getPhysicalConnectionRequirements() != null) {
                    data.set("physicalConnectionRequirements", om.valueToTree(this.getPhysicalConnectionRequirements()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.ConnectionInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectionInputProperty.Jsii$Proxy that = (ConnectionInputProperty.Jsii$Proxy) o;

                if (!connectionType.equals(that.connectionType)) return false;
                if (this.connectionProperties != null ? !this.connectionProperties.equals(that.connectionProperties) : that.connectionProperties != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.matchCriteria != null ? !this.matchCriteria.equals(that.matchCriteria) : that.matchCriteria != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                return this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.equals(that.physicalConnectionRequirements) : that.physicalConnectionRequirements == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectionType.hashCode();
                result = 31 * result + (this.connectionProperties != null ? this.connectionProperties.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.matchCriteria != null ? this.matchCriteria.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the physical requirements for a connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.glue.*;
     * PhysicalConnectionRequirementsProperty physicalConnectionRequirementsProperty = PhysicalConnectionRequirementsProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .securityGroupIdList(List.of("securityGroupIdList"))
     *         .subnetId("subnetId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_glue.CfnConnection.PhysicalConnectionRequirementsProperty")
    @software.amazon.jsii.Jsii.Proxy(PhysicalConnectionRequirementsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PhysicalConnectionRequirementsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The connection's Availability Zone.
         * <p>
         * This field is redundant because the specified subnet implies the Availability Zone to be used. Currently the field must be populated, but it will be deprecated in the future.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The security group ID list used by the connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIdList() {
            return null;
        }

        /**
         * The subnet ID used by the connection.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PhysicalConnectionRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PhysicalConnectionRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PhysicalConnectionRequirementsProperty> {
            java.lang.String availabilityZone;
            java.util.List<java.lang.String> securityGroupIdList;
            java.lang.String subnetId;

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getAvailabilityZone}
             * @param availabilityZone The connection's Availability Zone.
             *                         This field is redundant because the specified subnet implies the Availability Zone to be used. Currently the field must be populated, but it will be deprecated in the future.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getSecurityGroupIdList}
             * @param securityGroupIdList The security group ID list used by the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIdList(java.util.List<java.lang.String> securityGroupIdList) {
                this.securityGroupIdList = securityGroupIdList;
                return this;
            }

            /**
             * Sets the value of {@link PhysicalConnectionRequirementsProperty#getSubnetId}
             * @param subnetId The subnet ID used by the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PhysicalConnectionRequirementsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PhysicalConnectionRequirementsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PhysicalConnectionRequirementsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PhysicalConnectionRequirementsProperty {
            private final java.lang.String availabilityZone;
            private final java.util.List<java.lang.String> securityGroupIdList;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroupIdList = software.amazon.jsii.Kernel.get(this, "securityGroupIdList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.securityGroupIdList = builder.securityGroupIdList;
                this.subnetId = builder.subnetId;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIdList() {
                return this.securityGroupIdList;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getSecurityGroupIdList() != null) {
                    data.set("securityGroupIdList", om.valueToTree(this.getSecurityGroupIdList()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_glue.CfnConnection.PhysicalConnectionRequirementsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PhysicalConnectionRequirementsProperty.Jsii$Proxy that = (PhysicalConnectionRequirementsProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.securityGroupIdList != null ? !this.securityGroupIdList.equals(that.securityGroupIdList) : that.securityGroupIdList != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.securityGroupIdList != null ? this.securityGroupIdList.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.glue.CfnConnection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.glue.CfnConnection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.glue.CfnConnectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.glue.CfnConnectionProps.Builder();
        }

        /**
         * The ID of the data catalog to create the catalog object in.
         * <p>
         * Currently, this should be the AWS account ID.
         * <p>
         * <blockquote>
         * <p>
         * To specify the account ID, you can use the <code>Ref</code> intrinsic function with the <code>AWS::AccountId</code> pseudo parameter. For example: <code>!Ref AWS::AccountId</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param catalogId The ID of the data catalog to create the catalog object in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder catalogId(final java.lang.String catalogId) {
            this.props.catalogId(catalogId);
            return this;
        }

        /**
         * The connection that you want to create.
         * <p>
         * @return {@code this}
         * @param connectionInput The connection that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionInput(final software.amazon.awscdk.services.glue.CfnConnection.ConnectionInputProperty connectionInput) {
            this.props.connectionInput(connectionInput);
            return this;
        }
        /**
         * The connection that you want to create.
         * <p>
         * @return {@code this}
         * @param connectionInput The connection that you want to create. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionInput(final software.amazon.awscdk.IResolvable connectionInput) {
            this.props.connectionInput(connectionInput);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.glue.CfnConnection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.glue.CfnConnection build() {
            return new software.amazon.awscdk.services.glue.CfnConnection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
