package software.amazon.awscdk.services.greengrass;

/**
 * Properties for defining a `CfnCoreDefinitionVersion`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrass.*;
 * CfnCoreDefinitionVersionProps cfnCoreDefinitionVersionProps = CfnCoreDefinitionVersionProps.builder()
 *         .coreDefinitionId("coreDefinitionId")
 *         .cores(List.of(CoreProperty.builder()
 *                 .certificateArn("certificateArn")
 *                 .id("id")
 *                 .thingArn("thingArn")
 *                 // the properties below are optional
 *                 .syncShadow(false)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.612Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrass.CfnCoreDefinitionVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnCoreDefinitionVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCoreDefinitionVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the core definition associated with this version.
     * <p>
     * This value is a GUID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCoreDefinitionId();

    /**
     * The Greengrass core in this version.
     * <p>
     * Currently, the <code>Cores</code> property for a core definition version can contain only one core.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCores();

    /**
     * @return a {@link Builder} of {@link CfnCoreDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCoreDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCoreDefinitionVersionProps> {
        java.lang.String coreDefinitionId;
        java.lang.Object cores;

        /**
         * Sets the value of {@link CfnCoreDefinitionVersionProps#getCoreDefinitionId}
         * @param coreDefinitionId The ID of the core definition associated with this version. This parameter is required.
         *                         This value is a GUID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder coreDefinitionId(java.lang.String coreDefinitionId) {
            this.coreDefinitionId = coreDefinitionId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCoreDefinitionVersionProps#getCores}
         * @param cores The Greengrass core in this version. This parameter is required.
         *              Currently, the <code>Cores</code> property for a core definition version can contain only one core.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cores(software.amazon.awscdk.IResolvable cores) {
            this.cores = cores;
            return this;
        }

        /**
         * Sets the value of {@link CfnCoreDefinitionVersionProps#getCores}
         * @param cores The Greengrass core in this version. This parameter is required.
         *              Currently, the <code>Cores</code> property for a core definition version can contain only one core.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cores(java.util.List<? extends java.lang.Object> cores) {
            this.cores = cores;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCoreDefinitionVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCoreDefinitionVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCoreDefinitionVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCoreDefinitionVersionProps {
        private final java.lang.String coreDefinitionId;
        private final java.lang.Object cores;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.coreDefinitionId = software.amazon.jsii.Kernel.get(this, "coreDefinitionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cores = software.amazon.jsii.Kernel.get(this, "cores", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.coreDefinitionId = java.util.Objects.requireNonNull(builder.coreDefinitionId, "coreDefinitionId is required");
            this.cores = java.util.Objects.requireNonNull(builder.cores, "cores is required");
        }

        @Override
        public final java.lang.String getCoreDefinitionId() {
            return this.coreDefinitionId;
        }

        @Override
        public final java.lang.Object getCores() {
            return this.cores;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("coreDefinitionId", om.valueToTree(this.getCoreDefinitionId()));
            data.set("cores", om.valueToTree(this.getCores()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrass.CfnCoreDefinitionVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCoreDefinitionVersionProps.Jsii$Proxy that = (CfnCoreDefinitionVersionProps.Jsii$Proxy) o;

            if (!coreDefinitionId.equals(that.coreDefinitionId)) return false;
            return this.cores.equals(that.cores);
        }

        @Override
        public final int hashCode() {
            int result = this.coreDefinitionId.hashCode();
            result = 31 * result + (this.cores.hashCode());
            return result;
        }
    }
}
