package software.amazon.awscdk.services.iam;

/**
 * The Effect element of an IAM policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Resource books;
 * User iamUser;
 * Method getBooks = books.addMethod("GET", new HttpIntegration("http://amazon.com"), MethodOptions.builder()
 *         .authorizationType(AuthorizationType.IAM)
 *         .build());
 * iamUser.attachInlinePolicy(Policy.Builder.create(this, "AllowBooks")
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("execute-api:Invoke"))
 *                     .effect(Effect.ALLOW)
 *                     .resources(List.of(getBooks.getMethodArn()))
 *                     .build()))
 *         .build());
 * </pre></blockquote>
 * <p>
 * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_effect.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.762Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.Effect")
public enum Effect {
    /**
     * Allows access to a resource in an IAM policy statement.
     * <p>
     * By default, access to resources are denied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALLOW,
    /**
     * Explicitly deny access to a resource.
     * <p>
     * By default, all requests are denied implicitly.
     * <p>
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DENY,
}
