package software.amazon.awscdk.services.iot;

/**
 * A CloudFormation `AWS::IoT::ProvisioningTemplate`.
 * <p>
 * Creates a fleet provisioning template.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnProvisioningTemplate cfnProvisioningTemplate = CfnProvisioningTemplate.Builder.create(this, "MyCfnProvisioningTemplate")
 *         .provisioningRoleArn("provisioningRoleArn")
 *         .templateBody("templateBody")
 *         // the properties below are optional
 *         .description("description")
 *         .enabled(false)
 *         .preProvisioningHook(ProvisioningHookProperty.builder()
 *                 .payloadVersion("payloadVersion")
 *                 .targetArn("targetArn")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .templateName("templateName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.864Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnProvisioningTemplate")
public class CfnProvisioningTemplate extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnProvisioningTemplate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnProvisioningTemplate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iot.CfnProvisioningTemplate.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::IoT::ProvisioningTemplate`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnProvisioningTemplate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iot.CfnProvisioningTemplateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN that identifies the provisioning template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrTemplateArn() {
        return software.amazon.jsii.Kernel.get(this, "attrTemplateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Metadata that can be used to manage the fleet provisioning template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The role ARN for the role associated with the fleet provisioning template.
     * <p>
     * This IoT role grants permission to provision a device.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProvisioningRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "provisioningRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The role ARN for the role associated with the fleet provisioning template.
     * <p>
     * This IoT role grants permission to provision a device.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setProvisioningRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "provisioningRoleArn", java.util.Objects.requireNonNull(value, "provisioningRoleArn is required"));
    }

    /**
     * The JSON formatted contents of the fleet provisioning template version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTemplateBody() {
        return software.amazon.jsii.Kernel.get(this, "templateBody", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The JSON formatted contents of the fleet provisioning template version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateBody(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateBody", java.util.Objects.requireNonNull(value, "templateBody is required"));
    }

    /**
     * The description of the fleet provisioning template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the fleet provisioning template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * True to enable the fleet provisioning template, otherwise false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * True to enable the fleet provisioning template, otherwise false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * True to enable the fleet provisioning template, otherwise false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enabled", value);
    }

    /**
     * Creates a pre-provisioning hook template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPreProvisioningHook() {
        return software.amazon.jsii.Kernel.get(this, "preProvisioningHook", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Creates a pre-provisioning hook template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreProvisioningHook(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iot.CfnProvisioningTemplate.ProvisioningHookProperty value) {
        software.amazon.jsii.Kernel.set(this, "preProvisioningHook", value);
    }

    /**
     * Creates a pre-provisioning hook template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPreProvisioningHook(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "preProvisioningHook", value);
    }

    /**
     * The name of the fleet provisioning template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTemplateName() {
        return software.amazon.jsii.Kernel.get(this, "templateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the fleet provisioning template.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTemplateName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "templateName", value);
    }
    /**
     * Structure that contains payloadVersion and targetArn.
     * <p>
     * Provisioning hooks can be used when fleet provisioning to validate device parameters before allowing the device to be provisioned.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iot.*;
     * ProvisioningHookProperty provisioningHookProperty = ProvisioningHookProperty.builder()
     *         .payloadVersion("payloadVersion")
     *         .targetArn("targetArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnProvisioningTemplate.ProvisioningHookProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisioningHookProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisioningHookProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The payload that was sent to the target function.
         * <p>
         * The valid payload is <code>"2020-04-01"</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayloadVersion() {
            return null;
        }

        /**
         * The ARN of the target function.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProvisioningHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisioningHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisioningHookProperty> {
            java.lang.String payloadVersion;
            java.lang.String targetArn;

            /**
             * Sets the value of {@link ProvisioningHookProperty#getPayloadVersion}
             * @param payloadVersion The payload that was sent to the target function.
             *                       The valid payload is <code>"2020-04-01"</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payloadVersion(java.lang.String payloadVersion) {
                this.payloadVersion = payloadVersion;
                return this;
            }

            /**
             * Sets the value of {@link ProvisioningHookProperty#getTargetArn}
             * @param targetArn The ARN of the target function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetArn(java.lang.String targetArn) {
                this.targetArn = targetArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisioningHookProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisioningHookProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisioningHookProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisioningHookProperty {
            private final java.lang.String payloadVersion;
            private final java.lang.String targetArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.payloadVersion = software.amazon.jsii.Kernel.get(this, "payloadVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.payloadVersion = builder.payloadVersion;
                this.targetArn = builder.targetArn;
            }

            @Override
            public final java.lang.String getPayloadVersion() {
                return this.payloadVersion;
            }

            @Override
            public final java.lang.String getTargetArn() {
                return this.targetArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPayloadVersion() != null) {
                    data.set("payloadVersion", om.valueToTree(this.getPayloadVersion()));
                }
                if (this.getTargetArn() != null) {
                    data.set("targetArn", om.valueToTree(this.getTargetArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnProvisioningTemplate.ProvisioningHookProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisioningHookProperty.Jsii$Proxy that = (ProvisioningHookProperty.Jsii$Proxy) o;

                if (this.payloadVersion != null ? !this.payloadVersion.equals(that.payloadVersion) : that.payloadVersion != null) return false;
                return this.targetArn != null ? this.targetArn.equals(that.targetArn) : that.targetArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.payloadVersion != null ? this.payloadVersion.hashCode() : 0;
                result = 31 * result + (this.targetArn != null ? this.targetArn.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iot.CfnProvisioningTemplate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iot.CfnProvisioningTemplate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iot.CfnProvisioningTemplateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iot.CfnProvisioningTemplateProps.Builder();
        }

        /**
         * The role ARN for the role associated with the fleet provisioning template.
         * <p>
         * This IoT role grants permission to provision a device.
         * <p>
         * @return {@code this}
         * @param provisioningRoleArn The role ARN for the role associated with the fleet provisioning template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provisioningRoleArn(final java.lang.String provisioningRoleArn) {
            this.props.provisioningRoleArn(provisioningRoleArn);
            return this;
        }

        /**
         * The JSON formatted contents of the fleet provisioning template version.
         * <p>
         * @return {@code this}
         * @param templateBody The JSON formatted contents of the fleet provisioning template version. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateBody(final java.lang.String templateBody) {
            this.props.templateBody(templateBody);
            return this;
        }

        /**
         * The description of the fleet provisioning template.
         * <p>
         * @return {@code this}
         * @param description The description of the fleet provisioning template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * True to enable the fleet provisioning template, otherwise false.
         * <p>
         * @return {@code this}
         * @param enabled True to enable the fleet provisioning template, otherwise false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }
        /**
         * True to enable the fleet provisioning template, otherwise false.
         * <p>
         * @return {@code this}
         * @param enabled True to enable the fleet provisioning template, otherwise false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final software.amazon.awscdk.IResolvable enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * Creates a pre-provisioning hook template.
         * <p>
         * @return {@code this}
         * @param preProvisioningHook Creates a pre-provisioning hook template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preProvisioningHook(final software.amazon.awscdk.services.iot.CfnProvisioningTemplate.ProvisioningHookProperty preProvisioningHook) {
            this.props.preProvisioningHook(preProvisioningHook);
            return this;
        }
        /**
         * Creates a pre-provisioning hook template.
         * <p>
         * @return {@code this}
         * @param preProvisioningHook Creates a pre-provisioning hook template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder preProvisioningHook(final software.amazon.awscdk.IResolvable preProvisioningHook) {
            this.props.preProvisioningHook(preProvisioningHook);
            return this;
        }

        /**
         * Metadata that can be used to manage the fleet provisioning template.
         * <p>
         * @return {@code this}
         * @param tags Metadata that can be used to manage the fleet provisioning template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The name of the fleet provisioning template.
         * <p>
         * @return {@code this}
         * @param templateName The name of the fleet provisioning template. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder templateName(final java.lang.String templateName) {
            this.props.templateName(templateName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.iot.CfnProvisioningTemplate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iot.CfnProvisioningTemplate build() {
            return new software.amazon.awscdk.services.iot.CfnProvisioningTemplate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
