package software.amazon.awscdk.services.iotanalytics;

/**
 * Properties for defining a `CfnChannel`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotanalytics.*;
 * Object serviceManagedS3;
 * CfnChannelProps cfnChannelProps = CfnChannelProps.builder()
 *         .channelName("channelName")
 *         .channelStorage(ChannelStorageProperty.builder()
 *                 .customerManagedS3(CustomerManagedS3Property.builder()
 *                         .bucket("bucket")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .keyPrefix("keyPrefix")
 *                         .build())
 *                 .serviceManagedS3(serviceManagedS3)
 *                 .build())
 *         .retentionPeriod(RetentionPeriodProperty.builder()
 *                 .numberOfDays(123)
 *                 .unlimited(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:43.912Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotanalytics.CfnChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getChannelName() {
        return null;
    }

    /**
     * Where channel data is stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getChannelStorage() {
        return null;
    }

    /**
     * How long, in days, message data is kept for the channel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRetentionPeriod() {
        return null;
    }

    /**
     * Metadata which can be used to manage the channel.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnChannelProps> {
        java.lang.String channelName;
        java.lang.Object channelStorage;
        java.lang.Object retentionPeriod;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnChannelProps#getChannelName}
         * @param channelName The name of the channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelName(java.lang.String channelName) {
            this.channelName = channelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getChannelStorage}
         * @param channelStorage Where channel data is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelStorage(software.amazon.awscdk.services.iotanalytics.CfnChannel.ChannelStorageProperty channelStorage) {
            this.channelStorage = channelStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getChannelStorage}
         * @param channelStorage Where channel data is stored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder channelStorage(software.amazon.awscdk.IResolvable channelStorage) {
            this.channelStorage = channelStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getRetentionPeriod}
         * @param retentionPeriod How long, in days, message data is kept for the channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.services.iotanalytics.CfnChannel.RetentionPeriodProperty retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getRetentionPeriod}
         * @param retentionPeriod How long, in days, message data is kept for the channel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(software.amazon.awscdk.IResolvable retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTags}
         * @param tags Metadata which can be used to manage the channel.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnChannelProps {
        private final java.lang.String channelName;
        private final java.lang.Object channelStorage;
        private final java.lang.Object retentionPeriod;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.channelName = software.amazon.jsii.Kernel.get(this, "channelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.channelStorage = software.amazon.jsii.Kernel.get(this, "channelStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.channelName = builder.channelName;
            this.channelStorage = builder.channelStorage;
            this.retentionPeriod = builder.retentionPeriod;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getChannelName() {
            return this.channelName;
        }

        @Override
        public final java.lang.Object getChannelStorage() {
            return this.channelStorage;
        }

        @Override
        public final java.lang.Object getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getChannelName() != null) {
                data.set("channelName", om.valueToTree(this.getChannelName()));
            }
            if (this.getChannelStorage() != null) {
                data.set("channelStorage", om.valueToTree(this.getChannelStorage()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotanalytics.CfnChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnChannelProps.Jsii$Proxy that = (CfnChannelProps.Jsii$Proxy) o;

            if (this.channelName != null ? !this.channelName.equals(that.channelName) : that.channelName != null) return false;
            if (this.channelStorage != null ? !this.channelStorage.equals(that.channelStorage) : that.channelStorage != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.channelName != null ? this.channelName.hashCode() : 0;
            result = 31 * result + (this.channelStorage != null ? this.channelStorage.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
