package software.amazon.awscdk.services.ivs;

/**
 * Properties for defining a `CfnChannel`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ivs.*;
 * CfnChannelProps cfnChannelProps = CfnChannelProps.builder()
 *         .authorized(false)
 *         .latencyMode("latencyMode")
 *         .name("name")
 *         .recordingConfigurationArn("recordingConfigurationArn")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .type("type")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:44.082Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnChannelProps")
@software.amazon.jsii.Jsii.Proxy(CfnChannelProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnChannelProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Whether the channel is authorized.
     * <p>
     * <em>Default</em> : <code>false</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAuthorized() {
        return null;
    }

    /**
     * Channel latency mode. Valid values:.
     * <p>
     * <ul>
     * <li><code>NORMAL</code> : Use NORMAL to broadcast and deliver live video up to Full HD.</li>
     * <li><code>LOW</code> : Use LOW for near real-time interactions with viewers.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * In the  console, <code>LOW</code> and <code>NORMAL</code> correspond to <code>Ultra-low</code> and <code>Standard</code> , respectively.
     * <p>
     * </blockquote>
     * <p>
     * <em>Default</em> : <code>LOW</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLatencyMode() {
        return null;
    }

    /**
     * Channel name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The ARN of a RecordingConfiguration resource.
     * <p>
     * An empty string indicates that recording is disabled for the channel. A RecordingConfiguration ARN indicates that recording is enabled using the specified recording configuration. See the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html">RecordingConfiguration</a> resource for more information and an example.
     * <p>
     * <em>Default</em> : "" (empty string, recording is disabled)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRecordingConfigurationArn() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The channel type, which determines the allowable resolution and bitrate.
     * <p>
     * <em>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</em> Valid values:
     * <p>
     * <ul>
     * <li><code>STANDARD</code> : Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</li>
     * <li><code>BASIC</code> : delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</li>
     * </ul>
     * <p>
     * <em>Default</em> : <code>STANDARD</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getType() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnChannelProps> {
        java.lang.Object authorized;
        java.lang.String latencyMode;
        java.lang.String name;
        java.lang.String recordingConfigurationArn;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String type;

        /**
         * Sets the value of {@link CfnChannelProps#getAuthorized}
         * @param authorized Whether the channel is authorized.
         *                   <em>Default</em> : <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorized(java.lang.Boolean authorized) {
            this.authorized = authorized;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getAuthorized}
         * @param authorized Whether the channel is authorized.
         *                   <em>Default</em> : <code>false</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorized(software.amazon.awscdk.IResolvable authorized) {
            this.authorized = authorized;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getLatencyMode}
         * @param latencyMode Channel latency mode. Valid values:.
         *                    <ul>
         *                    <li><code>NORMAL</code> : Use NORMAL to broadcast and deliver live video up to Full HD.</li>
         *                    <li><code>LOW</code> : Use LOW for near real-time interactions with viewers.</li>
         *                    </ul>
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    In the  console, <code>LOW</code> and <code>NORMAL</code> correspond to <code>Ultra-low</code> and <code>Standard</code> , respectively.
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    <em>Default</em> : <code>LOW</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder latencyMode(java.lang.String latencyMode) {
            this.latencyMode = latencyMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getName}
         * @param name Channel name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getRecordingConfigurationArn}
         * @param recordingConfigurationArn The ARN of a RecordingConfiguration resource.
         *                                  An empty string indicates that recording is disabled for the channel. A RecordingConfiguration ARN indicates that recording is enabled using the specified recording configuration. See the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html">RecordingConfiguration</a> resource for more information and an example.
         *                                  <p>
         *                                  <em>Default</em> : "" (empty string, recording is disabled)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingConfigurationArn(java.lang.String recordingConfigurationArn) {
            this.recordingConfigurationArn = recordingConfigurationArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnChannelProps#getType}
         * @param type The channel type, which determines the allowable resolution and bitrate.
         *             <em>If you exceed the allowable resolution or bitrate, the stream probably will disconnect immediately.</em> Valid values:
         *             <p>
         *             <ul>
         *             <li><code>STANDARD</code> : Multiple qualities are generated from the original input, to automatically give viewers the best experience for their devices and network conditions. Resolution can be up to 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions 360p and below; above that, audio is passed through.</li>
         *             <li><code>BASIC</code> : delivers the original input to viewers. The viewer’s video-quality choice is limited to the original input. Resolution can be up to 480p and bitrate can be up to 1.5 Mbps.</li>
         *             </ul>
         *             <p>
         *             <em>Default</em> : <code>STANDARD</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnChannelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnChannelProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnChannelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnChannelProps {
        private final java.lang.Object authorized;
        private final java.lang.String latencyMode;
        private final java.lang.String name;
        private final java.lang.String recordingConfigurationArn;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String type;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorized = software.amazon.jsii.Kernel.get(this, "authorized", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.latencyMode = software.amazon.jsii.Kernel.get(this, "latencyMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordingConfigurationArn = software.amazon.jsii.Kernel.get(this, "recordingConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorized = builder.authorized;
            this.latencyMode = builder.latencyMode;
            this.name = builder.name;
            this.recordingConfigurationArn = builder.recordingConfigurationArn;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.type = builder.type;
        }

        @Override
        public final java.lang.Object getAuthorized() {
            return this.authorized;
        }

        @Override
        public final java.lang.String getLatencyMode() {
            return this.latencyMode;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRecordingConfigurationArn() {
            return this.recordingConfigurationArn;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAuthorized() != null) {
                data.set("authorized", om.valueToTree(this.getAuthorized()));
            }
            if (this.getLatencyMode() != null) {
                data.set("latencyMode", om.valueToTree(this.getLatencyMode()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRecordingConfigurationArn() != null) {
                data.set("recordingConfigurationArn", om.valueToTree(this.getRecordingConfigurationArn()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getType() != null) {
                data.set("type", om.valueToTree(this.getType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnChannelProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnChannelProps.Jsii$Proxy that = (CfnChannelProps.Jsii$Proxy) o;

            if (this.authorized != null ? !this.authorized.equals(that.authorized) : that.authorized != null) return false;
            if (this.latencyMode != null ? !this.latencyMode.equals(that.latencyMode) : that.latencyMode != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.recordingConfigurationArn != null ? !this.recordingConfigurationArn.equals(that.recordingConfigurationArn) : that.recordingConfigurationArn != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.type != null ? this.type.equals(that.type) : that.type == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorized != null ? this.authorized.hashCode() : 0;
            result = 31 * result + (this.latencyMode != null ? this.latencyMode.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.recordingConfigurationArn != null ? this.recordingConfigurationArn.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }
}
