package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Properties for defining a `CfnDeliveryStream`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kinesisfirehose.*;
 * CfnDeliveryStreamProps cfnDeliveryStreamProps = CfnDeliveryStreamProps.builder()
 *         .amazonopensearchserviceDestinationConfiguration(AmazonopensearchserviceDestinationConfigurationProperty.builder()
 *                 .indexName("indexName")
 *                 .roleArn("roleArn")
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 // the properties below are optional
 *                 .bufferingHints(AmazonopensearchserviceBufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .clusterEndpoint("clusterEndpoint")
 *                 .domainArn("domainArn")
 *                 .indexRotationPeriod("indexRotationPeriod")
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .retryOptions(AmazonopensearchserviceRetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .typeName("typeName")
 *                 .vpcConfiguration(VpcConfigurationProperty.builder()
 *                         .roleArn("roleArn")
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnetIds(List.of("subnetIds"))
 *                         .build())
 *                 .build())
 *         .deliveryStreamEncryptionConfigurationInput(DeliveryStreamEncryptionConfigurationInputProperty.builder()
 *                 .keyType("keyType")
 *                 // the properties below are optional
 *                 .keyArn("keyArn")
 *                 .build())
 *         .deliveryStreamName("deliveryStreamName")
 *         .deliveryStreamType("deliveryStreamType")
 *         .elasticsearchDestinationConfiguration(ElasticsearchDestinationConfigurationProperty.builder()
 *                 .indexName("indexName")
 *                 .roleArn("roleArn")
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 // the properties below are optional
 *                 .bufferingHints(ElasticsearchBufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .clusterEndpoint("clusterEndpoint")
 *                 .domainArn("domainArn")
 *                 .indexRotationPeriod("indexRotationPeriod")
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .retryOptions(ElasticsearchRetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .typeName("typeName")
 *                 .vpcConfiguration(VpcConfigurationProperty.builder()
 *                         .roleArn("roleArn")
 *                         .securityGroupIds(List.of("securityGroupIds"))
 *                         .subnetIds(List.of("subnetIds"))
 *                         .build())
 *                 .build())
 *         .extendedS3DestinationConfiguration(ExtendedS3DestinationConfigurationProperty.builder()
 *                 .bucketArn("bucketArn")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .bufferingHints(BufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .compressionFormat("compressionFormat")
 *                 .dataFormatConversionConfiguration(DataFormatConversionConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .inputFormatConfiguration(InputFormatConfigurationProperty.builder()
 *                                 .deserializer(DeserializerProperty.builder()
 *                                         .hiveJsonSerDe(HiveJsonSerDeProperty.builder()
 *                                                 .timestampFormats(List.of("timestampFormats"))
 *                                                 .build())
 *                                         .openXJsonSerDe(OpenXJsonSerDeProperty.builder()
 *                                                 .caseInsensitive(false)
 *                                                 .columnToJsonKeyMappings(Map.of(
 *                                                         "columnToJsonKeyMappingsKey", "columnToJsonKeyMappings"))
 *                                                 .convertDotsInJsonKeysToUnderscores(false)
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .outputFormatConfiguration(OutputFormatConfigurationProperty.builder()
 *                                 .serializer(SerializerProperty.builder()
 *                                         .orcSerDe(OrcSerDeProperty.builder()
 *                                                 .blockSizeBytes(123)
 *                                                 .bloomFilterColumns(List.of("bloomFilterColumns"))
 *                                                 .bloomFilterFalsePositiveProbability(123)
 *                                                 .compression("compression")
 *                                                 .dictionaryKeyThreshold(123)
 *                                                 .enablePadding(false)
 *                                                 .formatVersion("formatVersion")
 *                                                 .paddingTolerance(123)
 *                                                 .rowIndexStride(123)
 *                                                 .stripeSizeBytes(123)
 *                                                 .build())
 *                                         .parquetSerDe(ParquetSerDeProperty.builder()
 *                                                 .blockSizeBytes(123)
 *                                                 .compression("compression")
 *                                                 .enableDictionaryCompression(false)
 *                                                 .maxPaddingBytes(123)
 *                                                 .pageSizeBytes(123)
 *                                                 .writerVersion("writerVersion")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .schemaConfiguration(SchemaConfigurationProperty.builder()
 *                                 .catalogId("catalogId")
 *                                 .databaseName("databaseName")
 *                                 .region("region")
 *                                 .roleArn("roleArn")
 *                                 .tableName("tableName")
 *                                 .versionId("versionId")
 *                                 .build())
 *                         .build())
 *                 .dynamicPartitioningConfiguration(DynamicPartitioningConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .retryOptions(RetryOptionsProperty.builder()
 *                                 .durationInSeconds(123)
 *                                 .build())
 *                         .build())
 *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                 .awskmsKeyArn("awskmsKeyArn")
 *                                 .build())
 *                         .noEncryptionConfig("noEncryptionConfig")
 *                         .build())
 *                 .errorOutputPrefix("errorOutputPrefix")
 *                 .prefix("prefix")
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .s3BackupConfiguration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .build())
 *         .httpEndpointDestinationConfiguration(HttpEndpointDestinationConfigurationProperty.builder()
 *                 .endpointConfiguration(HttpEndpointConfigurationProperty.builder()
 *                         .url("url")
 *                         // the properties below are optional
 *                         .accessKey("accessKey")
 *                         .name("name")
 *                         .build())
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 // the properties below are optional
 *                 .bufferingHints(BufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .requestConfiguration(HttpEndpointRequestConfigurationProperty.builder()
 *                         .commonAttributes(List.of(HttpEndpointCommonAttributeProperty.builder()
 *                                 .attributeName("attributeName")
 *                                 .attributeValue("attributeValue")
 *                                 .build()))
 *                         .contentEncoding("contentEncoding")
 *                         .build())
 *                 .retryOptions(RetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .roleArn("roleArn")
 *                 .s3BackupMode("s3BackupMode")
 *                 .build())
 *         .kinesisStreamSourceConfiguration(KinesisStreamSourceConfigurationProperty.builder()
 *                 .kinesisStreamArn("kinesisStreamArn")
 *                 .roleArn("roleArn")
 *                 .build())
 *         .redshiftDestinationConfiguration(RedshiftDestinationConfigurationProperty.builder()
 *                 .clusterJdbcurl("clusterJdbcurl")
 *                 .copyCommand(CopyCommandProperty.builder()
 *                         .dataTableName("dataTableName")
 *                         // the properties below are optional
 *                         .copyOptions("copyOptions")
 *                         .dataTableColumns("dataTableColumns")
 *                         .build())
 *                 .password("password")
 *                 .roleArn("roleArn")
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 .username("username")
 *                 // the properties below are optional
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .retryOptions(RedshiftRetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .s3BackupConfiguration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .build())
 *         .s3DestinationConfiguration(S3DestinationConfigurationProperty.builder()
 *                 .bucketArn("bucketArn")
 *                 .roleArn("roleArn")
 *                 // the properties below are optional
 *                 .bufferingHints(BufferingHintsProperty.builder()
 *                         .intervalInSeconds(123)
 *                         .sizeInMBs(123)
 *                         .build())
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .compressionFormat("compressionFormat")
 *                 .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                         .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                 .awskmsKeyArn("awskmsKeyArn")
 *                                 .build())
 *                         .noEncryptionConfig("noEncryptionConfig")
 *                         .build())
 *                 .errorOutputPrefix("errorOutputPrefix")
 *                 .prefix("prefix")
 *                 .build())
 *         .splunkDestinationConfiguration(SplunkDestinationConfigurationProperty.builder()
 *                 .hecEndpoint("hecEndpoint")
 *                 .hecEndpointType("hecEndpointType")
 *                 .hecToken("hecToken")
 *                 .s3Configuration(S3DestinationConfigurationProperty.builder()
 *                         .bucketArn("bucketArn")
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .bufferingHints(BufferingHintsProperty.builder()
 *                                 .intervalInSeconds(123)
 *                                 .sizeInMBs(123)
 *                                 .build())
 *                         .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                                 .enabled(false)
 *                                 .logGroupName("logGroupName")
 *                                 .logStreamName("logStreamName")
 *                                 .build())
 *                         .compressionFormat("compressionFormat")
 *                         .encryptionConfiguration(EncryptionConfigurationProperty.builder()
 *                                 .kmsEncryptionConfig(KMSEncryptionConfigProperty.builder()
 *                                         .awskmsKeyArn("awskmsKeyArn")
 *                                         .build())
 *                                 .noEncryptionConfig("noEncryptionConfig")
 *                                 .build())
 *                         .errorOutputPrefix("errorOutputPrefix")
 *                         .prefix("prefix")
 *                         .build())
 *                 // the properties below are optional
 *                 .cloudWatchLoggingOptions(CloudWatchLoggingOptionsProperty.builder()
 *                         .enabled(false)
 *                         .logGroupName("logGroupName")
 *                         .logStreamName("logStreamName")
 *                         .build())
 *                 .hecAcknowledgmentTimeoutInSeconds(123)
 *                 .processingConfiguration(ProcessingConfigurationProperty.builder()
 *                         .enabled(false)
 *                         .processors(List.of(ProcessorProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .parameters(List.of(ProcessorParameterProperty.builder()
 *                                         .parameterName("parameterName")
 *                                         .parameterValue("parameterValue")
 *                                         .build()))
 *                                 .build()))
 *                         .build())
 *                 .retryOptions(SplunkRetryOptionsProperty.builder()
 *                         .durationInSeconds(123)
 *                         .build())
 *                 .s3BackupMode("s3BackupMode")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:44.286Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStreamProps")
@software.amazon.jsii.Jsii.Proxy(CfnDeliveryStreamProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDeliveryStreamProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination in Amazon OpenSearch Service.
     * <p>
     * You can specify only one destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAmazonopensearchserviceDestinationConfiguration() {
        return null;
    }

    /**
     * Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeliveryStreamEncryptionConfigurationInput() {
        return null;
    }

    /**
     * The name of the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamName() {
        return null;
    }

    /**
     * The delivery stream type. This can be one of the following values:.
     * <p>
     * <ul>
     * <li><code>DirectPut</code> : Provider applications access the delivery stream directly.</li>
     * <li><code>KinesisStreamAsSource</code> : The delivery stream uses a Kinesis data stream as a source.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStreamType() {
        return null;
    }

    /**
     * An Amazon ES destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchDestinationConfiguration() {
        return null;
    }

    /**
     * An Amazon S3 destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getExtendedS3DestinationConfiguration() {
        return null;
    }

    /**
     * Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
     * <p>
     * You can specify only one destination.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHttpEndpointDestinationConfiguration() {
        return null;
    }

    /**
     * When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKinesisStreamSourceConfiguration() {
        return null;
    }

    /**
     * An Amazon Redshift destination for the delivery stream.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRedshiftDestinationConfiguration() {
        return null;
    }

    /**
     * The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
     * <p>
     * Conditional. You must specify only one destination configuration.
     * <p>
     * If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getS3DestinationConfiguration() {
        return null;
    }

    /**
     * The configuration of a destination in Splunk for the delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSplunkDestinationConfiguration() {
        return null;
    }

    /**
     * A set of tags to assign to the delivery stream.
     * <p>
     * A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.
     * <p>
     * You can specify up to 50 tags when creating a delivery stream.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDeliveryStreamProps> {
        java.lang.Object amazonopensearchserviceDestinationConfiguration;
        java.lang.Object deliveryStreamEncryptionConfigurationInput;
        java.lang.String deliveryStreamName;
        java.lang.String deliveryStreamType;
        java.lang.Object elasticsearchDestinationConfiguration;
        java.lang.Object extendedS3DestinationConfiguration;
        java.lang.Object httpEndpointDestinationConfiguration;
        java.lang.Object kinesisStreamSourceConfiguration;
        java.lang.Object redshiftDestinationConfiguration;
        java.lang.Object s3DestinationConfiguration;
        java.lang.Object splunkDestinationConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getAmazonopensearchserviceDestinationConfiguration}
         * @param amazonopensearchserviceDestinationConfiguration The destination in Amazon OpenSearch Service.
         *                                                        You can specify only one destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonopensearchserviceDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.AmazonopensearchserviceDestinationConfigurationProperty amazonopensearchserviceDestinationConfiguration) {
            this.amazonopensearchserviceDestinationConfiguration = amazonopensearchserviceDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getAmazonopensearchserviceDestinationConfiguration}
         * @param amazonopensearchserviceDestinationConfiguration The destination in Amazon OpenSearch Service.
         *                                                        You can specify only one destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonopensearchserviceDestinationConfiguration(software.amazon.awscdk.IResolvable amazonopensearchserviceDestinationConfiguration) {
            this.amazonopensearchserviceDestinationConfiguration = amazonopensearchserviceDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDeliveryStreamEncryptionConfigurationInput}
         * @param deliveryStreamEncryptionConfigurationInput Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamEncryptionConfigurationInput(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.DeliveryStreamEncryptionConfigurationInputProperty deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDeliveryStreamEncryptionConfigurationInput}
         * @param deliveryStreamEncryptionConfigurationInput Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side Encryption (SSE).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamEncryptionConfigurationInput(software.amazon.awscdk.IResolvable deliveryStreamEncryptionConfigurationInput) {
            this.deliveryStreamEncryptionConfigurationInput = deliveryStreamEncryptionConfigurationInput;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDeliveryStreamName}
         * @param deliveryStreamName The name of the delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamName(java.lang.String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getDeliveryStreamType}
         * @param deliveryStreamType The delivery stream type. This can be one of the following values:.
         *                           <ul>
         *                           <li><code>DirectPut</code> : Provider applications access the delivery stream directly.</li>
         *                           <li><code>KinesisStreamAsSource</code> : The delivery stream uses a Kinesis data stream as a source.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deliveryStreamType(java.lang.String deliveryStreamType) {
            this.deliveryStreamType = deliveryStreamType;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getElasticsearchDestinationConfiguration}
         * @param elasticsearchDestinationConfiguration An Amazon ES destination for the delivery stream.
         *                                              Conditional. You must specify only one destination configuration.
         *                                              <p>
         *                                              If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ElasticsearchDestinationConfigurationProperty elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getElasticsearchDestinationConfiguration}
         * @param elasticsearchDestinationConfiguration An Amazon ES destination for the delivery stream.
         *                                              Conditional. You must specify only one destination configuration.
         *                                              <p>
         *                                              If you change the delivery stream destination from an Amazon ES destination to an Amazon S3 or Amazon Redshift destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder elasticsearchDestinationConfiguration(software.amazon.awscdk.IResolvable elasticsearchDestinationConfiguration) {
            this.elasticsearchDestinationConfiguration = elasticsearchDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getExtendedS3DestinationConfiguration}
         * @param extendedS3DestinationConfiguration An Amazon S3 destination for the delivery stream.
         *                                           Conditional. You must specify only one destination configuration.
         *                                           <p>
         *                                           If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendedS3DestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.ExtendedS3DestinationConfigurationProperty extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getExtendedS3DestinationConfiguration}
         * @param extendedS3DestinationConfiguration An Amazon S3 destination for the delivery stream.
         *                                           Conditional. You must specify only one destination configuration.
         *                                           <p>
         *                                           If you change the delivery stream destination from an Amazon Extended S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendedS3DestinationConfiguration(software.amazon.awscdk.IResolvable extendedS3DestinationConfiguration) {
            this.extendedS3DestinationConfiguration = extendedS3DestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getHttpEndpointDestinationConfiguration}
         * @param httpEndpointDestinationConfiguration Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
         *                                             You can specify only one destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpEndpointDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.HttpEndpointDestinationConfigurationProperty httpEndpointDestinationConfiguration) {
            this.httpEndpointDestinationConfiguration = httpEndpointDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getHttpEndpointDestinationConfiguration}
         * @param httpEndpointDestinationConfiguration Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint destination.
         *                                             You can specify only one destination.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpEndpointDestinationConfiguration(software.amazon.awscdk.IResolvable httpEndpointDestinationConfiguration) {
            this.httpEndpointDestinationConfiguration = httpEndpointDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getKinesisStreamSourceConfiguration}
         * @param kinesisStreamSourceConfiguration When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSourceConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.KinesisStreamSourceConfigurationProperty kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getKinesisStreamSourceConfiguration}
         * @param kinesisStreamSourceConfiguration When a Kinesis stream is used as the source for the delivery stream, a [KinesisStreamSourceConfiguration](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-kinesisfirehose-deliverystream-kinesisstreamsourceconfiguration.html) containing the Kinesis stream ARN and the role ARN for the source stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStreamSourceConfiguration(software.amazon.awscdk.IResolvable kinesisStreamSourceConfiguration) {
            this.kinesisStreamSourceConfiguration = kinesisStreamSourceConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getRedshiftDestinationConfiguration}
         * @param redshiftDestinationConfiguration An Amazon Redshift destination for the delivery stream.
         *                                         Conditional. You must specify only one destination configuration.
         *                                         <p>
         *                                         If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.RedshiftDestinationConfigurationProperty redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getRedshiftDestinationConfiguration}
         * @param redshiftDestinationConfiguration An Amazon Redshift destination for the delivery stream.
         *                                         Conditional. You must specify only one destination configuration.
         *                                         <p>
         *                                         If you change the delivery stream destination from an Amazon Redshift destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder redshiftDestinationConfiguration(software.amazon.awscdk.IResolvable redshiftDestinationConfiguration) {
            this.redshiftDestinationConfiguration = redshiftDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getS3DestinationConfiguration}
         * @param s3DestinationConfiguration The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
         *                                   Conditional. You must specify only one destination configuration.
         *                                   <p>
         *                                   If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3DestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.S3DestinationConfigurationProperty s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getS3DestinationConfiguration}
         * @param s3DestinationConfiguration The `S3DestinationConfiguration` property type specifies an Amazon Simple Storage Service (Amazon S3) destination to which Amazon Kinesis Data Firehose (Kinesis Data Firehose) delivers data.
         *                                   Conditional. You must specify only one destination configuration.
         *                                   <p>
         *                                   If you change the delivery stream destination from an Amazon S3 destination to an Amazon ES destination, update requires <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-some-interrupt">some interruptions</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3DestinationConfiguration(software.amazon.awscdk.IResolvable s3DestinationConfiguration) {
            this.s3DestinationConfiguration = s3DestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getSplunkDestinationConfiguration}
         * @param splunkDestinationConfiguration The configuration of a destination in Splunk for the delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splunkDestinationConfiguration(software.amazon.awscdk.services.kinesisfirehose.CfnDeliveryStream.SplunkDestinationConfigurationProperty splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getSplunkDestinationConfiguration}
         * @param splunkDestinationConfiguration The configuration of a destination in Splunk for the delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder splunkDestinationConfiguration(software.amazon.awscdk.IResolvable splunkDestinationConfiguration) {
            this.splunkDestinationConfiguration = splunkDestinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnDeliveryStreamProps#getTags}
         * @param tags A set of tags to assign to the delivery stream.
         *             A tag is a key-value pair that you can define and assign to AWS resources. Tags are metadata. For example, you can add friendly names and descriptions or other types of information that can help you distinguish the delivery stream. For more information about tags, see <a href="https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html">Using Cost Allocation Tags</a> in the AWS Billing and Cost Management User Guide.
         *             <p>
         *             You can specify up to 50 tags when creating a delivery stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeliveryStreamProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDeliveryStreamProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDeliveryStreamProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeliveryStreamProps {
        private final java.lang.Object amazonopensearchserviceDestinationConfiguration;
        private final java.lang.Object deliveryStreamEncryptionConfigurationInput;
        private final java.lang.String deliveryStreamName;
        private final java.lang.String deliveryStreamType;
        private final java.lang.Object elasticsearchDestinationConfiguration;
        private final java.lang.Object extendedS3DestinationConfiguration;
        private final java.lang.Object httpEndpointDestinationConfiguration;
        private final java.lang.Object kinesisStreamSourceConfiguration;
        private final java.lang.Object redshiftDestinationConfiguration;
        private final java.lang.Object s3DestinationConfiguration;
        private final java.lang.Object splunkDestinationConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.amazonopensearchserviceDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "amazonopensearchserviceDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deliveryStreamEncryptionConfigurationInput = software.amazon.jsii.Kernel.get(this, "deliveryStreamEncryptionConfigurationInput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deliveryStreamName = software.amazon.jsii.Kernel.get(this, "deliveryStreamName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.deliveryStreamType = software.amazon.jsii.Kernel.get(this, "deliveryStreamType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.elasticsearchDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "elasticsearchDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.extendedS3DestinationConfiguration = software.amazon.jsii.Kernel.get(this, "extendedS3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.httpEndpointDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "httpEndpointDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kinesisStreamSourceConfiguration = software.amazon.jsii.Kernel.get(this, "kinesisStreamSourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.redshiftDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "redshiftDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.s3DestinationConfiguration = software.amazon.jsii.Kernel.get(this, "s3DestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.splunkDestinationConfiguration = software.amazon.jsii.Kernel.get(this, "splunkDestinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.amazonopensearchserviceDestinationConfiguration = builder.amazonopensearchserviceDestinationConfiguration;
            this.deliveryStreamEncryptionConfigurationInput = builder.deliveryStreamEncryptionConfigurationInput;
            this.deliveryStreamName = builder.deliveryStreamName;
            this.deliveryStreamType = builder.deliveryStreamType;
            this.elasticsearchDestinationConfiguration = builder.elasticsearchDestinationConfiguration;
            this.extendedS3DestinationConfiguration = builder.extendedS3DestinationConfiguration;
            this.httpEndpointDestinationConfiguration = builder.httpEndpointDestinationConfiguration;
            this.kinesisStreamSourceConfiguration = builder.kinesisStreamSourceConfiguration;
            this.redshiftDestinationConfiguration = builder.redshiftDestinationConfiguration;
            this.s3DestinationConfiguration = builder.s3DestinationConfiguration;
            this.splunkDestinationConfiguration = builder.splunkDestinationConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getAmazonopensearchserviceDestinationConfiguration() {
            return this.amazonopensearchserviceDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getDeliveryStreamEncryptionConfigurationInput() {
            return this.deliveryStreamEncryptionConfigurationInput;
        }

        @Override
        public final java.lang.String getDeliveryStreamName() {
            return this.deliveryStreamName;
        }

        @Override
        public final java.lang.String getDeliveryStreamType() {
            return this.deliveryStreamType;
        }

        @Override
        public final java.lang.Object getElasticsearchDestinationConfiguration() {
            return this.elasticsearchDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getExtendedS3DestinationConfiguration() {
            return this.extendedS3DestinationConfiguration;
        }

        @Override
        public final java.lang.Object getHttpEndpointDestinationConfiguration() {
            return this.httpEndpointDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getKinesisStreamSourceConfiguration() {
            return this.kinesisStreamSourceConfiguration;
        }

        @Override
        public final java.lang.Object getRedshiftDestinationConfiguration() {
            return this.redshiftDestinationConfiguration;
        }

        @Override
        public final java.lang.Object getS3DestinationConfiguration() {
            return this.s3DestinationConfiguration;
        }

        @Override
        public final java.lang.Object getSplunkDestinationConfiguration() {
            return this.splunkDestinationConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAmazonopensearchserviceDestinationConfiguration() != null) {
                data.set("amazonopensearchserviceDestinationConfiguration", om.valueToTree(this.getAmazonopensearchserviceDestinationConfiguration()));
            }
            if (this.getDeliveryStreamEncryptionConfigurationInput() != null) {
                data.set("deliveryStreamEncryptionConfigurationInput", om.valueToTree(this.getDeliveryStreamEncryptionConfigurationInput()));
            }
            if (this.getDeliveryStreamName() != null) {
                data.set("deliveryStreamName", om.valueToTree(this.getDeliveryStreamName()));
            }
            if (this.getDeliveryStreamType() != null) {
                data.set("deliveryStreamType", om.valueToTree(this.getDeliveryStreamType()));
            }
            if (this.getElasticsearchDestinationConfiguration() != null) {
                data.set("elasticsearchDestinationConfiguration", om.valueToTree(this.getElasticsearchDestinationConfiguration()));
            }
            if (this.getExtendedS3DestinationConfiguration() != null) {
                data.set("extendedS3DestinationConfiguration", om.valueToTree(this.getExtendedS3DestinationConfiguration()));
            }
            if (this.getHttpEndpointDestinationConfiguration() != null) {
                data.set("httpEndpointDestinationConfiguration", om.valueToTree(this.getHttpEndpointDestinationConfiguration()));
            }
            if (this.getKinesisStreamSourceConfiguration() != null) {
                data.set("kinesisStreamSourceConfiguration", om.valueToTree(this.getKinesisStreamSourceConfiguration()));
            }
            if (this.getRedshiftDestinationConfiguration() != null) {
                data.set("redshiftDestinationConfiguration", om.valueToTree(this.getRedshiftDestinationConfiguration()));
            }
            if (this.getS3DestinationConfiguration() != null) {
                data.set("s3DestinationConfiguration", om.valueToTree(this.getS3DestinationConfiguration()));
            }
            if (this.getSplunkDestinationConfiguration() != null) {
                data.set("splunkDestinationConfiguration", om.valueToTree(this.getSplunkDestinationConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesisfirehose.CfnDeliveryStreamProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeliveryStreamProps.Jsii$Proxy that = (CfnDeliveryStreamProps.Jsii$Proxy) o;

            if (this.amazonopensearchserviceDestinationConfiguration != null ? !this.amazonopensearchserviceDestinationConfiguration.equals(that.amazonopensearchserviceDestinationConfiguration) : that.amazonopensearchserviceDestinationConfiguration != null) return false;
            if (this.deliveryStreamEncryptionConfigurationInput != null ? !this.deliveryStreamEncryptionConfigurationInput.equals(that.deliveryStreamEncryptionConfigurationInput) : that.deliveryStreamEncryptionConfigurationInput != null) return false;
            if (this.deliveryStreamName != null ? !this.deliveryStreamName.equals(that.deliveryStreamName) : that.deliveryStreamName != null) return false;
            if (this.deliveryStreamType != null ? !this.deliveryStreamType.equals(that.deliveryStreamType) : that.deliveryStreamType != null) return false;
            if (this.elasticsearchDestinationConfiguration != null ? !this.elasticsearchDestinationConfiguration.equals(that.elasticsearchDestinationConfiguration) : that.elasticsearchDestinationConfiguration != null) return false;
            if (this.extendedS3DestinationConfiguration != null ? !this.extendedS3DestinationConfiguration.equals(that.extendedS3DestinationConfiguration) : that.extendedS3DestinationConfiguration != null) return false;
            if (this.httpEndpointDestinationConfiguration != null ? !this.httpEndpointDestinationConfiguration.equals(that.httpEndpointDestinationConfiguration) : that.httpEndpointDestinationConfiguration != null) return false;
            if (this.kinesisStreamSourceConfiguration != null ? !this.kinesisStreamSourceConfiguration.equals(that.kinesisStreamSourceConfiguration) : that.kinesisStreamSourceConfiguration != null) return false;
            if (this.redshiftDestinationConfiguration != null ? !this.redshiftDestinationConfiguration.equals(that.redshiftDestinationConfiguration) : that.redshiftDestinationConfiguration != null) return false;
            if (this.s3DestinationConfiguration != null ? !this.s3DestinationConfiguration.equals(that.s3DestinationConfiguration) : that.s3DestinationConfiguration != null) return false;
            if (this.splunkDestinationConfiguration != null ? !this.splunkDestinationConfiguration.equals(that.splunkDestinationConfiguration) : that.splunkDestinationConfiguration != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.amazonopensearchserviceDestinationConfiguration != null ? this.amazonopensearchserviceDestinationConfiguration.hashCode() : 0;
            result = 31 * result + (this.deliveryStreamEncryptionConfigurationInput != null ? this.deliveryStreamEncryptionConfigurationInput.hashCode() : 0);
            result = 31 * result + (this.deliveryStreamName != null ? this.deliveryStreamName.hashCode() : 0);
            result = 31 * result + (this.deliveryStreamType != null ? this.deliveryStreamType.hashCode() : 0);
            result = 31 * result + (this.elasticsearchDestinationConfiguration != null ? this.elasticsearchDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.extendedS3DestinationConfiguration != null ? this.extendedS3DestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.httpEndpointDestinationConfiguration != null ? this.httpEndpointDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.kinesisStreamSourceConfiguration != null ? this.kinesisStreamSourceConfiguration.hashCode() : 0);
            result = 31 * result + (this.redshiftDestinationConfiguration != null ? this.redshiftDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.s3DestinationConfiguration != null ? this.s3DestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.splunkDestinationConfiguration != null ? this.splunkDestinationConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
