package software.amazon.awscdk.services.lambda;

/**
 * A CloudFormation `AWS::Lambda::Permission`.
 * <p>
 * The <code>AWS::Lambda::Permission</code> resource grants an AWS service or another account permission to use a function. You can apply the policy at the function level, or specify a qualifier to restrict access to a single version or alias. If you use a qualifier, the invoker must use the full Amazon Resource Name (ARN) of that version or alias to invoke the function.
 * <p>
 * To grant permission to another account, specify the account ID as the <code>Principal</code> . To grant permission to an organization defined in AWS Organizations , specify the organization ID as the <code>PrincipalOrgID</code> . For AWS services, the principal is a domain-style identifier defined by the service, like <code>s3.amazonaws.com</code> or <code>sns.amazonaws.com</code> . For AWS services, you can also specify the ARN of the associated resource as the <code>SourceArn</code> . If you grant permission to a service principal without specifying the source, other accounts could potentially configure resources in their account to invoke your Lambda function.
 * <p>
 * This resource adds a statement to a resource-based permission policy for the function. For more information about function policies, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/access-control-resource-based.html">Lambda Function Policies</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnPermission cfnPermission = CfnPermission.Builder.create(this, "MyCfnPermission")
 *         .action("action")
 *         .functionName("functionName")
 *         .principal("principal")
 *         // the properties below are optional
 *         .eventSourceToken("eventSourceToken")
 *         .principalOrgId("principalOrgId")
 *         .sourceAccount("sourceAccount")
 *         .sourceArn("sourceArn")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:44.387Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnPermission")
public class CfnPermission extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnPermission(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPermission(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.CfnPermission.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Lambda::Permission`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPermission(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnPermissionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The action that the principal can use on the function.
     * <p>
     * For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAction() {
        return software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The action that the principal can use on the function.
     * <p>
     * For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAction(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "action", java.util.Objects.requireNonNull(value, "action is required"));
    }

    /**
     * The name of the Lambda function, version, or alias.
     * <p>
     * <strong>Name formats</strong> - <em>Function name</em> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
     * <p>
     * <ul>
     * <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code> .</li>
     * <li><em>Partial ARN</em> - <code>123456789012:function:my-function</code> .</li>
     * </ul>
     * <p>
     * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Lambda function, version, or alias.
     * <p>
     * <strong>Name formats</strong> - <em>Function name</em> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
     * <p>
     * <ul>
     * <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code> .</li>
     * <li><em>Partial ARN</em> - <code>123456789012:function:my-function</code> .</li>
     * </ul>
     * <p>
     * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctionName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "functionName", java.util.Objects.requireNonNull(value, "functionName is required"));
    }

    /**
     * The AWS service or account that invokes the function.
     * <p>
     * If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "principal", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS service or account that invokes the function.
     * <p>
     * If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrincipal(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "principal", java.util.Objects.requireNonNull(value, "principal is required"));
    }

    /**
     * For Alexa Smart Home functions, a token that must be supplied by the invoker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEventSourceToken() {
        return software.amazon.jsii.Kernel.get(this, "eventSourceToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For Alexa Smart Home functions, a token that must be supplied by the invoker.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventSourceToken(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "eventSourceToken", value);
    }

    /**
     * The identifier for your organization in AWS Organizations .
     * <p>
     * Use this to grant permissions to all the AWS accounts under this organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPrincipalOrgId() {
        return software.amazon.jsii.Kernel.get(this, "principalOrgId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier for your organization in AWS Organizations .
     * <p>
     * Use this to grant permissions to all the AWS accounts under this organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPrincipalOrgId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "principalOrgId", value);
    }

    /**
     * For Amazon S3, the ID of the account that owns the resource.
     * <p>
     * Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceAccount() {
        return software.amazon.jsii.Kernel.get(this, "sourceAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For Amazon S3, the ID of the account that owns the resource.
     * <p>
     * Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceAccount(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceAccount", value);
    }

    /**
     * For AWS services, the ARN of the AWS resource that invokes the function.
     * <p>
     * For example, an Amazon S3 bucket or Amazon SNS topic.
     * <p>
     * Note that Lambda configures the comparison using the <code>StringLike</code> operator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceArn() {
        return software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * For AWS services, the ARN of the AWS resource that invokes the function.
     * <p>
     * For example, an Amazon S3 bucket or Amazon SNS topic.
     * <p>
     * Note that Lambda configures the comparison using the <code>StringLike</code> operator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceArn", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.CfnPermission}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.CfnPermission> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.CfnPermissionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.CfnPermissionProps.Builder();
        }

        /**
         * The action that the principal can use on the function.
         * <p>
         * For example, <code>lambda:InvokeFunction</code> or <code>lambda:GetFunction</code> .
         * <p>
         * @return {@code this}
         * @param action The action that the principal can use on the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(final java.lang.String action) {
            this.props.action(action);
            return this;
        }

        /**
         * The name of the Lambda function, version, or alias.
         * <p>
         * <strong>Name formats</strong> - <em>Function name</em> - <code>my-function</code> (name-only), <code>my-function:v1</code> (with alias).
         * <p>
         * <ul>
         * <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code> .</li>
         * <li><em>Partial ARN</em> - <code>123456789012:function:my-function</code> .</li>
         * </ul>
         * <p>
         * You can append a version number or alias to any of the formats. The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * <p>
         * @return {@code this}
         * @param functionName The name of the Lambda function, version, or alias. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * The AWS service or account that invokes the function.
         * <p>
         * If you specify a service, use <code>SourceArn</code> or <code>SourceAccount</code> to limit who can invoke the function through that service.
         * <p>
         * @return {@code this}
         * @param principal The AWS service or account that invokes the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principal(final java.lang.String principal) {
            this.props.principal(principal);
            return this;
        }

        /**
         * For Alexa Smart Home functions, a token that must be supplied by the invoker.
         * <p>
         * @return {@code this}
         * @param eventSourceToken For Alexa Smart Home functions, a token that must be supplied by the invoker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceToken(final java.lang.String eventSourceToken) {
            this.props.eventSourceToken(eventSourceToken);
            return this;
        }

        /**
         * The identifier for your organization in AWS Organizations .
         * <p>
         * Use this to grant permissions to all the AWS accounts under this organization.
         * <p>
         * @return {@code this}
         * @param principalOrgId The identifier for your organization in AWS Organizations . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder principalOrgId(final java.lang.String principalOrgId) {
            this.props.principalOrgId(principalOrgId);
            return this;
        }

        /**
         * For Amazon S3, the ID of the account that owns the resource.
         * <p>
         * Use this together with <code>SourceArn</code> to ensure that the resource is owned by the specified account. It is possible for an Amazon S3 bucket to be deleted by its owner and recreated by another account.
         * <p>
         * @return {@code this}
         * @param sourceAccount For Amazon S3, the ID of the account that owns the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAccount(final java.lang.String sourceAccount) {
            this.props.sourceAccount(sourceAccount);
            return this;
        }

        /**
         * For AWS services, the ARN of the AWS resource that invokes the function.
         * <p>
         * For example, an Amazon S3 bucket or Amazon SNS topic.
         * <p>
         * Note that Lambda configures the comparison using the <code>StringLike</code> operator.
         * <p>
         * @return {@code this}
         * @param sourceArn For AWS services, the ARN of the AWS resource that invokes the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceArn(final java.lang.String sourceArn) {
            this.props.sourceArn(sourceArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.CfnPermission}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.CfnPermission build() {
            return new software.amazon.awscdk.services.lambda.CfnPermission(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
