package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Use a MSK cluster as a streaming source for AWS Lambda.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.secretsmanager.Secret;
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * Function myFunction;
 * // Your MSK cluster arn
 * String clusterArn = "arn:aws:kafka:us-east-1:0123456789019:cluster/SalesCluster/abcd1234-abcd-cafe-abab-9876543210ab-4";
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * // The secret that allows access to your MSK cluster
 * // You still have to make sure that it is associated with your cluster as described in the documentation
 * Secret secret = Secret.Builder.create(this, "Secret").secretName("AmazonMSK_KafkaSecret").build();
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .secret(secret)
 *         .batchSize(100) // default
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:44.467Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.ManagedKafkaEventSource")
public class ManagedKafkaEventSource extends software.amazon.awscdk.services.lambda.eventsources.StreamEventSource {

    protected ManagedKafkaEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ManagedKafkaEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ManagedKafkaEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * The identifier for this EventSourceMapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventSourceMappingId() {
        return software.amazon.jsii.Kernel.get(this, "eventSourceMappingId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSourceProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSourceProps.Builder();
        }

        /**
         * Where to begin consuming the stream.
         * <p>
         * @return {@code this}
         * @param startingPosition Where to begin consuming the stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(final software.amazon.awscdk.services.lambda.StartingPosition startingPosition) {
            this.props.startingPosition(startingPosition);
            return this;
        }

        /**
         * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * <p>
         * Your function receives an
         * event with all the retrieved records.
         * <p>
         * Valid Range:
         * <p>
         * <ul>
         * <li>Minimum value of 1</li>
         * <li>Maximum value of:
         * <p>
         * <ul>
         * <li>1000 for {&#64;link DynamoEventSource}</li>
         * <li>10000 for {&#64;link KinesisEventSource}, {&#64;link ManagedKafkaEventSource} and {&#64;link SelfManagedKafkaEventSource}</li>
         * </ul></li>
         * </ul>
         * <p>
         * Default: 100
         * <p>
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props.batchSize(batchSize);
            return this;
        }

        /**
         * If the stream event source mapping should be enabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled If the stream event source mapping should be enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The maximum amount of time to gather records before invoking the function.
         * <p>
         * Maximum of Duration.minutes(5)
         * <p>
         * Default: Duration.seconds(0)
         * <p>
         * @return {@code this}
         * @param maxBatchingWindow The maximum amount of time to gather records before invoking the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxBatchingWindow(final software.amazon.awscdk.Duration maxBatchingWindow) {
            this.props.maxBatchingWindow(maxBatchingWindow);
            return this;
        }

        /**
         * An Amazon SQS queue or Amazon SNS topic destination for discarded records.
         * <p>
         * Default: discarded records are ignored
         * <p>
         * @return {@code this}
         * @param onFailure An Amazon SQS queue or Amazon SNS topic destination for discarded records. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IEventSourceDlq onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * The Kafka topic to subscribe to.
         * <p>
         * @return {@code this}
         * @param topic The Kafka topic to subscribe to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topic(final java.lang.String topic) {
            this.props.topic(topic);
            return this;
        }

        /**
         * The secret with the Kafka credentials, see https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html for details This field is required if your Kafka brokers are accessed over the Internet.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param secret The secret with the Kafka credentials, see https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html for details This field is required if your Kafka brokers are accessed over the Internet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(final software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        /**
         * An MSK cluster construct.
         * <p>
         * @return {@code this}
         * @param clusterArn An MSK cluster construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterArn(final java.lang.String clusterArn) {
            this.props.clusterArn(clusterArn);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource(
                this.props.build()
            );
        }
    }
}
