package software.amazon.awscdk.services.logs;

/**
 * A CloudFormation `AWS::Logs::MetricFilter`.
 * <p>
 * The <code>AWS::Logs::MetricFilter</code> resource specifies a metric filter that describes how CloudWatch Logs extracts information from logs and transforms it into Amazon CloudWatch metrics. If you have multiple metric filters that are associated with a log group, all the filters are applied to the log streams in that group.
 * <p>
 * The maximum number of metric filters that can be associated with a log group is 100.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnMetricFilter cfnMetricFilter = CfnMetricFilter.Builder.create(this, "MyCfnMetricFilter")
 *         .filterPattern("filterPattern")
 *         .logGroupName("logGroupName")
 *         .metricTransformations(List.of(MetricTransformationProperty.builder()
 *                 .metricName("metricName")
 *                 .metricNamespace("metricNamespace")
 *                 .metricValue("metricValue")
 *                 // the properties below are optional
 *                 .defaultValue(123)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:44.662Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnMetricFilter")
public class CfnMetricFilter extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnMetricFilter(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMetricFilter(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.CfnMetricFilter.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::Logs::MetricFilter`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnMetricFilter(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.CfnMetricFilterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A filter pattern for extracting metric data out of ingested log events.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFilterPattern() {
        return software.amazon.jsii.Kernel.get(this, "filterPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A filter pattern for extracting metric data out of ingested log events.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFilterPattern(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "filterPattern", java.util.Objects.requireNonNull(value, "filterPattern is required"));
    }

    /**
     * The name of an existing log group that you want to associate with this metric filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getLogGroupName() {
        return software.amazon.jsii.Kernel.get(this, "logGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of an existing log group that you want to associate with this metric filter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogGroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "logGroupName", java.util.Objects.requireNonNull(value, "logGroupName is required"));
    }

    /**
     * The metric transformations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMetricTransformations() {
        return software.amazon.jsii.Kernel.get(this, "metricTransformations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The metric transformations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricTransformations(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metricTransformations", java.util.Objects.requireNonNull(value, "metricTransformations is required"));
    }

    /**
     * The metric transformations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetricTransformations(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        software.amazon.jsii.Kernel.set(this, "metricTransformations", java.util.Objects.requireNonNull(value, "metricTransformations is required"));
    }
    /**
     * `MetricTransformation` is a property of the `AWS::Logs::MetricFilter` resource that describes how to transform log streams into a CloudWatch metric.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * MetricTransformationProperty metricTransformationProperty = MetricTransformationProperty.builder()
     *         .metricName("metricName")
     *         .metricNamespace("metricNamespace")
     *         .metricValue("metricValue")
     *         // the properties below are optional
     *         .defaultValue(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnMetricFilter.MetricTransformationProperty")
    @software.amazon.jsii.Jsii.Proxy(MetricTransformationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetricTransformationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the CloudWatch metric.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

        /**
         * A custom namespace to contain your metric in CloudWatch.
         * <p>
         * Use namespaces to group together metrics that are similar. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricNamespace();

        /**
         * The value that is published to the CloudWatch metric.
         * <p>
         * For example, if you're counting the occurrences of a particular term like <code>Error</code> , specify 1 for the metric value. If you're counting the number of bytes transferred, reference the value that is in the log event by using $ followed by the name of the field that you specified in the filter pattern, such as <code>$.size</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetricValue();

        /**
         * (Optional) The value to emit when a filter pattern does not match a log event.
         * <p>
         * This value can be null.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetricTransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetricTransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetricTransformationProperty> {
            java.lang.String metricName;
            java.lang.String metricNamespace;
            java.lang.String metricValue;
            java.lang.Number defaultValue;

            /**
             * Sets the value of {@link MetricTransformationProperty#getMetricName}
             * @param metricName The name of the CloudWatch metric. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricName(java.lang.String metricName) {
                this.metricName = metricName;
                return this;
            }

            /**
             * Sets the value of {@link MetricTransformationProperty#getMetricNamespace}
             * @param metricNamespace A custom namespace to contain your metric in CloudWatch. This parameter is required.
             *                        Use namespaces to group together metrics that are similar. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Namespace">Namespaces</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricNamespace(java.lang.String metricNamespace) {
                this.metricNamespace = metricNamespace;
                return this;
            }

            /**
             * Sets the value of {@link MetricTransformationProperty#getMetricValue}
             * @param metricValue The value that is published to the CloudWatch metric. This parameter is required.
             *                    For example, if you're counting the occurrences of a particular term like <code>Error</code> , specify 1 for the metric value. If you're counting the number of bytes transferred, reference the value that is in the log event by using $ followed by the name of the field that you specified in the filter pattern, such as <code>$.size</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metricValue(java.lang.String metricValue) {
                this.metricValue = metricValue;
                return this;
            }

            /**
             * Sets the value of {@link MetricTransformationProperty#getDefaultValue}
             * @param defaultValue (Optional) The value to emit when a filter pattern does not match a log event.
             *                     This value can be null.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(java.lang.Number defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetricTransformationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetricTransformationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetricTransformationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetricTransformationProperty {
            private final java.lang.String metricName;
            private final java.lang.String metricNamespace;
            private final java.lang.String metricValue;
            private final java.lang.Number defaultValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricNamespace = software.amazon.jsii.Kernel.get(this, "metricNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metricValue = software.amazon.jsii.Kernel.get(this, "metricValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
                this.metricNamespace = java.util.Objects.requireNonNull(builder.metricNamespace, "metricNamespace is required");
                this.metricValue = java.util.Objects.requireNonNull(builder.metricValue, "metricValue is required");
                this.defaultValue = builder.defaultValue;
            }

            @Override
            public final java.lang.String getMetricName() {
                return this.metricName;
            }

            @Override
            public final java.lang.String getMetricNamespace() {
                return this.metricNamespace;
            }

            @Override
            public final java.lang.String getMetricValue() {
                return this.metricValue;
            }

            @Override
            public final java.lang.Number getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("metricName", om.valueToTree(this.getMetricName()));
                data.set("metricNamespace", om.valueToTree(this.getMetricNamespace()));
                data.set("metricValue", om.valueToTree(this.getMetricValue()));
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnMetricFilter.MetricTransformationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetricTransformationProperty.Jsii$Proxy that = (MetricTransformationProperty.Jsii$Proxy) o;

                if (!metricName.equals(that.metricName)) return false;
                if (!metricNamespace.equals(that.metricNamespace)) return false;
                if (!metricValue.equals(that.metricValue)) return false;
                return this.defaultValue != null ? this.defaultValue.equals(that.defaultValue) : that.defaultValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.metricName.hashCode();
                result = 31 * result + (this.metricNamespace.hashCode());
                result = 31 * result + (this.metricValue.hashCode());
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.CfnMetricFilter}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.CfnMetricFilter> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.CfnMetricFilterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.CfnMetricFilterProps.Builder();
        }

        /**
         * A filter pattern for extracting metric data out of ingested log events.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/FilterAndPatternSyntax.html">Filter and Pattern Syntax</a> .
         * <p>
         * @return {@code this}
         * @param filterPattern A filter pattern for extracting metric data out of ingested log events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterPattern(final java.lang.String filterPattern) {
            this.props.filterPattern(filterPattern);
            return this;
        }

        /**
         * The name of an existing log group that you want to associate with this metric filter.
         * <p>
         * @return {@code this}
         * @param logGroupName The name of an existing log group that you want to associate with this metric filter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroupName(final java.lang.String logGroupName) {
            this.props.logGroupName(logGroupName);
            return this;
        }

        /**
         * The metric transformations.
         * <p>
         * @return {@code this}
         * @param metricTransformations The metric transformations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricTransformations(final software.amazon.awscdk.IResolvable metricTransformations) {
            this.props.metricTransformations(metricTransformations);
            return this;
        }
        /**
         * The metric transformations.
         * <p>
         * @return {@code this}
         * @param metricTransformations The metric transformations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricTransformations(final java.util.List<? extends java.lang.Object> metricTransformations) {
            this.props.metricTransformations(metricTransformations);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.logs.CfnMetricFilter}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.CfnMetricFilter build() {
            return new software.amazon.awscdk.services.logs.CfnMetricFilter(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
