package software.amazon.awscdk.services.mediapackage;

/**
 * A CloudFormation `AWS::MediaPackage::PackagingConfiguration`.
 * <p>
 * Creates a packaging configuration in a packaging group.
 * <p>
 * The packaging configuration represents a single delivery point for an asset. It determines the format and setting for the egressing content. Specify only one package format per configuration, such as <code>HlsPackage</code> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mediapackage.*;
 * CfnPackagingConfiguration cfnPackagingConfiguration = CfnPackagingConfiguration.Builder.create(this, "MyCfnPackagingConfiguration")
 *         .id("id")
 *         .packagingGroupId("packagingGroupId")
 *         // the properties below are optional
 *         .cmafPackage(CmafPackageProperty.builder()
 *                 .hlsManifests(List.of(HlsManifestProperty.builder()
 *                         .adMarkers("adMarkers")
 *                         .includeIframeOnlyStream(false)
 *                         .manifestName("manifestName")
 *                         .programDateTimeIntervalSeconds(123)
 *                         .repeatExtXKey(false)
 *                         .streamSelection(StreamSelectionProperty.builder()
 *                                 .maxVideoBitsPerSecond(123)
 *                                 .minVideoBitsPerSecond(123)
 *                                 .streamOrder("streamOrder")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .encryption(CmafEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 .build())
 *                         .build())
 *                 .includeEncoderConfigurationInSegments(false)
 *                 .segmentDurationSeconds(123)
 *                 .build())
 *         .dashPackage(DashPackageProperty.builder()
 *                 .dashManifests(List.of(DashManifestProperty.builder()
 *                         .manifestLayout("manifestLayout")
 *                         .manifestName("manifestName")
 *                         .minBufferTimeSeconds(123)
 *                         .profile("profile")
 *                         .streamSelection(StreamSelectionProperty.builder()
 *                                 .maxVideoBitsPerSecond(123)
 *                                 .minVideoBitsPerSecond(123)
 *                                 .streamOrder("streamOrder")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .encryption(DashEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 .build())
 *                         .build())
 *                 .includeEncoderConfigurationInSegments(false)
 *                 .periodTriggers(List.of("periodTriggers"))
 *                 .segmentDurationSeconds(123)
 *                 .segmentTemplateFormat("segmentTemplateFormat")
 *                 .build())
 *         .hlsPackage(HlsPackageProperty.builder()
 *                 .hlsManifests(List.of(HlsManifestProperty.builder()
 *                         .adMarkers("adMarkers")
 *                         .includeIframeOnlyStream(false)
 *                         .manifestName("manifestName")
 *                         .programDateTimeIntervalSeconds(123)
 *                         .repeatExtXKey(false)
 *                         .streamSelection(StreamSelectionProperty.builder()
 *                                 .maxVideoBitsPerSecond(123)
 *                                 .minVideoBitsPerSecond(123)
 *                                 .streamOrder("streamOrder")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .encryption(HlsEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 .build())
 *                         // the properties below are optional
 *                         .constantInitializationVector("constantInitializationVector")
 *                         .encryptionMethod("encryptionMethod")
 *                         .build())
 *                 .segmentDurationSeconds(123)
 *                 .useAudioRenditionGroup(false)
 *                 .build())
 *         .mssPackage(MssPackageProperty.builder()
 *                 .mssManifests(List.of(MssManifestProperty.builder()
 *                         .manifestName("manifestName")
 *                         .streamSelection(StreamSelectionProperty.builder()
 *                                 .maxVideoBitsPerSecond(123)
 *                                 .minVideoBitsPerSecond(123)
 *                                 .streamOrder("streamOrder")
 *                                 .build())
 *                         .build()))
 *                 // the properties below are optional
 *                 .encryption(MssEncryptionProperty.builder()
 *                         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
 *                                 .roleArn("roleArn")
 *                                 .systemIds(List.of("systemIds"))
 *                                 .url("url")
 *                                 .build())
 *                         .build())
 *                 .segmentDurationSeconds(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:44.886Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration")
public class CfnPackagingConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnPackagingConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPackagingConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::MediaPackage::PackagingConfiguration`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPackagingConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mediapackage.CfnPackagingConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) for the packaging configuration.
     * <p>
     * You can get this from the response to any request to the packaging configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The tags to assign to the packaging configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Unique identifier that you assign to the packaging configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Unique identifier that you assign to the packaging configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "id", java.util.Objects.requireNonNull(value, "id is required"));
    }

    /**
     * The ID of the packaging group associated with this packaging configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPackagingGroupId() {
        return software.amazon.jsii.Kernel.get(this, "packagingGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the packaging group associated with this packaging configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPackagingGroupId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "packagingGroupId", java.util.Objects.requireNonNull(value, "packagingGroupId is required"));
    }

    /**
     * Parameters for CMAF packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCmafPackage() {
        return software.amazon.jsii.Kernel.get(this, "cmafPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters for CMAF packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCmafPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.CmafPackageProperty value) {
        software.amazon.jsii.Kernel.set(this, "cmafPackage", value);
    }

    /**
     * Parameters for CMAF packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCmafPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cmafPackage", value);
    }

    /**
     * Parameters for DASH-ISO packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDashPackage() {
        return software.amazon.jsii.Kernel.get(this, "dashPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters for DASH-ISO packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.DashPackageProperty value) {
        software.amazon.jsii.Kernel.set(this, "dashPackage", value);
    }

    /**
     * Parameters for DASH-ISO packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDashPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dashPackage", value);
    }

    /**
     * Parameters for Apple HLS packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getHlsPackage() {
        return software.amazon.jsii.Kernel.get(this, "hlsPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters for Apple HLS packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHlsPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.HlsPackageProperty value) {
        software.amazon.jsii.Kernel.set(this, "hlsPackage", value);
    }

    /**
     * Parameters for Apple HLS packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHlsPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "hlsPackage", value);
    }

    /**
     * Parameters for Microsoft Smooth Streaming packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMssPackage() {
        return software.amazon.jsii.Kernel.get(this, "mssPackage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Parameters for Microsoft Smooth Streaming packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMssPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.MssPackageProperty value) {
        software.amazon.jsii.Kernel.set(this, "mssPackage", value);
    }

    /**
     * Parameters for Microsoft Smooth Streaming packaging.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMssPackage(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "mssPackage", value);
    }
    /**
     * Holds encryption information so that access to the content can be controlled by a DRM solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * CmafEncryptionProperty cmafEncryptionProperty = CmafEncryptionProperty.builder()
     *         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                 .roleArn("roleArn")
     *                 .systemIds(List.of("systemIds"))
     *                 .url("url")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.CmafEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(CmafEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CmafEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for the SPEKE key provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSpekeKeyProvider();

        /**
         * @return a {@link Builder} of {@link CmafEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CmafEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CmafEncryptionProperty> {
            java.lang.Object spekeKeyProvider;

            /**
             * Sets the value of {@link CmafEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.SpekeKeyProviderProperty spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link CmafEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.IResolvable spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CmafEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CmafEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CmafEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CmafEncryptionProperty {
            private final java.lang.Object spekeKeyProvider;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spekeKeyProvider = software.amazon.jsii.Kernel.get(this, "spekeKeyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spekeKeyProvider = java.util.Objects.requireNonNull(builder.spekeKeyProvider, "spekeKeyProvider is required");
            }

            @Override
            public final java.lang.Object getSpekeKeyProvider() {
                return this.spekeKeyProvider;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spekeKeyProvider", om.valueToTree(this.getSpekeKeyProvider()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.CmafEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CmafEncryptionProperty.Jsii$Proxy that = (CmafEncryptionProperty.Jsii$Proxy) o;

                return this.spekeKeyProvider.equals(that.spekeKeyProvider);
            }

            @Override
            public final int hashCode() {
                int result = this.spekeKeyProvider.hashCode();
                return result;
            }
        }
    }
    /**
     * Parameters for a packaging configuration that uses Common Media Application Format (CMAF) packaging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * CmafPackageProperty cmafPackageProperty = CmafPackageProperty.builder()
     *         .hlsManifests(List.of(HlsManifestProperty.builder()
     *                 .adMarkers("adMarkers")
     *                 .includeIframeOnlyStream(false)
     *                 .manifestName("manifestName")
     *                 .programDateTimeIntervalSeconds(123)
     *                 .repeatExtXKey(false)
     *                 .streamSelection(StreamSelectionProperty.builder()
     *                         .maxVideoBitsPerSecond(123)
     *                         .minVideoBitsPerSecond(123)
     *                         .streamOrder("streamOrder")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .encryption(CmafEncryptionProperty.builder()
     *                 .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                         .roleArn("roleArn")
     *                         .systemIds(List.of("systemIds"))
     *                         .url("url")
     *                         .build())
     *                 .build())
     *         .includeEncoderConfigurationInSegments(false)
     *         .segmentDurationSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.CmafPackageProperty")
    @software.amazon.jsii.Jsii.Proxy(CmafPackageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CmafPackageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of HLS manifest configurations that are available from this endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHlsManifests();

        /**
         * Parameters for encrypting content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment.
         * <p>
         * This lets you use different SPS/PPS/VPS settings for your assets during content playback.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeEncoderConfigurationInSegments() {
            return null;
        }

        /**
         * Duration (in seconds) of each segment.
         * <p>
         * Actual segments are rounded to the nearest multiple of the source fragment duration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentDurationSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CmafPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CmafPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CmafPackageProperty> {
            java.lang.Object hlsManifests;
            java.lang.Object encryption;
            java.lang.Object includeEncoderConfigurationInSegments;
            java.lang.Number segmentDurationSeconds;

            /**
             * Sets the value of {@link CmafPackageProperty#getHlsManifests}
             * @param hlsManifests A list of HLS manifest configurations that are available from this endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsManifests(software.amazon.awscdk.IResolvable hlsManifests) {
                this.hlsManifests = hlsManifests;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getHlsManifests}
             * @param hlsManifests A list of HLS manifest configurations that are available from this endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsManifests(java.util.List<? extends java.lang.Object> hlsManifests) {
                this.hlsManifests = hlsManifests;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.CmafEncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getIncludeEncoderConfigurationInSegments}
             * @param includeEncoderConfigurationInSegments When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment.
             *                                              This lets you use different SPS/PPS/VPS settings for your assets during content playback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeEncoderConfigurationInSegments(java.lang.Boolean includeEncoderConfigurationInSegments) {
                this.includeEncoderConfigurationInSegments = includeEncoderConfigurationInSegments;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getIncludeEncoderConfigurationInSegments}
             * @param includeEncoderConfigurationInSegments When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment.
             *                                              This lets you use different SPS/PPS/VPS settings for your assets during content playback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeEncoderConfigurationInSegments(software.amazon.awscdk.IResolvable includeEncoderConfigurationInSegments) {
                this.includeEncoderConfigurationInSegments = includeEncoderConfigurationInSegments;
                return this;
            }

            /**
             * Sets the value of {@link CmafPackageProperty#getSegmentDurationSeconds}
             * @param segmentDurationSeconds Duration (in seconds) of each segment.
             *                               Actual segments are rounded to the nearest multiple of the source fragment duration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDurationSeconds(java.lang.Number segmentDurationSeconds) {
                this.segmentDurationSeconds = segmentDurationSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CmafPackageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CmafPackageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CmafPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CmafPackageProperty {
            private final java.lang.Object hlsManifests;
            private final java.lang.Object encryption;
            private final java.lang.Object includeEncoderConfigurationInSegments;
            private final java.lang.Number segmentDurationSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hlsManifests = software.amazon.jsii.Kernel.get(this, "hlsManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeEncoderConfigurationInSegments = software.amazon.jsii.Kernel.get(this, "includeEncoderConfigurationInSegments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.segmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "segmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hlsManifests = java.util.Objects.requireNonNull(builder.hlsManifests, "hlsManifests is required");
                this.encryption = builder.encryption;
                this.includeEncoderConfigurationInSegments = builder.includeEncoderConfigurationInSegments;
                this.segmentDurationSeconds = builder.segmentDurationSeconds;
            }

            @Override
            public final java.lang.Object getHlsManifests() {
                return this.hlsManifests;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.Object getIncludeEncoderConfigurationInSegments() {
                return this.includeEncoderConfigurationInSegments;
            }

            @Override
            public final java.lang.Number getSegmentDurationSeconds() {
                return this.segmentDurationSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hlsManifests", om.valueToTree(this.getHlsManifests()));
                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getIncludeEncoderConfigurationInSegments() != null) {
                    data.set("includeEncoderConfigurationInSegments", om.valueToTree(this.getIncludeEncoderConfigurationInSegments()));
                }
                if (this.getSegmentDurationSeconds() != null) {
                    data.set("segmentDurationSeconds", om.valueToTree(this.getSegmentDurationSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.CmafPackageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CmafPackageProperty.Jsii$Proxy that = (CmafPackageProperty.Jsii$Proxy) o;

                if (!hlsManifests.equals(that.hlsManifests)) return false;
                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                if (this.includeEncoderConfigurationInSegments != null ? !this.includeEncoderConfigurationInSegments.equals(that.includeEncoderConfigurationInSegments) : that.includeEncoderConfigurationInSegments != null) return false;
                return this.segmentDurationSeconds != null ? this.segmentDurationSeconds.equals(that.segmentDurationSeconds) : that.segmentDurationSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hlsManifests.hashCode();
                result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
                result = 31 * result + (this.includeEncoderConfigurationInSegments != null ? this.includeEncoderConfigurationInSegments.hashCode() : 0);
                result = 31 * result + (this.segmentDurationSeconds != null ? this.segmentDurationSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Holds encryption information so that access to the content can be controlled by a DRM solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * DashEncryptionProperty dashEncryptionProperty = DashEncryptionProperty.builder()
     *         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                 .roleArn("roleArn")
     *                 .systemIds(List.of("systemIds"))
     *                 .url("url")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.DashEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(DashEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for the SPEKE key provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSpekeKeyProvider();

        /**
         * @return a {@link Builder} of {@link DashEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashEncryptionProperty> {
            java.lang.Object spekeKeyProvider;

            /**
             * Sets the value of {@link DashEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.SpekeKeyProviderProperty spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link DashEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.IResolvable spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashEncryptionProperty {
            private final java.lang.Object spekeKeyProvider;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spekeKeyProvider = software.amazon.jsii.Kernel.get(this, "spekeKeyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spekeKeyProvider = java.util.Objects.requireNonNull(builder.spekeKeyProvider, "spekeKeyProvider is required");
            }

            @Override
            public final java.lang.Object getSpekeKeyProvider() {
                return this.spekeKeyProvider;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spekeKeyProvider", om.valueToTree(this.getSpekeKeyProvider()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.DashEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashEncryptionProperty.Jsii$Proxy that = (DashEncryptionProperty.Jsii$Proxy) o;

                return this.spekeKeyProvider.equals(that.spekeKeyProvider);
            }

            @Override
            public final int hashCode() {
                int result = this.spekeKeyProvider.hashCode();
                return result;
            }
        }
    }
    /**
     * Parameters for a DASH manifest.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * DashManifestProperty dashManifestProperty = DashManifestProperty.builder()
     *         .manifestLayout("manifestLayout")
     *         .manifestName("manifestName")
     *         .minBufferTimeSeconds(123)
     *         .profile("profile")
     *         .streamSelection(StreamSelectionProperty.builder()
     *                 .maxVideoBitsPerSecond(123)
     *                 .minVideoBitsPerSecond(123)
     *                 .streamOrder("streamOrder")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.DashManifestProperty")
    @software.amazon.jsii.Jsii.Proxy(DashManifestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashManifestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines the position of some tags in the Media Presentation Description (MPD).
         * <p>
         * When set to <code>FULL</code> , elements like <code>SegmentTemplate</code> and <code>ContentProtection</code> are included in each <code>Representation</code> . When set to <code>COMPACT</code> , duplicate elements are combined and presented at the AdaptationSet level.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestLayout() {
            return null;
        }

        /**
         * A short string that's appended to the end of the endpoint URL to create a unique path to this packaging configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestName() {
            return null;
        }

        /**
         * Minimum amount of content (measured in seconds) that a player must keep available in the buffer.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinBufferTimeSeconds() {
            return null;
        }

        /**
         * The DASH profile type.
         * <p>
         * When set to <code>HBBTV_1_5</code> , the content is compliant with HbbTV 1.5.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getProfile() {
            return null;
        }

        /**
         * Limitations for outputs from the endpoint, based on the video bitrate.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSelection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashManifestProperty> {
            java.lang.String manifestLayout;
            java.lang.String manifestName;
            java.lang.Number minBufferTimeSeconds;
            java.lang.String profile;
            java.lang.Object streamSelection;

            /**
             * Sets the value of {@link DashManifestProperty#getManifestLayout}
             * @param manifestLayout Determines the position of some tags in the Media Presentation Description (MPD).
             *                       When set to <code>FULL</code> , elements like <code>SegmentTemplate</code> and <code>ContentProtection</code> are included in each <code>Representation</code> . When set to <code>COMPACT</code> , duplicate elements are combined and presented at the AdaptationSet level.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestLayout(java.lang.String manifestLayout) {
                this.manifestLayout = manifestLayout;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestProperty#getManifestName}
             * @param manifestName A short string that's appended to the end of the endpoint URL to create a unique path to this packaging configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestName(java.lang.String manifestName) {
                this.manifestName = manifestName;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestProperty#getMinBufferTimeSeconds}
             * @param minBufferTimeSeconds Minimum amount of content (measured in seconds) that a player must keep available in the buffer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minBufferTimeSeconds(java.lang.Number minBufferTimeSeconds) {
                this.minBufferTimeSeconds = minBufferTimeSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestProperty#getProfile}
             * @param profile The DASH profile type.
             *                When set to <code>HBBTV_1_5</code> , the content is compliant with HbbTV 1.5.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder profile(java.lang.String profile) {
                this.profile = profile;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.StreamSelectionProperty streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Sets the value of {@link DashManifestProperty#getStreamSelection}
             * @param streamSelection Limitations for outputs from the endpoint, based on the video bitrate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.IResolvable streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashManifestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashManifestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashManifestProperty {
            private final java.lang.String manifestLayout;
            private final java.lang.String manifestName;
            private final java.lang.Number minBufferTimeSeconds;
            private final java.lang.String profile;
            private final java.lang.Object streamSelection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestLayout = software.amazon.jsii.Kernel.get(this, "manifestLayout", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manifestName = software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minBufferTimeSeconds = software.amazon.jsii.Kernel.get(this, "minBufferTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.profile = software.amazon.jsii.Kernel.get(this, "profile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamSelection = software.amazon.jsii.Kernel.get(this, "streamSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestLayout = builder.manifestLayout;
                this.manifestName = builder.manifestName;
                this.minBufferTimeSeconds = builder.minBufferTimeSeconds;
                this.profile = builder.profile;
                this.streamSelection = builder.streamSelection;
            }

            @Override
            public final java.lang.String getManifestLayout() {
                return this.manifestLayout;
            }

            @Override
            public final java.lang.String getManifestName() {
                return this.manifestName;
            }

            @Override
            public final java.lang.Number getMinBufferTimeSeconds() {
                return this.minBufferTimeSeconds;
            }

            @Override
            public final java.lang.String getProfile() {
                return this.profile;
            }

            @Override
            public final java.lang.Object getStreamSelection() {
                return this.streamSelection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getManifestLayout() != null) {
                    data.set("manifestLayout", om.valueToTree(this.getManifestLayout()));
                }
                if (this.getManifestName() != null) {
                    data.set("manifestName", om.valueToTree(this.getManifestName()));
                }
                if (this.getMinBufferTimeSeconds() != null) {
                    data.set("minBufferTimeSeconds", om.valueToTree(this.getMinBufferTimeSeconds()));
                }
                if (this.getProfile() != null) {
                    data.set("profile", om.valueToTree(this.getProfile()));
                }
                if (this.getStreamSelection() != null) {
                    data.set("streamSelection", om.valueToTree(this.getStreamSelection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.DashManifestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashManifestProperty.Jsii$Proxy that = (DashManifestProperty.Jsii$Proxy) o;

                if (this.manifestLayout != null ? !this.manifestLayout.equals(that.manifestLayout) : that.manifestLayout != null) return false;
                if (this.manifestName != null ? !this.manifestName.equals(that.manifestName) : that.manifestName != null) return false;
                if (this.minBufferTimeSeconds != null ? !this.minBufferTimeSeconds.equals(that.minBufferTimeSeconds) : that.minBufferTimeSeconds != null) return false;
                if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) return false;
                return this.streamSelection != null ? this.streamSelection.equals(that.streamSelection) : that.streamSelection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestLayout != null ? this.manifestLayout.hashCode() : 0;
                result = 31 * result + (this.manifestName != null ? this.manifestName.hashCode() : 0);
                result = 31 * result + (this.minBufferTimeSeconds != null ? this.minBufferTimeSeconds.hashCode() : 0);
                result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
                result = 31 * result + (this.streamSelection != null ? this.streamSelection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters for a packaging configuration that uses Dynamic Adaptive Streaming over HTTP (DASH) packaging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * DashPackageProperty dashPackageProperty = DashPackageProperty.builder()
     *         .dashManifests(List.of(DashManifestProperty.builder()
     *                 .manifestLayout("manifestLayout")
     *                 .manifestName("manifestName")
     *                 .minBufferTimeSeconds(123)
     *                 .profile("profile")
     *                 .streamSelection(StreamSelectionProperty.builder()
     *                         .maxVideoBitsPerSecond(123)
     *                         .minVideoBitsPerSecond(123)
     *                         .streamOrder("streamOrder")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .encryption(DashEncryptionProperty.builder()
     *                 .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                         .roleArn("roleArn")
     *                         .systemIds(List.of("systemIds"))
     *                         .url("url")
     *                         .build())
     *                 .build())
     *         .includeEncoderConfigurationInSegments(false)
     *         .periodTriggers(List.of("periodTriggers"))
     *         .segmentDurationSeconds(123)
     *         .segmentTemplateFormat("segmentTemplateFormat")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.DashPackageProperty")
    @software.amazon.jsii.Jsii.Proxy(DashPackageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DashPackageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of DASH manifest configurations that are available from this endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDashManifests();

        /**
         * Parameters for encrypting content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment.
         * <p>
         * This lets you use different SPS/PPS/VPS settings for your assets during content playback.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeEncoderConfigurationInSegments() {
            return null;
        }

        /**
         * Controls whether MediaPackage produces single-period or multi-period DASH manifests.
         * <p>
         * For more information about periods, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a> .
         * <p>
         * Valid values:
         * <p>
         * <ul>
         * <li><code>ADS</code> - MediaPackage will produce multi-period DASH manifests. Periods are created based on the SCTE-35 ad markers present in the input manifest.</li>
         * <li><em>No value</em> - MediaPackage will produce single-period DASH manifests. This is the default setting.</li>
         * </ul>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPeriodTriggers() {
            return null;
        }

        /**
         * Duration (in seconds) of each fragment.
         * <p>
         * Actual fragments are rounded to the nearest multiple of the source segment duration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentDurationSeconds() {
            return null;
        }

        /**
         * Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).
         * <p>
         * When set to <code>NUMBER_WITH_TIMELINE</code> , a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to <code>TIME_WITH_TIMELINE</code> , a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to <code>NUMBER_WITH_DURATION</code> , only a duration is included in each SegmentTemplate, with $Number$ media URLs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSegmentTemplateFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DashPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DashPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DashPackageProperty> {
            java.lang.Object dashManifests;
            java.lang.Object encryption;
            java.lang.Object includeEncoderConfigurationInSegments;
            java.util.List<java.lang.String> periodTriggers;
            java.lang.Number segmentDurationSeconds;
            java.lang.String segmentTemplateFormat;

            /**
             * Sets the value of {@link DashPackageProperty#getDashManifests}
             * @param dashManifests A list of DASH manifest configurations that are available from this endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dashManifests(software.amazon.awscdk.IResolvable dashManifests) {
                this.dashManifests = dashManifests;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getDashManifests}
             * @param dashManifests A list of DASH manifest configurations that are available from this endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dashManifests(java.util.List<? extends java.lang.Object> dashManifests) {
                this.dashManifests = dashManifests;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.DashEncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getIncludeEncoderConfigurationInSegments}
             * @param includeEncoderConfigurationInSegments When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment.
             *                                              This lets you use different SPS/PPS/VPS settings for your assets during content playback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeEncoderConfigurationInSegments(java.lang.Boolean includeEncoderConfigurationInSegments) {
                this.includeEncoderConfigurationInSegments = includeEncoderConfigurationInSegments;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getIncludeEncoderConfigurationInSegments}
             * @param includeEncoderConfigurationInSegments When includeEncoderConfigurationInSegments is set to true, MediaPackage places your encoder's Sequence Parameter Set (SPS), Picture Parameter Set (PPS), and Video Parameter Set (VPS) metadata in every video segment instead of in the init fragment.
             *                                              This lets you use different SPS/PPS/VPS settings for your assets during content playback.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeEncoderConfigurationInSegments(software.amazon.awscdk.IResolvable includeEncoderConfigurationInSegments) {
                this.includeEncoderConfigurationInSegments = includeEncoderConfigurationInSegments;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getPeriodTriggers}
             * @param periodTriggers Controls whether MediaPackage produces single-period or multi-period DASH manifests.
             *                       For more information about periods, see <a href="https://docs.aws.amazon.com/mediapackage/latest/ug/multi-period.html">Multi-period DASH in AWS Elemental MediaPackage</a> .
             *                       <p>
             *                       Valid values:
             *                       <p>
             *                       <ul>
             *                       <li><code>ADS</code> - MediaPackage will produce multi-period DASH manifests. Periods are created based on the SCTE-35 ad markers present in the input manifest.</li>
             *                       <li><em>No value</em> - MediaPackage will produce single-period DASH manifests. This is the default setting.</li>
             *                       </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder periodTriggers(java.util.List<java.lang.String> periodTriggers) {
                this.periodTriggers = periodTriggers;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getSegmentDurationSeconds}
             * @param segmentDurationSeconds Duration (in seconds) of each fragment.
             *                               Actual fragments are rounded to the nearest multiple of the source segment duration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDurationSeconds(java.lang.Number segmentDurationSeconds) {
                this.segmentDurationSeconds = segmentDurationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link DashPackageProperty#getSegmentTemplateFormat}
             * @param segmentTemplateFormat Determines the type of SegmentTemplate included in the Media Presentation Description (MPD).
             *                              When set to <code>NUMBER_WITH_TIMELINE</code> , a full timeline is presented in each SegmentTemplate, with $Number$ media URLs. When set to <code>TIME_WITH_TIMELINE</code> , a full timeline is presented in each SegmentTemplate, with $Time$ media URLs. When set to <code>NUMBER_WITH_DURATION</code> , only a duration is included in each SegmentTemplate, with $Number$ media URLs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentTemplateFormat(java.lang.String segmentTemplateFormat) {
                this.segmentTemplateFormat = segmentTemplateFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DashPackageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DashPackageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DashPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DashPackageProperty {
            private final java.lang.Object dashManifests;
            private final java.lang.Object encryption;
            private final java.lang.Object includeEncoderConfigurationInSegments;
            private final java.util.List<java.lang.String> periodTriggers;
            private final java.lang.Number segmentDurationSeconds;
            private final java.lang.String segmentTemplateFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dashManifests = software.amazon.jsii.Kernel.get(this, "dashManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeEncoderConfigurationInSegments = software.amazon.jsii.Kernel.get(this, "includeEncoderConfigurationInSegments", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.periodTriggers = software.amazon.jsii.Kernel.get(this, "periodTriggers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.segmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "segmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.segmentTemplateFormat = software.amazon.jsii.Kernel.get(this, "segmentTemplateFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dashManifests = java.util.Objects.requireNonNull(builder.dashManifests, "dashManifests is required");
                this.encryption = builder.encryption;
                this.includeEncoderConfigurationInSegments = builder.includeEncoderConfigurationInSegments;
                this.periodTriggers = builder.periodTriggers;
                this.segmentDurationSeconds = builder.segmentDurationSeconds;
                this.segmentTemplateFormat = builder.segmentTemplateFormat;
            }

            @Override
            public final java.lang.Object getDashManifests() {
                return this.dashManifests;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.Object getIncludeEncoderConfigurationInSegments() {
                return this.includeEncoderConfigurationInSegments;
            }

            @Override
            public final java.util.List<java.lang.String> getPeriodTriggers() {
                return this.periodTriggers;
            }

            @Override
            public final java.lang.Number getSegmentDurationSeconds() {
                return this.segmentDurationSeconds;
            }

            @Override
            public final java.lang.String getSegmentTemplateFormat() {
                return this.segmentTemplateFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dashManifests", om.valueToTree(this.getDashManifests()));
                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getIncludeEncoderConfigurationInSegments() != null) {
                    data.set("includeEncoderConfigurationInSegments", om.valueToTree(this.getIncludeEncoderConfigurationInSegments()));
                }
                if (this.getPeriodTriggers() != null) {
                    data.set("periodTriggers", om.valueToTree(this.getPeriodTriggers()));
                }
                if (this.getSegmentDurationSeconds() != null) {
                    data.set("segmentDurationSeconds", om.valueToTree(this.getSegmentDurationSeconds()));
                }
                if (this.getSegmentTemplateFormat() != null) {
                    data.set("segmentTemplateFormat", om.valueToTree(this.getSegmentTemplateFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.DashPackageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DashPackageProperty.Jsii$Proxy that = (DashPackageProperty.Jsii$Proxy) o;

                if (!dashManifests.equals(that.dashManifests)) return false;
                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                if (this.includeEncoderConfigurationInSegments != null ? !this.includeEncoderConfigurationInSegments.equals(that.includeEncoderConfigurationInSegments) : that.includeEncoderConfigurationInSegments != null) return false;
                if (this.periodTriggers != null ? !this.periodTriggers.equals(that.periodTriggers) : that.periodTriggers != null) return false;
                if (this.segmentDurationSeconds != null ? !this.segmentDurationSeconds.equals(that.segmentDurationSeconds) : that.segmentDurationSeconds != null) return false;
                return this.segmentTemplateFormat != null ? this.segmentTemplateFormat.equals(that.segmentTemplateFormat) : that.segmentTemplateFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dashManifests.hashCode();
                result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
                result = 31 * result + (this.includeEncoderConfigurationInSegments != null ? this.includeEncoderConfigurationInSegments.hashCode() : 0);
                result = 31 * result + (this.periodTriggers != null ? this.periodTriggers.hashCode() : 0);
                result = 31 * result + (this.segmentDurationSeconds != null ? this.segmentDurationSeconds.hashCode() : 0);
                result = 31 * result + (this.segmentTemplateFormat != null ? this.segmentTemplateFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Holds encryption information so that access to the content can be controlled by a DRM solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * HlsEncryptionProperty hlsEncryptionProperty = HlsEncryptionProperty.builder()
     *         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                 .roleArn("roleArn")
     *                 .systemIds(List.of("systemIds"))
     *                 .url("url")
     *                 .build())
     *         // the properties below are optional
     *         .constantInitializationVector("constantInitializationVector")
     *         .encryptionMethod("encryptionMethod")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.HlsEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for the SPEKE key provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSpekeKeyProvider();

        /**
         * A 128-bit, 16-byte hex value represented by a 32-character string, used with the key for encrypting blocks.
         * <p>
         * If you don't specify a constant initialization vector (IV), MediaPackage periodically rotates the IV.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConstantInitializationVector() {
            return null;
        }

        /**
         * HLS encryption type.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionMethod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsEncryptionProperty> {
            java.lang.Object spekeKeyProvider;
            java.lang.String constantInitializationVector;
            java.lang.String encryptionMethod;

            /**
             * Sets the value of {@link HlsEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.SpekeKeyProviderProperty spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link HlsEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.IResolvable spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link HlsEncryptionProperty#getConstantInitializationVector}
             * @param constantInitializationVector A 128-bit, 16-byte hex value represented by a 32-character string, used with the key for encrypting blocks.
             *                                     If you don't specify a constant initialization vector (IV), MediaPackage periodically rotates the IV.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder constantInitializationVector(java.lang.String constantInitializationVector) {
                this.constantInitializationVector = constantInitializationVector;
                return this;
            }

            /**
             * Sets the value of {@link HlsEncryptionProperty#getEncryptionMethod}
             * @param encryptionMethod HLS encryption type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionMethod(java.lang.String encryptionMethod) {
                this.encryptionMethod = encryptionMethod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsEncryptionProperty {
            private final java.lang.Object spekeKeyProvider;
            private final java.lang.String constantInitializationVector;
            private final java.lang.String encryptionMethod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spekeKeyProvider = software.amazon.jsii.Kernel.get(this, "spekeKeyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.constantInitializationVector = software.amazon.jsii.Kernel.get(this, "constantInitializationVector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encryptionMethod = software.amazon.jsii.Kernel.get(this, "encryptionMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spekeKeyProvider = java.util.Objects.requireNonNull(builder.spekeKeyProvider, "spekeKeyProvider is required");
                this.constantInitializationVector = builder.constantInitializationVector;
                this.encryptionMethod = builder.encryptionMethod;
            }

            @Override
            public final java.lang.Object getSpekeKeyProvider() {
                return this.spekeKeyProvider;
            }

            @Override
            public final java.lang.String getConstantInitializationVector() {
                return this.constantInitializationVector;
            }

            @Override
            public final java.lang.String getEncryptionMethod() {
                return this.encryptionMethod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spekeKeyProvider", om.valueToTree(this.getSpekeKeyProvider()));
                if (this.getConstantInitializationVector() != null) {
                    data.set("constantInitializationVector", om.valueToTree(this.getConstantInitializationVector()));
                }
                if (this.getEncryptionMethod() != null) {
                    data.set("encryptionMethod", om.valueToTree(this.getEncryptionMethod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.HlsEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsEncryptionProperty.Jsii$Proxy that = (HlsEncryptionProperty.Jsii$Proxy) o;

                if (!spekeKeyProvider.equals(that.spekeKeyProvider)) return false;
                if (this.constantInitializationVector != null ? !this.constantInitializationVector.equals(that.constantInitializationVector) : that.constantInitializationVector != null) return false;
                return this.encryptionMethod != null ? this.encryptionMethod.equals(that.encryptionMethod) : that.encryptionMethod == null;
            }

            @Override
            public final int hashCode() {
                int result = this.spekeKeyProvider.hashCode();
                result = 31 * result + (this.constantInitializationVector != null ? this.constantInitializationVector.hashCode() : 0);
                result = 31 * result + (this.encryptionMethod != null ? this.encryptionMethod.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters for an HLS manifest.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * HlsManifestProperty hlsManifestProperty = HlsManifestProperty.builder()
     *         .adMarkers("adMarkers")
     *         .includeIframeOnlyStream(false)
     *         .manifestName("manifestName")
     *         .programDateTimeIntervalSeconds(123)
     *         .repeatExtXKey(false)
     *         .streamSelection(StreamSelectionProperty.builder()
     *                 .maxVideoBitsPerSecond(123)
     *                 .minVideoBitsPerSecond(123)
     *                 .streamOrder("streamOrder")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.HlsManifestProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsManifestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsManifestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This setting controls ad markers in the packaged content.
         * <p>
         * <code>NONE</code> omits SCTE-35 ad markers from the output. <code>PASSTHROUGH</code> copies SCTE-35 ad markers from the source content to the output. <code>SCTE35_ENHANCED</code> generates ad markers and blackout tags in the output, based on SCTE-35 messages in the source content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAdMarkers() {
            return null;
        }

        /**
         * Applies to stream sets with a single video track only.
         * <p>
         * When enabled, the output includes an additional I-frame only stream, along with the other tracks.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeIframeOnlyStream() {
            return null;
        }

        /**
         * A short string that's appended to the end of the endpoint URL to create a unique path to this packaging configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestName() {
            return null;
        }

        /**
         * Inserts `EXT-X-PROGRAM-DATE-TIME` tags in the output manifest at the interval that you specify.
         * <p>
         * Additionally, ID3Timed metadata messages are generated every 5 seconds starting when the content was ingested.
         * <p>
         * Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.
         * <p>
         * Omit this attribute or enter <code>0</code> to indicate that the <code>EXT-X-PROGRAM-DATE-TIME</code> tags are not included in the manifest.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getProgramDateTimeIntervalSeconds() {
            return null;
        }

        /**
         * Repeat the `EXT-X-KEY` directive for every media segment.
         * <p>
         * This might result in an increase in client requests to the DRM server.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRepeatExtXKey() {
            return null;
        }

        /**
         * Video bitrate limitations for outputs from this packaging configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSelection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsManifestProperty> {
            java.lang.String adMarkers;
            java.lang.Object includeIframeOnlyStream;
            java.lang.String manifestName;
            java.lang.Number programDateTimeIntervalSeconds;
            java.lang.Object repeatExtXKey;
            java.lang.Object streamSelection;

            /**
             * Sets the value of {@link HlsManifestProperty#getAdMarkers}
             * @param adMarkers This setting controls ad markers in the packaged content.
             *                  <code>NONE</code> omits SCTE-35 ad markers from the output. <code>PASSTHROUGH</code> copies SCTE-35 ad markers from the source content to the output. <code>SCTE35_ENHANCED</code> generates ad markers and blackout tags in the output, based on SCTE-35 messages in the source content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder adMarkers(java.lang.String adMarkers) {
                this.adMarkers = adMarkers;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getIncludeIframeOnlyStream}
             * @param includeIframeOnlyStream Applies to stream sets with a single video track only.
             *                                When enabled, the output includes an additional I-frame only stream, along with the other tracks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStream(java.lang.Boolean includeIframeOnlyStream) {
                this.includeIframeOnlyStream = includeIframeOnlyStream;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getIncludeIframeOnlyStream}
             * @param includeIframeOnlyStream Applies to stream sets with a single video track only.
             *                                When enabled, the output includes an additional I-frame only stream, along with the other tracks.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeIframeOnlyStream(software.amazon.awscdk.IResolvable includeIframeOnlyStream) {
                this.includeIframeOnlyStream = includeIframeOnlyStream;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getManifestName}
             * @param manifestName A short string that's appended to the end of the endpoint URL to create a unique path to this packaging configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestName(java.lang.String manifestName) {
                this.manifestName = manifestName;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getProgramDateTimeIntervalSeconds}
             * @param programDateTimeIntervalSeconds Inserts `EXT-X-PROGRAM-DATE-TIME` tags in the output manifest at the interval that you specify.
             *                                       Additionally, ID3Timed metadata messages are generated every 5 seconds starting when the content was ingested.
             *                                       <p>
             *                                       Irrespective of this parameter, if any ID3Timed metadata is in the HLS input, it is passed through to the HLS output.
             *                                       <p>
             *                                       Omit this attribute or enter <code>0</code> to indicate that the <code>EXT-X-PROGRAM-DATE-TIME</code> tags are not included in the manifest.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder programDateTimeIntervalSeconds(java.lang.Number programDateTimeIntervalSeconds) {
                this.programDateTimeIntervalSeconds = programDateTimeIntervalSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getRepeatExtXKey}
             * @param repeatExtXKey Repeat the `EXT-X-KEY` directive for every media segment.
             *                      This might result in an increase in client requests to the DRM server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repeatExtXKey(java.lang.Boolean repeatExtXKey) {
                this.repeatExtXKey = repeatExtXKey;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getRepeatExtXKey}
             * @param repeatExtXKey Repeat the `EXT-X-KEY` directive for every media segment.
             *                      This might result in an increase in client requests to the DRM server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repeatExtXKey(software.amazon.awscdk.IResolvable repeatExtXKey) {
                this.repeatExtXKey = repeatExtXKey;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getStreamSelection}
             * @param streamSelection Video bitrate limitations for outputs from this packaging configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.StreamSelectionProperty streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Sets the value of {@link HlsManifestProperty#getStreamSelection}
             * @param streamSelection Video bitrate limitations for outputs from this packaging configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.IResolvable streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsManifestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsManifestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsManifestProperty {
            private final java.lang.String adMarkers;
            private final java.lang.Object includeIframeOnlyStream;
            private final java.lang.String manifestName;
            private final java.lang.Number programDateTimeIntervalSeconds;
            private final java.lang.Object repeatExtXKey;
            private final java.lang.Object streamSelection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.adMarkers = software.amazon.jsii.Kernel.get(this, "adMarkers", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeIframeOnlyStream = software.amazon.jsii.Kernel.get(this, "includeIframeOnlyStream", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.manifestName = software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.programDateTimeIntervalSeconds = software.amazon.jsii.Kernel.get(this, "programDateTimeIntervalSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.repeatExtXKey = software.amazon.jsii.Kernel.get(this, "repeatExtXKey", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.streamSelection = software.amazon.jsii.Kernel.get(this, "streamSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.adMarkers = builder.adMarkers;
                this.includeIframeOnlyStream = builder.includeIframeOnlyStream;
                this.manifestName = builder.manifestName;
                this.programDateTimeIntervalSeconds = builder.programDateTimeIntervalSeconds;
                this.repeatExtXKey = builder.repeatExtXKey;
                this.streamSelection = builder.streamSelection;
            }

            @Override
            public final java.lang.String getAdMarkers() {
                return this.adMarkers;
            }

            @Override
            public final java.lang.Object getIncludeIframeOnlyStream() {
                return this.includeIframeOnlyStream;
            }

            @Override
            public final java.lang.String getManifestName() {
                return this.manifestName;
            }

            @Override
            public final java.lang.Number getProgramDateTimeIntervalSeconds() {
                return this.programDateTimeIntervalSeconds;
            }

            @Override
            public final java.lang.Object getRepeatExtXKey() {
                return this.repeatExtXKey;
            }

            @Override
            public final java.lang.Object getStreamSelection() {
                return this.streamSelection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdMarkers() != null) {
                    data.set("adMarkers", om.valueToTree(this.getAdMarkers()));
                }
                if (this.getIncludeIframeOnlyStream() != null) {
                    data.set("includeIframeOnlyStream", om.valueToTree(this.getIncludeIframeOnlyStream()));
                }
                if (this.getManifestName() != null) {
                    data.set("manifestName", om.valueToTree(this.getManifestName()));
                }
                if (this.getProgramDateTimeIntervalSeconds() != null) {
                    data.set("programDateTimeIntervalSeconds", om.valueToTree(this.getProgramDateTimeIntervalSeconds()));
                }
                if (this.getRepeatExtXKey() != null) {
                    data.set("repeatExtXKey", om.valueToTree(this.getRepeatExtXKey()));
                }
                if (this.getStreamSelection() != null) {
                    data.set("streamSelection", om.valueToTree(this.getStreamSelection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.HlsManifestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsManifestProperty.Jsii$Proxy that = (HlsManifestProperty.Jsii$Proxy) o;

                if (this.adMarkers != null ? !this.adMarkers.equals(that.adMarkers) : that.adMarkers != null) return false;
                if (this.includeIframeOnlyStream != null ? !this.includeIframeOnlyStream.equals(that.includeIframeOnlyStream) : that.includeIframeOnlyStream != null) return false;
                if (this.manifestName != null ? !this.manifestName.equals(that.manifestName) : that.manifestName != null) return false;
                if (this.programDateTimeIntervalSeconds != null ? !this.programDateTimeIntervalSeconds.equals(that.programDateTimeIntervalSeconds) : that.programDateTimeIntervalSeconds != null) return false;
                if (this.repeatExtXKey != null ? !this.repeatExtXKey.equals(that.repeatExtXKey) : that.repeatExtXKey != null) return false;
                return this.streamSelection != null ? this.streamSelection.equals(that.streamSelection) : that.streamSelection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.adMarkers != null ? this.adMarkers.hashCode() : 0;
                result = 31 * result + (this.includeIframeOnlyStream != null ? this.includeIframeOnlyStream.hashCode() : 0);
                result = 31 * result + (this.manifestName != null ? this.manifestName.hashCode() : 0);
                result = 31 * result + (this.programDateTimeIntervalSeconds != null ? this.programDateTimeIntervalSeconds.hashCode() : 0);
                result = 31 * result + (this.repeatExtXKey != null ? this.repeatExtXKey.hashCode() : 0);
                result = 31 * result + (this.streamSelection != null ? this.streamSelection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters for a packaging configuration that uses HTTP Live Streaming (HLS) packaging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * HlsPackageProperty hlsPackageProperty = HlsPackageProperty.builder()
     *         .hlsManifests(List.of(HlsManifestProperty.builder()
     *                 .adMarkers("adMarkers")
     *                 .includeIframeOnlyStream(false)
     *                 .manifestName("manifestName")
     *                 .programDateTimeIntervalSeconds(123)
     *                 .repeatExtXKey(false)
     *                 .streamSelection(StreamSelectionProperty.builder()
     *                         .maxVideoBitsPerSecond(123)
     *                         .minVideoBitsPerSecond(123)
     *                         .streamOrder("streamOrder")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .encryption(HlsEncryptionProperty.builder()
     *                 .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                         .roleArn("roleArn")
     *                         .systemIds(List.of("systemIds"))
     *                         .url("url")
     *                         .build())
     *                 // the properties below are optional
     *                 .constantInitializationVector("constantInitializationVector")
     *                 .encryptionMethod("encryptionMethod")
     *                 .build())
     *         .segmentDurationSeconds(123)
     *         .useAudioRenditionGroup(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.HlsPackageProperty")
    @software.amazon.jsii.Jsii.Proxy(HlsPackageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HlsPackageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of HLS manifest configurations that are available from this endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getHlsManifests();

        /**
         * Parameters for encrypting content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * Duration (in seconds) of each fragment.
         * <p>
         * Actual fragments are rounded to the nearest multiple of the source fragment duration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentDurationSeconds() {
            return null;
        }

        /**
         * When true, AWS Elemental MediaPackage bundles all audio tracks in a rendition group.
         * <p>
         * All other tracks in the stream can be used with any audio rendition from the group.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUseAudioRenditionGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HlsPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HlsPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HlsPackageProperty> {
            java.lang.Object hlsManifests;
            java.lang.Object encryption;
            java.lang.Number segmentDurationSeconds;
            java.lang.Object useAudioRenditionGroup;

            /**
             * Sets the value of {@link HlsPackageProperty#getHlsManifests}
             * @param hlsManifests A list of HLS manifest configurations that are available from this endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsManifests(software.amazon.awscdk.IResolvable hlsManifests) {
                this.hlsManifests = hlsManifests;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getHlsManifests}
             * @param hlsManifests A list of HLS manifest configurations that are available from this endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hlsManifests(java.util.List<? extends java.lang.Object> hlsManifests) {
                this.hlsManifests = hlsManifests;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.HlsEncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getSegmentDurationSeconds}
             * @param segmentDurationSeconds Duration (in seconds) of each fragment.
             *                               Actual fragments are rounded to the nearest multiple of the source fragment duration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDurationSeconds(java.lang.Number segmentDurationSeconds) {
                this.segmentDurationSeconds = segmentDurationSeconds;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getUseAudioRenditionGroup}
             * @param useAudioRenditionGroup When true, AWS Elemental MediaPackage bundles all audio tracks in a rendition group.
             *                               All other tracks in the stream can be used with any audio rendition from the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAudioRenditionGroup(java.lang.Boolean useAudioRenditionGroup) {
                this.useAudioRenditionGroup = useAudioRenditionGroup;
                return this;
            }

            /**
             * Sets the value of {@link HlsPackageProperty#getUseAudioRenditionGroup}
             * @param useAudioRenditionGroup When true, AWS Elemental MediaPackage bundles all audio tracks in a rendition group.
             *                               All other tracks in the stream can be used with any audio rendition from the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder useAudioRenditionGroup(software.amazon.awscdk.IResolvable useAudioRenditionGroup) {
                this.useAudioRenditionGroup = useAudioRenditionGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HlsPackageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HlsPackageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HlsPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HlsPackageProperty {
            private final java.lang.Object hlsManifests;
            private final java.lang.Object encryption;
            private final java.lang.Number segmentDurationSeconds;
            private final java.lang.Object useAudioRenditionGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hlsManifests = software.amazon.jsii.Kernel.get(this, "hlsManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.segmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "segmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.useAudioRenditionGroup = software.amazon.jsii.Kernel.get(this, "useAudioRenditionGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hlsManifests = java.util.Objects.requireNonNull(builder.hlsManifests, "hlsManifests is required");
                this.encryption = builder.encryption;
                this.segmentDurationSeconds = builder.segmentDurationSeconds;
                this.useAudioRenditionGroup = builder.useAudioRenditionGroup;
            }

            @Override
            public final java.lang.Object getHlsManifests() {
                return this.hlsManifests;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.Number getSegmentDurationSeconds() {
                return this.segmentDurationSeconds;
            }

            @Override
            public final java.lang.Object getUseAudioRenditionGroup() {
                return this.useAudioRenditionGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hlsManifests", om.valueToTree(this.getHlsManifests()));
                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getSegmentDurationSeconds() != null) {
                    data.set("segmentDurationSeconds", om.valueToTree(this.getSegmentDurationSeconds()));
                }
                if (this.getUseAudioRenditionGroup() != null) {
                    data.set("useAudioRenditionGroup", om.valueToTree(this.getUseAudioRenditionGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.HlsPackageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HlsPackageProperty.Jsii$Proxy that = (HlsPackageProperty.Jsii$Proxy) o;

                if (!hlsManifests.equals(that.hlsManifests)) return false;
                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                if (this.segmentDurationSeconds != null ? !this.segmentDurationSeconds.equals(that.segmentDurationSeconds) : that.segmentDurationSeconds != null) return false;
                return this.useAudioRenditionGroup != null ? this.useAudioRenditionGroup.equals(that.useAudioRenditionGroup) : that.useAudioRenditionGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.hlsManifests.hashCode();
                result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
                result = 31 * result + (this.segmentDurationSeconds != null ? this.segmentDurationSeconds.hashCode() : 0);
                result = 31 * result + (this.useAudioRenditionGroup != null ? this.useAudioRenditionGroup.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Holds encryption information so that access to the content can be controlled by a DRM solution.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * MssEncryptionProperty mssEncryptionProperty = MssEncryptionProperty.builder()
     *         .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                 .roleArn("roleArn")
     *                 .systemIds(List.of("systemIds"))
     *                 .url("url")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.MssEncryptionProperty")
    @software.amazon.jsii.Jsii.Proxy(MssEncryptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MssEncryptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Parameters for the SPEKE key provider.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSpekeKeyProvider();

        /**
         * @return a {@link Builder} of {@link MssEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MssEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MssEncryptionProperty> {
            java.lang.Object spekeKeyProvider;

            /**
             * Sets the value of {@link MssEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.SpekeKeyProviderProperty spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Sets the value of {@link MssEncryptionProperty#getSpekeKeyProvider}
             * @param spekeKeyProvider Parameters for the SPEKE key provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder spekeKeyProvider(software.amazon.awscdk.IResolvable spekeKeyProvider) {
                this.spekeKeyProvider = spekeKeyProvider;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MssEncryptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MssEncryptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MssEncryptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MssEncryptionProperty {
            private final java.lang.Object spekeKeyProvider;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.spekeKeyProvider = software.amazon.jsii.Kernel.get(this, "spekeKeyProvider", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.spekeKeyProvider = java.util.Objects.requireNonNull(builder.spekeKeyProvider, "spekeKeyProvider is required");
            }

            @Override
            public final java.lang.Object getSpekeKeyProvider() {
                return this.spekeKeyProvider;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("spekeKeyProvider", om.valueToTree(this.getSpekeKeyProvider()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.MssEncryptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MssEncryptionProperty.Jsii$Proxy that = (MssEncryptionProperty.Jsii$Proxy) o;

                return this.spekeKeyProvider.equals(that.spekeKeyProvider);
            }

            @Override
            public final int hashCode() {
                int result = this.spekeKeyProvider.hashCode();
                return result;
            }
        }
    }
    /**
     * Parameters for a Microsoft Smooth manifest.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * MssManifestProperty mssManifestProperty = MssManifestProperty.builder()
     *         .manifestName("manifestName")
     *         .streamSelection(StreamSelectionProperty.builder()
     *                 .maxVideoBitsPerSecond(123)
     *                 .minVideoBitsPerSecond(123)
     *                 .streamOrder("streamOrder")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.MssManifestProperty")
    @software.amazon.jsii.Jsii.Proxy(MssManifestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MssManifestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A short string that's appended to the end of the endpoint URL to create a unique path to this packaging configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestName() {
            return null;
        }

        /**
         * Video bitrate limitations for outputs from this packaging configuration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSelection() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MssManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MssManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MssManifestProperty> {
            java.lang.String manifestName;
            java.lang.Object streamSelection;

            /**
             * Sets the value of {@link MssManifestProperty#getManifestName}
             * @param manifestName A short string that's appended to the end of the endpoint URL to create a unique path to this packaging configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestName(java.lang.String manifestName) {
                this.manifestName = manifestName;
                return this;
            }

            /**
             * Sets the value of {@link MssManifestProperty#getStreamSelection}
             * @param streamSelection Video bitrate limitations for outputs from this packaging configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.StreamSelectionProperty streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Sets the value of {@link MssManifestProperty#getStreamSelection}
             * @param streamSelection Video bitrate limitations for outputs from this packaging configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamSelection(software.amazon.awscdk.IResolvable streamSelection) {
                this.streamSelection = streamSelection;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MssManifestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MssManifestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MssManifestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MssManifestProperty {
            private final java.lang.String manifestName;
            private final java.lang.Object streamSelection;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.manifestName = software.amazon.jsii.Kernel.get(this, "manifestName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.streamSelection = software.amazon.jsii.Kernel.get(this, "streamSelection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.manifestName = builder.manifestName;
                this.streamSelection = builder.streamSelection;
            }

            @Override
            public final java.lang.String getManifestName() {
                return this.manifestName;
            }

            @Override
            public final java.lang.Object getStreamSelection() {
                return this.streamSelection;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getManifestName() != null) {
                    data.set("manifestName", om.valueToTree(this.getManifestName()));
                }
                if (this.getStreamSelection() != null) {
                    data.set("streamSelection", om.valueToTree(this.getStreamSelection()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.MssManifestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MssManifestProperty.Jsii$Proxy that = (MssManifestProperty.Jsii$Proxy) o;

                if (this.manifestName != null ? !this.manifestName.equals(that.manifestName) : that.manifestName != null) return false;
                return this.streamSelection != null ? this.streamSelection.equals(that.streamSelection) : that.streamSelection == null;
            }

            @Override
            public final int hashCode() {
                int result = this.manifestName != null ? this.manifestName.hashCode() : 0;
                result = 31 * result + (this.streamSelection != null ? this.streamSelection.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Parameters for a packaging configuration that uses Microsoft Smooth Streaming (MSS) packaging.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * MssPackageProperty mssPackageProperty = MssPackageProperty.builder()
     *         .mssManifests(List.of(MssManifestProperty.builder()
     *                 .manifestName("manifestName")
     *                 .streamSelection(StreamSelectionProperty.builder()
     *                         .maxVideoBitsPerSecond(123)
     *                         .minVideoBitsPerSecond(123)
     *                         .streamOrder("streamOrder")
     *                         .build())
     *                 .build()))
     *         // the properties below are optional
     *         .encryption(MssEncryptionProperty.builder()
     *                 .spekeKeyProvider(SpekeKeyProviderProperty.builder()
     *                         .roleArn("roleArn")
     *                         .systemIds(List.of("systemIds"))
     *                         .url("url")
     *                         .build())
     *                 .build())
     *         .segmentDurationSeconds(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.MssPackageProperty")
    @software.amazon.jsii.Jsii.Proxy(MssPackageProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MssPackageProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of Microsoft Smooth manifest configurations that are available from this endpoint.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMssManifests();

        /**
         * Parameters for encrypting content.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryption() {
            return null;
        }

        /**
         * Duration (in seconds) of each fragment.
         * <p>
         * Actual fragments are rounded to the nearest multiple of the source fragment duration.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSegmentDurationSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MssPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MssPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MssPackageProperty> {
            java.lang.Object mssManifests;
            java.lang.Object encryption;
            java.lang.Number segmentDurationSeconds;

            /**
             * Sets the value of {@link MssPackageProperty#getMssManifests}
             * @param mssManifests A list of Microsoft Smooth manifest configurations that are available from this endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mssManifests(software.amazon.awscdk.IResolvable mssManifests) {
                this.mssManifests = mssManifests;
                return this;
            }

            /**
             * Sets the value of {@link MssPackageProperty#getMssManifests}
             * @param mssManifests A list of Microsoft Smooth manifest configurations that are available from this endpoint. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mssManifests(java.util.List<? extends java.lang.Object> mssManifests) {
                this.mssManifests = mssManifests;
                return this;
            }

            /**
             * Sets the value of {@link MssPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.MssEncryptionProperty encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link MssPackageProperty#getEncryption}
             * @param encryption Parameters for encrypting content.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryption(software.amazon.awscdk.IResolvable encryption) {
                this.encryption = encryption;
                return this;
            }

            /**
             * Sets the value of {@link MssPackageProperty#getSegmentDurationSeconds}
             * @param segmentDurationSeconds Duration (in seconds) of each fragment.
             *                               Actual fragments are rounded to the nearest multiple of the source fragment duration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder segmentDurationSeconds(java.lang.Number segmentDurationSeconds) {
                this.segmentDurationSeconds = segmentDurationSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MssPackageProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MssPackageProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MssPackageProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MssPackageProperty {
            private final java.lang.Object mssManifests;
            private final java.lang.Object encryption;
            private final java.lang.Number segmentDurationSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.mssManifests = software.amazon.jsii.Kernel.get(this, "mssManifests", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryption = software.amazon.jsii.Kernel.get(this, "encryption", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.segmentDurationSeconds = software.amazon.jsii.Kernel.get(this, "segmentDurationSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.mssManifests = java.util.Objects.requireNonNull(builder.mssManifests, "mssManifests is required");
                this.encryption = builder.encryption;
                this.segmentDurationSeconds = builder.segmentDurationSeconds;
            }

            @Override
            public final java.lang.Object getMssManifests() {
                return this.mssManifests;
            }

            @Override
            public final java.lang.Object getEncryption() {
                return this.encryption;
            }

            @Override
            public final java.lang.Number getSegmentDurationSeconds() {
                return this.segmentDurationSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("mssManifests", om.valueToTree(this.getMssManifests()));
                if (this.getEncryption() != null) {
                    data.set("encryption", om.valueToTree(this.getEncryption()));
                }
                if (this.getSegmentDurationSeconds() != null) {
                    data.set("segmentDurationSeconds", om.valueToTree(this.getSegmentDurationSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.MssPackageProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MssPackageProperty.Jsii$Proxy that = (MssPackageProperty.Jsii$Proxy) o;

                if (!mssManifests.equals(that.mssManifests)) return false;
                if (this.encryption != null ? !this.encryption.equals(that.encryption) : that.encryption != null) return false;
                return this.segmentDurationSeconds != null ? this.segmentDurationSeconds.equals(that.segmentDurationSeconds) : that.segmentDurationSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.mssManifests.hashCode();
                result = 31 * result + (this.encryption != null ? this.encryption.hashCode() : 0);
                result = 31 * result + (this.segmentDurationSeconds != null ? this.segmentDurationSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A configuration for accessing an external Secure Packager and Encoder Key Exchange (SPEKE) service that provides encryption keys.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * SpekeKeyProviderProperty spekeKeyProviderProperty = SpekeKeyProviderProperty.builder()
     *         .roleArn("roleArn")
     *         .systemIds(List.of("systemIds"))
     *         .url("url")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.SpekeKeyProviderProperty")
    @software.amazon.jsii.Jsii.Proxy(SpekeKeyProviderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SpekeKeyProviderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN for the IAM role that's granted by the key provider to provide access to the key provider API.
         * <p>
         * Valid format: arn:aws:iam::{accountID}:role/{name}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * List of unique identifiers for the DRM systems to use, as defined in the CPIX specification.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSystemIds();

        /**
         * URL for the key provider's key retrieval API endpoint.
         * <p>
         * Must start with https://.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getUrl();

        /**
         * @return a {@link Builder} of {@link SpekeKeyProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SpekeKeyProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SpekeKeyProviderProperty> {
            java.lang.String roleArn;
            java.util.List<java.lang.String> systemIds;
            java.lang.String url;

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getRoleArn}
             * @param roleArn The ARN for the IAM role that's granted by the key provider to provide access to the key provider API. This parameter is required.
             *                Valid format: arn:aws:iam::{accountID}:role/{name}
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getSystemIds}
             * @param systemIds List of unique identifiers for the DRM systems to use, as defined in the CPIX specification. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemIds(java.util.List<java.lang.String> systemIds) {
                this.systemIds = systemIds;
                return this;
            }

            /**
             * Sets the value of {@link SpekeKeyProviderProperty#getUrl}
             * @param url URL for the key provider's key retrieval API endpoint. This parameter is required.
             *            Must start with https://.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SpekeKeyProviderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SpekeKeyProviderProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SpekeKeyProviderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SpekeKeyProviderProperty {
            private final java.lang.String roleArn;
            private final java.util.List<java.lang.String> systemIds;
            private final java.lang.String url;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.systemIds = software.amazon.jsii.Kernel.get(this, "systemIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.systemIds = java.util.Objects.requireNonNull(builder.systemIds, "systemIds is required");
                this.url = java.util.Objects.requireNonNull(builder.url, "url is required");
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.util.List<java.lang.String> getSystemIds() {
                return this.systemIds;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("systemIds", om.valueToTree(this.getSystemIds()));
                data.set("url", om.valueToTree(this.getUrl()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.SpekeKeyProviderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SpekeKeyProviderProperty.Jsii$Proxy that = (SpekeKeyProviderProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!systemIds.equals(that.systemIds)) return false;
                return this.url.equals(that.url);
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.systemIds.hashCode());
                result = 31 * result + (this.url.hashCode());
                return result;
            }
        }
    }
    /**
     * Limitations for outputs from the endpoint, based on the video bitrate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mediapackage.*;
     * StreamSelectionProperty streamSelectionProperty = StreamSelectionProperty.builder()
     *         .maxVideoBitsPerSecond(123)
     *         .minVideoBitsPerSecond(123)
     *         .streamOrder("streamOrder")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.StreamSelectionProperty")
    @software.amazon.jsii.Jsii.Proxy(StreamSelectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StreamSelectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The upper limit of the bitrates that this endpoint serves.
         * <p>
         * If the video track exceeds this threshold, then AWS Elemental MediaPackage excludes it from output. If you don't specify a value, it defaults to 2147483647 bits per second.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxVideoBitsPerSecond() {
            return null;
        }

        /**
         * The lower limit of the bitrates that this endpoint serves.
         * <p>
         * If the video track is below this threshold, then AWS Elemental MediaPackage excludes it from output. If you don't specify a value, it defaults to 0 bits per second.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinVideoBitsPerSecond() {
            return null;
        }

        /**
         * Order in which the different video bitrates are presented to the player.
         * <p>
         * Valid values: <code>ORIGINAL</code> , <code>VIDEO_BITRATE_ASCENDING</code> , <code>VIDEO_BITRATE_DESCENDING</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStreamOrder() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StreamSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StreamSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StreamSelectionProperty> {
            java.lang.Number maxVideoBitsPerSecond;
            java.lang.Number minVideoBitsPerSecond;
            java.lang.String streamOrder;

            /**
             * Sets the value of {@link StreamSelectionProperty#getMaxVideoBitsPerSecond}
             * @param maxVideoBitsPerSecond The upper limit of the bitrates that this endpoint serves.
             *                              If the video track exceeds this threshold, then AWS Elemental MediaPackage excludes it from output. If you don't specify a value, it defaults to 2147483647 bits per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxVideoBitsPerSecond(java.lang.Number maxVideoBitsPerSecond) {
                this.maxVideoBitsPerSecond = maxVideoBitsPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link StreamSelectionProperty#getMinVideoBitsPerSecond}
             * @param minVideoBitsPerSecond The lower limit of the bitrates that this endpoint serves.
             *                              If the video track is below this threshold, then AWS Elemental MediaPackage excludes it from output. If you don't specify a value, it defaults to 0 bits per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minVideoBitsPerSecond(java.lang.Number minVideoBitsPerSecond) {
                this.minVideoBitsPerSecond = minVideoBitsPerSecond;
                return this;
            }

            /**
             * Sets the value of {@link StreamSelectionProperty#getStreamOrder}
             * @param streamOrder Order in which the different video bitrates are presented to the player.
             *                    Valid values: <code>ORIGINAL</code> , <code>VIDEO_BITRATE_ASCENDING</code> , <code>VIDEO_BITRATE_DESCENDING</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder streamOrder(java.lang.String streamOrder) {
                this.streamOrder = streamOrder;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StreamSelectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StreamSelectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StreamSelectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StreamSelectionProperty {
            private final java.lang.Number maxVideoBitsPerSecond;
            private final java.lang.Number minVideoBitsPerSecond;
            private final java.lang.String streamOrder;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxVideoBitsPerSecond = software.amazon.jsii.Kernel.get(this, "maxVideoBitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minVideoBitsPerSecond = software.amazon.jsii.Kernel.get(this, "minVideoBitsPerSecond", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.streamOrder = software.amazon.jsii.Kernel.get(this, "streamOrder", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxVideoBitsPerSecond = builder.maxVideoBitsPerSecond;
                this.minVideoBitsPerSecond = builder.minVideoBitsPerSecond;
                this.streamOrder = builder.streamOrder;
            }

            @Override
            public final java.lang.Number getMaxVideoBitsPerSecond() {
                return this.maxVideoBitsPerSecond;
            }

            @Override
            public final java.lang.Number getMinVideoBitsPerSecond() {
                return this.minVideoBitsPerSecond;
            }

            @Override
            public final java.lang.String getStreamOrder() {
                return this.streamOrder;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxVideoBitsPerSecond() != null) {
                    data.set("maxVideoBitsPerSecond", om.valueToTree(this.getMaxVideoBitsPerSecond()));
                }
                if (this.getMinVideoBitsPerSecond() != null) {
                    data.set("minVideoBitsPerSecond", om.valueToTree(this.getMinVideoBitsPerSecond()));
                }
                if (this.getStreamOrder() != null) {
                    data.set("streamOrder", om.valueToTree(this.getStreamOrder()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mediapackage.CfnPackagingConfiguration.StreamSelectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StreamSelectionProperty.Jsii$Proxy that = (StreamSelectionProperty.Jsii$Proxy) o;

                if (this.maxVideoBitsPerSecond != null ? !this.maxVideoBitsPerSecond.equals(that.maxVideoBitsPerSecond) : that.maxVideoBitsPerSecond != null) return false;
                if (this.minVideoBitsPerSecond != null ? !this.minVideoBitsPerSecond.equals(that.minVideoBitsPerSecond) : that.minVideoBitsPerSecond != null) return false;
                return this.streamOrder != null ? this.streamOrder.equals(that.streamOrder) : that.streamOrder == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxVideoBitsPerSecond != null ? this.maxVideoBitsPerSecond.hashCode() : 0;
                result = 31 * result + (this.minVideoBitsPerSecond != null ? this.minVideoBitsPerSecond.hashCode() : 0);
                result = 31 * result + (this.streamOrder != null ? this.streamOrder.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mediapackage.CfnPackagingConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mediapackage.CfnPackagingConfigurationProps.Builder();
        }

        /**
         * Unique identifier that you assign to the packaging configuration.
         * <p>
         * @return {@code this}
         * @param id Unique identifier that you assign to the packaging configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder id(final java.lang.String id) {
            this.props.id(id);
            return this;
        }

        /**
         * The ID of the packaging group associated with this packaging configuration.
         * <p>
         * @return {@code this}
         * @param packagingGroupId The ID of the packaging group associated with this packaging configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packagingGroupId(final java.lang.String packagingGroupId) {
            this.props.packagingGroupId(packagingGroupId);
            return this;
        }

        /**
         * Parameters for CMAF packaging.
         * <p>
         * @return {@code this}
         * @param cmafPackage Parameters for CMAF packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmafPackage(final software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.CmafPackageProperty cmafPackage) {
            this.props.cmafPackage(cmafPackage);
            return this;
        }
        /**
         * Parameters for CMAF packaging.
         * <p>
         * @return {@code this}
         * @param cmafPackage Parameters for CMAF packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cmafPackage(final software.amazon.awscdk.IResolvable cmafPackage) {
            this.props.cmafPackage(cmafPackage);
            return this;
        }

        /**
         * Parameters for DASH-ISO packaging.
         * <p>
         * @return {@code this}
         * @param dashPackage Parameters for DASH-ISO packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashPackage(final software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.DashPackageProperty dashPackage) {
            this.props.dashPackage(dashPackage);
            return this;
        }
        /**
         * Parameters for DASH-ISO packaging.
         * <p>
         * @return {@code this}
         * @param dashPackage Parameters for DASH-ISO packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashPackage(final software.amazon.awscdk.IResolvable dashPackage) {
            this.props.dashPackage(dashPackage);
            return this;
        }

        /**
         * Parameters for Apple HLS packaging.
         * <p>
         * @return {@code this}
         * @param hlsPackage Parameters for Apple HLS packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsPackage(final software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.HlsPackageProperty hlsPackage) {
            this.props.hlsPackage(hlsPackage);
            return this;
        }
        /**
         * Parameters for Apple HLS packaging.
         * <p>
         * @return {@code this}
         * @param hlsPackage Parameters for Apple HLS packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hlsPackage(final software.amazon.awscdk.IResolvable hlsPackage) {
            this.props.hlsPackage(hlsPackage);
            return this;
        }

        /**
         * Parameters for Microsoft Smooth Streaming packaging.
         * <p>
         * @return {@code this}
         * @param mssPackage Parameters for Microsoft Smooth Streaming packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mssPackage(final software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration.MssPackageProperty mssPackage) {
            this.props.mssPackage(mssPackage);
            return this;
        }
        /**
         * Parameters for Microsoft Smooth Streaming packaging.
         * <p>
         * @return {@code this}
         * @param mssPackage Parameters for Microsoft Smooth Streaming packaging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mssPackage(final software.amazon.awscdk.IResolvable mssPackage) {
            this.props.mssPackage(mssPackage);
            return this;
        }

        /**
         * The tags to assign to the packaging configuration.
         * <p>
         * @return {@code this}
         * @param tags The tags to assign to the packaging configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration build() {
            return new software.amazon.awscdk.services.mediapackage.CfnPackagingConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
