package software.amazon.awscdk.services.msk;

/**
 * A CloudFormation `AWS::MSK::Cluster`.
 * <p>
 * The <code>AWS::MSK::Cluster</code> resource creates an Amazon MSK cluster . For more information, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/what-is-msk.html">What Is Amazon MSK?</a> in the <em>Amazon MSK Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.msk.*;
 * CfnCluster cfnCluster = CfnCluster.Builder.create(this, "MyCfnCluster")
 *         .brokerNodeGroupInfo(BrokerNodeGroupInfoProperty.builder()
 *                 .clientSubnets(List.of("clientSubnets"))
 *                 .instanceType("instanceType")
 *                 // the properties below are optional
 *                 .brokerAzDistribution("brokerAzDistribution")
 *                 .connectivityInfo(ConnectivityInfoProperty.builder()
 *                         .publicAccess(PublicAccessProperty.builder()
 *                                 .type("type")
 *                                 .build())
 *                         .build())
 *                 .securityGroups(List.of("securityGroups"))
 *                 .storageInfo(StorageInfoProperty.builder()
 *                         .ebsStorageInfo(EBSStorageInfoProperty.builder()
 *                                 .provisionedThroughput(ProvisionedThroughputProperty.builder()
 *                                         .enabled(false)
 *                                         .volumeThroughput(123)
 *                                         .build())
 *                                 .volumeSize(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .clusterName("clusterName")
 *         .kafkaVersion("kafkaVersion")
 *         .numberOfBrokerNodes(123)
 *         // the properties below are optional
 *         .clientAuthentication(ClientAuthenticationProperty.builder()
 *                 .sasl(SaslProperty.builder()
 *                         .iam(IamProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .scram(ScramProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .build())
 *                 .tls(TlsProperty.builder()
 *                         .certificateAuthorityArnList(List.of("certificateAuthorityArnList"))
 *                         .enabled(false)
 *                         .build())
 *                 .unauthenticated(UnauthenticatedProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .build())
 *         .configurationInfo(ConfigurationInfoProperty.builder()
 *                 .arn("arn")
 *                 .revision(123)
 *                 .build())
 *         .currentVersion("currentVersion")
 *         .encryptionInfo(EncryptionInfoProperty.builder()
 *                 .encryptionAtRest(EncryptionAtRestProperty.builder()
 *                         .dataVolumeKmsKeyId("dataVolumeKmsKeyId")
 *                         .build())
 *                 .encryptionInTransit(EncryptionInTransitProperty.builder()
 *                         .clientBroker("clientBroker")
 *                         .inCluster(false)
 *                         .build())
 *                 .build())
 *         .enhancedMonitoring("enhancedMonitoring")
 *         .loggingInfo(LoggingInfoProperty.builder()
 *                 .brokerLogs(BrokerLogsProperty.builder()
 *                         .cloudWatchLogs(CloudWatchLogsProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .logGroup("logGroup")
 *                                 .build())
 *                         .firehose(FirehoseProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .deliveryStream("deliveryStream")
 *                                 .build())
 *                         .s3(S3Property.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .bucket("bucket")
 *                                 .prefix("prefix")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .openMonitoring(OpenMonitoringProperty.builder()
 *                 .prometheus(PrometheusProperty.builder()
 *                         .jmxExporter(JmxExporterProperty.builder()
 *                                 .enabledInBroker(false)
 *                                 .build())
 *                         .nodeExporter(NodeExporterProperty.builder()
 *                                 .enabledInBroker(false)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:44.922Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster")
public class CfnCluster extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnCluster(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCluster(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.msk.CfnCluster.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::MSK::Cluster`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCluster(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.CfnClusterProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A map of key:value pairs to apply to this resource.
     * <p>
     * Both key and value are of type String.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The setup to be used for brokers in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getBrokerNodeGroupInfo() {
        return software.amazon.jsii.Kernel.get(this, "brokerNodeGroupInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The setup to be used for brokers in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBrokerNodeGroupInfo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.msk.CfnCluster.BrokerNodeGroupInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "brokerNodeGroupInfo", java.util.Objects.requireNonNull(value, "brokerNodeGroupInfo is required"));
    }

    /**
     * The setup to be used for brokers in the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBrokerNodeGroupInfo(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "brokerNodeGroupInfo", java.util.Objects.requireNonNull(value, "brokerNodeGroupInfo is required"));
    }

    /**
     * The name of the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getClusterName() {
        return software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clusterName", java.util.Objects.requireNonNull(value, "clusterName is required"));
    }

    /**
     * The version of Apache Kafka.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/supported-kafka-versions.html">Supported Apache Kafka versions</a> in the Amazon MSK Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKafkaVersion() {
        return software.amazon.jsii.Kernel.get(this, "kafkaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of Apache Kafka.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/supported-kafka-versions.html">Supported Apache Kafka versions</a> in the Amazon MSK Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKafkaVersion(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kafkaVersion", java.util.Objects.requireNonNull(value, "kafkaVersion is required"));
    }

    /**
     * The number of broker nodes you want in the Amazon MSK cluster.
     * <p>
     * You can submit an update to increase the number of broker nodes in a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getNumberOfBrokerNodes() {
        return software.amazon.jsii.Kernel.get(this, "numberOfBrokerNodes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of broker nodes you want in the Amazon MSK cluster.
     * <p>
     * You can submit an update to increase the number of broker nodes in a cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNumberOfBrokerNodes(final @org.jetbrains.annotations.NotNull java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "numberOfBrokerNodes", java.util.Objects.requireNonNull(value, "numberOfBrokerNodes is required"));
    }

    /**
     * Includes information related to client authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClientAuthentication() {
        return software.amazon.jsii.Kernel.get(this, "clientAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Includes information related to client authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.CfnCluster.ClientAuthenticationProperty value) {
        software.amazon.jsii.Kernel.set(this, "clientAuthentication", value);
    }

    /**
     * Includes information related to client authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientAuthentication(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clientAuthentication", value);
    }

    /**
     * The Amazon MSK configuration to use for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationInfo() {
        return software.amazon.jsii.Kernel.get(this, "configurationInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon MSK configuration to use for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.CfnCluster.ConfigurationInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "configurationInfo", value);
    }

    /**
     * The Amazon MSK configuration to use for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigurationInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configurationInfo", value);
    }

    /**
     * The version of the cluster that you want to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCurrentVersion() {
        return software.amazon.jsii.Kernel.get(this, "currentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the cluster that you want to update.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCurrentVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "currentVersion", value);
    }

    /**
     * Includes all encryption-related information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionInfo() {
        return software.amazon.jsii.Kernel.get(this, "encryptionInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Includes all encryption-related information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.CfnCluster.EncryptionInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionInfo", value);
    }

    /**
     * Includes all encryption-related information.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionInfo", value);
    }

    /**
     * Specifies the level of monitoring for the MSK cluster.
     * <p>
     * The possible values are <code>DEFAULT</code> , <code>PER_BROKER</code> , and <code>PER_TOPIC_PER_BROKER</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnhancedMonitoring() {
        return software.amazon.jsii.Kernel.get(this, "enhancedMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the level of monitoring for the MSK cluster.
     * <p>
     * The possible values are <code>DEFAULT</code> , <code>PER_BROKER</code> , and <code>PER_TOPIC_PER_BROKER</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedMonitoring(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "enhancedMonitoring", value);
    }

    /**
     * You can configure your Amazon MSK cluster to send broker logs to different destination types.
     * <p>
     * This is a container for the configuration details related to broker logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoggingInfo() {
        return software.amazon.jsii.Kernel.get(this, "loggingInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * You can configure your Amazon MSK cluster to send broker logs to different destination types.
     * <p>
     * This is a container for the configuration details related to broker logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.CfnCluster.LoggingInfoProperty value) {
        software.amazon.jsii.Kernel.set(this, "loggingInfo", value);
    }

    /**
     * You can configure your Amazon MSK cluster to send broker logs to different destination types.
     * <p>
     * This is a container for the configuration details related to broker logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingInfo(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loggingInfo", value);
    }

    /**
     * The settings for open monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOpenMonitoring() {
        return software.amazon.jsii.Kernel.get(this, "openMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for open monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenMonitoring(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.msk.CfnCluster.OpenMonitoringProperty value) {
        software.amazon.jsii.Kernel.set(this, "openMonitoring", value);
    }

    /**
     * The settings for open monitoring.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOpenMonitoring(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "openMonitoring", value);
    }
    /**
     * You can configure your Amazon MSK cluster to send broker logs to different destination types.
     * <p>
     * This configuration specifies the details of these destinations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * BrokerLogsProperty brokerLogsProperty = BrokerLogsProperty.builder()
     *         .cloudWatchLogs(CloudWatchLogsProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .logGroup("logGroup")
     *                 .build())
     *         .firehose(FirehoseProperty.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .deliveryStream("deliveryStream")
     *                 .build())
     *         .s3(S3Property.builder()
     *                 .enabled(false)
     *                 // the properties below are optional
     *                 .bucket("bucket")
     *                 .prefix("prefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.BrokerLogsProperty")
    @software.amazon.jsii.Jsii.Proxy(BrokerLogsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BrokerLogsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details of the CloudWatch Logs destination for broker logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogs() {
            return null;
        }

        /**
         * Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFirehose() {
            return null;
        }

        /**
         * Details of the Amazon MSK destination for broker logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BrokerLogsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BrokerLogsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BrokerLogsProperty> {
            java.lang.Object cloudWatchLogs;
            java.lang.Object firehose;
            java.lang.Object s3;

            /**
             * Sets the value of {@link BrokerLogsProperty#getCloudWatchLogs}
             * @param cloudWatchLogs Details of the CloudWatch Logs destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.services.msk.CfnCluster.CloudWatchLogsProperty cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link BrokerLogsProperty#getCloudWatchLogs}
             * @param cloudWatchLogs Details of the CloudWatch Logs destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogs(software.amazon.awscdk.IResolvable cloudWatchLogs) {
                this.cloudWatchLogs = cloudWatchLogs;
                return this;
            }

            /**
             * Sets the value of {@link BrokerLogsProperty#getFirehose}
             * @param firehose Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.services.msk.CfnCluster.FirehoseProperty firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link BrokerLogsProperty#getFirehose}
             * @param firehose Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firehose(software.amazon.awscdk.IResolvable firehose) {
                this.firehose = firehose;
                return this;
            }

            /**
             * Sets the value of {@link BrokerLogsProperty#getS3}
             * @param s3 Details of the Amazon MSK destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.msk.CfnCluster.S3Property s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link BrokerLogsProperty#getS3}
             * @param s3 Details of the Amazon MSK destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BrokerLogsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BrokerLogsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BrokerLogsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BrokerLogsProperty {
            private final java.lang.Object cloudWatchLogs;
            private final java.lang.Object firehose;
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogs = software.amazon.jsii.Kernel.get(this, "cloudWatchLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.firehose = software.amazon.jsii.Kernel.get(this, "firehose", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogs = builder.cloudWatchLogs;
                this.firehose = builder.firehose;
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.Object getCloudWatchLogs() {
                return this.cloudWatchLogs;
            }

            @Override
            public final java.lang.Object getFirehose() {
                return this.firehose;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogs() != null) {
                    data.set("cloudWatchLogs", om.valueToTree(this.getCloudWatchLogs()));
                }
                if (this.getFirehose() != null) {
                    data.set("firehose", om.valueToTree(this.getFirehose()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.BrokerLogsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BrokerLogsProperty.Jsii$Proxy that = (BrokerLogsProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogs != null ? !this.cloudWatchLogs.equals(that.cloudWatchLogs) : that.cloudWatchLogs != null) return false;
                if (this.firehose != null ? !this.firehose.equals(that.firehose) : that.firehose != null) return false;
                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogs != null ? this.cloudWatchLogs.hashCode() : 0;
                result = 31 * result + (this.firehose != null ? this.firehose.hashCode() : 0);
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The setup to be used for brokers in the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * BrokerNodeGroupInfoProperty brokerNodeGroupInfoProperty = BrokerNodeGroupInfoProperty.builder()
     *         .clientSubnets(List.of("clientSubnets"))
     *         .instanceType("instanceType")
     *         // the properties below are optional
     *         .brokerAzDistribution("brokerAzDistribution")
     *         .connectivityInfo(ConnectivityInfoProperty.builder()
     *                 .publicAccess(PublicAccessProperty.builder()
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .securityGroups(List.of("securityGroups"))
     *         .storageInfo(StorageInfoProperty.builder()
     *                 .ebsStorageInfo(EBSStorageInfoProperty.builder()
     *                         .provisionedThroughput(ProvisionedThroughputProperty.builder()
     *                                 .enabled(false)
     *                                 .volumeThroughput(123)
     *                                 .build())
     *                         .volumeSize(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.BrokerNodeGroupInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(BrokerNodeGroupInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BrokerNodeGroupInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of subnets to connect to in the client virtual private cloud (VPC).
         * <p>
         * Amazon creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data.
         * <p>
         * Specify exactly two subnets if you are using the US West (N. California) Region. For other Regions where Amazon MSK is available, you can specify either two or three subnets. The subnets that you specify must be in distinct Availability Zones. When you create a cluster, Amazon MSK distributes the broker nodes evenly across the subnets that you specify.
         * <p>
         * Client subnets can't be in Availability Zone us-east-1e.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getClientSubnets();

        /**
         * The type of Amazon EC2 instances to use for brokers.
         * <p>
         * The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.8xlarge, kafka.m5.12xlarge, kafka.m5.16xlarge, and kafka.m5.24xlarge.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getInstanceType();

        /**
         * This parameter is currently not in use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBrokerAzDistribution() {
            return null;
        }

        /**
         * Information about the cluster's connectivity setting.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectivityInfo() {
            return null;
        }

        /**
         * The security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster.
         * <p>
         * If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC. If you specify security groups that were shared with you, you must ensure that you have permissions to them. Specifically, you need the <code>ec2:DescribeSecurityGroups</code> permission.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * Contains information about storage volumes attached to MSK broker nodes.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStorageInfo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link BrokerNodeGroupInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BrokerNodeGroupInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BrokerNodeGroupInfoProperty> {
            java.util.List<java.lang.String> clientSubnets;
            java.lang.String instanceType;
            java.lang.String brokerAzDistribution;
            java.lang.Object connectivityInfo;
            java.util.List<java.lang.String> securityGroups;
            java.lang.Object storageInfo;

            /**
             * Sets the value of {@link BrokerNodeGroupInfoProperty#getClientSubnets}
             * @param clientSubnets The list of subnets to connect to in the client virtual private cloud (VPC). This parameter is required.
             *                      Amazon creates elastic network interfaces inside these subnets. Client applications use elastic network interfaces to produce and consume data.
             *                      <p>
             *                      Specify exactly two subnets if you are using the US West (N. California) Region. For other Regions where Amazon MSK is available, you can specify either two or three subnets. The subnets that you specify must be in distinct Availability Zones. When you create a cluster, Amazon MSK distributes the broker nodes evenly across the subnets that you specify.
             *                      <p>
             *                      Client subnets can't be in Availability Zone us-east-1e.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientSubnets(java.util.List<java.lang.String> clientSubnets) {
                this.clientSubnets = clientSubnets;
                return this;
            }

            /**
             * Sets the value of {@link BrokerNodeGroupInfoProperty#getInstanceType}
             * @param instanceType The type of Amazon EC2 instances to use for brokers. This parameter is required.
             *                     The following instance types are allowed: kafka.m5.large, kafka.m5.xlarge, kafka.m5.2xlarge, kafka.m5.4xlarge, kafka.m5.8xlarge, kafka.m5.12xlarge, kafka.m5.16xlarge, and kafka.m5.24xlarge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link BrokerNodeGroupInfoProperty#getBrokerAzDistribution}
             * @param brokerAzDistribution This parameter is currently not in use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder brokerAzDistribution(java.lang.String brokerAzDistribution) {
                this.brokerAzDistribution = brokerAzDistribution;
                return this;
            }

            /**
             * Sets the value of {@link BrokerNodeGroupInfoProperty#getConnectivityInfo}
             * @param connectivityInfo Information about the cluster's connectivity setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectivityInfo(software.amazon.awscdk.services.msk.CfnCluster.ConnectivityInfoProperty connectivityInfo) {
                this.connectivityInfo = connectivityInfo;
                return this;
            }

            /**
             * Sets the value of {@link BrokerNodeGroupInfoProperty#getConnectivityInfo}
             * @param connectivityInfo Information about the cluster's connectivity setting.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectivityInfo(software.amazon.awscdk.IResolvable connectivityInfo) {
                this.connectivityInfo = connectivityInfo;
                return this;
            }

            /**
             * Sets the value of {@link BrokerNodeGroupInfoProperty#getSecurityGroups}
             * @param securityGroups The security groups to associate with the elastic network interfaces in order to specify who can connect to and communicate with the Amazon MSK cluster.
             *                       If you don't specify a security group, Amazon MSK uses the default security group associated with the VPC. If you specify security groups that were shared with you, you must ensure that you have permissions to them. Specifically, you need the <code>ec2:DescribeSecurityGroups</code> permission.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link BrokerNodeGroupInfoProperty#getStorageInfo}
             * @param storageInfo Contains information about storage volumes attached to MSK broker nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageInfo(software.amazon.awscdk.services.msk.CfnCluster.StorageInfoProperty storageInfo) {
                this.storageInfo = storageInfo;
                return this;
            }

            /**
             * Sets the value of {@link BrokerNodeGroupInfoProperty#getStorageInfo}
             * @param storageInfo Contains information about storage volumes attached to MSK broker nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storageInfo(software.amazon.awscdk.IResolvable storageInfo) {
                this.storageInfo = storageInfo;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BrokerNodeGroupInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BrokerNodeGroupInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BrokerNodeGroupInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BrokerNodeGroupInfoProperty {
            private final java.util.List<java.lang.String> clientSubnets;
            private final java.lang.String instanceType;
            private final java.lang.String brokerAzDistribution;
            private final java.lang.Object connectivityInfo;
            private final java.util.List<java.lang.String> securityGroups;
            private final java.lang.Object storageInfo;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientSubnets = software.amazon.jsii.Kernel.get(this, "clientSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.brokerAzDistribution = software.amazon.jsii.Kernel.get(this, "brokerAzDistribution", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectivityInfo = software.amazon.jsii.Kernel.get(this, "connectivityInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.storageInfo = software.amazon.jsii.Kernel.get(this, "storageInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientSubnets = java.util.Objects.requireNonNull(builder.clientSubnets, "clientSubnets is required");
                this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
                this.brokerAzDistribution = builder.brokerAzDistribution;
                this.connectivityInfo = builder.connectivityInfo;
                this.securityGroups = builder.securityGroups;
                this.storageInfo = builder.storageInfo;
            }

            @Override
            public final java.util.List<java.lang.String> getClientSubnets() {
                return this.clientSubnets;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.String getBrokerAzDistribution() {
                return this.brokerAzDistribution;
            }

            @Override
            public final java.lang.Object getConnectivityInfo() {
                return this.connectivityInfo;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.lang.Object getStorageInfo() {
                return this.storageInfo;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("clientSubnets", om.valueToTree(this.getClientSubnets()));
                data.set("instanceType", om.valueToTree(this.getInstanceType()));
                if (this.getBrokerAzDistribution() != null) {
                    data.set("brokerAzDistribution", om.valueToTree(this.getBrokerAzDistribution()));
                }
                if (this.getConnectivityInfo() != null) {
                    data.set("connectivityInfo", om.valueToTree(this.getConnectivityInfo()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getStorageInfo() != null) {
                    data.set("storageInfo", om.valueToTree(this.getStorageInfo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.BrokerNodeGroupInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BrokerNodeGroupInfoProperty.Jsii$Proxy that = (BrokerNodeGroupInfoProperty.Jsii$Proxy) o;

                if (!clientSubnets.equals(that.clientSubnets)) return false;
                if (!instanceType.equals(that.instanceType)) return false;
                if (this.brokerAzDistribution != null ? !this.brokerAzDistribution.equals(that.brokerAzDistribution) : that.brokerAzDistribution != null) return false;
                if (this.connectivityInfo != null ? !this.connectivityInfo.equals(that.connectivityInfo) : that.connectivityInfo != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                return this.storageInfo != null ? this.storageInfo.equals(that.storageInfo) : that.storageInfo == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientSubnets.hashCode();
                result = 31 * result + (this.instanceType.hashCode());
                result = 31 * result + (this.brokerAzDistribution != null ? this.brokerAzDistribution.hashCode() : 0);
                result = 31 * result + (this.connectivityInfo != null ? this.connectivityInfo.hashCode() : 0);
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.storageInfo != null ? this.storageInfo.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Includes information related to client authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * ClientAuthenticationProperty clientAuthenticationProperty = ClientAuthenticationProperty.builder()
     *         .sasl(SaslProperty.builder()
     *                 .iam(IamProperty.builder()
     *                         .enabled(false)
     *                         .build())
     *                 .scram(ScramProperty.builder()
     *                         .enabled(false)
     *                         .build())
     *                 .build())
     *         .tls(TlsProperty.builder()
     *                 .certificateAuthorityArnList(List.of("certificateAuthorityArnList"))
     *                 .enabled(false)
     *                 .build())
     *         .unauthenticated(UnauthenticatedProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.ClientAuthenticationProperty")
    @software.amazon.jsii.Jsii.Proxy(ClientAuthenticationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClientAuthenticationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details for ClientAuthentication using SASL.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSasl() {
            return null;
        }

        /**
         * Details for client authentication using TLS.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTls() {
            return null;
        }

        /**
         * Details for ClientAuthentication using no authentication.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUnauthenticated() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClientAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClientAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClientAuthenticationProperty> {
            java.lang.Object sasl;
            java.lang.Object tls;
            java.lang.Object unauthenticated;

            /**
             * Sets the value of {@link ClientAuthenticationProperty#getSasl}
             * @param sasl Details for ClientAuthentication using SASL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sasl(software.amazon.awscdk.services.msk.CfnCluster.SaslProperty sasl) {
                this.sasl = sasl;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationProperty#getSasl}
             * @param sasl Details for ClientAuthentication using SASL.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sasl(software.amazon.awscdk.IResolvable sasl) {
                this.sasl = sasl;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationProperty#getTls}
             * @param tls Details for client authentication using TLS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.services.msk.CfnCluster.TlsProperty tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationProperty#getTls}
             * @param tls Details for client authentication using TLS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.IResolvable tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationProperty#getUnauthenticated}
             * @param unauthenticated Details for ClientAuthentication using no authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unauthenticated(software.amazon.awscdk.services.msk.CfnCluster.UnauthenticatedProperty unauthenticated) {
                this.unauthenticated = unauthenticated;
                return this;
            }

            /**
             * Sets the value of {@link ClientAuthenticationProperty#getUnauthenticated}
             * @param unauthenticated Details for ClientAuthentication using no authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unauthenticated(software.amazon.awscdk.IResolvable unauthenticated) {
                this.unauthenticated = unauthenticated;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClientAuthenticationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClientAuthenticationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClientAuthenticationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClientAuthenticationProperty {
            private final java.lang.Object sasl;
            private final java.lang.Object tls;
            private final java.lang.Object unauthenticated;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sasl = software.amazon.jsii.Kernel.get(this, "sasl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.unauthenticated = software.amazon.jsii.Kernel.get(this, "unauthenticated", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sasl = builder.sasl;
                this.tls = builder.tls;
                this.unauthenticated = builder.unauthenticated;
            }

            @Override
            public final java.lang.Object getSasl() {
                return this.sasl;
            }

            @Override
            public final java.lang.Object getTls() {
                return this.tls;
            }

            @Override
            public final java.lang.Object getUnauthenticated() {
                return this.unauthenticated;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSasl() != null) {
                    data.set("sasl", om.valueToTree(this.getSasl()));
                }
                if (this.getTls() != null) {
                    data.set("tls", om.valueToTree(this.getTls()));
                }
                if (this.getUnauthenticated() != null) {
                    data.set("unauthenticated", om.valueToTree(this.getUnauthenticated()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.ClientAuthenticationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClientAuthenticationProperty.Jsii$Proxy that = (ClientAuthenticationProperty.Jsii$Proxy) o;

                if (this.sasl != null ? !this.sasl.equals(that.sasl) : that.sasl != null) return false;
                if (this.tls != null ? !this.tls.equals(that.tls) : that.tls != null) return false;
                return this.unauthenticated != null ? this.unauthenticated.equals(that.unauthenticated) : that.unauthenticated == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sasl != null ? this.sasl.hashCode() : 0;
                result = 31 * result + (this.tls != null ? this.tls.hashCode() : 0);
                result = 31 * result + (this.unauthenticated != null ? this.unauthenticated.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details of the CloudWatch Logs destination for broker logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * CloudWatchLogsProperty cloudWatchLogsProperty = CloudWatchLogsProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .logGroup("logGroup")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.CloudWatchLogsProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether broker logs get sent to the specified CloudWatch Logs destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The CloudWatch Logs group that is the destination for broker logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsProperty> {
            java.lang.Object enabled;
            java.lang.String logGroup;

            /**
             * Sets the value of {@link CloudWatchLogsProperty#getEnabled}
             * @param enabled Specifies whether broker logs get sent to the specified CloudWatch Logs destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsProperty#getEnabled}
             * @param enabled Specifies whether broker logs get sent to the specified CloudWatch Logs destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudWatchLogsProperty#getLogGroup}
             * @param logGroup The CloudWatch Logs group that is the destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroup(java.lang.String logGroup) {
                this.logGroup = logGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String logGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.logGroup = builder.logGroup;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getLogGroup() {
                return this.logGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getLogGroup() != null) {
                    data.set("logGroup", om.valueToTree(this.getLogGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.CloudWatchLogsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsProperty.Jsii$Proxy that = (CloudWatchLogsProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.logGroup != null ? this.logGroup.equals(that.logGroup) : that.logGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the Amazon MSK configuration to use for the brokers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * ConfigurationInfoProperty configurationInfoProperty = ConfigurationInfoProperty.builder()
     *         .arn("arn")
     *         .revision(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.ConfigurationInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigurationInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigurationInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the MSK configuration to use.
         * <p>
         * For example, <code>arn:aws:kafka:us-east-1:123456789012:configuration/example-configuration-name/abcdabcd-1234-abcd-1234-abcd123e8e8e-1</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * The revision of the Amazon MSK configuration to use.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getRevision();

        /**
         * @return a {@link Builder} of {@link ConfigurationInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigurationInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigurationInfoProperty> {
            java.lang.String arn;
            java.lang.Number revision;

            /**
             * Sets the value of {@link ConfigurationInfoProperty#getArn}
             * @param arn The Amazon Resource Name (ARN) of the MSK configuration to use. This parameter is required.
             *            For example, <code>arn:aws:kafka:us-east-1:123456789012:configuration/example-configuration-name/abcdabcd-1234-abcd-1234-abcd123e8e8e-1</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Sets the value of {@link ConfigurationInfoProperty#getRevision}
             * @param revision The revision of the Amazon MSK configuration to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder revision(java.lang.Number revision) {
                this.revision = revision;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigurationInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigurationInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigurationInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigurationInfoProperty {
            private final java.lang.String arn;
            private final java.lang.Number revision;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.revision = software.amazon.jsii.Kernel.get(this, "revision", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
                this.revision = java.util.Objects.requireNonNull(builder.revision, "revision is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            public final java.lang.Number getRevision() {
                return this.revision;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));
                data.set("revision", om.valueToTree(this.getRevision()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.ConfigurationInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigurationInfoProperty.Jsii$Proxy that = (ConfigurationInfoProperty.Jsii$Proxy) o;

                if (!arn.equals(that.arn)) return false;
                return this.revision.equals(that.revision);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                result = 31 * result + (this.revision.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies whether the cluster's brokers are publicly accessible.
     * <p>
     * By default, they are not.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * ConnectivityInfoProperty connectivityInfoProperty = ConnectivityInfoProperty.builder()
     *         .publicAccess(PublicAccessProperty.builder()
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.ConnectivityInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectivityInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectivityInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the cluster's brokers are accessible from the internet.
         * <p>
         * Public access is off by default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPublicAccess() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectivityInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectivityInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectivityInfoProperty> {
            java.lang.Object publicAccess;

            /**
             * Sets the value of {@link ConnectivityInfoProperty#getPublicAccess}
             * @param publicAccess Specifies whether the cluster's brokers are accessible from the internet.
             *                     Public access is off by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publicAccess(software.amazon.awscdk.services.msk.CfnCluster.PublicAccessProperty publicAccess) {
                this.publicAccess = publicAccess;
                return this;
            }

            /**
             * Sets the value of {@link ConnectivityInfoProperty#getPublicAccess}
             * @param publicAccess Specifies whether the cluster's brokers are accessible from the internet.
             *                     Public access is off by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publicAccess(software.amazon.awscdk.IResolvable publicAccess) {
                this.publicAccess = publicAccess;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectivityInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectivityInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectivityInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectivityInfoProperty {
            private final java.lang.Object publicAccess;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.publicAccess = software.amazon.jsii.Kernel.get(this, "publicAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.publicAccess = builder.publicAccess;
            }

            @Override
            public final java.lang.Object getPublicAccess() {
                return this.publicAccess;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPublicAccess() != null) {
                    data.set("publicAccess", om.valueToTree(this.getPublicAccess()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.ConnectivityInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectivityInfoProperty.Jsii$Proxy that = (ConnectivityInfoProperty.Jsii$Proxy) o;

                return this.publicAccess != null ? this.publicAccess.equals(that.publicAccess) : that.publicAccess == null;
            }

            @Override
            public final int hashCode() {
                int result = this.publicAccess != null ? this.publicAccess.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains information about the EBS storage volumes attached to brokers.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * EBSStorageInfoProperty eBSStorageInfoProperty = EBSStorageInfoProperty.builder()
     *         .provisionedThroughput(ProvisionedThroughputProperty.builder()
     *                 .enabled(false)
     *                 .volumeThroughput(123)
     *                 .build())
     *         .volumeSize(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.EBSStorageInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(EBSStorageInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EBSStorageInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether provisioned throughput is turned on and the volume throughput target.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getProvisionedThroughput() {
            return null;
        }

        /**
         * The size in GiB of the EBS volume for the data drive on each broker node.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EBSStorageInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EBSStorageInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EBSStorageInfoProperty> {
            java.lang.Object provisionedThroughput;
            java.lang.Number volumeSize;

            /**
             * Sets the value of {@link EBSStorageInfoProperty#getProvisionedThroughput}
             * @param provisionedThroughput Specifies whether provisioned throughput is turned on and the volume throughput target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedThroughput(software.amazon.awscdk.services.msk.CfnCluster.ProvisionedThroughputProperty provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Sets the value of {@link EBSStorageInfoProperty#getProvisionedThroughput}
             * @param provisionedThroughput Specifies whether provisioned throughput is turned on and the volume throughput target.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder provisionedThroughput(software.amazon.awscdk.IResolvable provisionedThroughput) {
                this.provisionedThroughput = provisionedThroughput;
                return this;
            }

            /**
             * Sets the value of {@link EBSStorageInfoProperty#getVolumeSize}
             * @param volumeSize The size in GiB of the EBS volume for the data drive on each broker node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EBSStorageInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EBSStorageInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EBSStorageInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EBSStorageInfoProperty {
            private final java.lang.Object provisionedThroughput;
            private final java.lang.Number volumeSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.provisionedThroughput = software.amazon.jsii.Kernel.get(this, "provisionedThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.provisionedThroughput = builder.provisionedThroughput;
                this.volumeSize = builder.volumeSize;
            }

            @Override
            public final java.lang.Object getProvisionedThroughput() {
                return this.provisionedThroughput;
            }

            @Override
            public final java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getProvisionedThroughput() != null) {
                    data.set("provisionedThroughput", om.valueToTree(this.getProvisionedThroughput()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.EBSStorageInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EBSStorageInfoProperty.Jsii$Proxy that = (EBSStorageInfoProperty.Jsii$Proxy) o;

                if (this.provisionedThroughput != null ? !this.provisionedThroughput.equals(that.provisionedThroughput) : that.provisionedThroughput != null) return false;
                return this.volumeSize != null ? this.volumeSize.equals(that.volumeSize) : that.volumeSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.provisionedThroughput != null ? this.provisionedThroughput.hashCode() : 0;
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The data volume encryption details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * EncryptionAtRestProperty encryptionAtRestProperty = EncryptionAtRestProperty.builder()
     *         .dataVolumeKmsKeyId("dataVolumeKmsKeyId")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.EncryptionAtRestProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionAtRestProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionAtRestProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the Amazon KMS key for encrypting data at rest.
         * <p>
         * If you don't specify a KMS key, MSK creates one for you and uses it on your behalf.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataVolumeKmsKeyId();

        /**
         * @return a {@link Builder} of {@link EncryptionAtRestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionAtRestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionAtRestProperty> {
            java.lang.String dataVolumeKmsKeyId;

            /**
             * Sets the value of {@link EncryptionAtRestProperty#getDataVolumeKmsKeyId}
             * @param dataVolumeKmsKeyId The ARN of the Amazon KMS key for encrypting data at rest. This parameter is required.
             *                           If you don't specify a KMS key, MSK creates one for you and uses it on your behalf.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataVolumeKmsKeyId(java.lang.String dataVolumeKmsKeyId) {
                this.dataVolumeKmsKeyId = dataVolumeKmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionAtRestProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionAtRestProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionAtRestProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionAtRestProperty {
            private final java.lang.String dataVolumeKmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataVolumeKmsKeyId = software.amazon.jsii.Kernel.get(this, "dataVolumeKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataVolumeKmsKeyId = java.util.Objects.requireNonNull(builder.dataVolumeKmsKeyId, "dataVolumeKmsKeyId is required");
            }

            @Override
            public final java.lang.String getDataVolumeKmsKeyId() {
                return this.dataVolumeKmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dataVolumeKmsKeyId", om.valueToTree(this.getDataVolumeKmsKeyId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.EncryptionAtRestProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionAtRestProperty.Jsii$Proxy that = (EncryptionAtRestProperty.Jsii$Proxy) o;

                return this.dataVolumeKmsKeyId.equals(that.dataVolumeKmsKeyId);
            }

            @Override
            public final int hashCode() {
                int result = this.dataVolumeKmsKeyId.hashCode();
                return result;
            }
        }
    }
    /**
     * The settings for encrypting data in transit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * EncryptionInTransitProperty encryptionInTransitProperty = EncryptionInTransitProperty.builder()
     *         .clientBroker("clientBroker")
     *         .inCluster(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.EncryptionInTransitProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionInTransitProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionInTransitProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates the encryption setting for data in transit between clients and brokers. The following are the possible values.
         * <p>
         * <ul>
         * <li><code>TLS</code> means that client-broker communication is enabled with TLS only.</li>
         * <li><code>TLS_PLAINTEXT</code> means that client-broker communication is enabled for both TLS-encrypted, as well as plain text data.</li>
         * <li><code>PLAINTEXT</code> means that client-broker communication is enabled in plain text only.</li>
         * </ul>
         * <p>
         * The default value is <code>TLS</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getClientBroker() {
            return null;
        }

        /**
         * When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted.
         * <p>
         * When set to false, the communication happens in plain text. The default value is true.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInCluster() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionInTransitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionInTransitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionInTransitProperty> {
            java.lang.String clientBroker;
            java.lang.Object inCluster;

            /**
             * Sets the value of {@link EncryptionInTransitProperty#getClientBroker}
             * @param clientBroker Indicates the encryption setting for data in transit between clients and brokers. The following are the possible values.
             *                     <ul>
             *                     <li><code>TLS</code> means that client-broker communication is enabled with TLS only.</li>
             *                     <li><code>TLS_PLAINTEXT</code> means that client-broker communication is enabled for both TLS-encrypted, as well as plain text data.</li>
             *                     <li><code>PLAINTEXT</code> means that client-broker communication is enabled in plain text only.</li>
             *                     </ul>
             *                     <p>
             *                     The default value is <code>TLS</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientBroker(java.lang.String clientBroker) {
                this.clientBroker = clientBroker;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionInTransitProperty#getInCluster}
             * @param inCluster When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted.
             *                  When set to false, the communication happens in plain text. The default value is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inCluster(java.lang.Boolean inCluster) {
                this.inCluster = inCluster;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionInTransitProperty#getInCluster}
             * @param inCluster When set to true, it indicates that data communication among the broker nodes of the cluster is encrypted.
             *                  When set to false, the communication happens in plain text. The default value is true.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inCluster(software.amazon.awscdk.IResolvable inCluster) {
                this.inCluster = inCluster;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionInTransitProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionInTransitProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionInTransitProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionInTransitProperty {
            private final java.lang.String clientBroker;
            private final java.lang.Object inCluster;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.clientBroker = software.amazon.jsii.Kernel.get(this, "clientBroker", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inCluster = software.amazon.jsii.Kernel.get(this, "inCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.clientBroker = builder.clientBroker;
                this.inCluster = builder.inCluster;
            }

            @Override
            public final java.lang.String getClientBroker() {
                return this.clientBroker;
            }

            @Override
            public final java.lang.Object getInCluster() {
                return this.inCluster;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getClientBroker() != null) {
                    data.set("clientBroker", om.valueToTree(this.getClientBroker()));
                }
                if (this.getInCluster() != null) {
                    data.set("inCluster", om.valueToTree(this.getInCluster()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.EncryptionInTransitProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionInTransitProperty.Jsii$Proxy that = (EncryptionInTransitProperty.Jsii$Proxy) o;

                if (this.clientBroker != null ? !this.clientBroker.equals(that.clientBroker) : that.clientBroker != null) return false;
                return this.inCluster != null ? this.inCluster.equals(that.inCluster) : that.inCluster == null;
            }

            @Override
            public final int hashCode() {
                int result = this.clientBroker != null ? this.clientBroker.hashCode() : 0;
                result = 31 * result + (this.inCluster != null ? this.inCluster.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Includes encryption-related information, such as the Amazon KMS key used for encrypting data at rest and whether you want MSK to encrypt your data in transit.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * EncryptionInfoProperty encryptionInfoProperty = EncryptionInfoProperty.builder()
     *         .encryptionAtRest(EncryptionAtRestProperty.builder()
     *                 .dataVolumeKmsKeyId("dataVolumeKmsKeyId")
     *                 .build())
     *         .encryptionInTransit(EncryptionInTransitProperty.builder()
     *                 .clientBroker("clientBroker")
     *                 .inCluster(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.EncryptionInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data-volume encryption details.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionAtRest() {
            return null;
        }

        /**
         * The details for encryption in transit.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionInTransit() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionInfoProperty> {
            java.lang.Object encryptionAtRest;
            java.lang.Object encryptionInTransit;

            /**
             * Sets the value of {@link EncryptionInfoProperty#getEncryptionAtRest}
             * @param encryptionAtRest The data-volume encryption details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionAtRest(software.amazon.awscdk.services.msk.CfnCluster.EncryptionAtRestProperty encryptionAtRest) {
                this.encryptionAtRest = encryptionAtRest;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionInfoProperty#getEncryptionAtRest}
             * @param encryptionAtRest The data-volume encryption details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionAtRest(software.amazon.awscdk.IResolvable encryptionAtRest) {
                this.encryptionAtRest = encryptionAtRest;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionInfoProperty#getEncryptionInTransit}
             * @param encryptionInTransit The details for encryption in transit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionInTransit(software.amazon.awscdk.services.msk.CfnCluster.EncryptionInTransitProperty encryptionInTransit) {
                this.encryptionInTransit = encryptionInTransit;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionInfoProperty#getEncryptionInTransit}
             * @param encryptionInTransit The details for encryption in transit.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionInTransit(software.amazon.awscdk.IResolvable encryptionInTransit) {
                this.encryptionInTransit = encryptionInTransit;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionInfoProperty {
            private final java.lang.Object encryptionAtRest;
            private final java.lang.Object encryptionInTransit;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.encryptionAtRest = software.amazon.jsii.Kernel.get(this, "encryptionAtRest", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.encryptionInTransit = software.amazon.jsii.Kernel.get(this, "encryptionInTransit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.encryptionAtRest = builder.encryptionAtRest;
                this.encryptionInTransit = builder.encryptionInTransit;
            }

            @Override
            public final java.lang.Object getEncryptionAtRest() {
                return this.encryptionAtRest;
            }

            @Override
            public final java.lang.Object getEncryptionInTransit() {
                return this.encryptionInTransit;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEncryptionAtRest() != null) {
                    data.set("encryptionAtRest", om.valueToTree(this.getEncryptionAtRest()));
                }
                if (this.getEncryptionInTransit() != null) {
                    data.set("encryptionInTransit", om.valueToTree(this.getEncryptionInTransit()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.EncryptionInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionInfoProperty.Jsii$Proxy that = (EncryptionInfoProperty.Jsii$Proxy) o;

                if (this.encryptionAtRest != null ? !this.encryptionAtRest.equals(that.encryptionAtRest) : that.encryptionAtRest != null) return false;
                return this.encryptionInTransit != null ? this.encryptionInTransit.equals(that.encryptionInTransit) : that.encryptionInTransit == null;
            }

            @Override
            public final int hashCode() {
                int result = this.encryptionAtRest != null ? this.encryptionAtRest.hashCode() : 0;
                result = 31 * result + (this.encryptionInTransit != null ? this.encryptionInTransit.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details of the Kinesis Data Firehose delivery stream that is the destination for broker logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * FirehoseProperty firehoseProperty = FirehoseProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .deliveryStream("deliveryStream")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.FirehoseProperty")
    @software.amazon.jsii.Jsii.Proxy(FirehoseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FirehoseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether broker logs get sent to the specified Kinesis Data Firehose delivery stream.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The Kinesis Data Firehose delivery stream that is the destination for broker logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDeliveryStream() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FirehoseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FirehoseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FirehoseProperty> {
            java.lang.Object enabled;
            java.lang.String deliveryStream;

            /**
             * Sets the value of {@link FirehoseProperty#getEnabled}
             * @param enabled Specifies whether broker logs get sent to the specified Kinesis Data Firehose delivery stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseProperty#getEnabled}
             * @param enabled Specifies whether broker logs get sent to the specified Kinesis Data Firehose delivery stream. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link FirehoseProperty#getDeliveryStream}
             * @param deliveryStream The Kinesis Data Firehose delivery stream that is the destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deliveryStream(java.lang.String deliveryStream) {
                this.deliveryStream = deliveryStream;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FirehoseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FirehoseProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FirehoseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FirehoseProperty {
            private final java.lang.Object enabled;
            private final java.lang.String deliveryStream;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deliveryStream = software.amazon.jsii.Kernel.get(this, "deliveryStream", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.deliveryStream = builder.deliveryStream;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getDeliveryStream() {
                return this.deliveryStream;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getDeliveryStream() != null) {
                    data.set("deliveryStream", om.valueToTree(this.getDeliveryStream()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.FirehoseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FirehoseProperty.Jsii$Proxy that = (FirehoseProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                return this.deliveryStream != null ? this.deliveryStream.equals(that.deliveryStream) : that.deliveryStream == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.deliveryStream != null ? this.deliveryStream.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details for IAM access control.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * IamProperty iamProperty = IamProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.IamProperty")
    @software.amazon.jsii.Jsii.Proxy(IamProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IamProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether IAM access control is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link IamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IamProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link IamProperty#getEnabled}
             * @param enabled Whether IAM access control is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link IamProperty#getEnabled}
             * @param enabled Whether IAM access control is enabled. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IamProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IamProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IamProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IamProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.IamProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IamProperty.Jsii$Proxy that = (IamProperty.Jsii$Proxy) o;

                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                return result;
            }
        }
    }
    /**
     * Indicates whether you want to enable or disable the JMX Exporter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * JmxExporterProperty jmxExporterProperty = JmxExporterProperty.builder()
     *         .enabledInBroker(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.JmxExporterProperty")
    @software.amazon.jsii.Jsii.Proxy(JmxExporterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JmxExporterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether you want to enable or disable the JMX Exporter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabledInBroker();

        /**
         * @return a {@link Builder} of {@link JmxExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JmxExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JmxExporterProperty> {
            java.lang.Object enabledInBroker;

            /**
             * Sets the value of {@link JmxExporterProperty#getEnabledInBroker}
             * @param enabledInBroker Indicates whether you want to enable or disable the JMX Exporter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledInBroker(java.lang.Boolean enabledInBroker) {
                this.enabledInBroker = enabledInBroker;
                return this;
            }

            /**
             * Sets the value of {@link JmxExporterProperty#getEnabledInBroker}
             * @param enabledInBroker Indicates whether you want to enable or disable the JMX Exporter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledInBroker(software.amazon.awscdk.IResolvable enabledInBroker) {
                this.enabledInBroker = enabledInBroker;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JmxExporterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JmxExporterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JmxExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JmxExporterProperty {
            private final java.lang.Object enabledInBroker;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabledInBroker = software.amazon.jsii.Kernel.get(this, "enabledInBroker", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabledInBroker = java.util.Objects.requireNonNull(builder.enabledInBroker, "enabledInBroker is required");
            }

            @Override
            public final java.lang.Object getEnabledInBroker() {
                return this.enabledInBroker;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabledInBroker", om.valueToTree(this.getEnabledInBroker()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.JmxExporterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JmxExporterProperty.Jsii$Proxy that = (JmxExporterProperty.Jsii$Proxy) o;

                return this.enabledInBroker.equals(that.enabledInBroker);
            }

            @Override
            public final int hashCode() {
                int result = this.enabledInBroker.hashCode();
                return result;
            }
        }
    }
    /**
     * You can configure your Amazon MSK cluster to send broker logs to different destination types.
     * <p>
     * This is a container for the configuration details related to broker logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * LoggingInfoProperty loggingInfoProperty = LoggingInfoProperty.builder()
     *         .brokerLogs(BrokerLogsProperty.builder()
     *                 .cloudWatchLogs(CloudWatchLogsProperty.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .logGroup("logGroup")
     *                         .build())
     *                 .firehose(FirehoseProperty.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .deliveryStream("deliveryStream")
     *                         .build())
     *                 .s3(S3Property.builder()
     *                         .enabled(false)
     *                         // the properties below are optional
     *                         .bucket("bucket")
     *                         .prefix("prefix")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.LoggingInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * You can configure your Amazon MSK cluster to send broker logs to different destination types.
         * <p>
         * This configuration specifies the details of these destinations.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getBrokerLogs();

        /**
         * @return a {@link Builder} of {@link LoggingInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingInfoProperty> {
            java.lang.Object brokerLogs;

            /**
             * Sets the value of {@link LoggingInfoProperty#getBrokerLogs}
             * @param brokerLogs You can configure your Amazon MSK cluster to send broker logs to different destination types. This parameter is required.
             *                   This configuration specifies the details of these destinations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder brokerLogs(software.amazon.awscdk.services.msk.CfnCluster.BrokerLogsProperty brokerLogs) {
                this.brokerLogs = brokerLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingInfoProperty#getBrokerLogs}
             * @param brokerLogs You can configure your Amazon MSK cluster to send broker logs to different destination types. This parameter is required.
             *                   This configuration specifies the details of these destinations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder brokerLogs(software.amazon.awscdk.IResolvable brokerLogs) {
                this.brokerLogs = brokerLogs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingInfoProperty {
            private final java.lang.Object brokerLogs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.brokerLogs = software.amazon.jsii.Kernel.get(this, "brokerLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.brokerLogs = java.util.Objects.requireNonNull(builder.brokerLogs, "brokerLogs is required");
            }

            @Override
            public final java.lang.Object getBrokerLogs() {
                return this.brokerLogs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("brokerLogs", om.valueToTree(this.getBrokerLogs()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.LoggingInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingInfoProperty.Jsii$Proxy that = (LoggingInfoProperty.Jsii$Proxy) o;

                return this.brokerLogs.equals(that.brokerLogs);
            }

            @Override
            public final int hashCode() {
                int result = this.brokerLogs.hashCode();
                return result;
            }
        }
    }
    /**
     * Indicates whether you want to enable or disable the Node Exporter.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * NodeExporterProperty nodeExporterProperty = NodeExporterProperty.builder()
     *         .enabledInBroker(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.NodeExporterProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeExporterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeExporterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether you want to enable or disable the Node Exporter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabledInBroker();

        /**
         * @return a {@link Builder} of {@link NodeExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeExporterProperty> {
            java.lang.Object enabledInBroker;

            /**
             * Sets the value of {@link NodeExporterProperty#getEnabledInBroker}
             * @param enabledInBroker Indicates whether you want to enable or disable the Node Exporter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledInBroker(java.lang.Boolean enabledInBroker) {
                this.enabledInBroker = enabledInBroker;
                return this;
            }

            /**
             * Sets the value of {@link NodeExporterProperty#getEnabledInBroker}
             * @param enabledInBroker Indicates whether you want to enable or disable the Node Exporter. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledInBroker(software.amazon.awscdk.IResolvable enabledInBroker) {
                this.enabledInBroker = enabledInBroker;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeExporterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeExporterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeExporterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeExporterProperty {
            private final java.lang.Object enabledInBroker;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabledInBroker = software.amazon.jsii.Kernel.get(this, "enabledInBroker", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabledInBroker = java.util.Objects.requireNonNull(builder.enabledInBroker, "enabledInBroker is required");
            }

            @Override
            public final java.lang.Object getEnabledInBroker() {
                return this.enabledInBroker;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabledInBroker", om.valueToTree(this.getEnabledInBroker()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.NodeExporterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeExporterProperty.Jsii$Proxy that = (NodeExporterProperty.Jsii$Proxy) o;

                return this.enabledInBroker.equals(that.enabledInBroker);
            }

            @Override
            public final int hashCode() {
                int result = this.enabledInBroker.hashCode();
                return result;
            }
        }
    }
    /**
     * JMX and Node monitoring for the MSK cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * OpenMonitoringProperty openMonitoringProperty = OpenMonitoringProperty.builder()
     *         .prometheus(PrometheusProperty.builder()
     *                 .jmxExporter(JmxExporterProperty.builder()
     *                         .enabledInBroker(false)
     *                         .build())
     *                 .nodeExporter(NodeExporterProperty.builder()
     *                         .enabledInBroker(false)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.OpenMonitoringProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenMonitoringProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenMonitoringProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Prometheus exporter settings.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrometheus();

        /**
         * @return a {@link Builder} of {@link OpenMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenMonitoringProperty> {
            java.lang.Object prometheus;

            /**
             * Sets the value of {@link OpenMonitoringProperty#getPrometheus}
             * @param prometheus Prometheus exporter settings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prometheus(software.amazon.awscdk.services.msk.CfnCluster.PrometheusProperty prometheus) {
                this.prometheus = prometheus;
                return this;
            }

            /**
             * Sets the value of {@link OpenMonitoringProperty#getPrometheus}
             * @param prometheus Prometheus exporter settings. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prometheus(software.amazon.awscdk.IResolvable prometheus) {
                this.prometheus = prometheus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenMonitoringProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenMonitoringProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenMonitoringProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenMonitoringProperty {
            private final java.lang.Object prometheus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prometheus = software.amazon.jsii.Kernel.get(this, "prometheus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prometheus = java.util.Objects.requireNonNull(builder.prometheus, "prometheus is required");
            }

            @Override
            public final java.lang.Object getPrometheus() {
                return this.prometheus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("prometheus", om.valueToTree(this.getPrometheus()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.OpenMonitoringProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenMonitoringProperty.Jsii$Proxy that = (OpenMonitoringProperty.Jsii$Proxy) o;

                return this.prometheus.equals(that.prometheus);
            }

            @Override
            public final int hashCode() {
                int result = this.prometheus.hashCode();
                return result;
            }
        }
    }
    /**
     * Prometheus settings for open monitoring.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * PrometheusProperty prometheusProperty = PrometheusProperty.builder()
     *         .jmxExporter(JmxExporterProperty.builder()
     *                 .enabledInBroker(false)
     *                 .build())
     *         .nodeExporter(NodeExporterProperty.builder()
     *                 .enabledInBroker(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.PrometheusProperty")
    @software.amazon.jsii.Jsii.Proxy(PrometheusProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrometheusProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether you want to enable or disable the JMX Exporter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJmxExporter() {
            return null;
        }

        /**
         * Indicates whether you want to enable or disable the Node Exporter.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNodeExporter() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrometheusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrometheusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrometheusProperty> {
            java.lang.Object jmxExporter;
            java.lang.Object nodeExporter;

            /**
             * Sets the value of {@link PrometheusProperty#getJmxExporter}
             * @param jmxExporter Indicates whether you want to enable or disable the JMX Exporter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jmxExporter(software.amazon.awscdk.services.msk.CfnCluster.JmxExporterProperty jmxExporter) {
                this.jmxExporter = jmxExporter;
                return this;
            }

            /**
             * Sets the value of {@link PrometheusProperty#getJmxExporter}
             * @param jmxExporter Indicates whether you want to enable or disable the JMX Exporter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jmxExporter(software.amazon.awscdk.IResolvable jmxExporter) {
                this.jmxExporter = jmxExporter;
                return this;
            }

            /**
             * Sets the value of {@link PrometheusProperty#getNodeExporter}
             * @param nodeExporter Indicates whether you want to enable or disable the Node Exporter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeExporter(software.amazon.awscdk.services.msk.CfnCluster.NodeExporterProperty nodeExporter) {
                this.nodeExporter = nodeExporter;
                return this;
            }

            /**
             * Sets the value of {@link PrometheusProperty#getNodeExporter}
             * @param nodeExporter Indicates whether you want to enable or disable the Node Exporter.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeExporter(software.amazon.awscdk.IResolvable nodeExporter) {
                this.nodeExporter = nodeExporter;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrometheusProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrometheusProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrometheusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrometheusProperty {
            private final java.lang.Object jmxExporter;
            private final java.lang.Object nodeExporter;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.jmxExporter = software.amazon.jsii.Kernel.get(this, "jmxExporter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nodeExporter = software.amazon.jsii.Kernel.get(this, "nodeExporter", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.jmxExporter = builder.jmxExporter;
                this.nodeExporter = builder.nodeExporter;
            }

            @Override
            public final java.lang.Object getJmxExporter() {
                return this.jmxExporter;
            }

            @Override
            public final java.lang.Object getNodeExporter() {
                return this.nodeExporter;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getJmxExporter() != null) {
                    data.set("jmxExporter", om.valueToTree(this.getJmxExporter()));
                }
                if (this.getNodeExporter() != null) {
                    data.set("nodeExporter", om.valueToTree(this.getNodeExporter()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.PrometheusProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrometheusProperty.Jsii$Proxy that = (PrometheusProperty.Jsii$Proxy) o;

                if (this.jmxExporter != null ? !this.jmxExporter.equals(that.jmxExporter) : that.jmxExporter != null) return false;
                return this.nodeExporter != null ? this.nodeExporter.equals(that.nodeExporter) : that.nodeExporter == null;
            }

            @Override
            public final int hashCode() {
                int result = this.jmxExporter != null ? this.jmxExporter.hashCode() : 0;
                result = 31 * result + (this.nodeExporter != null ? this.nodeExporter.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies whether provisioned throughput is turned on and the volume throughput target.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * ProvisionedThroughputProperty provisionedThroughputProperty = ProvisionedThroughputProperty.builder()
     *         .enabled(false)
     *         .volumeThroughput(123)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.ProvisionedThroughputProperty")
    @software.amazon.jsii.Jsii.Proxy(ProvisionedThroughputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ProvisionedThroughputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether provisioned throughput is turned on for the cluster.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The provisioned throughput rate in MiB per second.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeThroughput() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ProvisionedThroughputProperty> {
            java.lang.Object enabled;
            java.lang.Number volumeThroughput;

            /**
             * Sets the value of {@link ProvisionedThroughputProperty#getEnabled}
             * @param enabled Specifies whether provisioned throughput is turned on for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ProvisionedThroughputProperty#getEnabled}
             * @param enabled Specifies whether provisioned throughput is turned on for the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ProvisionedThroughputProperty#getVolumeThroughput}
             * @param volumeThroughput The provisioned throughput rate in MiB per second.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeThroughput(java.lang.Number volumeThroughput) {
                this.volumeThroughput = volumeThroughput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ProvisionedThroughputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ProvisionedThroughputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ProvisionedThroughputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ProvisionedThroughputProperty {
            private final java.lang.Object enabled;
            private final java.lang.Number volumeThroughput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.volumeThroughput = software.amazon.jsii.Kernel.get(this, "volumeThroughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.volumeThroughput = builder.volumeThroughput;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Number getVolumeThroughput() {
                return this.volumeThroughput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getVolumeThroughput() != null) {
                    data.set("volumeThroughput", om.valueToTree(this.getVolumeThroughput()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.ProvisionedThroughputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ProvisionedThroughputProperty.Jsii$Proxy that = (ProvisionedThroughputProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.volumeThroughput != null ? this.volumeThroughput.equals(that.volumeThroughput) : that.volumeThroughput == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.volumeThroughput != null ? this.volumeThroughput.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies whether the cluster's brokers are accessible from the internet.
     * <p>
     * Public access is off by default.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * PublicAccessProperty publicAccessProperty = PublicAccessProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.PublicAccessProperty")
    @software.amazon.jsii.Jsii.Proxy(PublicAccessProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PublicAccessProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Set to `DISABLED` to turn off public access or to `SERVICE_PROVIDED_EIPS` to turn it on.
         * <p>
         * Public access if off by default.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PublicAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PublicAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PublicAccessProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link PublicAccessProperty#getType}
             * @param type Set to `DISABLED` to turn off public access or to `SERVICE_PROVIDED_EIPS` to turn it on.
             *             Public access if off by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PublicAccessProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PublicAccessProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PublicAccessProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PublicAccessProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.PublicAccessProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PublicAccessProperty.Jsii$Proxy that = (PublicAccessProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The details of the Amazon S3 destination for broker logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * S3Property s3Property = S3Property.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .bucket("bucket")
     *         .prefix("prefix")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.S3Property")
    @software.amazon.jsii.Jsii.Proxy(S3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether broker logs get sent to the specified Amazon S3 destination.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The name of the S3 bucket that is the destination for broker logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucket() {
            return null;
        }

        /**
         * The S3 prefix that is the destination for broker logs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3Property> {
            java.lang.Object enabled;
            java.lang.String bucket;
            java.lang.String prefix;

            /**
             * Sets the value of {@link S3Property#getEnabled}
             * @param enabled Specifies whether broker logs get sent to the specified Amazon S3 destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getEnabled}
             * @param enabled Specifies whether broker logs get sent to the specified Amazon S3 destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getBucket}
             * @param bucket The name of the S3 bucket that is the destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getPrefix}
             * @param prefix The S3 prefix that is the destination for broker logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3Property {
            private final java.lang.Object enabled;
            private final java.lang.String bucket;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.bucket = builder.bucket;
                this.prefix = builder.prefix;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getBucket() != null) {
                    data.set("bucket", om.valueToTree(this.getBucket()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.S3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3Property.Jsii$Proxy that = (S3Property.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details for client authentication using SASL.
     * <p>
     * To turn on SASL, you must also turn on <code>EncryptionInTransit</code> by setting <code>inCluster</code> to true. You must set <code>clientBroker</code> to either <code>TLS</code> or <code>TLS_PLAINTEXT</code> . If you choose <code>TLS_PLAINTEXT</code> , then you must also set <code>unauthenticated</code> to true.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * SaslProperty saslProperty = SaslProperty.builder()
     *         .iam(IamProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .scram(ScramProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.SaslProperty")
    @software.amazon.jsii.Jsii.Proxy(SaslProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SaslProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Details for IAM access control.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIam() {
            return null;
        }

        /**
         * Details for SASL/SCRAM client authentication.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getScram() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SaslProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SaslProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SaslProperty> {
            java.lang.Object iam;
            java.lang.Object scram;

            /**
             * Sets the value of {@link SaslProperty#getIam}
             * @param iam Details for IAM access control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iam(software.amazon.awscdk.services.msk.CfnCluster.IamProperty iam) {
                this.iam = iam;
                return this;
            }

            /**
             * Sets the value of {@link SaslProperty#getIam}
             * @param iam Details for IAM access control.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iam(software.amazon.awscdk.IResolvable iam) {
                this.iam = iam;
                return this;
            }

            /**
             * Sets the value of {@link SaslProperty#getScram}
             * @param scram Details for SASL/SCRAM client authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scram(software.amazon.awscdk.services.msk.CfnCluster.ScramProperty scram) {
                this.scram = scram;
                return this;
            }

            /**
             * Sets the value of {@link SaslProperty#getScram}
             * @param scram Details for SASL/SCRAM client authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scram(software.amazon.awscdk.IResolvable scram) {
                this.scram = scram;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SaslProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SaslProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SaslProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SaslProperty {
            private final java.lang.Object iam;
            private final java.lang.Object scram;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.iam = software.amazon.jsii.Kernel.get(this, "iam", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.scram = software.amazon.jsii.Kernel.get(this, "scram", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.iam = builder.iam;
                this.scram = builder.scram;
            }

            @Override
            public final java.lang.Object getIam() {
                return this.iam;
            }

            @Override
            public final java.lang.Object getScram() {
                return this.scram;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIam() != null) {
                    data.set("iam", om.valueToTree(this.getIam()));
                }
                if (this.getScram() != null) {
                    data.set("scram", om.valueToTree(this.getScram()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.SaslProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SaslProperty.Jsii$Proxy that = (SaslProperty.Jsii$Proxy) o;

                if (this.iam != null ? !this.iam.equals(that.iam) : that.iam != null) return false;
                return this.scram != null ? this.scram.equals(that.scram) : that.scram == null;
            }

            @Override
            public final int hashCode() {
                int result = this.iam != null ? this.iam.hashCode() : 0;
                result = 31 * result + (this.scram != null ? this.scram.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details for SASL/SCRAM client authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * ScramProperty scramProperty = ScramProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.ScramProperty")
    @software.amazon.jsii.Jsii.Proxy(ScramProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScramProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * SASL/SCRAM authentication is enabled or not.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link ScramProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScramProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScramProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link ScramProperty#getEnabled}
             * @param enabled SASL/SCRAM authentication is enabled or not. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ScramProperty#getEnabled}
             * @param enabled SASL/SCRAM authentication is enabled or not. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScramProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScramProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScramProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScramProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.ScramProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScramProperty.Jsii$Proxy that = (ScramProperty.Jsii$Proxy) o;

                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains information about storage volumes attached to MSK broker nodes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * StorageInfoProperty storageInfoProperty = StorageInfoProperty.builder()
     *         .ebsStorageInfo(EBSStorageInfoProperty.builder()
     *                 .provisionedThroughput(ProvisionedThroughputProperty.builder()
     *                         .enabled(false)
     *                         .volumeThroughput(123)
     *                         .build())
     *                 .volumeSize(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.StorageInfoProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageInfoProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageInfoProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * EBS volume information.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsStorageInfo() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageInfoProperty> {
            java.lang.Object ebsStorageInfo;

            /**
             * Sets the value of {@link StorageInfoProperty#getEbsStorageInfo}
             * @param ebsStorageInfo EBS volume information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsStorageInfo(software.amazon.awscdk.services.msk.CfnCluster.EBSStorageInfoProperty ebsStorageInfo) {
                this.ebsStorageInfo = ebsStorageInfo;
                return this;
            }

            /**
             * Sets the value of {@link StorageInfoProperty#getEbsStorageInfo}
             * @param ebsStorageInfo EBS volume information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsStorageInfo(software.amazon.awscdk.IResolvable ebsStorageInfo) {
                this.ebsStorageInfo = ebsStorageInfo;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageInfoProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageInfoProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageInfoProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageInfoProperty {
            private final java.lang.Object ebsStorageInfo;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsStorageInfo = software.amazon.jsii.Kernel.get(this, "ebsStorageInfo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsStorageInfo = builder.ebsStorageInfo;
            }

            @Override
            public final java.lang.Object getEbsStorageInfo() {
                return this.ebsStorageInfo;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsStorageInfo() != null) {
                    data.set("ebsStorageInfo", om.valueToTree(this.getEbsStorageInfo()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.StorageInfoProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageInfoProperty.Jsii$Proxy that = (StorageInfoProperty.Jsii$Proxy) o;

                return this.ebsStorageInfo != null ? this.ebsStorageInfo.equals(that.ebsStorageInfo) : that.ebsStorageInfo == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsStorageInfo != null ? this.ebsStorageInfo.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Details for client authentication using TLS.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * TlsProperty tlsProperty = TlsProperty.builder()
     *         .certificateAuthorityArnList(List.of("certificateAuthorityArnList"))
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.TlsProperty")
    @software.amazon.jsii.Jsii.Proxy(TlsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TlsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * List of ACM Certificate Authority ARNs.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCertificateAuthorityArnList() {
            return null;
        }

        /**
         * TLS authentication is enabled or not.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TlsProperty> {
            java.util.List<java.lang.String> certificateAuthorityArnList;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link TlsProperty#getCertificateAuthorityArnList}
             * @param certificateAuthorityArnList List of ACM Certificate Authority ARNs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder certificateAuthorityArnList(java.util.List<java.lang.String> certificateAuthorityArnList) {
                this.certificateAuthorityArnList = certificateAuthorityArnList;
                return this;
            }

            /**
             * Sets the value of {@link TlsProperty#getEnabled}
             * @param enabled TLS authentication is enabled or not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TlsProperty#getEnabled}
             * @param enabled TLS authentication is enabled or not.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TlsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TlsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TlsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TlsProperty {
            private final java.util.List<java.lang.String> certificateAuthorityArnList;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.certificateAuthorityArnList = software.amazon.jsii.Kernel.get(this, "certificateAuthorityArnList", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateAuthorityArnList = builder.certificateAuthorityArnList;
                this.enabled = builder.enabled;
            }

            @Override
            public final java.util.List<java.lang.String> getCertificateAuthorityArnList() {
                return this.certificateAuthorityArnList;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCertificateAuthorityArnList() != null) {
                    data.set("certificateAuthorityArnList", om.valueToTree(this.getCertificateAuthorityArnList()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.TlsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TlsProperty.Jsii$Proxy that = (TlsProperty.Jsii$Proxy) o;

                if (this.certificateAuthorityArnList != null ? !this.certificateAuthorityArnList.equals(that.certificateAuthorityArnList) : that.certificateAuthorityArnList != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.certificateAuthorityArnList != null ? this.certificateAuthorityArnList.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Details for allowing no client authentication.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.msk.*;
     * UnauthenticatedProperty unauthenticatedProperty = UnauthenticatedProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_msk.CfnCluster.UnauthenticatedProperty")
    @software.amazon.jsii.Jsii.Proxy(UnauthenticatedProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UnauthenticatedProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Unauthenticated is enabled or not.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * @return a {@link Builder} of {@link UnauthenticatedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UnauthenticatedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UnauthenticatedProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link UnauthenticatedProperty#getEnabled}
             * @param enabled Unauthenticated is enabled or not. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link UnauthenticatedProperty#getEnabled}
             * @param enabled Unauthenticated is enabled or not. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UnauthenticatedProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UnauthenticatedProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UnauthenticatedProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UnauthenticatedProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_msk.CfnCluster.UnauthenticatedProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UnauthenticatedProperty.Jsii$Proxy that = (UnauthenticatedProperty.Jsii$Proxy) o;

                return this.enabled.equals(that.enabled);
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.msk.CfnCluster}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.msk.CfnCluster> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.msk.CfnClusterProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.msk.CfnClusterProps.Builder();
        }

        /**
         * The setup to be used for brokers in the cluster.
         * <p>
         * @return {@code this}
         * @param brokerNodeGroupInfo The setup to be used for brokers in the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder brokerNodeGroupInfo(final software.amazon.awscdk.services.msk.CfnCluster.BrokerNodeGroupInfoProperty brokerNodeGroupInfo) {
            this.props.brokerNodeGroupInfo(brokerNodeGroupInfo);
            return this;
        }
        /**
         * The setup to be used for brokers in the cluster.
         * <p>
         * @return {@code this}
         * @param brokerNodeGroupInfo The setup to be used for brokers in the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder brokerNodeGroupInfo(final software.amazon.awscdk.IResolvable brokerNodeGroupInfo) {
            this.props.brokerNodeGroupInfo(brokerNodeGroupInfo);
            return this;
        }

        /**
         * The name of the cluster.
         * <p>
         * @return {@code this}
         * @param clusterName The name of the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(final java.lang.String clusterName) {
            this.props.clusterName(clusterName);
            return this;
        }

        /**
         * The version of Apache Kafka.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/msk/latest/developerguide/supported-kafka-versions.html">Supported Apache Kafka versions</a> in the Amazon MSK Developer Guide.
         * <p>
         * @return {@code this}
         * @param kafkaVersion The version of Apache Kafka. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaVersion(final java.lang.String kafkaVersion) {
            this.props.kafkaVersion(kafkaVersion);
            return this;
        }

        /**
         * The number of broker nodes you want in the Amazon MSK cluster.
         * <p>
         * You can submit an update to increase the number of broker nodes in a cluster.
         * <p>
         * @return {@code this}
         * @param numberOfBrokerNodes The number of broker nodes you want in the Amazon MSK cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder numberOfBrokerNodes(final java.lang.Number numberOfBrokerNodes) {
            this.props.numberOfBrokerNodes(numberOfBrokerNodes);
            return this;
        }

        /**
         * Includes information related to client authentication.
         * <p>
         * @return {@code this}
         * @param clientAuthentication Includes information related to client authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientAuthentication(final software.amazon.awscdk.services.msk.CfnCluster.ClientAuthenticationProperty clientAuthentication) {
            this.props.clientAuthentication(clientAuthentication);
            return this;
        }
        /**
         * Includes information related to client authentication.
         * <p>
         * @return {@code this}
         * @param clientAuthentication Includes information related to client authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientAuthentication(final software.amazon.awscdk.IResolvable clientAuthentication) {
            this.props.clientAuthentication(clientAuthentication);
            return this;
        }

        /**
         * The Amazon MSK configuration to use for the cluster.
         * <p>
         * @return {@code this}
         * @param configurationInfo The Amazon MSK configuration to use for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationInfo(final software.amazon.awscdk.services.msk.CfnCluster.ConfigurationInfoProperty configurationInfo) {
            this.props.configurationInfo(configurationInfo);
            return this;
        }
        /**
         * The Amazon MSK configuration to use for the cluster.
         * <p>
         * @return {@code this}
         * @param configurationInfo The Amazon MSK configuration to use for the cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configurationInfo(final software.amazon.awscdk.IResolvable configurationInfo) {
            this.props.configurationInfo(configurationInfo);
            return this;
        }

        /**
         * The version of the cluster that you want to update.
         * <p>
         * @return {@code this}
         * @param currentVersion The version of the cluster that you want to update. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder currentVersion(final java.lang.String currentVersion) {
            this.props.currentVersion(currentVersion);
            return this;
        }

        /**
         * Includes all encryption-related information.
         * <p>
         * @return {@code this}
         * @param encryptionInfo Includes all encryption-related information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionInfo(final software.amazon.awscdk.services.msk.CfnCluster.EncryptionInfoProperty encryptionInfo) {
            this.props.encryptionInfo(encryptionInfo);
            return this;
        }
        /**
         * Includes all encryption-related information.
         * <p>
         * @return {@code this}
         * @param encryptionInfo Includes all encryption-related information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionInfo(final software.amazon.awscdk.IResolvable encryptionInfo) {
            this.props.encryptionInfo(encryptionInfo);
            return this;
        }

        /**
         * Specifies the level of monitoring for the MSK cluster.
         * <p>
         * The possible values are <code>DEFAULT</code> , <code>PER_BROKER</code> , and <code>PER_TOPIC_PER_BROKER</code> .
         * <p>
         * @return {@code this}
         * @param enhancedMonitoring Specifies the level of monitoring for the MSK cluster. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedMonitoring(final java.lang.String enhancedMonitoring) {
            this.props.enhancedMonitoring(enhancedMonitoring);
            return this;
        }

        /**
         * You can configure your Amazon MSK cluster to send broker logs to different destination types.
         * <p>
         * This is a container for the configuration details related to broker logs.
         * <p>
         * @return {@code this}
         * @param loggingInfo You can configure your Amazon MSK cluster to send broker logs to different destination types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingInfo(final software.amazon.awscdk.services.msk.CfnCluster.LoggingInfoProperty loggingInfo) {
            this.props.loggingInfo(loggingInfo);
            return this;
        }
        /**
         * You can configure your Amazon MSK cluster to send broker logs to different destination types.
         * <p>
         * This is a container for the configuration details related to broker logs.
         * <p>
         * @return {@code this}
         * @param loggingInfo You can configure your Amazon MSK cluster to send broker logs to different destination types. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingInfo(final software.amazon.awscdk.IResolvable loggingInfo) {
            this.props.loggingInfo(loggingInfo);
            return this;
        }

        /**
         * The settings for open monitoring.
         * <p>
         * @return {@code this}
         * @param openMonitoring The settings for open monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openMonitoring(final software.amazon.awscdk.services.msk.CfnCluster.OpenMonitoringProperty openMonitoring) {
            this.props.openMonitoring(openMonitoring);
            return this;
        }
        /**
         * The settings for open monitoring.
         * <p>
         * @return {@code this}
         * @param openMonitoring The settings for open monitoring. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder openMonitoring(final software.amazon.awscdk.IResolvable openMonitoring) {
            this.props.openMonitoring(openMonitoring);
            return this;
        }

        /**
         * A map of key:value pairs to apply to this resource.
         * <p>
         * Both key and value are of type String.
         * <p>
         * @return {@code this}
         * @param tags A map of key:value pairs to apply to this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.msk.CfnCluster}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.msk.CfnCluster build() {
            return new software.amazon.awscdk.services.msk.CfnCluster(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
