package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a `CfnDBSecurityGroupIngress`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnDBSecurityGroupIngressProps cfnDBSecurityGroupIngressProps = CfnDBSecurityGroupIngressProps.builder()
 *         .dbSecurityGroupName("dbSecurityGroupName")
 *         // the properties below are optional
 *         .cidrip("cidrip")
 *         .ec2SecurityGroupId("ec2SecurityGroupId")
 *         .ec2SecurityGroupName("ec2SecurityGroupName")
 *         .ec2SecurityGroupOwnerId("ec2SecurityGroupOwnerId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.358Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnDBSecurityGroupIngressProps")
@software.amazon.jsii.Jsii.Proxy(CfnDBSecurityGroupIngressProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDBSecurityGroupIngressProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the DB security group to add authorization to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDbSecurityGroupName();

    /**
     * The IP range to authorize.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrip() {
        return null;
    }

    /**
     * Id of the EC2 security group to authorize.
     * <p>
     * For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEc2SecurityGroupId() {
        return null;
    }

    /**
     * Name of the EC2 security group to authorize.
     * <p>
     * For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEc2SecurityGroupName() {
        return null;
    }

    /**
     * AWS account number of the owner of the EC2 security group specified in the `EC2SecurityGroupName` parameter.
     * <p>
     * The AWS access key ID isn't an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEc2SecurityGroupOwnerId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDBSecurityGroupIngressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDBSecurityGroupIngressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDBSecurityGroupIngressProps> {
        java.lang.String dbSecurityGroupName;
        java.lang.String cidrip;
        java.lang.String ec2SecurityGroupId;
        java.lang.String ec2SecurityGroupName;
        java.lang.String ec2SecurityGroupOwnerId;

        /**
         * Sets the value of {@link CfnDBSecurityGroupIngressProps#getDbSecurityGroupName}
         * @param dbSecurityGroupName The name of the DB security group to add authorization to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dbSecurityGroupName(java.lang.String dbSecurityGroupName) {
            this.dbSecurityGroupName = dbSecurityGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBSecurityGroupIngressProps#getCidrip}
         * @param cidrip The IP range to authorize.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrip(java.lang.String cidrip) {
            this.cidrip = cidrip;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBSecurityGroupIngressProps#getEc2SecurityGroupId}
         * @param ec2SecurityGroupId Id of the EC2 security group to authorize.
         *                           For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SecurityGroupId(java.lang.String ec2SecurityGroupId) {
            this.ec2SecurityGroupId = ec2SecurityGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBSecurityGroupIngressProps#getEc2SecurityGroupName}
         * @param ec2SecurityGroupName Name of the EC2 security group to authorize.
         *                             For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SecurityGroupName(java.lang.String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDBSecurityGroupIngressProps#getEc2SecurityGroupOwnerId}
         * @param ec2SecurityGroupOwnerId AWS account number of the owner of the EC2 security group specified in the `EC2SecurityGroupName` parameter.
         *                                The AWS access key ID isn't an acceptable value. For VPC DB security groups, <code>EC2SecurityGroupId</code> must be provided. Otherwise, <code>EC2SecurityGroupOwnerId</code> and either <code>EC2SecurityGroupName</code> or <code>EC2SecurityGroupId</code> must be provided.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SecurityGroupOwnerId(java.lang.String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDBSecurityGroupIngressProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDBSecurityGroupIngressProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDBSecurityGroupIngressProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDBSecurityGroupIngressProps {
        private final java.lang.String dbSecurityGroupName;
        private final java.lang.String cidrip;
        private final java.lang.String ec2SecurityGroupId;
        private final java.lang.String ec2SecurityGroupName;
        private final java.lang.String ec2SecurityGroupOwnerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dbSecurityGroupName = software.amazon.jsii.Kernel.get(this, "dbSecurityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cidrip = software.amazon.jsii.Kernel.get(this, "cidrip", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ec2SecurityGroupId = software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ec2SecurityGroupName = software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ec2SecurityGroupOwnerId = software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupOwnerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dbSecurityGroupName = java.util.Objects.requireNonNull(builder.dbSecurityGroupName, "dbSecurityGroupName is required");
            this.cidrip = builder.cidrip;
            this.ec2SecurityGroupId = builder.ec2SecurityGroupId;
            this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
            this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
        }

        @Override
        public final java.lang.String getDbSecurityGroupName() {
            return this.dbSecurityGroupName;
        }

        @Override
        public final java.lang.String getCidrip() {
            return this.cidrip;
        }

        @Override
        public final java.lang.String getEc2SecurityGroupId() {
            return this.ec2SecurityGroupId;
        }

        @Override
        public final java.lang.String getEc2SecurityGroupName() {
            return this.ec2SecurityGroupName;
        }

        @Override
        public final java.lang.String getEc2SecurityGroupOwnerId() {
            return this.ec2SecurityGroupOwnerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dbSecurityGroupName", om.valueToTree(this.getDbSecurityGroupName()));
            if (this.getCidrip() != null) {
                data.set("cidrip", om.valueToTree(this.getCidrip()));
            }
            if (this.getEc2SecurityGroupId() != null) {
                data.set("ec2SecurityGroupId", om.valueToTree(this.getEc2SecurityGroupId()));
            }
            if (this.getEc2SecurityGroupName() != null) {
                data.set("ec2SecurityGroupName", om.valueToTree(this.getEc2SecurityGroupName()));
            }
            if (this.getEc2SecurityGroupOwnerId() != null) {
                data.set("ec2SecurityGroupOwnerId", om.valueToTree(this.getEc2SecurityGroupOwnerId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnDBSecurityGroupIngressProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDBSecurityGroupIngressProps.Jsii$Proxy that = (CfnDBSecurityGroupIngressProps.Jsii$Proxy) o;

            if (!dbSecurityGroupName.equals(that.dbSecurityGroupName)) return false;
            if (this.cidrip != null ? !this.cidrip.equals(that.cidrip) : that.cidrip != null) return false;
            if (this.ec2SecurityGroupId != null ? !this.ec2SecurityGroupId.equals(that.ec2SecurityGroupId) : that.ec2SecurityGroupId != null) return false;
            if (this.ec2SecurityGroupName != null ? !this.ec2SecurityGroupName.equals(that.ec2SecurityGroupName) : that.ec2SecurityGroupName != null) return false;
            return this.ec2SecurityGroupOwnerId != null ? this.ec2SecurityGroupOwnerId.equals(that.ec2SecurityGroupOwnerId) : that.ec2SecurityGroupOwnerId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dbSecurityGroupName.hashCode();
            result = 31 * result + (this.cidrip != null ? this.cidrip.hashCode() : 0);
            result = 31 * result + (this.ec2SecurityGroupId != null ? this.ec2SecurityGroupId.hashCode() : 0);
            result = 31 * result + (this.ec2SecurityGroupName != null ? this.ec2SecurityGroupName.hashCode() : 0);
            result = 31 * result + (this.ec2SecurityGroupOwnerId != null ? this.ec2SecurityGroupOwnerId.hashCode() : 0);
            return result;
        }
    }
}
