package software.amazon.awscdk.services.rds;

/**
 * Properties common to single-user and multi-user rotation options.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.rds.*;
 * InterfaceVpcEndpoint interfaceVpcEndpoint;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * CommonRotationUserOptions commonRotationUserOptions = CommonRotationUserOptions.builder()
 *         .automaticallyAfter(Duration.minutes(30))
 *         .endpoint(interfaceVpcEndpoint)
 *         .excludeCharacters("excludeCharacters")
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.367Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CommonRotationUserOptions")
@software.amazon.jsii.Jsii.Proxy(CommonRotationUserOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CommonRotationUserOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
     * <p>
     * Default: - 30 days
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getAutomaticallyAfter() {
        return null;
    }

    /**
     * The VPC interface endpoint to use for the Secrets Manager API.
     * <p>
     * If you enable private DNS hostnames for your VPC private endpoint (the default), you don't
     * need to specify an endpoint. The standard Secrets Manager DNS hostname the Secrets Manager
     * CLI and SDKs use by default (https://secretsmanager.<region>.amazonaws.com) automatically
     * resolves to your VPC endpoint.
     * <p>
     * Default: https://secretsmanager.<region>.amazonaws.com
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint getEndpoint() {
        return null;
    }

    /**
     * Specifies characters to not include in generated passwords.
     * <p>
     * Default: " %+~`#$&*()|[]{}:;<>?!'/
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
        return null;
    }

    /**
     * Where to place the rotation Lambda function.
     * <p>
     * Default: - same placement as instance or cluster
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CommonRotationUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CommonRotationUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CommonRotationUserOptions> {
        software.amazon.awscdk.Duration automaticallyAfter;
        software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint;
        java.lang.String excludeCharacters;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link CommonRotationUserOptions#getAutomaticallyAfter}
         * @param automaticallyAfter Specifies the number of days after the previous rotation before Secrets Manager triggers the next automatic rotation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder automaticallyAfter(software.amazon.awscdk.Duration automaticallyAfter) {
            this.automaticallyAfter = automaticallyAfter;
            return this;
        }

        /**
         * Sets the value of {@link CommonRotationUserOptions#getEndpoint}
         * @param endpoint The VPC interface endpoint to use for the Secrets Manager API.
         *                 If you enable private DNS hostnames for your VPC private endpoint (the default), you don't
         *                 need to specify an endpoint. The standard Secrets Manager DNS hostname the Secrets Manager
         *                 CLI and SDKs use by default (https://secretsmanager.<region>.amazonaws.com) automatically
         *                 resolves to your VPC endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpoint(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        /**
         * Sets the value of {@link CommonRotationUserOptions#getExcludeCharacters}
         * @param excludeCharacters Specifies characters to not include in generated passwords.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(java.lang.String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        /**
         * Sets the value of {@link CommonRotationUserOptions#getVpcSubnets}
         * @param vpcSubnets Where to place the rotation Lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CommonRotationUserOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CommonRotationUserOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CommonRotationUserOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CommonRotationUserOptions {
        private final software.amazon.awscdk.Duration automaticallyAfter;
        private final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint endpoint;
        private final java.lang.String excludeCharacters;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.automaticallyAfter = software.amazon.jsii.Kernel.get(this, "automaticallyAfter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint.class));
            this.excludeCharacters = software.amazon.jsii.Kernel.get(this, "excludeCharacters", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.automaticallyAfter = builder.automaticallyAfter;
            this.endpoint = builder.endpoint;
            this.excludeCharacters = builder.excludeCharacters;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.Duration getAutomaticallyAfter() {
            return this.automaticallyAfter;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IInterfaceVpcEndpoint getEndpoint() {
            return this.endpoint;
        }

        @Override
        public final java.lang.String getExcludeCharacters() {
            return this.excludeCharacters;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAutomaticallyAfter() != null) {
                data.set("automaticallyAfter", om.valueToTree(this.getAutomaticallyAfter()));
            }
            if (this.getEndpoint() != null) {
                data.set("endpoint", om.valueToTree(this.getEndpoint()));
            }
            if (this.getExcludeCharacters() != null) {
                data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CommonRotationUserOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CommonRotationUserOptions.Jsii$Proxy that = (CommonRotationUserOptions.Jsii$Proxy) o;

            if (this.automaticallyAfter != null ? !this.automaticallyAfter.equals(that.automaticallyAfter) : that.automaticallyAfter != null) return false;
            if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
            if (this.excludeCharacters != null ? !this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.automaticallyAfter != null ? this.automaticallyAfter.hashCode() : 0;
            result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
            result = 31 * result + (this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
