package software.amazon.awscdk.services.rds;

/**
 * A database instance engine.
 * <p>
 * Provides mapping to DatabaseEngine used for
 * secret rotation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * DatabaseInstance sourceInstance;
 * DatabaseInstanceFromSnapshot.Builder.create(this, "Instance")
 *         .snapshotIdentifier("my-snapshot")
 *         .engine(DatabaseInstanceEngine.postgres(PostgresInstanceEngineProps.builder().version(PostgresEngineVersion.VER_12_3).build()))
 *         // optional, defaults to m5.large
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * DatabaseInstanceReadReplica.Builder.create(this, "ReadReplica")
 *         .sourceDatabaseInstance(sourceInstance)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE2, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.387Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.DatabaseInstanceEngine")
public class DatabaseInstanceEngine extends software.amazon.jsii.JsiiObject {

    protected DatabaseInstanceEngine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DatabaseInstanceEngine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        MARIADB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "MARIADB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        MYSQL = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "MYSQL", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        ORACLE_EE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "ORACLE_EE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        ORACLE_SE2 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "ORACLE_SE2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        POSTGRES = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "POSTGRES", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        SQL_SERVER_EE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "SQL_SERVER_EE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        SQL_SERVER_EX = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "SQL_SERVER_EX", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        SQL_SERVER_SE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "SQL_SERVER_SE", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
        SQL_SERVER_WEB = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "SQL_SERVER_WEB", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DatabaseInstanceEngine() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Creates a new MariaDB instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine mariaDb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.MariaDbInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "mariaDb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new MySQL instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine mysql(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.MySqlInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "mysql", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new Oracle Enterprise Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine oracleEe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OracleEeInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "oracleEe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new Oracle Standard Edition 1 instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine oracleSe2(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.OracleSe2InstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "oracleSe2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new PostgreSQL instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine postgres(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.PostgresInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "postgres", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new SQL Server Enterprise Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine sqlServerEe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerEeInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "sqlServerEe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new SQL Server Express Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine sqlServerEx(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerExInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "sqlServerEx", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new SQL Server Standard Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine sqlServerSe(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerSeInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "sqlServerSe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a new SQL Server Web Edition instance engine.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.IInstanceEngine sqlServerWeb(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.SqlServerWebInstanceEngineProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.DatabaseInstanceEngine.class, "sqlServerWeb", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.IInstanceEngine.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The unversioned 'mariadb' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {&#64;link mariaDb()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine MARIADB;

    /**
     * The unversioned 'mysql' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {&#64;link mysql()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine MYSQL;

    /**
     * The unversioned 'oracle-ee' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {&#64;link oracleEe()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine ORACLE_EE;

    /**
     * The unversioned 'oracle-se2' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {&#64;link oracleSe2()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine ORACLE_SE2;

    /**
     * The unversioned 'postgres' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {&#64;link postgres()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine POSTGRES;

    /**
     * The unversioned 'sqlserver-ee' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {&#64;link sqlServerEe()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine SQL_SERVER_EE;

    /**
     * The unversioned 'sqlserver-ex' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {&#64;link sqlServerEx()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine SQL_SERVER_EX;

    /**
     * The unversioned 'sqlserver-se' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {&#64;link sqlServerSe()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine SQL_SERVER_SE;

    /**
     * The unversioned 'sqlserver-web' instance engine.
     * <p>
     * NOTE: using unversioned engines is an availability risk.
     * We recommend using versioned engines created using the {&#64;link sqlServerWeb()} method
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.IInstanceEngine SQL_SERVER_WEB;
}
