package software.amazon.awscdk.services.refactorspaces;

/**
 * Properties for defining a `CfnApplication`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.refactorspaces.*;
 * CfnApplicationProps cfnApplicationProps = CfnApplicationProps.builder()
 *         .apiGatewayProxy(ApiGatewayProxyInputProperty.builder()
 *                 .endpointType("endpointType")
 *                 .stageName("stageName")
 *                 .build())
 *         .environmentIdentifier("environmentIdentifier")
 *         .name("name")
 *         .proxyType("proxyType")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcId("vpcId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.481Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_refactorspaces.CfnApplicationProps")
@software.amazon.jsii.Jsii.Proxy(CfnApplicationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApplicationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The endpoint URL of the Amazon API Gateway proxy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApiGatewayProxy() {
        return null;
    }

    /**
     * The unique identifier of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentIdentifier() {
        return null;
    }

    /**
     * The name of the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The proxy type of the proxy created within the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getProxyType() {
        return null;
    }

    /**
     * The tags assigned to the application.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The ID of the virtual private cloud (VPC).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApplicationProps> {
        java.lang.Object apiGatewayProxy;
        java.lang.String environmentIdentifier;
        java.lang.String name;
        java.lang.String proxyType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String vpcId;

        /**
         * Sets the value of {@link CfnApplicationProps#getApiGatewayProxy}
         * @param apiGatewayProxy The endpoint URL of the Amazon API Gateway proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiGatewayProxy(software.amazon.awscdk.services.refactorspaces.CfnApplication.ApiGatewayProxyInputProperty apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getApiGatewayProxy}
         * @param apiGatewayProxy The endpoint URL of the Amazon API Gateway proxy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiGatewayProxy(software.amazon.awscdk.IResolvable apiGatewayProxy) {
            this.apiGatewayProxy = apiGatewayProxy;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getEnvironmentIdentifier}
         * @param environmentIdentifier The unique identifier of the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentIdentifier(java.lang.String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getName}
         * @param name The name of the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getProxyType}
         * @param proxyType The proxy type of the proxy created within the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyType(java.lang.String proxyType) {
            this.proxyType = proxyType;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getTags}
         * @param tags The tags assigned to the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnApplicationProps#getVpcId}
         * @param vpcId The ID of the virtual private cloud (VPC).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApplicationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApplicationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApplicationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApplicationProps {
        private final java.lang.Object apiGatewayProxy;
        private final java.lang.String environmentIdentifier;
        private final java.lang.String name;
        private final java.lang.String proxyType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String vpcId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiGatewayProxy = software.amazon.jsii.Kernel.get(this, "apiGatewayProxy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.environmentIdentifier = software.amazon.jsii.Kernel.get(this, "environmentIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxyType = software.amazon.jsii.Kernel.get(this, "proxyType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiGatewayProxy = builder.apiGatewayProxy;
            this.environmentIdentifier = builder.environmentIdentifier;
            this.name = builder.name;
            this.proxyType = builder.proxyType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.vpcId = builder.vpcId;
        }

        @Override
        public final java.lang.Object getApiGatewayProxy() {
            return this.apiGatewayProxy;
        }

        @Override
        public final java.lang.String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getProxyType() {
            return this.proxyType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiGatewayProxy() != null) {
                data.set("apiGatewayProxy", om.valueToTree(this.getApiGatewayProxy()));
            }
            if (this.getEnvironmentIdentifier() != null) {
                data.set("environmentIdentifier", om.valueToTree(this.getEnvironmentIdentifier()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getProxyType() != null) {
                data.set("proxyType", om.valueToTree(this.getProxyType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVpcId() != null) {
                data.set("vpcId", om.valueToTree(this.getVpcId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_refactorspaces.CfnApplicationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApplicationProps.Jsii$Proxy that = (CfnApplicationProps.Jsii$Proxy) o;

            if (this.apiGatewayProxy != null ? !this.apiGatewayProxy.equals(that.apiGatewayProxy) : that.apiGatewayProxy != null) return false;
            if (this.environmentIdentifier != null ? !this.environmentIdentifier.equals(that.environmentIdentifier) : that.environmentIdentifier != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.proxyType != null ? !this.proxyType.equals(that.proxyType) : that.proxyType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiGatewayProxy != null ? this.apiGatewayProxy.hashCode() : 0;
            result = 31 * result + (this.environmentIdentifier != null ? this.environmentIdentifier.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.proxyType != null ? this.proxyType.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
            return result;
        }
    }
}
