package software.amazon.awscdk.services.route53;

/**
 * Options for a RecordSet.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.route53.*;
 * HostedZone hostedZone;
 * RecordSetOptions recordSetOptions = RecordSetOptions.builder()
 *         .zone(hostedZone)
 *         // the properties below are optional
 *         .comment("comment")
 *         .recordName("recordName")
 *         .ttl(Duration.minutes(30))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.582Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53.RecordSetOptions")
@software.amazon.jsii.Jsii.Proxy(RecordSetOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface RecordSetOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The hosted zone in which to define the new record.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getZone();

    /**
     * A comment to add on the record.
     * <p>
     * Default: no comment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
        return null;
    }

    /**
     * The domain name for this record.
     * <p>
     * Default: zone root
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getRecordName() {
        return null;
    }

    /**
     * The resource record cache time to live (TTL).
     * <p>
     * Default: Duration.minutes(30)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTtl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RecordSetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RecordSetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<RecordSetOptions> {
        software.amazon.awscdk.services.route53.IHostedZone zone;
        java.lang.String comment;
        java.lang.String recordName;
        software.amazon.awscdk.Duration ttl;

        /**
         * Sets the value of {@link RecordSetOptions#getZone}
         * @param zone The hosted zone in which to define the new record. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.zone = zone;
            return this;
        }

        /**
         * Sets the value of {@link RecordSetOptions#getComment}
         * @param comment A comment to add on the record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link RecordSetOptions#getRecordName}
         * @param recordName The domain name for this record.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordName(java.lang.String recordName) {
            this.recordName = recordName;
            return this;
        }

        /**
         * Sets the value of {@link RecordSetOptions#getTtl}
         * @param ttl The resource record cache time to live (TTL).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ttl(software.amazon.awscdk.Duration ttl) {
            this.ttl = ttl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RecordSetOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public RecordSetOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link RecordSetOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RecordSetOptions {
        private final software.amazon.awscdk.services.route53.IHostedZone zone;
        private final java.lang.String comment;
        private final java.lang.String recordName;
        private final software.amazon.awscdk.Duration ttl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.zone = software.amazon.jsii.Kernel.get(this, "zone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordName = software.amazon.jsii.Kernel.get(this, "recordName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ttl = software.amazon.jsii.Kernel.get(this, "ttl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.zone = java.util.Objects.requireNonNull(builder.zone, "zone is required");
            this.comment = builder.comment;
            this.recordName = builder.recordName;
            this.ttl = builder.ttl;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getZone() {
            return this.zone;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final java.lang.String getRecordName() {
            return this.recordName;
        }

        @Override
        public final software.amazon.awscdk.Duration getTtl() {
            return this.ttl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("zone", om.valueToTree(this.getZone()));
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getRecordName() != null) {
                data.set("recordName", om.valueToTree(this.getRecordName()));
            }
            if (this.getTtl() != null) {
                data.set("ttl", om.valueToTree(this.getTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53.RecordSetOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RecordSetOptions.Jsii$Proxy that = (RecordSetOptions.Jsii$Proxy) o;

            if (!zone.equals(that.zone)) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.recordName != null ? !this.recordName.equals(that.recordName) : that.recordName != null) return false;
            return this.ttl != null ? this.ttl.equals(that.ttl) : that.ttl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.zone.hashCode();
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.recordName != null ? this.recordName.hashCode() : 0);
            result = 31 * result + (this.ttl != null ? this.ttl.hashCode() : 0);
            return result;
        }
    }
}
