package software.amazon.awscdk.services.route53.patterns;

/**
 * Properties to configure an HTTPS Redirect.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HttpsRedirect.Builder.create(this, "Redirect")
 *         .recordNames(List.of("foo.example.com"))
 *         .targetDomain("bar.example.com")
 *         .zone(HostedZone.fromHostedZoneAttributes(this, "HostedZone", HostedZoneAttributes.builder()
 *                 .hostedZoneId("ID")
 *                 .zoneName("example.com")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.594Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53_patterns.HttpsRedirectProps")
@software.amazon.jsii.Jsii.Proxy(HttpsRedirectProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpsRedirectProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The redirect target fully qualified domain name (FQDN).
     * <p>
     * An alias record
     * will be created that points to your CloudFront distribution. Root domain
     * or sub-domain can be supplied.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetDomain();

    /**
     * Hosted zone of the domain which will be used to create alias record(s) from domain names in the hosted zone to the target domain.
     * <p>
     * The hosted zone must
     * contain entries for the domain name(s) supplied through <code>recordNames</code> that
     * will redirect to the target domain.
     * <p>
     * Domain names in the hosted zone can include a specific domain (example.com)
     * and its subdomains (acme.example.com, zenith.example.com).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IHostedZone getZone();

    /**
     * The AWS Certificate Manager (ACM) certificate that will be associated with the CloudFront distribution that will be created.
     * <p>
     * If provided, the certificate must be
     * stored in us-east-1 (N. Virginia)
     * <p>
     * Default: - A new certificate is created in us-east-1 (N. Virginia)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
        return null;
    }

    /**
     * The domain names that will redirect to `targetDomain`.
     * <p>
     * Default: - the domain name of the hosted zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRecordNames() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpsRedirectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpsRedirectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpsRedirectProps> {
        java.lang.String targetDomain;
        software.amazon.awscdk.services.route53.IHostedZone zone;
        software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        java.util.List<java.lang.String> recordNames;

        /**
         * Sets the value of {@link HttpsRedirectProps#getTargetDomain}
         * @param targetDomain The redirect target fully qualified domain name (FQDN). This parameter is required.
         *                     An alias record
         *                     will be created that points to your CloudFront distribution. Root domain
         *                     or sub-domain can be supplied.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetDomain(java.lang.String targetDomain) {
            this.targetDomain = targetDomain;
            return this;
        }

        /**
         * Sets the value of {@link HttpsRedirectProps#getZone}
         * @param zone Hosted zone of the domain which will be used to create alias record(s) from domain names in the hosted zone to the target domain. This parameter is required.
         *             The hosted zone must
         *             contain entries for the domain name(s) supplied through <code>recordNames</code> that
         *             will redirect to the target domain.
         *             <p>
         *             Domain names in the hosted zone can include a specific domain (example.com)
         *             and its subdomains (acme.example.com, zenith.example.com).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zone(software.amazon.awscdk.services.route53.IHostedZone zone) {
            this.zone = zone;
            return this;
        }

        /**
         * Sets the value of {@link HttpsRedirectProps#getCertificate}
         * @param certificate The AWS Certificate Manager (ACM) certificate that will be associated with the CloudFront distribution that will be created.
         *                    If provided, the certificate must be
         *                    stored in us-east-1 (N. Virginia)
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.certificate = certificate;
            return this;
        }

        /**
         * Sets the value of {@link HttpsRedirectProps#getRecordNames}
         * @param recordNames The domain names that will redirect to `targetDomain`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordNames(java.util.List<java.lang.String> recordNames) {
            this.recordNames = recordNames;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpsRedirectProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpsRedirectProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpsRedirectProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpsRedirectProps {
        private final java.lang.String targetDomain;
        private final software.amazon.awscdk.services.route53.IHostedZone zone;
        private final software.amazon.awscdk.services.certificatemanager.ICertificate certificate;
        private final java.util.List<java.lang.String> recordNames;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetDomain = software.amazon.jsii.Kernel.get(this, "targetDomain", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.zone = software.amazon.jsii.Kernel.get(this, "zone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.IHostedZone.class));
            this.certificate = software.amazon.jsii.Kernel.get(this, "certificate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ICertificate.class));
            this.recordNames = software.amazon.jsii.Kernel.get(this, "recordNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetDomain = java.util.Objects.requireNonNull(builder.targetDomain, "targetDomain is required");
            this.zone = java.util.Objects.requireNonNull(builder.zone, "zone is required");
            this.certificate = builder.certificate;
            this.recordNames = builder.recordNames;
        }

        @Override
        public final java.lang.String getTargetDomain() {
            return this.targetDomain;
        }

        @Override
        public final software.amazon.awscdk.services.route53.IHostedZone getZone() {
            return this.zone;
        }

        @Override
        public final software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.certificate;
        }

        @Override
        public final java.util.List<java.lang.String> getRecordNames() {
            return this.recordNames;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetDomain", om.valueToTree(this.getTargetDomain()));
            data.set("zone", om.valueToTree(this.getZone()));
            if (this.getCertificate() != null) {
                data.set("certificate", om.valueToTree(this.getCertificate()));
            }
            if (this.getRecordNames() != null) {
                data.set("recordNames", om.valueToTree(this.getRecordNames()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53_patterns.HttpsRedirectProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpsRedirectProps.Jsii$Proxy that = (HttpsRedirectProps.Jsii$Proxy) o;

            if (!targetDomain.equals(that.targetDomain)) return false;
            if (!zone.equals(that.zone)) return false;
            if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) return false;
            return this.recordNames != null ? this.recordNames.equals(that.recordNames) : that.recordNames == null;
        }

        @Override
        public final int hashCode() {
            int result = this.targetDomain.hashCode();
            result = 31 * result + (this.zone.hashCode());
            result = 31 * result + (this.certificate != null ? this.certificate.hashCode() : 0);
            result = 31 * result + (this.recordNames != null ? this.recordNames.hashCode() : 0);
            return result;
        }
    }
}
