package software.amazon.awscdk.services.route53.targets;

/**
 * Use a classic ELB as an alias record target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.elasticloadbalancing.*;
 * HostedZone zone;
 * LoadBalancer lb;
 * ARecord.Builder.create(this, "AliasRecord")
 *         .zone(zone)
 *         .target(RecordTarget.fromAlias(new ClassicLoadBalancerTarget(lb)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.597Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53_targets.ClassicLoadBalancerTarget")
public class ClassicLoadBalancerTarget extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.route53.IAliasRecordTarget {

    protected ClassicLoadBalancerTarget(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ClassicLoadBalancerTarget(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ClassicLoadBalancerTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param _record This parameter is required.
     * @param _zone
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet _record, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone _zone) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_record, "_record is required"), _zone });
    }

    /**
     * Return hosted zone ID and DNS name, usable for Route53 alias targets.
     * <p>
     * @param _record This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.AliasRecordTargetConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.route53.IRecordSet _record) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.route53.AliasRecordTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_record, "_record is required") });
    }
}
