package software.amazon.awscdk.services.route53resolver;

/**
 * Properties for defining a `CfnFirewallRuleGroupAssociation`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.route53resolver.*;
 * CfnFirewallRuleGroupAssociationProps cfnFirewallRuleGroupAssociationProps = CfnFirewallRuleGroupAssociationProps.builder()
 *         .firewallRuleGroupId("firewallRuleGroupId")
 *         .priority(123)
 *         .vpcId("vpcId")
 *         // the properties below are optional
 *         .mutationProtection("mutationProtection")
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.614Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_route53resolver.CfnFirewallRuleGroupAssociationProps")
@software.amazon.jsii.Jsii.Proxy(CfnFirewallRuleGroupAssociationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnFirewallRuleGroupAssociationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique identifier of the firewall rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFirewallRuleGroupId();

    /**
     * The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC.
     * <p>
     * DNS Firewall filters VPC traffic starting from rule group with the lowest numeric priority setting.
     * <p>
     * You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You can change the priority setting for a rule group association after you create it.
     * <p>
     * The allowed values for <code>Priority</code> are between 100 and 9900 (excluding 100 and 9900).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Number getPriority();

    /**
     * The unique identifier of the VPC that is associated with the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVpcId();

    /**
     * If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMutationProtection() {
        return null;
    }

    /**
     * The name of the association.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * A list of the tag keys and values that you want to associate with the rule group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnFirewallRuleGroupAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnFirewallRuleGroupAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnFirewallRuleGroupAssociationProps> {
        java.lang.String firewallRuleGroupId;
        java.lang.Number priority;
        java.lang.String vpcId;
        java.lang.String mutationProtection;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnFirewallRuleGroupAssociationProps#getFirewallRuleGroupId}
         * @param firewallRuleGroupId The unique identifier of the firewall rule group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder firewallRuleGroupId(java.lang.String firewallRuleGroupId) {
            this.firewallRuleGroupId = firewallRuleGroupId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallRuleGroupAssociationProps#getPriority}
         * @param priority The setting that determines the processing order of the rule group among the rule groups that are associated with a single VPC. This parameter is required.
         *                 DNS Firewall filters VPC traffic starting from rule group with the lowest numeric priority setting.
         *                 <p>
         *                 You must specify a unique priority for each rule group that you associate with a single VPC. To make it easier to insert rule groups later, leave space between the numbers, for example, use 101, 200, and so on. You can change the priority setting for a rule group association after you create it.
         *                 <p>
         *                 The allowed values for <code>Priority</code> are between 100 and 9900 (excluding 100 and 9900).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallRuleGroupAssociationProps#getVpcId}
         * @param vpcId The unique identifier of the VPC that is associated with the rule group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcId(java.lang.String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallRuleGroupAssociationProps#getMutationProtection}
         * @param mutationProtection If enabled, this setting disallows modification or removal of the association, to help prevent against accidentally altering DNS firewall protections.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutationProtection(java.lang.String mutationProtection) {
            this.mutationProtection = mutationProtection;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallRuleGroupAssociationProps#getName}
         * @param name The name of the association.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnFirewallRuleGroupAssociationProps#getTags}
         * @param tags A list of the tag keys and values that you want to associate with the rule group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnFirewallRuleGroupAssociationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnFirewallRuleGroupAssociationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnFirewallRuleGroupAssociationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnFirewallRuleGroupAssociationProps {
        private final java.lang.String firewallRuleGroupId;
        private final java.lang.Number priority;
        private final java.lang.String vpcId;
        private final java.lang.String mutationProtection;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.firewallRuleGroupId = software.amazon.jsii.Kernel.get(this, "firewallRuleGroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mutationProtection = software.amazon.jsii.Kernel.get(this, "mutationProtection", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.firewallRuleGroupId = java.util.Objects.requireNonNull(builder.firewallRuleGroupId, "firewallRuleGroupId is required");
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
            this.vpcId = java.util.Objects.requireNonNull(builder.vpcId, "vpcId is required");
            this.mutationProtection = builder.mutationProtection;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getFirewallRuleGroupId() {
            return this.firewallRuleGroupId;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final java.lang.String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final java.lang.String getMutationProtection() {
            return this.mutationProtection;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("firewallRuleGroupId", om.valueToTree(this.getFirewallRuleGroupId()));
            data.set("priority", om.valueToTree(this.getPriority()));
            data.set("vpcId", om.valueToTree(this.getVpcId()));
            if (this.getMutationProtection() != null) {
                data.set("mutationProtection", om.valueToTree(this.getMutationProtection()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_route53resolver.CfnFirewallRuleGroupAssociationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnFirewallRuleGroupAssociationProps.Jsii$Proxy that = (CfnFirewallRuleGroupAssociationProps.Jsii$Proxy) o;

            if (!firewallRuleGroupId.equals(that.firewallRuleGroupId)) return false;
            if (!priority.equals(that.priority)) return false;
            if (!vpcId.equals(that.vpcId)) return false;
            if (this.mutationProtection != null ? !this.mutationProtection.equals(that.mutationProtection) : that.mutationProtection != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.firewallRuleGroupId.hashCode();
            result = 31 * result + (this.priority.hashCode());
            result = 31 * result + (this.vpcId.hashCode());
            result = 31 * result + (this.mutationProtection != null ? this.mutationProtection.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
