package software.amazon.awscdk.services.s3;

/**
 * Properties for defining a `CfnAccessPoint`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * Object policy;
 * Object policyStatus;
 * CfnAccessPointProps cfnAccessPointProps = CfnAccessPointProps.builder()
 *         .bucket("bucket")
 *         // the properties below are optional
 *         .name("name")
 *         .policy(policy)
 *         .policyStatus(policyStatus)
 *         .publicAccessBlockConfiguration(PublicAccessBlockConfigurationProperty.builder()
 *                 .blockPublicAcls(false)
 *                 .blockPublicPolicy(false)
 *                 .ignorePublicAcls(false)
 *                 .restrictPublicBuckets(false)
 *                 .build())
 *         .vpcConfiguration(VpcConfigurationProperty.builder()
 *                 .vpcId("vpcId")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.653Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.CfnAccessPointProps")
@software.amazon.jsii.Jsii.Proxy(CfnAccessPointProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAccessPointProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the bucket associated with this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBucket();

    /**
     * The name of this access point.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the access point name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The access point policy associated with this access point.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicy() {
        return null;
    }

    /**
     * The container element for a bucket's policy status.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPolicyStatus() {
        return null;
    }

    /**
     * The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
     * <p>
     * You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPublicAccessBlockConfiguration() {
        return null;
    }

    /**
     * The Virtual Private Cloud (VPC) configuration for this access point, if one exists.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAccessPointProps> {
        java.lang.String bucket;
        java.lang.String name;
        java.lang.Object policy;
        java.lang.Object policyStatus;
        java.lang.Object publicAccessBlockConfiguration;
        java.lang.Object vpcConfiguration;

        /**
         * Sets the value of {@link CfnAccessPointProps#getBucket}
         * @param bucket The name of the bucket associated with this access point. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(java.lang.String bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getName}
         * @param name The name of this access point.
         *             If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID for the access point name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPolicy}
         * @param policy The access point policy associated with this access point.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(java.lang.Object policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPolicyStatus}
         * @param policyStatus The container element for a bucket's policy status.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatus(java.lang.Object policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPublicAccessBlockConfiguration}
         * @param publicAccessBlockConfiguration The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
         *                                       You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(software.amazon.awscdk.services.s3.CfnAccessPoint.PublicAccessBlockConfigurationProperty publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getPublicAccessBlockConfiguration}
         * @param publicAccessBlockConfiguration The PublicAccessBlock configuration that you want to apply to this Amazon S3 bucket.
         *                                       You can enable the configuration options in any combination. For more information about when Amazon S3 considers a bucket or object public, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html#access-control-block-public-access-policy-status">The Meaning of "Public"</a> in the <em>Amazon S3 User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publicAccessBlockConfiguration(software.amazon.awscdk.IResolvable publicAccessBlockConfiguration) {
            this.publicAccessBlockConfiguration = publicAccessBlockConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getVpcConfiguration}
         * @param vpcConfiguration The Virtual Private Cloud (VPC) configuration for this access point, if one exists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.services.s3.CfnAccessPoint.VpcConfigurationProperty vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAccessPointProps#getVpcConfiguration}
         * @param vpcConfiguration The Virtual Private Cloud (VPC) configuration for this access point, if one exists.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(software.amazon.awscdk.IResolvable vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAccessPointProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAccessPointProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAccessPointProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAccessPointProps {
        private final java.lang.String bucket;
        private final java.lang.String name;
        private final java.lang.Object policy;
        private final java.lang.Object policyStatus;
        private final java.lang.Object publicAccessBlockConfiguration;
        private final java.lang.Object vpcConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.policyStatus = software.amazon.jsii.Kernel.get(this, "policyStatus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.publicAccessBlockConfiguration = software.amazon.jsii.Kernel.get(this, "publicAccessBlockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.vpcConfiguration = software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
            this.name = builder.name;
            this.policy = builder.policy;
            this.policyStatus = builder.policyStatus;
            this.publicAccessBlockConfiguration = builder.publicAccessBlockConfiguration;
            this.vpcConfiguration = builder.vpcConfiguration;
        }

        @Override
        public final java.lang.String getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getPolicy() {
            return this.policy;
        }

        @Override
        public final java.lang.Object getPolicyStatus() {
            return this.policyStatus;
        }

        @Override
        public final java.lang.Object getPublicAccessBlockConfiguration() {
            return this.publicAccessBlockConfiguration;
        }

        @Override
        public final java.lang.Object getVpcConfiguration() {
            return this.vpcConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("bucket", om.valueToTree(this.getBucket()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getPolicyStatus() != null) {
                data.set("policyStatus", om.valueToTree(this.getPolicyStatus()));
            }
            if (this.getPublicAccessBlockConfiguration() != null) {
                data.set("publicAccessBlockConfiguration", om.valueToTree(this.getPublicAccessBlockConfiguration()));
            }
            if (this.getVpcConfiguration() != null) {
                data.set("vpcConfiguration", om.valueToTree(this.getVpcConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.CfnAccessPointProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAccessPointProps.Jsii$Proxy that = (CfnAccessPointProps.Jsii$Proxy) o;

            if (!bucket.equals(that.bucket)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.policyStatus != null ? !this.policyStatus.equals(that.policyStatus) : that.policyStatus != null) return false;
            if (this.publicAccessBlockConfiguration != null ? !this.publicAccessBlockConfiguration.equals(that.publicAccessBlockConfiguration) : that.publicAccessBlockConfiguration != null) return false;
            return this.vpcConfiguration != null ? this.vpcConfiguration.equals(that.vpcConfiguration) : that.vpcConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.policyStatus != null ? this.policyStatus.hashCode() : 0);
            result = 31 * result + (this.publicAccessBlockConfiguration != null ? this.publicAccessBlockConfiguration.hashCode() : 0);
            result = 31 * result + (this.vpcConfiguration != null ? this.vpcConfiguration.hashCode() : 0);
            return result;
        }
    }
}
