package software.amazon.awscdk.services.s3.deployment;

/**
 * Specifies bucket deployment source.
 * <p>
 * Usage:
 * <p>
 * <blockquote><pre>
 *  Source.bucket(bucket, key)
 *  Source.asset('/local/path/to/directory')
 *  Source.asset('/local/path/to/a/file.zip')
 *  Source.data('hello/world/file.txt', 'Hello, world!')
 *  Source.data('config.json', { baz: topic.topicArn })
 * </pre></blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket websiteBucket;
 * BucketDeployment deployment = BucketDeployment.Builder.create(this, "DeployWebsite")
 *         .sources(List.of(Source.asset(join(__dirname, "my-website"))))
 *         .destinationBucket(websiteBucket)
 *         .build();
 * new ConstructThatReadsFromTheBucket(this, "Consumer", Map.of(
 *         // Use 'deployment.deployedBucket' instead of 'websiteBucket' here
 *         "bucket", deployment.getDeployedBucket()));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.55.1 (build 07d2d90)", date = "2022-04-07T11:16:45.745Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3_deployment.Source")
public class Source extends software.amazon.jsii.JsiiObject {

    protected Source(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Source(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Uses a local asset as the deployment source.
     * <p>
     * If the local asset is a .zip archive, make sure you trust the
     * producer of the archive.
     * <p>
     * @param path The path to a local .zip file or a directory. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource asset(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.assets.AssetOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "asset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), options });
    }

    /**
     * Uses a local asset as the deployment source.
     * <p>
     * If the local asset is a .zip archive, make sure you trust the
     * producer of the archive.
     * <p>
     * @param path The path to a local .zip file or a directory. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource asset(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "asset", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * Uses a .zip file stored in an S3 bucket as the source for the destination bucket contents.
     * <p>
     * Make sure you trust the producer of the archive.
     * <p>
     * @param bucket The S3 Bucket. This parameter is required.
     * @param zipObjectKey The S3 object key of the zip file with contents. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource bucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String zipObjectKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(zipObjectKey, "zipObjectKey is required") });
    }

    /**
     * Deploys an object with the specified string contents into the bucket.
     * <p>
     * The
     * content can include deploy-time values (such as <code>snsTopic.topicArn</code>) that
     * will get resolved only during deployment.
     * <p>
     * To store a JSON object use <code>Source.jsonData()</code>.
     * <p>
     * @param objectKey The destination S3 object key (relative to the root of the S3 deployment). This parameter is required.
     * @param data The data to be stored in the object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource data(final @org.jetbrains.annotations.NotNull java.lang.String objectKey, final @org.jetbrains.annotations.NotNull java.lang.String data) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "data", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(objectKey, "objectKey is required"), java.util.Objects.requireNonNull(data, "data is required") });
    }

    /**
     * Deploys an object with the specified JSON object into the bucket.
     * <p>
     * The
     * object can include deploy-time values (such as <code>snsTopic.topicArn</code>) that
     * will get resolved only during deployment.
     * <p>
     * @param objectKey The destination S3 object key (relative to the root of the S3 deployment). This parameter is required.
     * @param obj A JSON object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.deployment.ISource jsonData(final @org.jetbrains.annotations.NotNull java.lang.String objectKey, final @org.jetbrains.annotations.NotNull java.lang.Object obj) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.s3.deployment.Source.class, "jsonData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.deployment.ISource.class), new Object[] { java.util.Objects.requireNonNull(objectKey, "objectKey is required"), obj });
    }
}
